/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.InputStream;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;

public class UpdateImpl
implements Update {
    private UpdateCheckInstanceImpl instance;
    private String name;
    private String[] description;
    private String relative_url_base = "";
    private String new_version;
    private ResourceDownloader[] downloaders;
    private boolean mandatory;
    private int restart_required;
    private String description_url;
    private Object user_object;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private volatile boolean cancelled;
    private volatile boolean complete;

    protected UpdateImpl(UpdateCheckInstanceImpl _instance, String _name, String[] _desc, String _new_version, ResourceDownloader[] _downloaders, boolean _mandatory, int _restart_required) {
        this.instance = _instance;
        this.name = _name;
        this.description = _desc;
        this.new_version = _new_version;
        this.downloaders = _downloaders;
        this.mandatory = _mandatory;
        this.restart_required = _restart_required;
    }

    public UpdateCheckInstance getCheckInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDescription() {
        return this.description;
    }

    public String getRelativeURLBase() {
        return this.relative_url_base;
    }

    public void setRelativeURLBase(String base) {
        this.relative_url_base = base;
    }

    public String getDesciptionURL() {
        return this.description_url;
    }

    public void setDescriptionURL(String url) {
        this.description_url = url;
    }

    public String getNewVersion() {
        return this.new_version;
    }

    public ResourceDownloader[] getDownloaders() {
        return this.downloaders;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setRestartRequired(int _restart_required) {
        this.restart_required = _restart_required;
    }

    public int getRestartRequired() {
        return this.restart_required;
    }

    public void setUserObject(Object obj) {
        this.user_object = obj;
    }

    public Object getUserObject() {
        return this.user_object;
    }

    public void cancel() {
        this.cancelled = true;
        for (int i = 0; i < this.downloaders.length; ++i) {
            try {
                this.downloaders[i].cancel();
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((UpdateListener)it.next()).cancelled(this);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void complete() {
        this.complete = true;
        Iterator it = this.listeners.iterator();
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UpdateListener)it.next()).complete(this);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Object getDecision(int decision_type, String decision_name, String decision_description, Object decision_data) {
        return this.instance.getDecision(this, decision_type, decision_name, decision_description, decision_data);
    }

    public InputStream verifyData(InputStream is, boolean force) throws UpdateException {
        return ((UpdateManagerImpl)this.instance.getManager()).verifyData(this, is, force);
    }

    public void addListener(UpdateListener l) {
        this.listeners.add(l);
        if (this.cancelled) {
            l.cancelled(this);
        } else if (this.complete) {
            l.complete(this);
        }
    }

    public void removeListener(UpdateListener l) {
        this.listeners.remove(l);
    }
}

