/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPChecker;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerFactory;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.AggregatedDispatcher;
import org.gudy.azureus2.plugins.utils.AggregatedList;
import org.gudy.azureus2.plugins.utils.AggregatedListAcceptor;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInitiator;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.LocaleUtilitiesImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.MonitorImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.SemaphoreImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UTTimerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourceuploader.ResourceUploaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.security.SESecurityManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSFeedImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilitiesImpl
implements Utilities {
    private static InetAddress last_public_ip_address;
    private static long last_public_ip_address_time;
    private AzureusCore core;
    private PluginInterface pi;
    private static ThreadLocal<PluginInterface> tls;
    private static List<searchManager> search_managers;
    private static List<Object[]> search_providers;
    private static List delayed_tasks;
    private static AESemaphore delayed_tasks_sem;
    private static AEThread2 delayed_task_thread;

    public UtilitiesImpl(AzureusCore _core, PluginInterface _pi) {
        this.core = _core;
        this.pi = _pi;
    }

    @Override
    public String getAzureusUserDir() {
        String res = SystemProperties.getUserPath();
        if (res.endsWith(File.separator)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    @Override
    public String getAzureusProgramDir() {
        String res = SystemProperties.getApplicationPath();
        if (res.endsWith(File.separator)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    @Override
    public boolean isWindows() {
        return Constants.isWindows;
    }

    @Override
    public boolean isLinux() {
        return Constants.isLinux;
    }

    @Override
    public boolean isUnix() {
        return Constants.isUnix;
    }

    @Override
    public boolean isFreeBSD() {
        return Constants.isFreeBSD;
    }

    @Override
    public boolean isSolaris() {
        return Constants.isSolaris;
    }

    @Override
    public boolean isOSX() {
        return Constants.isOSX;
    }

    @Override
    public boolean isCVSVersion() {
        return Constants.isCVSVersion();
    }

    @Override
    public InputStream getImageAsStream(String image_name) {
        return UtilitiesImpl.class.getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/icons/" + image_name);
    }

    @Override
    public Semaphore getSemaphore() {
        return new SemaphoreImpl(this.pi);
    }

    @Override
    public Monitor getMonitor() {
        return new MonitorImpl(this.pi);
    }

    @Override
    public ByteBuffer allocateDirectByteBuffer(int size) {
        return DirectByteBufferPool.getBuffer((byte)1, size).getBuffer((byte)1);
    }

    @Override
    public void freeDirectByteBuffer(ByteBuffer buffer) {
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(int length) {
        return new PooledByteBufferImpl(length);
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(byte[] data) {
        return new PooledByteBufferImpl(data);
    }

    @Override
    public PooledByteBuffer allocatePooledByteBuffer(Map map) throws IOException {
        return new PooledByteBufferImpl(BEncoder.encode(map));
    }

    @Override
    public Formatters getFormatters() {
        return new FormattersImpl();
    }

    @Override
    public LocaleUtilities getLocaleUtilities() {
        return new LocaleUtilitiesImpl(this.pi);
    }

    @Override
    public UTTimer createTimer(String name) {
        return new UTTimerImpl(this.pi, name, false);
    }

    @Override
    public UTTimer createTimer(String name, boolean lightweight) {
        return new UTTimerImpl(this.pi, name, lightweight);
    }

    @Override
    public UTTimer createTimer(String name, int priority) {
        return new UTTimerImpl(this.pi, name, priority);
    }

    @Override
    public void createThread(String name, final Runnable target) {
        AEThread2 t = new AEThread2(this.pi.getPluginName() + "::" + name, true){

            public void run() {
                UtilitiesImpl.callWithPluginThreadContext(UtilitiesImpl.this.pi, target);
            }
        };
        t.start();
    }

    @Override
    public void createProcess(String command_line) throws PluginException {
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            pm.createProcess(command_line, false);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            try {
                Runtime.getRuntime().exec(command_line);
            }
            catch (Throwable f) {
                throw new PluginException("Failed to create process", f);
            }
        }
    }

    @Override
    public ResourceDownloaderFactory getResourceDownloaderFactory() {
        return ResourceDownloaderFactoryImpl.getSingleton();
    }

    @Override
    public ResourceUploaderFactory getResourceUploaderFactory() {
        return ResourceUploaderFactoryImpl.getSingleton();
    }

    @Override
    public SESecurityManager getSecurityManager() {
        return new SESecurityManagerImpl(this.core);
    }

    @Override
    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory() {
        return new SimpleXMLParserDocumentFactoryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RSSFeed getRSSFeed(InputStream is) throws SimpleXMLParserDocumentException {
        try {
            RSSFeedImpl rSSFeedImpl = new RSSFeedImpl((Utilities)this, is);
            return rSSFeedImpl;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public RSSFeed getRSSFeed(URL feed_location) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return this.getRSSFeed(this.getResourceDownloaderFactory().create(feed_location));
    }

    @Override
    public RSSFeed getRSSFeed(ResourceDownloader feed_location) throws ResourceDownloaderException, SimpleXMLParserDocumentException {
        return new RSSFeedImpl((Utilities)this, feed_location);
    }

    @Override
    public InetAddress getPublicAddress(boolean v6) {
        if (v6) {
            String vc_ip = VersionCheckClient.getSingleton().getExternalIpAddress(false, true);
            if (vc_ip != null && vc_ip.length() > 0) {
                try {
                    return InetAddress.getByName(vc_ip);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            return null;
        }
        return this.getPublicAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getPublicAddress() {
        InetAddress res;
        long now;
        block13: {
            now = SystemTime.getCurrentTime();
            if (now < last_public_ip_address_time) {
                last_public_ip_address_time = now;
            } else if (last_public_ip_address != null && now - last_public_ip_address_time < 900000L) {
                return last_public_ip_address;
            }
            res = null;
            try {
                String vc_ip = VersionCheckClient.getSingleton().getExternalIpAddress(false, false);
                if (vc_ip != null && vc_ip.length() > 0) {
                    res = InetAddress.getByName(vc_ip);
                    break block13;
                }
                ExternalIPChecker checker = ExternalIPCheckerFactory.create();
                ExternalIPCheckerService[] services = checker.getServices();
                final String[] ip = new String[]{null};
                for (int i = 0; i < services.length && ip[0] == null; ++i) {
                    ExternalIPCheckerService service = services[i];
                    if (service.supportsCheck()) {
                        final AESemaphore sem = new AESemaphore("Utilities:getExtIP");
                        ExternalIPCheckerServiceListener listener = new ExternalIPCheckerServiceListener(){

                            public void checkComplete(ExternalIPCheckerService _service, String _ip) {
                                ip[0] = _ip;
                                sem.release();
                            }

                            public void checkFailed(ExternalIPCheckerService _service, String _reason) {
                                sem.release();
                            }

                            public void reportProgress(ExternalIPCheckerService _service, String _message) {
                            }
                        };
                        services[i].addListener(listener);
                        try {
                            services[i].initiateCheck(60000L);
                            sem.reserve(60000L);
                        }
                        finally {
                            services[i].removeListener(listener);
                        }
                    }
                    if (ip[0] == null) continue;
                    res = InetAddress.getByName(ip[0]);
                    break;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (res == null) {
            res = last_public_ip_address;
        } else {
            last_public_ip_address = res;
            last_public_ip_address_time = now;
        }
        return res;
    }

    @Override
    public String reverseDNSLookup(InetAddress address) {
        final AESemaphore sem = new AESemaphore("Utilities:reverseDNS");
        final String[] res = new String[]{null};
        IPToHostNameResolver.addResolverRequest(address.getHostAddress(), new IPToHostNameResolverListener(){

            public void IPResolutionComplete(String result, boolean succeeded) {
                if (succeeded) {
                    res[0] = result;
                }
                sem.release();
            }
        });
        sem.reserve(60000L);
        return res[0];
    }

    @Override
    public long getCurrentSystemTime() {
        return SystemTime.getCurrentTime();
    }

    @Override
    public ByteArrayWrapper createWrapper(byte[] data) {
        return new HashWrapper(data);
    }

    @Override
    public AggregatedDispatcher createAggregatedDispatcher(final long idle_dispatch_time, final long max_queue_size) {
        return new AggregatedDispatcher(){
            private AggregatedList list;
            {
                this.list = UtilitiesImpl.this.createAggregatedList(new AggregatedListAcceptor(){

                    public void accept(List l) {
                        for (int i = 0; i < l.size(); ++i) {
                            try {
                                ((Runnable)l.get(i)).run();
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                }, idle_dispatch_time, max_queue_size);
            }

            public void add(Runnable runnable) {
                this.list.add(runnable);
            }

            public Runnable remove(Runnable runnable) {
                return (Runnable)this.list.remove(runnable);
            }

            public void destroy() {
                this.list.destroy();
            }
        };
    }

    @Override
    public AggregatedList createAggregatedList(final AggregatedListAcceptor acceptor, final long idle_dispatch_time, final long max_queue_size) {
        return new AggregatedList(){
            AEMonitor timer_mon = new AEMonitor("aggregatedList");
            Timer timer = new Timer("AggregatedList");
            TimerEvent event;
            List list = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void add(Object obj) {
                List dispatch_now = null;
                try {
                    this.timer_mon.enter();
                    if (max_queue_size > 0L && max_queue_size == (long)this.list.size()) {
                        dispatch_now = this.list;
                        this.list = new ArrayList();
                    }
                    this.list.add(obj);
                    long now = SystemTime.getCurrentTime();
                    if (this.event != null) {
                        this.event.cancel();
                    }
                    this.event = this.timer.addEvent(now + idle_dispatch_time, new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            this.dispatch();
                        }
                    });
                }
                finally {
                    this.timer_mon.exit();
                }
                if (dispatch_now != null) {
                    this.dispatch(dispatch_now);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object remove(Object obj) {
                Object res = null;
                try {
                    this.timer_mon.enter();
                    Object object = res = this.list.remove(obj) ? obj : null;
                    if (res != null) {
                        long now = SystemTime.getCurrentTime();
                        if (this.event != null) {
                            this.event.cancel();
                        }
                        this.event = this.list.size() == 0 ? null : this.timer.addEvent(now + idle_dispatch_time, new TimerEventPerformer(){

                            public void perform(TimerEvent event2) {
                                this.dispatch();
                            }
                        });
                    }
                }
                finally {
                    this.timer_mon.exit();
                }
                return res;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void dispatch() {
                List dispatch_list;
                try {
                    this.timer_mon.enter();
                    dispatch_list = this.list;
                    this.list = new ArrayList();
                }
                finally {
                    this.timer_mon.exit();
                }
                this.dispatch(dispatch_list);
            }

            protected void dispatch(List l) {
                if (l.size() > 0) {
                    try {
                        acceptor.accept(l);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }

            public void destroy() {
                this.dispatch();
                this.timer.destroy();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void callWithPluginThreadContext(PluginInterface pi, Runnable target) {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            target.run();
        }
        finally {
            tls.set(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends Exception> void callWithPluginThreadContext(PluginInterface pi, runnableWithException<T> target) throws T {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            target.run();
        }
        finally {
            tls.set(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T callWithPluginThreadContext(PluginInterface pi, runnableWithReturn<T> target) {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            T t = target.run();
            return t;
        }
        finally {
            tls.set(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T, S extends Exception> T callWithPluginThreadContext(PluginInterface pi, runnableWithReturnAndException<T, S> target) throws S {
        PluginInterface existing = tls.get();
        try {
            tls.set(pi);
            T t = target.run();
            return t;
        }
        finally {
            tls.set(existing);
        }
    }

    public static PluginInterface getPluginThreadContext() {
        return tls.get();
    }

    @Override
    public Map readResilientBEncodedFile(File parent_dir, String file_name, boolean use_backup) {
        return FileUtil.readResilientFile(parent_dir, file_name, use_backup);
    }

    @Override
    public void writeResilientBEncodedFile(File parent_dir, String file_name, Map data, boolean use_backup) {
        FileUtil.writeResilientFile(parent_dir, file_name, data, use_backup);
    }

    @Override
    public int compareVersions(String v1, String v2) {
        return Constants.compareVersions(v1, v2);
    }

    @Override
    public String normaliseFileName(String f_name) {
        return FileUtil.convertOSSpecificChars(f_name, false);
    }

    @Override
    public DelayedTask createDelayedTask(Runnable target) {
        return UtilitiesImpl.addDelayedTask(this.pi.getPluginName(), target);
    }

    public static DelayedTask addDelayedTask(String name, Runnable r) {
        DelayedTaskImpl res = new DelayedTaskImpl(name);
        res.setTask(r);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueTask(DelayedTaskImpl task2, int pos) {
        List list = delayed_tasks;
        synchronized (list) {
            delayed_tasks.add(pos == -1 ? delayed_tasks.size() : pos, task2);
            delayed_tasks_sem.release();
            if (delayed_task_thread == null) {
                delayed_task_thread = new AEThread2("Utilities:delayedTask", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            PluginInitializer.addInitThread();
                            while (true) {
                                DelayedTaskImpl task2;
                                if (!delayed_tasks_sem.reserve(5000L)) {
                                    List list = delayed_tasks;
                                    synchronized (list) {
                                        if (delayed_tasks.isEmpty()) {
                                            delayed_task_thread = null;
                                            break;
                                        }
                                    }
                                }
                                List list = delayed_tasks;
                                synchronized (list) {
                                    task2 = (DelayedTaskImpl)delayed_tasks.remove(0);
                                }
                                task2.run();
                            }
                        }
                        finally {
                            PluginInitializer.removeInitThread();
                        }
                    }
                };
                delayed_task_thread.setPriority(1);
                delayed_task_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSearchProvider(SearchProvider provider2) throws SearchException {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            search_providers.add(new Object[]{this.pi, provider2});
            ArrayList<searchManager> managers = new ArrayList<searchManager>(search_managers);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (int i = 0; i < managers.size(); ++i) {
                ((searchManager)managers.get(i)).addProvider(this.pi, provider2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchInitiator getSearchInitiator() throws SearchException {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            ArrayList<searchManager> managers = new ArrayList<searchManager>(search_managers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (managers.size() == 0) {
                throw new SearchException("No search managers registered - try later");
            }
            return (SearchInitiator)managers.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchManager(searchManager manager) {
        Class<UtilitiesImpl> clazz = UtilitiesImpl.class;
        synchronized (UtilitiesImpl.class) {
            search_managers.add(manager);
            ArrayList<Object[]> providers = new ArrayList<Object[]>(search_providers);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (int i = 0; i < providers.size(); ++i) {
                Object[] entry = (Object[])providers.get(i);
                manager.addProvider((PluginInterface)entry[0], (SearchProvider)entry[1]);
            }
            return;
        }
    }

    static {
        tls = new ThreadLocal<PluginInterface>(){

            @Override
            public PluginInterface initialValue() {
                return null;
            }
        };
        search_managers = new ArrayList<searchManager>();
        search_providers = new ArrayList<Object[]>();
        delayed_tasks = new ArrayList();
        delayed_tasks_sem = new AESemaphore("Utilities:delayedTask");
    }

    static class DelayedTaskImpl
    implements DelayedTask {
        private String name;
        private Runnable target;
        private long create_time = SystemTime.getCurrentTime();
        private long run_time;

        private DelayedTaskImpl(String _name) {
            this.name = _name;
        }

        public void setTask(Runnable _target) {
            this.target = _target;
        }

        public void queue() {
            if (this.target == null) {
                throw new RuntimeException("Target must be set before queueing");
            }
            UtilitiesImpl.queueTask(this, -1);
        }

        public void queueFirst() {
            if (this.target == null) {
                throw new RuntimeException("Target must be set before queueing");
            }
            UtilitiesImpl.queueTask(this, 0);
        }

        protected void run() {
            try {
                this.run_time = SystemTime.getCurrentTime();
                this.target.run();
                long now = SystemTime.getCurrentTime();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LogIDs.PLUGIN, 0, "Delayed task '" + this.getName() + "': queue_time=" + (this.run_time - this.create_time) + ", exec_time=" + (now - this.run_time)));
                }
            }
            catch (Throwable e) {
                Debug.out("Initialisation task " + this.getName() + " failed to complete", e);
            }
        }

        protected String getName() {
            return this.name + " (" + this.target.getClass() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface runnableWithException<T extends Exception> {
        public void run() throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface runnableWithReturn<T> {
        public T run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface runnableWithReturnAndException<T, S extends Exception> {
        public T run() throws S;
    }

    public static interface searchManager
    extends SearchInitiator {
        public void addProvider(PluginInterface var1, SearchProvider var2);
    }
}

