/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;

public class MenuItemManager {
    private static MenuItemManager instance;
    private static AEMonitor class_mon;
    private Map items;
    private AEMonitor items_mon = new AEMonitor("MenuManager:items");

    private MenuItemManager() {
        this.items = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MenuItemManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new MenuItemManager();
            }
            MenuItemManager menuItemManager = instance;
            return menuItemManager;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenuItem(MenuItem item) {
        try {
            String name = item.getResourceKey();
            String sMenuID = item.getMenuID();
            try {
                this.items_mon.enter();
                LinkedHashMap<String, MenuItem> mTypes = (LinkedHashMap<String, MenuItem>)this.items.get(sMenuID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, MenuItem>();
                    this.items.put(sMenuID, mTypes);
                }
                mTypes.put(name, item);
            }
            finally {
                this.items_mon.exit();
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Menu Item");
            Debug.printStackTrace(e);
        }
    }

    public void removeAllMenuItems(String sMenuID) {
        this.items.remove(sMenuID);
    }

    public void removeMenuItem(MenuItem item) {
        Map menu_item_map = (Map)this.items.get(item.getMenuID());
        if (menu_item_map != null) {
            menu_item_map.remove(item.getResourceKey());
        }
    }

    public MenuItem[] getAllAsArray(String sMenuID) {
        Map local_menu_item_map = (Map)this.items.get(sMenuID);
        Map global_menu_item_map = (Map)this.items.get(null);
        if (local_menu_item_map == null && global_menu_item_map == null) {
            return new MenuItem[0];
        }
        if (sMenuID == null) {
            local_menu_item_map = null;
        }
        ArrayList l = new ArrayList();
        if (local_menu_item_map != null) {
            l.addAll(local_menu_item_map.values());
        }
        if (global_menu_item_map != null) {
            l.addAll(global_menu_item_map.values());
        }
        return l.toArray(new MenuItem[l.size()]);
    }

    public MenuItem[] getAllAsArray(String[] menu_ids) {
        ArrayList l = new ArrayList();
        for (int i = 0; i < menu_ids.length; ++i) {
            this.addMenuItems(menu_ids[i], l);
        }
        this.addMenuItems(null, l);
        return l.toArray(new MenuItem[l.size()]);
    }

    private void addMenuItems(String menu_id, ArrayList l) {
        Map menu_map = (Map)this.items.get(menu_id);
        if (menu_map != null) {
            l.addAll(menu_map.values());
        }
    }

    static {
        class_mon = new AEMonitor("MenuManager");
    }
}

