/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.jws;

import com.aelitis.azureus.launcher.Launcher;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class Main
implements Plugin,
PluginListener,
PluginEventListener {
    protected static Main singleton;
    protected static AESemaphore init_sem;
    private static AEMonitor class_mon;
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected AESemaphore ready_sem = new AESemaphore("UIJWSReady");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Main getSingleton(String[] args) {
        try {
            class_mon.enter();
            if (singleton == null) {
                new AEThread("plugin initialiser "){

                    public void runSupport() {
                        PluginManager.registerPlugin(Main.class);
                        Properties props = new Properties();
                        props.put("MULTI_INSTANCE", "false");
                        PluginManager.startAzureus(1, props);
                    }
                }.start();
                init_sem.reserve();
            }
            Main main = singleton;
            return main;
        }
        finally {
            class_mon.exit();
        }
    }

    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        singleton = this;
        this.log = this.plugin_interface.getLogger().getChannel("JWS Launcher");
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                System.out.println(content);
            }

            public void messageLogged(String str, Throwable error) {
                System.out.println(str);
                Debug.printStackTrace(error);
            }
        });
        this.log.log(1, "Plugin Initialised");
        this.plugin_interface.addListener(this);
        this.plugin_interface.addEventListener(this);
        init_sem.release();
    }

    public void initializationComplete() {
    }

    public void handleEvent(PluginEvent ev) {
        System.out.println("PluginEvent:" + ev.getType());
        if (ev.getType() == 2) {
            this.ready_sem.release();
        }
    }

    protected void process() {
        this.ready_sem.reserve();
        this.log.log(1, "processing jws request");
        Properties props = System.getProperties();
        Enumeration<Object> enumx = props.keys();
        while (enumx.hasMoreElements()) {
            String key = (String)enumx.nextElement();
            this.log.log(1, "\t" + key + " = '" + props.get(key) + "'");
        }
        String torrent_url = (String)props.get("azureus.javaws.torrent_url");
        this.log.log(1, "Torrent URL = " + torrent_url);
        if (torrent_url != null) {
            try {
                this.plugin_interface.getDownloadManager().addDownload(new URL(torrent_url));
            }
            catch (Throwable e) {
                this.log.log(e);
            }
        }
    }

    public void closedownInitiated() {
    }

    public void closedownComplete() {
    }

    public static void main(String[] args) {
        if (Launcher.checkAndLaunch(Main.class, args)) {
            return;
        }
        Main.getSingleton(args).process();
    }

    static {
        init_sem = new AESemaphore("UIJWS");
        class_mon = new AEMonitor("UIJWS");
    }
}

