/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.net.URLDecoder;
import java.util.Map;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReportConstants;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReporterListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReporterWindow;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;

public class FileDownloadWindow
implements TorrentDownloaderCallBackInterface,
IProgressReportConstants {
    TorrentDownloader downloader;
    TorrentDownloaderCallBackInterface listener;
    IProgressReporter pReporter;
    Shell parent;
    String original_url;
    String decoded_url;
    String referrer;
    Map request_properties;
    String dirName = null;
    String shortURL = null;

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties) {
        this(parent, url, referrer, request_properties, null);
    }

    public FileDownloadWindow(Shell parent, String url, String referrer, Map request_properties, TorrentDownloaderCallBackInterface listener) {
        this.parent = parent;
        this.original_url = url;
        this.referrer = referrer;
        this.listener = listener;
        this.request_properties = request_properties;
        try {
            this.decoded_url = URLDecoder.decode(this.original_url, "UTF8");
        }
        catch (Throwable e) {
            this.decoded_url = this.original_url;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDownloadWindow.this.init();
            }
        });
    }

    private void init() {
        if (COConfigurationManager.getBooleanParameter("Save Torrent Files")) {
            try {
                this.dirName = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
            }
            catch (Exception egnore) {
                // empty catch block
            }
        }
        if (this.dirName == null) {
            DirectoryDialog dd = new DirectoryDialog(this.parent, 0);
            dd.setText(MessageText.getString("fileDownloadWindow.saveTorrentIn"));
            this.dirName = dd.open();
        }
        if (this.dirName == null) {
            return;
        }
        this.pReporter = ProgressReportingManager.getInstance().addReporter();
        this.setupAndShowDialog();
        this.downloader = TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)this, this.original_url, this.referrer, this.request_properties, this.dirName);
        this.downloader.setIgnoreReponseCode(true);
        this.downloader.start();
    }

    private void setupAndShowDialog() {
        if (null != this.pReporter) {
            this.pReporter.setName(MessageText.getString("fileDownloadWindow.state_downloading") + ": " + this.getFileName(this.decoded_url));
            this.pReporter.appendDetailMessage(MessageText.getString("fileDownloadWindow.downloading") + this.getShortURL(this.decoded_url));
            this.pReporter.setTitle(MessageText.getString("fileDownloadWindow.title"));
            this.pReporter.setIndeterminate(true);
            this.pReporter.setCancelAllowed(true);
            this.pReporter.setRetryAllowed(true);
            this.pReporter.addListener(new IProgressReporterListener(){

                public int report(IProgressReport pReport) {
                    switch (pReport.getReportType()) {
                        case 1: {
                            if (null == FileDownloadWindow.this.downloader) break;
                            FileDownloadWindow.this.downloader.cancel();
                            Logger.log(new LogEvent(LogIDs.LOGGER, MessageText.getString("FileDownload.canceled", new String[]{FileDownloadWindow.this.getShortURL(FileDownloadWindow.this.decoded_url)})));
                            break;
                        }
                        case 2: {
                            return 1;
                        }
                        case 5: {
                            if (!pReport.isRetryAllowed()) break;
                            FileDownloadWindow.this.downloader.cancel();
                            FileDownloadWindow.this.downloader = TorrentDownloaderFactory.create((TorrentDownloaderCallBackInterface)FileDownloadWindow.this, FileDownloadWindow.this.original_url, FileDownloadWindow.this.referrer, FileDownloadWindow.this.request_properties, FileDownloadWindow.this.dirName);
                            FileDownloadWindow.this.downloader.setIgnoreReponseCode(true);
                            FileDownloadWindow.this.downloader.start();
                            break;
                        }
                    }
                    return 0;
                }
            });
            ProgressReporterWindow.open(this.pReporter, 2);
        }
    }

    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (this.listener != null) {
            this.listener.TorrentDownloaderEvent(state, inf);
        }
        this.update();
    }

    private void update() {
        int state = this.downloader.getDownloadState();
        int percentDone = this.downloader.getPercentDone();
        IProgressReport pReport = this.pReporter.getProgressReport();
        switch (state) {
            case 6: {
                if (!pReport.isCanceled()) {
                    this.pReporter.cancel();
                }
                return;
            }
            case 2: {
                this.pReporter.setPercentage(percentDone, this.downloader.getStatus());
                break;
            }
            case 4: {
                if (pReport.isCanceled()) {
                    return;
                }
                this.pReporter.setErrorMessage(MessageText.getString("fileDownloadWindow.state_error") + this.downloader.getError());
                return;
            }
            case 3: {
                this.pReporter.setDone();
                if (this.listener == null) {
                    TorrentOpener.openTorrent(this.downloader.getFile().getAbsolutePath());
                }
                return;
            }
        }
    }

    private String getShortURL(String url) {
        if (null == this.shortURL) {
            this.shortURL = url;
            int amp_pos = this.shortURL.indexOf(38);
            if (amp_pos != -1) {
                this.shortURL = this.shortURL.substring(0, amp_pos + 1) + "...";
            }
            this.shortURL = this.shortURL.replaceAll("&", "&&");
        }
        return this.shortURL;
    }

    private String getFileName(String url) {
        try {
            String title;
            String lc_url = url.toLowerCase(MessageText.LOCALE_ENGLISH);
            int idx = lc_url.indexOf("&title=");
            if (idx >= 0 && (idx = (title = url.substring(idx + "&title=".length())).indexOf(38)) > 0) {
                title = title.substring(0, idx);
                if ((title = title.replace('+', ' ')).length() > 0) {
                    return title;
                }
            }
            if ((lc_url = (url = this.getShortURL(url)).toLowerCase(MessageText.LOCALE_ENGLISH)).startsWith("magnet:") || lc_url.startsWith("dht:")) {
                return url;
            }
            String tmp = url.substring(url.lastIndexOf(47) + 1);
            if (tmp.toLowerCase(MessageText.LOCALE_ENGLISH).lastIndexOf(".torrent") > 0) {
                tmp = tmp.substring(0, tmp.toLowerCase(MessageText.LOCALE_ENGLISH).lastIndexOf(".torrent"));
            }
            return tmp + ".torrent";
        }
        catch (Exception exception) {
            return url;
        }
    }
}

