/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.UISwitcherUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedToolItem;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class IconBar {
    private final boolean OVERRIDE_SHOW_UISWITCHER = System.getProperty("ui.toolbar.uiswitcher", "0").equals("1");
    CoolBar coolBar;
    Composite parent;
    Map itemKeyToControl;
    IconBarEnabler currentEnabler;
    private Composite cIconBar;
    private static List listeners = new ArrayList(0);
    private Listener listenerToolItem;

    public IconBar(Composite parent) {
        boolean enableUISwitcher;
        this.parent = parent;
        this.listenerToolItem = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 13) {
                    if (IconBar.this.currentEnabler != null) {
                        IconBar.this.currentEnabler.itemActivated((String)e.widget.getData("key"));
                    }
                } else if (e.type == 12) {
                    ImageLoader.getInstance().releaseImage((String)e.widget.getData("ImageID"));
                }
            }
        };
        this.cIconBar = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.cIconBar.setLayout((Layout)layout);
        this.itemKeyToControl = new HashMap();
        this.coolBar = new CoolBar(this.cIconBar, Constants.isWindows ? 0x800000 : 0);
        this.initBar();
        this.coolBar.setLocked(true);
        this.coolBar.setLayoutData((Object)new GridData(768));
        boolean bl = enableUISwitcher = this.OVERRIDE_SHOW_UISWITCHER || COConfigurationManager.getBooleanParameter("ui.toolbar.uiswitcher") || COConfigurationManager.getBooleanParameter("ui.asked", false);
        if (enableUISwitcher) {
            ToolBar tbSwitch = new ToolBar(this.cIconBar, 0x800000);
            GridData gridData = new GridData(128);
            tbSwitch.setLayoutData((Object)gridData);
            ToolItem tiSwitch = new ToolItem(tbSwitch, 8);
            tiSwitch.setImage(ImageLoader.getInstance().getImage("cb_switch"));
            Messages.setLanguageText((Widget)tiSwitch, "iconBar.switch.tooltip", true);
            tiSwitch.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctions uif;
                    int result;
                    String uiNew;
                    String uiOld = COConfigurationManager.getStringParameter("ui");
                    if (!uiOld.equals(uiNew = UISwitcherUtil.openSwitcherWindow(true)) && !IconBar.this.parent.isDisposed() && (result = MessageBoxShell.open(IconBar.this.parent.getShell(), MessageText.getString("dialog.uiswitcher.restart.title"), MessageText.getString("dialog.uiswitcher.restart.text"), new String[]{MessageText.getString("UpdateWindow.restart"), MessageText.getString("UpdateWindow.restartLater")}, 0)) == 0 && (uif = UIFunctionsManager.getUIFunctions()) != null) {
                        uif.dispose(true, false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            tiSwitch.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ImageLoader.getInstance().releaseImage("cb_switch");
                }
            });
        }
    }

    public void setEnabled(String itemKey, boolean enabled) {
        BufferedToolItem BufferedToolItem2 = (BufferedToolItem)this.itemKeyToControl.get(itemKey);
        if (BufferedToolItem2 != null) {
            BufferedToolItem2.setEnabled(enabled);
        }
    }

    public void setSelection(String itemKey, boolean selection) {
        BufferedToolItem BufferedToolItem2 = (BufferedToolItem)this.itemKeyToControl.get(itemKey);
        if (BufferedToolItem2 != null) {
            BufferedToolItem2.setSelection(selection);
        }
    }

    public void setCurrentEnabler(IconBarEnabler enabler) {
        this.currentEnabler = enabler;
        this.refreshEnableItems();
    }

    public IconBarEnabler getCurrentEnabler() {
        return this.currentEnabler;
    }

    private void refreshEnableItems() {
        for (String key : this.itemKeyToControl.keySet()) {
            BufferedToolItem BufferedToolItem2 = (BufferedToolItem)this.itemKeyToControl.get(key);
            if (BufferedToolItem2 == null) continue;
            if (this.currentEnabler != null) {
                BufferedToolItem2.setEnabled(this.currentEnabler.isEnabled(key));
                BufferedToolItem2.setSelection(this.currentEnabler.isSelected(key));
                continue;
            }
            BufferedToolItem2.setEnabled(false);
            BufferedToolItem2.setSelection(false);
        }
    }

    private BufferedToolItem createBufferedToolItem(ToolBar toolBar, int style, String key, String imageName, String toolTipKey) {
        BufferedToolItem bufferedToolItem = new BufferedToolItem(toolBar, style);
        bufferedToolItem.setData("key", key);
        bufferedToolItem.setData("ImageID", key);
        Messages.setLanguageText(bufferedToolItem.getWidget(), toolTipKey, true);
        bufferedToolItem.setImage(ImageLoader.getInstance().getImage(imageName));
        bufferedToolItem.addListener(13, this.listenerToolItem);
        bufferedToolItem.addListener(12, this.listenerToolItem);
        this.itemKeyToControl.put(key, bufferedToolItem);
        return bufferedToolItem;
    }

    public void addItemKeyToControl(String key, BufferedToolItem item) {
        this.itemKeyToControl.put(key, item);
    }

    private void initBar() {
        CoolItem coolItem = new CoolItem(this.coolBar, 0);
        ToolBar toolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.createBufferedToolItem(toolBar, 8, "open", "cb_open_no_default", "iconBar.open.tooltip");
        this.createBufferedToolItem(toolBar, 8, "new", "cb_new", "iconBar.new.tooltip");
        toolBar.pack();
        Point p = toolBar.getSize();
        coolItem.setControl((Control)toolBar);
        coolItem.setSize(coolItem.computeSize(p.x, p.y));
        coolItem.setMinimumSize(p.x, p.y);
        coolItem = new CoolItem(this.coolBar, 0);
        toolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.createBufferedToolItem(toolBar, 8, "top", "cb_top", "iconBar.top.tooltip");
        this.createBufferedToolItem(toolBar, 8, "up", "cb_up", "iconBar.up.tooltip");
        this.createBufferedToolItem(toolBar, 8, "down", "cb_down", "iconBar.down.tooltip");
        this.createBufferedToolItem(toolBar, 8, "bottom", "cb_bottom", "iconBar.bottom.tooltip");
        new BufferedToolItem(toolBar, 2);
        this.createBufferedToolItem(toolBar, 8, "run", "cb_run", "iconBar.run.tooltip");
        new BufferedToolItem(toolBar, 2);
        this.createBufferedToolItem(toolBar, 8, "start", "cb_start", "iconBar.start.tooltip");
        this.createBufferedToolItem(toolBar, 8, "stop", "cb_stop", "iconBar.stop.tooltip");
        this.createBufferedToolItem(toolBar, 8, "remove", "cb_remove", "iconBar.remove.tooltip");
        new BufferedToolItem(toolBar, 2);
        this.createBufferedToolItem(toolBar, 8, "editcolumns", "cb_editcolumns", "iconBar.editcolumns.tooltip");
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            try {
                IconBarListener l = (IconBarListener)iter.next();
                l.iconBarInitialized(this.coolBar, this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        toolBar.pack();
        p = toolBar.getSize();
        coolItem.setControl((Control)toolBar);
        if (Constants.isOSX) {
            p.x += 12;
        }
        coolItem.setSize(p.x, p.y);
        coolItem.setMinimumSize(p.x, p.y);
    }

    public void setLayoutData(Object layoutData) {
        this.cIconBar.setLayoutData(layoutData);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        shell.setLayout((Layout)layout);
        IconBar ibar = new IconBar((Composite)shell);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        ibar.setLayoutData(formData);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Composite getComposite() {
        return this.cIconBar;
    }

    public void delete() {
        Utils.disposeComposite(this.cIconBar);
        this.itemKeyToControl.clear();
        this.currentEnabler = null;
    }

    public static void addListener(IconBarListener l) {
        if (!listeners.contains(l)) {
            listeners.add(l);
        }
    }

    public static interface IconBarListener {
        public void iconBarInitialized(CoolBar var1, IconBar var2);
    }
}

