/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.skin.SkinProperties;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.Utils;

public class ImageRepository {
    private static final String[] noCacheExtList = new String[]{".exe"};
    private static final boolean forceNoAWT = Constants.isOSX;

    static void addPath(String path, String id) {
        SkinProperties[] skinProperties = ImageLoader.getInstance().getSkinProperties();
        if (skinProperties != null && skinProperties.length > 0) {
            skinProperties[0].addProperty(id, path);
        }
    }

    public static org.eclipse.swt.graphics.Image getImage(String name) {
        return ImageLoader.getInstance().getImage(name);
    }

    public static org.eclipse.swt.graphics.Image getIconFromExtension(String ext, boolean bBig, boolean minifolder) {
        org.eclipse.swt.graphics.Image image = null;
        try {
            Program program;
            String key = "osicon" + ext;
            if (bBig) {
                key = key + "-big";
            }
            if (minifolder) {
                key = key + "-fold";
            }
            if (ImageLoader.isRealImage(image = ImageLoader.getInstance().getImage(key))) {
                return image;
            }
            ImageLoader.getInstance().releaseImage(key);
            image = null;
            ImageData imageData = null;
            if (Constants.isWindows && bBig) {
                try {
                    Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.win32.Win32UIEnhancer");
                    Method method = ehancerClass.getMethod("getBigImageData", String.class);
                    imageData = (ImageData)method.invoke(null, ext);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
            if (imageData == null && (program = Program.findProgram((String)ext)) != null) {
                imageData = program.getImageData();
            }
            if (imageData != null) {
                image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
                if (!bBig) {
                    image = ImageRepository.force16height(image);
                }
                if (minifolder) {
                    image = ImageRepository.minifolderize(image, bBig);
                }
                ImageLoader.getInstance().addImageNoDipose(key, image);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (image == null) {
            return ImageRepository.getImage(minifolder ? "folder" : "transparent");
        }
        return image;
    }

    private static org.eclipse.swt.graphics.Image minifolderize(org.eclipse.swt.graphics.Image img, boolean big) {
        org.eclipse.swt.graphics.Image imgFolder = ImageRepository.getImage(big ? "folder" : "foldersmall");
        Rectangle folderBounds = imgFolder.getBounds();
        Rectangle dstBounds = img.getBounds();
        org.eclipse.swt.graphics.Image tempImg = Utils.renderTransparency(Display.getCurrent(), img, imgFolder, new Point(dstBounds.width - folderBounds.width, dstBounds.height - folderBounds.height), 204);
        if (tempImg != null) {
            img.dispose();
            img = tempImg;
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static org.eclipse.swt.graphics.Image force16height(org.eclipse.swt.graphics.Image image) {
        if (image == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        if (bounds.height != 16) {
            org.eclipse.swt.graphics.Image newImage = new org.eclipse.swt.graphics.Image(image.getDevice(), 16, 16);
            GC gc = new GC((Drawable)newImage);
            try {
                if (!Constants.isUnix) {
                    gc.setAdvanced(true);
                }
                gc.drawImage(image, 0, 0, bounds.width, bounds.height, 0, 0, 16, 16);
            }
            finally {
                gc.dispose();
            }
            image.dispose();
            image = newImage;
        }
        return image;
    }

    public static org.eclipse.swt.graphics.Image getPathIcon(String path, boolean bBig, boolean minifolder) {
        String ext;
        if (path == null) {
            return null;
        }
        File file = null;
        boolean bDeleteFile = false;
        boolean noAWT = forceNoAWT || !bBig;
        try {
            Object sfInstance;
            Method method;
            String key;
            file = new File(path);
            if (file.isDirectory()) {
                if (noAWT) {
                    return ImageRepository.getImage("folder");
                }
                key = file.getPath();
            } else {
                int idxDot = file.getName().lastIndexOf(".");
                if (idxDot == -1) {
                    if (noAWT) {
                        return ImageRepository.getImage("folder");
                    }
                    key = "?!blank";
                } else {
                    String ext2;
                    key = ext2 = file.getName().substring(idxDot);
                    if (noAWT) {
                        return ImageRepository.getIconFromExtension(ext2, bBig, minifolder);
                    }
                    for (int i = 0; i < noCacheExtList.length; ++i) {
                        if (!noCacheExtList[i].equalsIgnoreCase(ext2)) continue;
                        key = file.getPath();
                        break;
                    }
                }
            }
            if (bBig) {
                key = key + "-big";
            }
            if (minifolder) {
                key = key + "-fold";
            }
            key = "osicon" + key;
            org.eclipse.swt.graphics.Image image = ImageLoader.getInstance().getImage(key);
            if (ImageLoader.isRealImage(image)) {
                return image;
            }
            ImageLoader.getInstance().releaseImage(key);
            image = null;
            boolean bl = bDeleteFile = !file.exists();
            if (bDeleteFile) {
                file = File.createTempFile("AZ_", FileUtil.getExtension(path));
            }
            Image awtImage = null;
            Class<?> sfClass = Class.forName("sun.awt.shell.ShellFolder");
            if (sfClass != null && file != null && (method = sfClass.getMethod("getShellFolder", File.class)) != null && (sfInstance = method.invoke(null, file)) != null && (method = sfClass.getMethod("getIcon", Boolean.TYPE)) != null) {
                awtImage = (Image)method.invoke(sfInstance, new Boolean(bBig));
            }
            if (awtImage != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)awtImage), "png", outStream);
                ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), (InputStream)inStream);
                if (!bBig) {
                    image = ImageRepository.force16height(image);
                }
                if (minifolder) {
                    image = ImageRepository.minifolderize(image, bBig);
                }
                ImageLoader.getInstance().addImageNoDipose(key, image);
                if (bDeleteFile && file != null && file.exists()) {
                    file.delete();
                }
                return image;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bDeleteFile && file != null && file.exists()) {
            file.delete();
        }
        if ((ext = FileUtil.getExtension(path)).length() == 0) {
            return ImageRepository.getImage("folder");
        }
        return ImageRepository.getIconFromExtension(ext, bBig, minifolder);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new FillLayout(512));
        final Label label = new Label((Composite)shell, 2048);
        final Text text = new Text((Composite)shell, 2048);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                org.eclipse.swt.graphics.Image pathIcon = ImageRepository.getPathIcon(text.getText(), false, false);
                label.setImage(pathIcon);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

