/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.StringIterator;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.OpenUrlWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;

public class OpenTorrentWindow
implements TorrentDownloaderCallBackInterface,
UIUpdatable {
    private static final int MIN_BUTTON_HEIGHT = Constants.isWindows ? 24 : -1;
    private static final String PARAM_DEFSAVEPATH = "Default save path";
    private static final String PARAM_MOVEWHENDONE = "Move Completed When Done";
    private static final String PARAM_VIEWMODE = "OpenTorrentWindow.viewMode";
    private static final String MSG_ALREADY_EXISTS = "OpenTorrentWindow.mb.alreadyExists";
    private static final String MSG_ALREADY_EXISTS_NAME = "OpenTorrentWindow.mb.alreadyExists.default.name";
    private static final int STARTMODE_QUEUED = 0;
    private static final int STARTMODE_STOPPED = 1;
    private static final int STARTMODE_FORCESTARTED = 2;
    private static final int STARTMODE_SEEDING = 3;
    private static final int QUEUELOCATION_TOP = 0;
    private static final int QUEUELOCATION_BOTTOM = 1;
    private static final String[] startModes = new String[]{"queued", "stopped", "forceStarted", "seeding"};
    private static final String[] queueLocations = new String[]{"first", "last"};
    private static OpenTorrentWindow stOpenTorrentWindow = null;
    private Shell shell;
    private Table dataFileTable;
    private TableEditor dataFileTableEditor;
    private Table torrentTable;
    private Button ok;
    private Combo cmbDataDir;
    private Composite cSaveTo;
    private Combo cmbStartMode = null;
    private Combo cmbQueueLocation = null;
    private GlobalManager gm;
    private ArrayList dataFiles = new ArrayList();
    private ArrayList torrentList = new ArrayList();
    private ArrayList downloaders = new ArrayList();
    private boolean bOverrideStartModeToStopped = false;
    private boolean bDefaultForSeeding;
    private ArrayList disposeList = new ArrayList();
    private boolean bClosed = false;
    private Shell shellForChildren;
    private String sDestDir;
    protected boolean bSkipDataDirModify = false;
    private StringList dirList;
    private Label dataFileTableLabel;
    private Composite diskspaceComp;
    private int activeTorrentCount = 0;
    private static final int EDIT_COLUMN_INDEX = 1;
    private final Map fileStatCache = new WeakHashMap(20);
    private final Map parentToRootCache = new WeakHashMap(20);
    private volatile boolean diskFreeInfoRefreshPending = false;
    private volatile boolean diskFreeInfoRefreshRunning = false;

    public static final synchronized void invoke(Shell parent, GlobalManager gm, String sPathOfFilesToOpen, String[] sFilesToOpen, boolean bDefaultStopped, boolean bForSeeding, boolean bPopupOpenURL) {
        String saveSilentlyDir = null;
        if (stOpenTorrentWindow == null) {
            boolean bMustOpen;
            boolean bl = bMustOpen = sPathOfFilesToOpen == null && sFilesToOpen == null || bForSeeding;
            if (!bMustOpen) {
                saveSilentlyDir = OpenTorrentWindow.getSaveSilentlyDir();
                bMustOpen = saveSilentlyDir == null;
            }
            stOpenTorrentWindow = new OpenTorrentWindow(parent, gm, bMustOpen);
        } else if (OpenTorrentWindow.stOpenTorrentWindow.shell != null) {
            OpenTorrentWindow.stOpenTorrentWindow.shell.forceActive();
        }
        if (stOpenTorrentWindow != null) {
            OpenTorrentWindow openTorrentWindow = stOpenTorrentWindow;
            openTorrentWindow.bOverrideStartModeToStopped = bDefaultStopped;
            openTorrentWindow.bDefaultForSeeding = bForSeeding;
            if (sFilesToOpen != null && !bPopupOpenURL && openTorrentWindow.addTorrents(sPathOfFilesToOpen, sFilesToOpen) == 0 && openTorrentWindow.torrentList.size() == 0 && openTorrentWindow.downloaders.size() == 0) {
                openTorrentWindow.close(true, true);
                return;
            }
            if (bPopupOpenURL) {
                openTorrentWindow.browseURL();
            }
            if (saveSilentlyDir != null) {
                openTorrentWindow.sDestDir = saveSilentlyDir;
                for (int i = 0; i < openTorrentWindow.torrentList.size(); ++i) {
                    TorrentInfo info = (TorrentInfo)openTorrentWindow.torrentList.get(i);
                    info.renameDuplicates();
                }
                openTorrentWindow.openTorrents();
                openTorrentWindow.close(true, false);
            }
        }
    }

    public static final synchronized void invoke(Shell parent, GlobalManager gm) {
        OpenTorrentWindow.invoke(parent, gm, null, null, false, false, false);
    }

    public static final synchronized void invokeURLPopup(Shell parent, GlobalManager gm) {
        OpenTorrentWindow.invoke(parent, gm, null, null, false, false, true);
    }

    private OpenTorrentWindow(Shell parent, GlobalManager gm, boolean bOpenWindow) {
        this.gm = gm;
        this.sDestDir = COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH);
        if (bOpenWindow) {
            this.openWindow(parent);
        } else {
            this.shellForChildren = parent;
        }
    }

    private void openWindow(Shell parent) {
        boolean bTorrentInClipboard = false;
        this.shellForChildren = this.shell = ShellFactory.createShell(parent, 2160);
        this.shell.setText(MessageText.getString("OpenTorrentWindow.title"));
        Utils.setShellIcon(this.shell);
        GridLayout layout = this.FixupLayout(new GridLayout(), false);
        this.shell.setLayout((Layout)layout);
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                OpenTorrentWindow.this.resizeTables(3);
            }
        });
        Clipboard clipboard = new Clipboard(this.shell.getDisplay());
        String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (sClipText != null) {
            bTorrentInClipboard = this.addTorrentsFromTextList(sClipText, true) > 0;
        }
        Composite cButtons = new Composite((Composite)this.shell, 0);
        RowLayout rLayout = new RowLayout(256);
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        cButtons.setLayout((Layout)rLayout);
        Button browseTorrent = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)browseTorrent, "OpenTorrentWindow.addFiles");
        browseTorrent.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog fDialog = new FileDialog(OpenTorrentWindow.this.shell, 4098);
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String fileName = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (fileName != null) {
                    OpenTorrentWindow.this.addTorrents(fDialog.getFilterPath(), fDialog.getFileNames());
                }
            }
        });
        Utils.setGridData(cButtons, 768, (Control)browseTorrent, MIN_BUTTON_HEIGHT);
        Button browseURL = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)browseURL, "OpenTorrentWindow.addFiles.URL");
        browseURL.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.browseURL();
            }
        });
        Button browseFolder = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)browseFolder, "OpenTorrentWindow.addFiles.Folder");
        browseFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog fDialog = new DirectoryDialog(OpenTorrentWindow.this.shell, 0);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.folder"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path != null) {
                    OpenTorrentWindow.this.addTorrents(path, null);
                }
            }
        });
        if (bTorrentInClipboard) {
            Button pasteOpen = new Button(cButtons, 8);
            Messages.setLanguageText((Widget)pasteOpen, "OpenTorrentWindow.addFiles.Clipboard");
            pasteOpen.setToolTipText(sClipText);
            pasteOpen.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Clipboard clipboard = new Clipboard(OpenTorrentWindow.this.shell.getDisplay());
                    String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    if (sClipText != null) {
                        OpenTorrentWindow.this.addTorrentsFromTextList(sClipText.trim(), false);
                    }
                }
            });
        }
        Group gTorrentsArea = new Group((Composite)this.shell, 0);
        GridData gridData = new GridData(768);
        gTorrentsArea.setLayoutData((Object)gridData);
        layout = this.FixupLayout(new GridLayout(), true);
        gTorrentsArea.setLayout((Layout)layout);
        Messages.setLanguageText((Widget)gTorrentsArea, "OpenTorrentWindow.torrentLocation");
        Composite cTorrentList = new Composite((Composite)gTorrentsArea, 0);
        gridData = new GridData(768);
        cTorrentList.setLayoutData((Object)gridData);
        this.createTorrentListArea(cTorrentList);
        Composite cTorrentOptions = new Composite((Composite)gTorrentsArea, 0);
        gridData = new GridData(768);
        cTorrentOptions.setLayoutData((Object)gridData);
        layout = this.FixupLayout(new GridLayout(), true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cTorrentOptions.setLayout((Layout)layout);
        Label label = new Label(cTorrentOptions, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "OpenTorrentWindow.torrent.options");
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode > 0) {
            Composite cTorrentModes = new Composite(cTorrentOptions, 0);
            gridData = new GridData(768);
            cTorrentModes.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cTorrentModes.setLayout((Layout)layout);
            label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "OpenTorrentWindow.startMode");
            this.cmbStartMode = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            this.cmbStartMode.setLayoutData((Object)gridData);
            this.updateStartModeCombo();
            this.cmbStartMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentWindow.this.setSelectedStartMode(OpenTorrentWindow.this.cmbStartMode.getSelectionIndex());
                }
            });
            label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "OpenTorrentWindow.addPosition");
            this.cmbQueueLocation = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            this.cmbQueueLocation.setLayoutData((Object)gridData);
            this.updateQueueLocationCombo();
            this.cmbQueueLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentWindow.this.setSelectedQueueLocation(OpenTorrentWindow.this.cmbQueueLocation.getSelectionIndex());
                }
            });
        }
        this.cSaveTo = new Composite(cTorrentOptions, 0);
        layout = this.FixupLayout(new GridLayout(), false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.cSaveTo.setLayout((Layout)layout);
        Label lblDataDir = new Label(this.cSaveTo, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        lblDataDir.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lblDataDir, "OpenTorrentWindow.dataLocation");
        this.cmbDataDir = new Combo(this.cSaveTo, 2048);
        gridData = new GridData(768);
        this.cmbDataDir.setLayoutData((Object)gridData);
        this.cmbDataDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OpenTorrentWindow.this.bSkipDataDirModify) {
                    return;
                }
                OpenTorrentWindow.this.sDestDir = OpenTorrentWindow.this.cmbDataDir.getText();
                int[] indexes = OpenTorrentWindow.this.torrentTable.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(indexes[i]);
                    info.sDestDir = OpenTorrentWindow.this.sDestDir;
                }
                OpenTorrentWindow.this.torrentTable.clearAll();
                OpenTorrentWindow.this.checkSeedingMode();
                File file = new File(OpenTorrentWindow.this.sDestDir);
                if (!file.isDirectory()) {
                    OpenTorrentWindow.this.cmbDataDir.setBackground(Colors.colorErrorBG);
                } else {
                    OpenTorrentWindow.this.cmbDataDir.setBackground(null);
                }
                OpenTorrentWindow.this.cmbDataDir.redraw();
                OpenTorrentWindow.this.cmbDataDir.update();
                OpenTorrentWindow.this.diskFreeInfoRefreshPending = true;
            }
        });
        this.updateDataDirCombo();
        if (this.sDestDir != null && this.sDestDir.length() > 0) {
            this.cmbDataDir.add(this.sDestDir);
        }
        this.dirList = COConfigurationManager.getStringListParameter("saveTo_list");
        StringIterator iter = this.dirList.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (s.equals(this.sDestDir)) continue;
            this.cmbDataDir.add(s);
        }
        Button browseData = new Button(this.cSaveTo, 8);
        Messages.setLanguageText((Widget)browseData, "ConfigView.button.browse");
        browseData.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                String sDefPath = OpenTorrentWindow.this.cmbDataDir.getText();
                File f = new File(sDefPath);
                if (sDefPath.length() > 0) {
                    while (!f.exists()) {
                        if ((f = f.getParentFile()) != null) continue;
                        f = new File(sDefPath);
                        break;
                    }
                }
                DirectoryDialog dDialog = new DirectoryDialog(OpenTorrentWindow.this.shell, 131072);
                dDialog.setFilterPath(f.getAbsolutePath());
                dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath_forallfiles"));
                String sSavePath = dDialog.open();
                if (sSavePath != null) {
                    OpenTorrentWindow.this.cmbDataDir.setText(sSavePath);
                }
            }
        });
        gridData = new GridData(768);
        this.cSaveTo.setLayoutData((Object)gridData);
        Group gFilesArea = new Group((Composite)this.shell, 0);
        gridData = new GridData(1808);
        gFilesArea.setLayoutData((Object)gridData);
        layout = this.FixupLayout(new GridLayout(), true);
        gFilesArea.setLayout((Layout)layout);
        Messages.setLanguageText((Widget)gFilesArea, "OpenTorrentWindow.fileList");
        this.createTableDataFiles((Composite)gFilesArea);
        Composite cArea = new Composite((Composite)this.shell, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        this.ok = new Button(cArea, 8);
        Messages.setLanguageText((Widget)this.ok, "Button.ok");
        gridData = new GridData(128);
        gridData.widthHint = 70;
        this.ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(this.ok);
        this.ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.okPressed();
            }
        });
        this.checkSeedingMode();
        Button cancel = new Button(cArea, 8);
        Messages.setLanguageText((Widget)cancel, "Button.cancel");
        gridData = new GridData();
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.close(true, true);
            }
        });
        Utils.setGridData(cArea, 128, (Control)this.ok, MIN_BUTTON_HEIGHT);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!OpenTorrentWindow.this.bClosed) {
                    OpenTorrentWindow.this.close(false, true);
                }
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    OpenTorrentWindow.this.close(true, true);
                }
            }
        });
        KeyAdapter pasteKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = e.character;
                if ((e.stateMask & SWT.MOD1) != 0 && e.character <= '\u001a' && e.character > '\u0000') {
                    key += 96;
                }
                if (key == 118 && (e.stateMask & SWT.MOD1) > 0 || e.keyCode == 0x1000009 && (e.stateMask & 0x20000) > 0) {
                    e.doit = false;
                    Clipboard clipboard = new Clipboard(OpenTorrentWindow.this.shell.getDisplay());
                    String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    if (sClipText != null) {
                        OpenTorrentWindow.this.addTorrentsFromTextList(sClipText, false);
                    }
                }
            }
        };
        this.setPasteKeyListener((Control)this.shell, (KeyListener)pasteKeyListener);
        Utils.createTorrentDropTarget((Composite)this.shell, false);
        this.shell.pack();
        if (!Utils.linkShellMetricsToConfig(this.shell, "OpenTorrentWindow")) {
            Utils.centreWindow(this.shell);
        }
        this.resizeTables(3);
        this.shell.open();
        if (this.cSaveTo != null && !this.cSaveTo.isDisposed()) {
            this.cSaveTo.setFocus();
        }
        try {
            UIUpdaterSWT.getInstance().addUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    protected void okPressed() {
        String sDefaultPath;
        int j;
        boolean isPathInvalid;
        File fileDefSavePath;
        if (this.bClosed) {
            return;
        }
        if (this.torrentList.size() == 0 && this.downloaders.size() == 0) {
            this.close(true, false);
            return;
        }
        File file = new File(this.cmbDataDir.getText());
        if (file.equals(fileDefSavePath = new File(COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH))) && !fileDefSavePath.isDirectory()) {
            FileUtil.mkdirs(fileDefSavePath);
        }
        boolean bl = isPathInvalid = this.cmbDataDir.getText().length() == 0 || file.isFile();
        if (!isPathInvalid && !file.isDirectory()) {
            int doCreate = Utils.openMessageBox(this.shellForChildren, 196, "OpenTorrentWindow.mb.askCreateDir", new String[]{file.toString()});
            if (doCreate == 64) {
                isPathInvalid = !FileUtil.mkdirs(file);
            } else {
                this.cmbDataDir.setFocus();
                return;
            }
        }
        if (isPathInvalid) {
            Utils.openMessageBox(this.shellForChildren, 33, "OpenTorrentWindow.mb.noGlobalDestDir", new String[]{file.toString()});
            this.cmbDataDir.setFocus();
            return;
        }
        String sExistingFiles = "";
        int iNumExistingFiles = 0;
        block4: for (int i = 0; i < this.torrentList.size(); ++i) {
            TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
            file = new File(info.getDataDir());
            if (!file.isDirectory() && !FileUtil.mkdirs(file)) {
                Utils.openMessageBox(this.shellForChildren, 33, "OpenTorrentWindow.mb.noDestDir", new String[]{file.toString(), info.getTorrentName()});
                return;
            }
            if (!info.isValid) {
                Utils.openMessageBox(this.shellForChildren, 33, "OpenTorrentWindow.mb.notValid", new String[]{info.getTorrentName()});
                return;
            }
            TorrentFileInfo[] files = info.getFiles();
            for (j = 0; j < files.length; ++j) {
                TorrentFileInfo fileInfo2 = files[j];
                if (!fileInfo2.getDestFileFullName().exists()) continue;
                sExistingFiles = sExistingFiles + fileInfo2.orgFullName + " - " + info.getTorrentName() + "\n";
                if (++iNumExistingFiles > 5) continue block4;
            }
        }
        if (sExistingFiles.length() > 0) {
            if (iNumExistingFiles > 5) {
                sExistingFiles = sExistingFiles + MessageText.getString("OpenTorrentWindow.mb.existingFiles.partialList", new String[]{"" + iNumExistingFiles}) + "\n";
            }
            if (Utils.openMessageBox(this.shellForChildren, 296, "OpenTorrentWindow.mb.existingFiles", new String[]{sExistingFiles}) != 32) {
                return;
            }
        }
        if (!this.sDestDir.equals(sDefaultPath = COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH))) {
            File fDestDir = new File(this.sDestDir);
            int iDirPos = -1;
            for (int i = 0; i < this.dirList.size(); ++i) {
                String sDirName = this.dirList.get(i);
                File dir = new File(sDirName);
                if (!dir.equals(fDestDir)) continue;
                iDirPos = i;
                break;
            }
            if (iDirPos > 0 && iDirPos < this.dirList.size()) {
                this.dirList.remove(iDirPos);
            }
            this.dirList.add(0, this.sDestDir);
            if (this.dirList.size() > 15) {
                this.dirList.remove(this.dirList.size() - 1);
            }
            try {
                for (j = 0; j < this.dirList.size(); ++j) {
                    File dirJ = new File(this.dirList.get(j));
                    for (int i = 0; i < this.dirList.size(); ++i) {
                        try {
                            File dirI;
                            if (i == j || !(dirI = new File(this.dirList.get(i))).equals(dirJ)) continue;
                            this.dirList.remove(i);
                            if (j > i) {
                                --j;
                            }
                            --i;
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            COConfigurationManager.setParameter("saveTo_list", this.dirList);
            COConfigurationManager.save();
        }
        if (COConfigurationManager.getBooleanParameter("DefaultDir.AutoUpdate") && !COConfigurationManager.getBooleanParameter("Use default data dir")) {
            COConfigurationManager.setParameter(PARAM_DEFSAVEPATH, this.sDestDir);
        }
        this.openTorrents();
        this.close(true, false);
    }

    private GridLayout FixupLayout(GridLayout layout, boolean bFixMargin) {
        if (Constants.isOSX) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            if (bFixMargin) {
                layout.marginHeight = 0;
                layout.marginWidth = 0;
            }
        }
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataDirCombo() {
        if (this.cmbDataDir == null) {
            return;
        }
        try {
            this.bSkipDataDirModify = true;
            int[] indexes = this.torrentTable.getSelectionIndices();
            if (indexes.length == 0) {
                this.cmbDataDir.setText(this.sDestDir);
                return;
            }
            boolean allSame = true;
            String lastDir = null;
            for (int i = 0; i < indexes.length; ++i) {
                TorrentInfo info = (TorrentInfo)this.torrentList.get(indexes[i]);
                if (lastDir != null && !info.sDestDir.equals(lastDir)) {
                    allSame = false;
                    break;
                }
                lastDir = info.sDestDir;
            }
            if (allSame && lastDir != null) {
                this.cmbDataDir.setText(lastDir);
                this.sDestDir = lastDir;
            } else {
                this.cmbDataDir.setText("");
            }
        }
        finally {
            this.bSkipDataDirModify = false;
        }
    }

    private void updateStartModeCombo() {
        if (this.cmbStartMode == null) {
            return;
        }
        int[] indexes = this.torrentTable.getSelectionIndices();
        String[] sItemsText = new String[startModes.length];
        int iMaxMatches = 0;
        int iIndexToSelect = this.getDefaultStartMode();
        for (int i = 0; i < startModes.length; ++i) {
            int iMatches = 0;
            for (int j = 0; j < indexes.length; ++j) {
                TorrentInfo info = (TorrentInfo)this.torrentList.get(indexes[j]);
                if (info.iStartID != i) continue;
                ++iMatches;
            }
            if (iMatches > iMaxMatches) {
                iMaxMatches = iMatches;
                iIndexToSelect = i;
            }
            String sText = MessageText.getString("OpenTorrentWindow.startMode." + startModes[i]);
            if (iMatches > 0) {
                sText = sText + " " + MessageText.getString("OpenTorrentWindow.xOfTotal", new String[]{Integer.toString(iMatches), Integer.toString(indexes.length)});
            }
            sItemsText[i] = sText;
        }
        this.cmbStartMode.setItems(sItemsText);
        this.cmbStartMode.select(iIndexToSelect);
        this.cmbStartMode.layout(true);
    }

    private void updateQueueLocationCombo() {
        if (this.cmbQueueLocation == null) {
            return;
        }
        int[] indexes = this.torrentTable.getSelectionIndices();
        String[] sItemsText = new String[queueLocations.length];
        int iMaxMatches = 0;
        int iIndexToSelect = 1;
        for (int i = 0; i < queueLocations.length; ++i) {
            int iMatches = 0;
            for (int j = 0; j < indexes.length; ++j) {
                TorrentInfo info = (TorrentInfo)this.torrentList.get(indexes[j]);
                if (info.iQueueLocation != i) continue;
                ++iMatches;
            }
            if (iMatches > iMaxMatches) {
                iMaxMatches = iMatches;
                iIndexToSelect = i;
            }
            String sText = MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[i]);
            if (iMatches > 0) {
                sText = sText + " " + MessageText.getString("OpenTorrentWindow.xOfTotal", new String[]{Integer.toString(iMatches), Integer.toString(indexes.length)});
            }
            sItemsText[i] = sText;
        }
        this.cmbQueueLocation.setItems(sItemsText);
        this.cmbQueueLocation.select(iIndexToSelect);
    }

    private void setPasteKeyListener(Control c, KeyListener keyListener) {
        if (!(c instanceof Text) && !(c instanceof Combo) && !(c instanceof Composite) || c instanceof Table) {
            c.addKeyListener(keyListener);
        }
        if (c instanceof Composite) {
            Control[] controls = ((Composite)c).getChildren();
            for (int i = 0; i < controls.length; ++i) {
                this.setPasteKeyListener(controls[i], keyListener);
            }
        }
    }

    private void browseURL() {
        new OpenUrlWindow(this.shellForChildren, null, null, this);
    }

    private void close(boolean dispose, boolean bCancel) {
        stOpenTorrentWindow = null;
        this.bClosed = true;
        try {
            UIUpdaterSWT.getInstance().removeUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        if (dispose && this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        Utils.disposeSWTObjects(this.disposeList);
        if (this.downloaders.size() > 0) {
            for (TorrentDownloader element : this.downloaders) {
                element.cancel();
            }
            this.downloaders.clear();
        }
        if (bCancel) {
            for (TorrentInfo info : this.torrentList) {
                File file;
                if (!info.bDeleteFileOnCancel || !(file = new File(info.sFileName)).exists()) continue;
                file.delete();
            }
            this.torrentList.clear();
        }
    }

    private void createTorrentListArea(Composite cArea) {
        MenuItem item;
        int i;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        this.torrentTable = new Table(cArea, 268503042);
        GridData gridData = new GridData(784);
        gridData.heightHint = 50;
        gridData.widthHint = 450;
        this.torrentTable.setLayoutData((Object)gridData);
        TableColumn tc = new TableColumn(this.torrentTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.torrentTable.name");
        tc.setWidth(150);
        tc = new TableColumn(this.torrentTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.torrentTable.saveLocation");
        tc.setWidth(150);
        tc = new TableColumn(this.torrentTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.startMode");
        tc.setWidth(70);
        tc = new TableColumn(this.torrentTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.addPosition");
        tc.setWidth(80);
        if (Utils.LAST_TABLECOLUMN_EXPANDS) {
            tc.setData("Width", (Object)new Long(80L));
        }
        this.torrentTable.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                if (OpenTorrentWindow.this.bClosed) {
                    return;
                }
                TableItem item = (TableItem)event2.item;
                int index = OpenTorrentWindow.this.torrentTable.indexOf(item);
                if (index < 0) {
                    return;
                }
                TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(index);
                item.setText(new String[]{info.getTorrentName(), info.getDataDir(), MessageText.getString("OpenTorrentWindow.startMode." + startModes[info.iStartID]), MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[info.iQueueLocation])});
                if (!info.isValid) {
                    item.setForeground(Colors.red);
                    Font font = item.getFont();
                    FontData[] fd = font.getFontData();
                    for (int i = 0; i < fd.length; ++i) {
                        fd[i].setStyle(2);
                    }
                    font = new Font((Device)item.getDisplay(), fd);
                    OpenTorrentWindow.this.disposeList.add(font);
                    item.setFont(font);
                }
                Utils.alternateRowBackground(item);
            }
        });
        this.torrentTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenTorrentWindow.this.dataFiles.clear();
                int[] indexes = OpenTorrentWindow.this.torrentTable.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(indexes[i]);
                    TorrentFileInfo[] files = info.getFiles();
                    OpenTorrentWindow.this.dataFiles.addAll(Arrays.asList(files));
                }
                OpenTorrentWindow.this.updateDataDirCombo();
                OpenTorrentWindow.this.updateStartModeCombo();
                OpenTorrentWindow.this.updateQueueLocationCombo();
                OpenTorrentWindow.this.dataFileTable.setItemCount(OpenTorrentWindow.this.dataFiles.size());
                OpenTorrentWindow.this.dataFileTable.clearAll();
                OpenTorrentWindow.this.editCell(-1);
                OpenTorrentWindow.this.updateSize();
                OpenTorrentWindow.this.resizeTables(2);
            }
        });
        this.torrentTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    OpenTorrentWindow.this.deleteSelected(OpenTorrentWindow.this.torrentTable, OpenTorrentWindow.this.torrentList);
                    e.doit = false;
                }
            }
        });
        this.torrentTable.setHeaderVisible(true);
        Menu menu = new Menu((Control)this.torrentTable);
        String sTitle = MessageText.getString("OpenTorrentWindow.startMode");
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        for (i = 0; i < startModes.length; ++i) {
            if (i == 2 && userMode == 0) continue;
            item = new MenuItem(menu, 8);
            item.setData("Value", (Object)new Long(i));
            item.setText(sTitle + ": " + MessageText.getString("OpenTorrentWindow.startMode." + startModes[i]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Long l = (Long)e.widget.getData("Value");
                    if (l != null) {
                        OpenTorrentWindow.this.setSelectedStartMode(l.intValue());
                        OpenTorrentWindow.this.checkSeedingMode();
                    }
                }
            });
        }
        item = new MenuItem(menu, 2);
        sTitle = MessageText.getString("OpenTorrentWindow.addPosition");
        for (i = 0; i < queueLocations.length; ++i) {
            item = new MenuItem(menu, 8);
            item.setData("Value", (Object)new Long(i));
            item.setText(sTitle + ": " + MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[i]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Long l = (Long)e.widget.getData("Value");
                    if (l != null) {
                        OpenTorrentWindow.this.setSelectedQueueLocation(l.intValue());
                    }
                }
            });
        }
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.remove");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenTorrentWindow.this.deleteSelected(OpenTorrentWindow.this.torrentTable, OpenTorrentWindow.this.torrentList);
            }
        });
        item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indexes = OpenTorrentWindow.this.torrentTable.getSelectionIndices();
                String sDefPath = OpenTorrentWindow.this.sDestDir;
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(indexes[i]);
                    TorrentFileInfo[] files = info.getFiles();
                    if (files.length == 1) {
                        OpenTorrentWindow.this.changeFileDestination(new int[]{0});
                        continue;
                    }
                    DirectoryDialog dDialog = new DirectoryDialog(OpenTorrentWindow.this.shellForChildren, 131072);
                    dDialog.setFilterPath(sDefPath);
                    dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath") + " (" + info.getTorrentName() + ")");
                    String sNewDir = dDialog.open();
                    if (sNewDir == null) {
                        return;
                    }
                    File newDir = new File(sNewDir).getAbsoluteFile();
                    if (newDir.isDirectory()) {
                        sDefPath = sNewDir;
                    }
                    info.sDestDir = newDir.getParent();
                    if (info.sDestDir == null) {
                        info.sDestDir = newDir.getPath();
                    }
                    info.sDestSubDir = newDir.getName();
                    for (int j = 0; j < files.length; ++j) {
                        TorrentFileInfo fileInfo2 = files[j];
                        fileInfo2.setDestFileName(null);
                    }
                }
                OpenTorrentWindow.this.checkSeedingMode();
                OpenTorrentWindow.this.updateDataDirCombo();
                OpenTorrentWindow.this.diskFreeInfoRefreshPending = true;
            }
        });
        this.torrentTable.setMenu(menu);
        Composite cTorrentListRight = new Composite(cArea, 0);
        gridData = new GridData();
        cTorrentListRight.setLayoutData((Object)gridData);
        RowLayout rLayout = new RowLayout(512);
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        if (!Constants.isOSX) {
            rLayout.spacing = 0;
        }
        rLayout.fill = true;
        cTorrentListRight.setLayout((Layout)rLayout);
        ImageLoader imageLoader = ImageLoader.getInstance();
        Button torMoveUp = new Button(cTorrentListRight, 8);
        imageLoader.setButtonImage(torMoveUp, "up");
        torMoveUp.setToolTipText(MessageText.getString("Button.moveUp"));
        torMoveUp.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indices = OpenTorrentWindow.this.torrentTable.getSelectionIndices();
                if (indices.length == 0) {
                    return;
                }
                Arrays.sort(indices);
                if (indices[0] == 0) {
                    return;
                }
                int i = 0;
                while (i < indices.length) {
                    int pos = indices[i];
                    Object save = OpenTorrentWindow.this.torrentList.get(pos - 1);
                    OpenTorrentWindow.this.torrentList.set(pos - 1, OpenTorrentWindow.this.torrentList.get(pos));
                    OpenTorrentWindow.this.torrentList.set(pos, save);
                    int n = i++;
                    indices[n] = indices[n] - 1;
                }
                OpenTorrentWindow.this.torrentTable.setSelection(indices);
                OpenTorrentWindow.this.torrentTable.clearAll();
            }
        });
        Button torMoveDown = new Button(cTorrentListRight, 8);
        imageLoader.setButtonImage(torMoveDown, "down");
        torMoveDown.setToolTipText(MessageText.getString("Button.moveDown"));
        torMoveDown.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indices = OpenTorrentWindow.this.torrentTable.getSelectionIndices();
                if (indices.length == 0) {
                    return;
                }
                Arrays.sort(indices);
                int max = indices.length - 1;
                if (indices[max] == OpenTorrentWindow.this.torrentList.size() - 1) {
                    return;
                }
                int i = max;
                while (i >= 0) {
                    int pos = indices[i];
                    Object save = OpenTorrentWindow.this.torrentList.get(pos + 1);
                    OpenTorrentWindow.this.torrentList.set(pos + 1, OpenTorrentWindow.this.torrentList.get(pos));
                    OpenTorrentWindow.this.torrentList.set(pos, save);
                    int n = i--;
                    indices[n] = indices[n] + 1;
                }
                OpenTorrentWindow.this.torrentTable.setSelection(indices);
                OpenTorrentWindow.this.torrentTable.clearAll();
            }
        });
        Button torMoveRemove = new Button(cTorrentListRight, 8);
        torMoveRemove.setToolTipText(MessageText.getString("OpenTorrentWindow.torrent.remove"));
        imageLoader.setButtonImage(torMoveRemove, "delete");
        torMoveRemove.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.deleteSelected(OpenTorrentWindow.this.torrentTable, OpenTorrentWindow.this.torrentList);
            }
        });
    }

    protected void setSelectedQueueLocation(int iLocation) {
        int[] indices = this.torrentTable.getSelectionIndices();
        for (int i = 0; i < indices.length; ++i) {
            TorrentInfo info = (TorrentInfo)this.torrentList.get(indices[i]);
            info.iQueueLocation = iLocation;
        }
        this.updateQueueLocationCombo();
        this.torrentTable.clear(indices);
    }

    protected void setSelectedStartMode(int iStartID) {
        int[] indices = this.torrentTable.getSelectionIndices();
        for (int i = 0; i < indices.length; ++i) {
            TorrentInfo info = (TorrentInfo)this.torrentList.get(indices[i]);
            info.iStartID = iStartID;
        }
        this.checkSeedingMode();
        this.updateStartModeCombo();
        this.torrentTable.clear(indices);
    }

    private void checkSeedingMode() {
        for (int i = 0; i < this.torrentList.size(); ++i) {
            boolean bTorrentValid = true;
            TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
            if (info.iStartID == 3) {
                TorrentFileInfo[] files = info.getFiles();
                for (int j = 0; j < files.length; ++j) {
                    TorrentFileInfo fileInfo2 = files[j];
                    if (!fileInfo2.bDownload) continue;
                    File file = fileInfo2.getDestFileFullName();
                    if (!file.exists()) {
                        fileInfo2.isValid = false;
                        bTorrentValid = false;
                        continue;
                    }
                    if (fileInfo2.isValid) continue;
                    fileInfo2.isValid = true;
                }
            }
            info.isValid = bTorrentValid;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (OpenTorrentWindow.this.torrentTable != null && !OpenTorrentWindow.this.torrentTable.isDisposed()) {
                    OpenTorrentWindow.this.torrentTable.clearAll();
                }
                if (OpenTorrentWindow.this.dataFileTable != null && !OpenTorrentWindow.this.dataFileTable.isDisposed()) {
                    OpenTorrentWindow.this.dataFileTable.clearAll();
                    OpenTorrentWindow.this.editCell(-1);
                }
            }
        });
    }

    private void deleteSelected(Table table, ArrayList list) {
        int[] indexes = table.getSelectionIndices();
        Arrays.sort(indexes);
        for (int i = indexes.length - 1; i >= 0; --i) {
            if (list.get(indexes[i]) instanceof TorrentInfo) {
                File file;
                TorrentInfo info = (TorrentInfo)list.get(indexes[i]);
                if (info.bDeleteFileOnCancel && (file = new File(info.sFileName)).exists()) {
                    file.delete();
                }
            }
            list.remove(indexes[i]);
        }
        table.setItemCount(list.size());
        table.clearAll();
        table.notifyListeners(13, new Event());
    }

    private void editCell(final int row) {
        Text oldEditor = (Text)this.dataFileTableEditor.getEditor();
        if (row < 0 || row >= this.dataFileTable.getItemCount()) {
            if (oldEditor != null && !oldEditor.isDisposed()) {
                oldEditor.dispose();
            }
            return;
        }
        final Text newEditor = oldEditor == null || oldEditor.isDisposed() ? new Text((Composite)this.dataFileTable, 2048) : oldEditor;
        final TorrentFileInfo file = (TorrentFileInfo)this.dataFiles.get(row);
        final String uneditedName = file.getDestFileName();
        TableItem item = this.dataFileTable.getItem(row);
        TableColumn column = this.dataFileTable.getColumn(1);
        newEditor.setText(uneditedName);
        newEditor.selectAll();
        newEditor.forceFocus();
        Rectangle leftAlignedBounds = item.getBounds(1);
        leftAlignedBounds.width = this.dataFileTableEditor.minimumWidth = newEditor.computeSize((int)-1, (int)-1).x;
        this.dataFileTableEditor.horizontalAlignment = leftAlignedBounds.intersection(this.dataFileTable.getClientArea()).equals((Object)leftAlignedBounds) ? 16384 : 131072;
        this.dataFileTable.deselectAll();
        this.dataFileTable.select(row);
        this.dataFileTable.showItem(item);
        this.dataFileTable.showColumn(column);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class QuickEditListener
        implements ModifyListener,
        SelectionListener,
        KeyListener,
        TraverseListener {
            QuickEditListener() {
            }

            public void modifyText(ModifyEvent e) {
                file.setDestFileName(newEditor.getText());
                try {
                    file.getDestFileFullName().getCanonicalFile();
                    newEditor.setBackground(null);
                }
                catch (IOException e1) {
                    newEditor.setBackground(Colors.colorErrorBG);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                try {
                    file.getDestFileFullName().getCanonicalFile();
                }
                catch (IOException e1) {
                    file.setDestFileName(uneditedName);
                }
                this.move(row, 1, (Text)e.widget);
            }

            public void widgetSelected(SelectionEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    e.doit = false;
                    this.move(row, e.keyCode == 0x1000002 ? 1 : -1, (Text)e.widget);
                }
            }

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
                if (e.detail == 2) {
                    OpenTorrentWindow.this.editCell(-1);
                }
            }

            private void move(int oldRow, int offset, Text current) {
                current.removeModifyListener((ModifyListener)this);
                current.removeSelectionListener((SelectionListener)this);
                current.removeKeyListener((KeyListener)this);
                current.removeTraverseListener((TraverseListener)this);
                OpenTorrentWindow.this.editCell(oldRow + offset);
                OpenTorrentWindow.this.dataFileTable.clear(oldRow);
            }
        }
        QuickEditListener listener = new QuickEditListener();
        newEditor.addModifyListener((ModifyListener)listener);
        newEditor.addSelectionListener((SelectionListener)listener);
        newEditor.addKeyListener((KeyListener)listener);
        newEditor.addTraverseListener((TraverseListener)listener);
        this.dataFileTableEditor.setEditor((Control)newEditor, this.dataFileTable.getItem(row), 1);
    }

    private void createTableDataFiles(Composite cArea) {
        this.dataFileTable = new Table(cArea, 268503074);
        this.dataFileTableEditor = new TableEditor(this.dataFileTable);
        this.dataFileTableEditor.grabHorizontal = true;
        this.dataFileTableEditor.minimumWidth = 50;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 80;
        gridData.widthHint = 100;
        this.dataFileTable.setLayoutData((Object)gridData);
        TableColumn tc = new TableColumn(this.dataFileTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.fileTable.fileName");
        tc.setWidth(150);
        tc = new TableColumn(this.dataFileTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.fileTable.destinationName");
        tc.setWidth(140);
        tc = new TableColumn(this.dataFileTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.fileTable.size");
        tc.setAlignment(131072);
        tc.setWidth(90);
        if (Utils.LAST_TABLECOLUMN_EXPANDS) {
            tc.setData("Width", (Object)new Long(90L));
        }
        this.dataFileTable.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                if (OpenTorrentWindow.this.bClosed) {
                    return;
                }
                TableItem item = (TableItem)event2.item;
                int index = OpenTorrentWindow.this.dataFileTable.indexOf(item);
                TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(index);
                item.setText(new String[]{file.orgFullName, file.isLinked() ? file.getDestFileFullName().toString() : file.getDestFileName(), DisplayFormatters.formatByteCountToKiBEtc(file.lSize)});
                if (!file.isValid) {
                    item.setForeground(Colors.red);
                    Font font = item.getFont();
                    FontData[] fd = font.getFontData();
                    for (int i = 0; i < fd.length; ++i) {
                        fd[i].setStyle(2);
                    }
                    font = new Font((Device)item.getDisplay(), fd);
                    OpenTorrentWindow.this.disposeList.add(font);
                    item.setFont(font);
                }
                Utils.alternateRowBackground(item);
                Utils.setCheckedInSetData(item, file.bDownload);
                item.setGrayed(!file.okToDisable());
            }
        });
        this.dataFileTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                if (event2.detail == 32) {
                    TableItem item = (TableItem)event2.item;
                    int index = OpenTorrentWindow.this.dataFileTable.indexOf(item);
                    TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(index);
                    if (!item.getChecked() && !file.okToDisable()) {
                        item.setChecked(true);
                    } else {
                        file.bDownload = item.getChecked();
                    }
                    OpenTorrentWindow.this.updateSize();
                }
            }
        });
        this.dataFileTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int i;
                OpenTorrentWindow.this.editCell(-1);
                if (e.button != 1) {
                    return;
                }
                TableItem[] items = OpenTorrentWindow.this.dataFileTable.getItems();
                boolean found = false;
                block0: for (i = 0; i < items.length; ++i) {
                    TableItem item = items[i];
                    Rectangle rect = item.getBounds();
                    if (e.y < rect.y || rect.y + rect.height < e.y) continue;
                    for (int j = 0; j < OpenTorrentWindow.this.dataFileTable.getColumnCount(); ++j) {
                        if (!item.getBounds(j).contains(e.x, e.y)) continue;
                        found = j == 1;
                        break block0;
                    }
                }
                if (found) {
                    OpenTorrentWindow.this.editCell(i);
                }
            }
        });
        this.dataFileTable.setHeaderVisible(true);
        Menu menu = new Menu((Control)this.dataFileTable);
        this.dataFileTable.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indexes = OpenTorrentWindow.this.dataFileTable.getSelectionIndices();
                OpenTorrentWindow.this.changeFileDestination(indexes);
            }
        });
        Composite cBottomArea = new Composite(cArea, 0);
        GridLayout gLayout = new GridLayout();
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.numColumns = 2;
        gLayout.verticalSpacing = 0;
        cBottomArea.setLayout((Layout)gLayout);
        gridData = new GridData(768);
        cBottomArea.setLayoutData((Object)gridData);
        Composite cButtons = new Composite(cBottomArea, 0);
        RowLayout rLayout = new RowLayout(256);
        rLayout.wrap = false;
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        cButtons.setLayout((Layout)rLayout);
        gridData = new GridData(0x1000008, 1, false, false);
        gridData.verticalSpan = 2;
        cButtons.setLayoutData((Object)gridData);
        Button btnSelectAll = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnSelectAll, "Button.selectAll");
        btnSelectAll.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.dataFileTable.selectAll();
            }
        });
        Button btnMarkSelected = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnMarkSelected, "Button.markSelected");
        btnMarkSelected.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indexes = OpenTorrentWindow.this.dataFileTable.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(indexes[i]);
                    file.bDownload = true;
                }
                OpenTorrentWindow.this.dataFileTable.clearAll();
                OpenTorrentWindow.this.updateSize();
            }
        });
        Button btnUnmarkSelected = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnUnmarkSelected, "Button.unmarkSelected");
        btnUnmarkSelected.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indexes = OpenTorrentWindow.this.dataFileTable.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(indexes[i]);
                    if (!file.okToDisable()) continue;
                    file.bDownload = false;
                }
                OpenTorrentWindow.this.dataFileTable.clearAll();
                OpenTorrentWindow.this.updateSize();
            }
        });
        this.dataFileTableLabel = new Label(cBottomArea, 64);
        this.dataFileTableLabel.setAlignment(131072);
        gridData = new GridData(0x1000008, 1, true, false);
        this.dataFileTableLabel.setLayoutData((Object)gridData);
        this.diskspaceComp = new Composite(cBottomArea, 0);
        gLayout = new GridLayout(2, false);
        gLayout.marginWidth = 1;
        gLayout.marginHeight = 1;
        gLayout.verticalSpacing = 0;
        gLayout.horizontalSpacing = 15;
        this.diskspaceComp.setLayout((Layout)gLayout);
        gridData = new GridData(0x1000008, 1, true, false);
        this.diskspaceComp.setLayoutData((Object)gridData);
    }

    protected void changeFileDestination(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            TorrentFileInfo fileInfo2 = (TorrentFileInfo)this.dataFiles.get(indexes[i]);
            int style = fileInfo2.parent.iStartID == 3 ? 4096 : 8192;
            FileDialog fDialog = new FileDialog(this.shellForChildren, 0x20000 | style);
            String sFilterPath = fileInfo2.getDestPathName();
            String sFileName = fileInfo2.orgFileName;
            File f = new File(sFilterPath);
            if (!f.isDirectory()) {
                String parentPath;
                while (sFilterPath != null && (parentPath = f.getParent()) != null && !(f = new File(sFilterPath = parentPath)).isDirectory()) {
                }
            }
            if (sFilterPath != null) {
                fDialog.setFilterPath(sFilterPath);
            }
            fDialog.setFileName(sFileName);
            fDialog.setText(MessageText.getString("MainWindow.dialog.choose.savepath") + " (" + fileInfo2.orgFullName + ")");
            String sNewName = fDialog.open();
            if (sNewName == null) {
                return;
            }
            if (fileInfo2.parent.iStartID == 3) {
                File file = new File(sNewName);
                if (file.length() == fileInfo2.lSize) {
                    fileInfo2.setFullDestName(sNewName);
                    continue;
                }
                Utils.openMessageBox(this.shellForChildren, 32, "OpenTorrentWindow.mb.badSize", new String[]{file.getName(), fileInfo2.orgFullName});
                continue;
            }
            fileInfo2.setFullDestName(sNewName);
        }
        this.checkSeedingMode();
        this.updateDataDirCombo();
        this.diskFreeInfoRefreshPending = true;
    }

    private int addTorrentsFromTextList(String sClipText, boolean bVerifyOnly) {
        int i;
        String[] lines = null;
        int iNumFound = 0;
        int iNoTorrentLines = 0;
        int MAX_CONSECUTIVE_NONTORRENT_LINES = 100;
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        for (i = 0; i < splitters.length; ++i) {
            if (sClipText.indexOf(splitters[i]) < 0) continue;
            lines = sClipText.split(splitters[i]);
            break;
        }
        if (lines == null) {
            lines = new String[]{sClipText};
        }
        for (i = 0; i < lines.length; ++i) {
            boolean ok;
            String line = lines[i].trim();
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
            }
            if (line == "") {
                ok = false;
            } else if (UrlUtils.isURL(line)) {
                ok = true;
            } else {
                File file = new File(line);
                if (!file.exists()) {
                    ok = false;
                } else if (file.isDirectory()) {
                    if (bVerifyOnly) {
                        ok = true;
                    } else {
                        iNumFound += this.addTorrents(lines[i], null);
                        ok = false;
                    }
                } else {
                    ok = true;
                }
            }
            if (!ok) {
                lines[i] = null;
                if (++iNoTorrentLines <= 100) continue;
                break;
            }
            ++iNumFound;
            iNoTorrentLines = 0;
        }
        if (bVerifyOnly) {
            return iNumFound;
        }
        return this.addTorrents(null, lines);
    }

    private int addTorrents(String sTorrentFilePath, String[] sTorrentFilenames) {
        if ((sTorrentFilePath = this.ensureTrailingSeparator(sTorrentFilePath)) != null && sTorrentFilenames == null) {
            File dir = new File(sTorrentFilePath);
            if (!dir.isDirectory()) {
                return 0;
            }
            File[] files = dir.listFiles(new FileFilter(){

                public boolean accept(File arg0) {
                    if (FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".torrent")) {
                        return true;
                    }
                    return FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".tor");
                }
            });
            if (files.length == 0) {
                return 0;
            }
            sTorrentFilenames = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                sTorrentFilenames[i] = files[i].getName();
            }
        }
        int numAdded = 0;
        for (int i = 0; i < sTorrentFilenames.length; ++i) {
            String sURL;
            if (sTorrentFilenames[i] == null || sTorrentFilenames[i] == "") continue;
            String sFileName = (sTorrentFilePath == null ? "" : sTorrentFilePath) + sTorrentFilenames[i];
            if (!new File(sFileName).exists() && (sURL = UrlUtils.parseTextForURL(sTorrentFilenames[i], true)) != null) {
                if (COConfigurationManager.getBooleanParameter("Add URL Silently")) {
                    new FileDownloadWindow(this.shellForChildren, sURL, null, null, this);
                } else {
                    new OpenUrlWindow(this.shellForChildren, sURL, null, this);
                }
                ++numAdded;
                continue;
            }
            if (this.addTorrent(sFileName, sFileName) == null) continue;
            ++numAdded;
        }
        if (numAdded > 0 && this.shell != null && this.torrentTable != null && !this.shell.isDisposed()) {
            int iTotal = this.torrentList.size();
            this.torrentTable.setItemCount(iTotal);
            this.torrentTable.select(iTotal - numAdded, iTotal - 1);
            this.torrentTable.clearAll();
            this.torrentTable.notifyListeners(13, new Event());
            this.resizeTables(1);
            this.checkSeedingMode();
        }
        return numAdded;
    }

    private TorrentInfo addTorrent(String sFileName, final String sOriginatingLocation) {
        String sExistingName;
        File torrentFile;
        boolean bDeleteFileOnCancel;
        TOTorrent torrent;
        TorrentInfo info;
        block20: {
            info = null;
            torrent = null;
            bDeleteFileOnCancel = false;
            try {
                File fOriginal;
                if (sFileName.startsWith("file://localhost/")) {
                    sFileName = UrlUtils.decode(sFileName.substring(16));
                }
                if (!(fOriginal = new File(sFileName)).isFile() || !fOriginal.exists()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (OpenTorrentWindow.this.shell == null) {
                                new MessageSlideShell(Display.getCurrent(), 1, "OpenTorrentWindow.mb.openError", "", new String[]{sOriginatingLocation, "Not a File"}, -1);
                            } else {
                                Utils.openMessageBox(OpenTorrentWindow.this.shell, 32, "OpenTorrentWindow.mb.openError", new String[]{sOriginatingLocation, "Not a File"});
                            }
                        }
                    });
                    return null;
                }
                torrentFile = TorrentUtils.copyTorrentFileToSaveDir(fOriginal, true);
                bDeleteFileOnCancel = !fOriginal.equals(torrentFile);
            }
            catch (IOException e1) {
                torrentFile = new File(sFileName);
            }
            if (!TorrentUtil.isFileTorrent(torrentFile, this.shellForChildren, torrentFile.getName())) {
                if (bDeleteFileOnCancel) {
                    torrentFile.delete();
                }
                return null;
            }
            try {
                torrent = TorrentUtils.readFromFile(torrentFile, false);
            }
            catch (TOTorrentException e) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (OpenTorrentWindow.this.shell == null) {
                            new MessageSlideShell(Display.getCurrent(), 1, "OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{sOriginatingLocation, e.getMessage()}, -1);
                        } else {
                            Utils.openMessageBox(OpenTorrentWindow.this.shell, 32, "OpenTorrentWindow.mb.openError", new String[]{sOriginatingLocation, e.getMessage()});
                        }
                    }
                });
                if (bDeleteFileOnCancel) {
                    torrentFile.delete();
                }
                return null;
            }
            sExistingName = null;
            try {
                HashWrapper hash = torrent.getHashWrapper();
                if (hash == null) break block20;
                for (int i = 0; i < this.torrentList.size(); ++i) {
                    try {
                        TorrentInfo existing = (TorrentInfo)this.torrentList.get(i);
                        if (!existing.torrent.getHashWrapper().equals(hash)) continue;
                        if (bDeleteFileOnCancel) {
                            torrentFile.delete();
                        }
                        return null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        DownloadManager existingDownload = null;
        if (sExistingName == null) {
            DownloadManager downloadManager = existingDownload = this.gm == null ? null : this.gm.getDownloadManager(torrent);
            if (existingDownload != null) {
                sExistingName = existingDownload.getDisplayName();
            }
        }
        if (sExistingName == null) {
            info = new TorrentInfo(torrentFile.getAbsolutePath(), torrent, bDeleteFileOnCancel);
            info.sOriginatingLocation = sOriginatingLocation;
            this.torrentList.add(info);
        } else {
            final String sfExistingName = sExistingName;
            final DownloadManager fExistingDownload = existingDownload;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (OpenTorrentWindow.this.shell == null) {
                        new MessageSlideShell(Display.getCurrent(), 2, OpenTorrentWindow.MSG_ALREADY_EXISTS, null, new String[]{":" + sOriginatingLocation, sfExistingName, MessageText.getString(OpenTorrentWindow.MSG_ALREADY_EXISTS_NAME)}, new Object[]{fExistingDownload}, -1);
                    } else {
                        Utils.openMessageBox(OpenTorrentWindow.this.shell, 32, OpenTorrentWindow.MSG_ALREADY_EXISTS, new String[]{":" + sOriginatingLocation, sfExistingName, MessageText.getString(OpenTorrentWindow.MSG_ALREADY_EXISTS_NAME)});
                    }
                }
            });
            if (bDeleteFileOnCancel) {
                torrentFile.delete();
            }
        }
        return info;
    }

    private void resizeTables(int which) {
        try {
            int i;
            boolean columnToExpand;
            int iLength;
            int newSize;
            TableColumn[] tcs;
            if ((which & 1) > 0 && this.torrentTable != null && !this.torrentTable.isDisposed()) {
                tcs = this.torrentTable.getColumns();
                newSize = this.torrentTable.getClientArea().width - 20;
                iLength = tcs.length;
                if (Utils.LAST_TABLECOLUMN_EXPANDS) {
                    newSize -= ((Long)tcs[--iLength].getData("Width")).intValue();
                }
                columnToExpand = true;
                for (i = 0; i < iLength; ++i) {
                    if (i == 1) continue;
                    newSize -= tcs[i].getWidth();
                }
                if (newSize > 10) {
                    tcs[1].setWidth(newSize);
                }
            }
            if ((which & 2) > 0 && this.dataFileTable != null && !this.dataFileTable.isDisposed()) {
                tcs = this.dataFileTable.getColumns();
                newSize = this.dataFileTable.getClientArea().width - 20;
                iLength = tcs.length;
                if (Utils.LAST_TABLECOLUMN_EXPANDS) {
                    newSize -= ((Long)tcs[--iLength].getData("Width")).intValue();
                }
                columnToExpand = false;
                for (i = 0; i < iLength; ++i) {
                    if (i == 0) continue;
                    newSize -= tcs[i].getWidth();
                }
                if (newSize > 10) {
                    tcs[0].setWidth(newSize);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openTorrents() {
        ArrayList<DownloadManager> addedTorrentsTop = new ArrayList<DownloadManager>();
        for (int i = 0; i < this.torrentList.size(); ++i) {
            TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
            try {
                if (info.torrent == null) continue;
                int iStartState = info.iStartID == 1 ? 70 : 75;
                final TorrentFileInfo[] files = info.getFiles();
                byte[] hash = null;
                try {
                    hash = info.torrent.getHash();
                }
                catch (TOTorrentException e1) {
                    // empty catch block
                }
                DownloadManager dm = this.gm.addDownloadManager(info.sFileName, hash, info.sDestDir, info.sDestSubDir, iStartState, true, info.iStartID == 3, new DownloadManagerInitialisationAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void initialised(DownloadManager dm) {
                        DiskManagerFileInfo[] fileInfos = dm.getDiskManagerFileInfo();
                        try {
                            dm.getDownloadState().suppressStateSave(true);
                            boolean[] toSkip = new boolean[fileInfos.length];
                            boolean[] toCompact = new boolean[fileInfos.length];
                            for (int iIndex = 0; iIndex < fileInfos.length; ++iIndex) {
                                DiskManagerFileInfo fileInfo2 = fileInfos[iIndex];
                                if (iIndex < 0 || iIndex >= files.length || files[iIndex].lSize != fileInfo2.getLength()) continue;
                                File fDest = files[iIndex].getDestFileFullName();
                                if (files[iIndex].isLinked()) {
                                    dm.getDownloadState().setFileLink(fileInfo2.getFile(false), fDest);
                                }
                                if (files[iIndex].bDownload) continue;
                                toSkip[iIndex] = true;
                                if (fDest.exists()) continue;
                                toCompact[iIndex] = true;
                            }
                            dm.getDiskManagerFileInfoSet().setStorageTypes(toCompact, 2);
                            dm.getDiskManagerFileInfoSet().setSkipped(toSkip, true);
                        }
                        finally {
                            dm.getDownloadState().suppressStateSave(false);
                        }
                    }
                });
                if (dm == null) continue;
                if (info.iQueueLocation == 0) {
                    addedTorrentsTop.add(dm);
                }
                if (info.iStartID != 2) continue;
                dm.setForceStart(true);
                continue;
            }
            catch (Exception e) {
                if (this.shell == null) {
                    new MessageSlideShell(Display.getCurrent(), 1, "OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{info.sOriginatingLocation, e.getMessage()}, -1);
                    continue;
                }
                Utils.openMessageBox(this.shell, 32, "OpenTorrentWindow.mb.openError", new String[]{info.sOriginatingLocation, e.getMessage()});
            }
        }
        if (addedTorrentsTop.size() > 0) {
            DownloadManager[] dms = addedTorrentsTop.toArray(new DownloadManager[0]);
            this.gm.moveTop(dms);
        }
        this.torrentList.clear();
    }

    private int getDefaultStartMode() {
        if (this.bDefaultForSeeding) {
            return 3;
        }
        return this.bOverrideStartModeToStopped || COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped") ? 1 : 0;
    }

    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (!(inf.getDeleteFileOnCancel() || state != 6 && state != 4 && state != 5 && state != 3)) {
            --this.activeTorrentCount;
            this.enableControl((Control)this.ok, this.activeTorrentCount < 1);
            if (!this.downloaders.contains(inf)) {
                return;
            }
            this.downloaders.remove(inf);
            File file = inf.getFile();
            TorrentUtil.isFileTorrent(file, this.shellForChildren, inf.getURL());
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        if (state == 0) {
            ++this.activeTorrentCount;
            this.enableControl((Control)this.ok, this.activeTorrentCount < 1);
            this.downloaders.add(inf);
        } else if (state == 3) {
            --this.activeTorrentCount;
            this.enableControl((Control)this.ok, this.activeTorrentCount < 1);
            if (!this.downloaders.contains(inf)) {
                return;
            }
            this.downloaders.remove(inf);
            File file = inf.getFile();
            if (this.addTorrent(file.getAbsolutePath(), inf.getURL()) == null) {
                if (file.exists()) {
                    file.delete();
                }
            } else if (this.shell != null && !this.shell.isDisposed()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        OpenTorrentWindow.this.torrentTable.setItemCount(OpenTorrentWindow.this.torrentList.size());
                        OpenTorrentWindow.this.torrentTable.clearAll();
                        OpenTorrentWindow.this.torrentTable.select(OpenTorrentWindow.this.torrentList.size() - 1);
                        OpenTorrentWindow.this.torrentTable.notifyListeners(13, new Event());
                        OpenTorrentWindow.this.resizeTables(1);
                    }
                });
            } else {
                String saveSilentlyDir = OpenTorrentWindow.getSaveSilentlyDir();
                if (saveSilentlyDir != null) {
                    this.sDestDir = saveSilentlyDir;
                    for (int i = 0; i < this.torrentList.size(); ++i) {
                        TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
                        info.renameDuplicates();
                    }
                    this.openTorrents();
                }
            }
            this.checkSeedingMode();
        } else if (state == 6 || state == 4 || state == 5) {
            --this.activeTorrentCount;
            this.enableControl((Control)this.ok, this.activeTorrentCount < 1);
            this.downloaders.remove(inf);
        } else if (state == 2) {
            byte[] bytes;
            int count = inf.getLastReadCount();
            int numRead = inf.getTotalRead();
            if (!inf.getDeleteFileOnCancel() && numRead >= 16384) {
                inf.cancel();
            } else if (numRead == count && count > 0 && (bytes = inf.getLastReadBytes())[0] != 100) {
                inf.setDeleteFileOnCancel(false);
            }
        } else {
            return;
        }
    }

    private String ensureTrailingSeparator(String sPath) {
        if (sPath == null || sPath.length() == 0 || sPath.endsWith(File.separator)) {
            return sPath;
        }
        return sPath + File.separator;
    }

    private static String getSaveSilentlyDir() {
        boolean bUseDefault = COConfigurationManager.getBooleanParameter("Use default data dir");
        if (!bUseDefault) {
            return null;
        }
        String sDefDir = "";
        try {
            sDefDir = COConfigurationManager.getDirectoryParameter(PARAM_DEFSAVEPATH);
        }
        catch (IOException e) {
            return null;
        }
        return sDefDir == "" ? null : sDefDir;
    }

    private long getCachedDirFreeSpace(File directory) {
        FileStatsCacheItem item = (FileStatsCacheItem)this.fileStatCache.get(directory);
        if (item == null) {
            item = new FileStatsCacheItem(directory);
            this.fileStatCache.put(directory, item);
        }
        return item.freeSpace;
    }

    private boolean getCachedExistsStat(File directory) {
        FileStatsCacheItem item = (FileStatsCacheItem)this.fileStatCache.get(directory);
        if (item == null) {
            item = new FileStatsCacheItem(directory);
            this.fileStatCache.put(directory, item);
        }
        return item.exists;
    }

    public String getUpdateUIName() {
        return "OpenTorrentWindow";
    }

    public void updateUI() {
        if (this.bClosed) {
            try {
                UIUpdaterSWT.getInstance().removeUpdater(this);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            return;
        }
        if (this.diskFreeInfoRefreshPending && !this.diskFreeInfoRefreshRunning && FileUtil.getUsableSpaceSupported()) {
            this.diskFreeInfoRefreshRunning = true;
            this.diskFreeInfoRefreshPending = false;
            HashSet<File> FSroots = new HashSet<File>(Arrays.asList(File.listRoots()));
            HashMap<File, Partition> partitions = new HashMap<File, Partition>();
            for (int i = 0; i < this.torrentList.size(); ++i) {
                TorrentInfo tor = (TorrentInfo)this.torrentList.get(i);
                TorrentFileInfo[] files = tor.getFiles();
                for (int j = 0; j < files.length; ++j) {
                    TorrentFileInfo file = files[j];
                    if (!file.bDownload) continue;
                    File root = file.getDestFileFullName().getAbsoluteFile();
                    Partition part = (Partition)partitions.get((File)this.parentToRootCache.get(root.getParentFile()));
                    if (part == null) {
                        File next;
                        while (!((next = (root = root.getParentFile()).getParentFile()) == null || this.getCachedExistsStat(root) && root.isDirectory() && (FSroots.contains(root) || root.equals(next) || this.getCachedDirFreeSpace(next) != this.getCachedDirFreeSpace(root)))) {
                        }
                        this.parentToRootCache.put(file.getDestFileFullName().getAbsoluteFile().getParentFile(), root);
                        part = (Partition)partitions.get(root);
                        if (part == null) {
                            part = new Partition(root);
                            part.freeSpace = this.getCachedDirFreeSpace(root);
                            partitions.put(root, part);
                        }
                    }
                    part.bytesToConsume += file.lSize;
                }
            }
            Control[] labels = this.diskspaceComp.getChildren();
            for (int i = 0; i < labels.length; ++i) {
                labels[i].dispose();
            }
            for (Partition part : partitions.values()) {
                boolean filesTooBig = part.bytesToConsume > part.freeSpace;
                Label l = new Label(this.diskspaceComp, 0);
                l.setForeground((Color)(filesTooBig ? Colors.colorError : null));
                l.setText(part.root.getPath());
                l.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
                l = new Label(this.diskspaceComp, 0);
                l.setForeground((Color)(filesTooBig ? Colors.colorError : null));
                l.setText(MessageText.getString("OpenTorrentWindow.diskUsage", new String[]{DisplayFormatters.formatByteCountToKiBEtc(part.bytesToConsume), DisplayFormatters.formatByteCountToKiBEtc(part.freeSpace)}));
                l.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
            }
            this.diskspaceComp.update();
            this.diskspaceComp.getParent().getParent().getParent().layout(true, true);
            this.diskFreeInfoRefreshRunning = false;
        }
    }

    private void updateSize() {
        long totalSize = 0L;
        long checkedSize = 0L;
        for (int i = 0; i < this.dataFiles.size(); ++i) {
            TorrentFileInfo file = (TorrentFileInfo)this.dataFiles.get(i);
            totalSize += file.lSize;
            if (!file.bDownload) continue;
            checkedSize += file.lSize;
        }
        if (totalSize == 0L) {
            this.dataFileTableLabel.setText("");
        } else {
            this.dataFileTableLabel.setText(MessageText.getString("OpenTorrentWindow.filesInfo", new String[]{DisplayFormatters.formatByteCountToKiBEtc(checkedSize), DisplayFormatters.formatByteCountToKiBEtc(totalSize)}));
        }
        this.dataFileTableLabel.update();
        this.dataFileTableLabel.getParent().getParent().layout(true, true);
        this.diskFreeInfoRefreshPending = true;
    }

    private void enableControl(final Control control, final boolean enabledState) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (control != null && !control.isDisposed()) {
                    control.setEnabled(enabledState);
                }
            }
        });
    }

    public static void main(String[] args) {
        AzureusCore core = AzureusCoreFactory.create();
        core.start();
        Display display = Display.getDefault();
        Colors.getInstance();
        OpenTorrentWindow.invoke(null, core.getGlobalManager());
        while (stOpenTorrentWindow != null && !OpenTorrentWindow.stOpenTorrentWindow.bClosed) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        core.stop();
    }

    private static final class FileStatsCacheItem {
        boolean exists;
        long freeSpace;

        public FileStatsCacheItem(File f) {
            this.exists = f.exists();
            this.freeSpace = this.exists ? FileUtil.getUsableSpace(f) : -1L;
        }
    }

    private static final class Partition {
        long bytesToConsume = 0L;
        long freeSpace = 0L;
        final File root;

        public Partition(File root) {
            this.root = root;
        }
    }

    private class TorrentFileInfo {
        final String orgFullName;
        final String orgFileName;
        long lSize;
        boolean bDownload;
        private String destFileName;
        private String destPathName;
        long iIndex;
        boolean isValid;
        final TorrentInfo parent;

        public TorrentFileInfo(TorrentInfo parent, TOTorrentFile torrentFile, int iIndex) {
            this.parent = parent;
            this.lSize = torrentFile.getLength();
            this.iIndex = iIndex;
            this.bDownload = true;
            this.isValid = true;
            this.orgFullName = torrentFile.getRelativePath();
            this.orgFileName = new File(this.orgFullName).getName();
        }

        public void setFullDestName(String newFullName) {
            if (newFullName == null) {
                this.setDestPathName(null);
                this.setDestFileName(null);
                return;
            }
            File newPath = new File(newFullName);
            this.setDestPathName(newPath.getParent());
            this.setDestFileName(newPath.getName());
        }

        public void setDestPathName(String newPath) {
            if (this.parent.torrent.isSimpleTorrent()) {
                this.parent.setParentDir(newPath);
            } else {
                this.destPathName = newPath;
            }
        }

        public void setDestFileName(String newFileName) {
            this.destFileName = this.orgFileName.equals(newFileName) ? null : newFileName;
        }

        public String getDestPathName() {
            if (this.destPathName != null) {
                return this.destPathName;
            }
            if (this.parent.torrent.isSimpleTorrent()) {
                return this.parent.getParentDir();
            }
            return new File(this.parent.getDataDir(), this.orgFullName).getParent();
        }

        public String getDestFileName() {
            return this.destFileName == null ? this.orgFileName : this.destFileName;
        }

        public File getDestFileFullName() {
            String path = this.getDestPathName();
            String file = this.getDestFileName();
            return new File(path, file);
        }

        public boolean okToDisable() {
            return this.parent.okToDisableAll();
        }

        public boolean isLinked() {
            return this.destFileName != null || this.destPathName != null;
        }
    }

    private class TorrentInfo {
        String sOriginatingLocation;
        String sFileName;
        String sDestDir;
        String sDestSubDir;
        TOTorrent torrent;
        int iStartID;
        int iQueueLocation;
        boolean isValid;
        boolean bDeleteFileOnCancel;
        private TorrentFileInfo[] files = null;

        public TorrentInfo(String sFileName, TOTorrent torrent, boolean bDeleteFileOnCancel) {
            this.bDeleteFileOnCancel = bDeleteFileOnCancel;
            this.sFileName = sFileName;
            this.sOriginatingLocation = sFileName;
            this.torrent = torrent;
            this.sDestDir = OpenTorrentWindow.this.sDestDir;
            this.iStartID = OpenTorrentWindow.this.getDefaultStartMode();
            this.iQueueLocation = 1;
            this.isValid = true;
            try {
                LocaleTorrentUtil.getTorrentEncoding(this.torrent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (OpenTorrentWindow.getSaveSilentlyDir() == null && COConfigurationManager.getBooleanParameter("DefaultDir.BestGuess") && !COConfigurationManager.getBooleanParameter(OpenTorrentWindow.PARAM_MOVEWHENDONE)) {
                this.sDestDir = this.getSmartDestDir();
            }
        }

        public String getParentDir() {
            return this.sDestDir;
        }

        public void setParentDir(String parentDir) {
            this.sDestDir = parentDir;
        }

        public String getDataDir() {
            if (this.torrent.isSimpleTorrent()) {
                return this.sDestDir;
            }
            return new File(this.sDestDir, this.sDestSubDir == null ? FileUtil.convertOSSpecificChars(this.getTorrentName(), true) : this.sDestSubDir).getPath();
        }

        public String getSmartDestDir() {
            String sSmartDir = this.sDestDir;
            try {
                int iMatchLevel;
                String name = this.getTorrentName();
                String torrentFileName = new File(this.sFileName).getName().replaceFirst("\\.torrent$", "");
                int totalSegmentsLengths = 0;
                String[][] segments = new String[][]{name.split("[^a-zA-Z]+"), torrentFileName.split("[^a-zA-Z]+")};
                List downloadManagers = OpenTorrentWindow.this.gm.getDownloadManagers();
                for (int x = 0; x < segments.length; ++x) {
                    String[] segmentArray = segments[x];
                    for (int i = 0; i < segmentArray.length; ++i) {
                        int l = segmentArray[i].length();
                        if (l <= 1) continue;
                        segmentArray[i] = segmentArray[i].toLowerCase();
                        totalSegmentsLengths += l;
                    }
                }
                int maxMatches = 0;
                DownloadManager match = null;
                for (DownloadManager dm : downloadManagers) {
                    if (dm.getState() == 100) continue;
                    int numMatches = 0;
                    String dmName = dm.getDisplayName().toLowerCase();
                    for (int x = 0; x < segments.length; ++x) {
                        String[] segmentArray = segments[x];
                        for (int i = 0; i < segmentArray.length; ++i) {
                            String segment;
                            int l = segmentArray[i].length();
                            if (l <= 1 || dmName.indexOf(segment = segmentArray[i]) < 0) continue;
                            numMatches += l;
                        }
                    }
                    if (numMatches <= maxMatches) continue;
                    maxMatches = numMatches;
                    match = dm;
                }
                if (match != null && (iMatchLevel = maxMatches * 100 / totalSegmentsLengths) >= 30) {
                    File f = match.getSaveLocation();
                    if (!f.isDirectory() || match.getDiskManagerFileInfo().length > 1) {
                        f = f.getParentFile();
                    }
                    if (f != null && f.isDirectory()) {
                        sSmartDir = f.getAbsolutePath();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return sSmartDir;
        }

        public TorrentFileInfo[] getFiles() {
            if (this.files == null && this.torrent != null) {
                TOTorrentFile[] tfiles = this.torrent.getFiles();
                this.files = new TorrentFileInfo[tfiles.length];
                for (int i = 0; i < this.files.length; ++i) {
                    this.files[i] = new TorrentFileInfo(this, tfiles[i], i);
                }
            }
            return this.files;
        }

        public String getTorrentName() {
            if (this.torrent == null) {
                return "";
            }
            try {
                LocaleUtilDecoder decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(this.torrent);
                if (decoder != null) {
                    return decoder.decodeString(this.torrent.getName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                return new String(this.torrent.getName());
            }
            catch (Exception e) {
                return "TextDecodingError";
            }
        }

        public boolean allFilesMoving() {
            TorrentFileInfo[] files = this.getFiles();
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].isLinked()) continue;
                return false;
            }
            return true;
        }

        public boolean allFilesExist() {
            TorrentFileInfo[] files = this.getFiles();
            for (int i = 0; i < files.length; ++i) {
                File file;
                TorrentFileInfo fileInfo2 = files[i];
                if (!fileInfo2.bDownload || (file = fileInfo2.getDestFileFullName()).exists() && file.length() == fileInfo2.lSize) continue;
                return false;
            }
            return true;
        }

        public void renameDuplicates() {
            if (this.iStartID == 3 || !COConfigurationManager.getBooleanParameter("DefaultDir.AutoSave.AutoRename") || this.allFilesExist()) {
                return;
            }
            if (!this.torrent.isSimpleTorrent()) {
                if (new File(this.getDataDir()).isDirectory()) {
                    File f;
                    int idx = 0;
                    while ((f = new File(this.getDataDir() + "-" + ++idx)).isDirectory()) {
                    }
                    this.sDestSubDir = f.getName();
                }
            } else {
                TorrentFileInfo[] fileInfos = this.getFiles();
                for (int i = 0; i < fileInfos.length; ++i) {
                    TorrentFileInfo info = fileInfos[i];
                    File file = info.getDestFileFullName();
                    int idx = 0;
                    while (file.exists()) {
                        file = new File(info.getDestPathName(), ++idx + "-" + info.getDestFileName());
                    }
                    info.setDestFileName(file.getName());
                }
            }
        }

        public boolean okToDisableAll() {
            return true;
        }
    }
}

