/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableView;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TrackerChangerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class TorrentUtil {
    public static void fillTorrentMenu(final Menu menu, final DownloadManager[] dms, final AzureusCore azureus_core, final Composite composite, boolean include_show_details, int selected_dl_types, final TableView tv) {
        boolean bChecked;
        String msg_text;
        boolean isSeedingView;
        switch (selected_dl_types) {
            case 1: {
                isSeedingView = false;
                break;
            }
            case 2: {
                isSeedingView = true;
                break;
            }
            case 0: {
                if (dms.length == 1) {
                    isSeedingView = dms[0].isDownloadComplete(false);
                    break;
                }
            }
            default: {
                isSeedingView = false;
            }
        }
        boolean hasSelection = dms.length > 0;
        boolean isTrackerOn = TRTrackerUtils.isTrackerEnabled();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean bChangeDir = hasSelection;
        boolean fileRescan = true;
        boolean fileMove = true;
        boolean manualUpdate = true;
        boolean barsOpened = true;
        boolean changeUrl = true;
        boolean stop = false;
        boolean start = false;
        boolean recheck = false;
        boolean forceStartEnabled = false;
        boolean forceStart = false;
        boolean canSetSuperSeed = false;
        boolean superSeedAllYes = true;
        boolean superSeedAllNo = true;
        boolean upSpeedDisabled = false;
        long totalUpSpeed = 0L;
        boolean upSpeedUnlimited = false;
        long upSpeedSetMax = 0L;
        boolean downSpeedDisabled = false;
        long totalDownSpeed = 0L;
        boolean downSpeedUnlimited = false;
        long downSpeedSetMax = 0L;
        boolean allScanSelected = true;
        boolean allScanNotSelected = true;
        boolean allStopped = true;
        if (hasSelection) {
            for (int i = 0; i < dms.length; ++i) {
                int state;
                TRTrackerAnnouncer trackerClient;
                DownloadManager dm = dms[i];
                try {
                    int maxul = dm.getStats().getUploadRateLimitBytesPerSecond();
                    if (maxul == 0) {
                        upSpeedUnlimited = true;
                    } else if ((long)maxul > upSpeedSetMax) {
                        upSpeedSetMax = maxul;
                    }
                    if (maxul == -1) {
                        maxul = 0;
                        upSpeedDisabled = true;
                    }
                    totalUpSpeed += (long)maxul;
                    int maxdl = dm.getStats().getDownloadRateLimitBytesPerSecond();
                    if (maxdl == 0) {
                        downSpeedUnlimited = true;
                    } else if ((long)maxdl > downSpeedSetMax) {
                        downSpeedSetMax = maxdl;
                    }
                    if (maxdl == -1) {
                        maxdl = 0;
                        downSpeedDisabled = true;
                    }
                    totalDownSpeed += (long)maxdl;
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
                if (barsOpened && !DownloadBar.getManager().isOpen(dm)) {
                    barsOpened = false;
                }
                stop = stop || ManagerUtils.isStopable(dm);
                start = start || ManagerUtils.isStartable(dm);
                recheck = recheck || dm.canForceRecheck();
                forceStartEnabled = forceStartEnabled || ManagerUtils.isForceStartable(dm);
                forceStart = forceStart || dm.isForceStart();
                boolean stopped = ManagerUtils.isStopped(dm);
                allStopped &= stopped;
                boolean bl = fileMove = fileMove && dm.canMoveDataFiles();
                if (userMode < 2 && (trackerClient = dm.getTrackerClient()) != null) {
                    boolean update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
                    manualUpdate &= update_state;
                }
                if ((bChangeDir &= (state = dm.getState()) == 100 || state == 70 || state == 75) && dms.length == 1) {
                    bChangeDir = dm.isDataAlreadyAllocated() && !dm.filesExist(true);
                }
                boolean scan = dm.getDownloadState().getFlag(2L);
                boolean incomplete = !dm.isDownloadComplete(true);
                allScanSelected = incomplete && allScanSelected && scan;
                allScanNotSelected = incomplete && allScanNotSelected && !scan;
                PEPeerManager pm = dm.getPeerManager();
                if (pm != null) {
                    if (pm.canToggleSuperSeedMode()) {
                        canSetSuperSeed = true;
                    }
                    if (pm.isSuperSeedMode()) {
                        superSeedAllYes = false;
                        continue;
                    }
                    superSeedAllNo = false;
                    continue;
                }
                superSeedAllYes = false;
                superSeedAllNo = false;
            }
            fileRescan = allScanSelected || allScanNotSelected;
        } else {
            barsOpened = false;
            forceStart = false;
            forceStartEnabled = false;
            start = false;
            stop = false;
            fileMove = false;
            fileRescan = false;
            upSpeedDisabled = true;
            downSpeedDisabled = true;
            changeUrl = false;
            recheck = false;
            manualUpdate = false;
        }
        if (bChangeDir) {
            MenuItem menuItemChangeDir = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)menuItemChangeDir, "MyTorrentsView.menu.changeDirectory");
            menuItemChangeDir.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentUtil.changeDirSelectedTorrents(dms, composite.getShell());
                }
            });
        }
        if (include_show_details) {
            MenuItem itemDetails = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDetails, "MyTorrentsView.menu.showdetails");
            menu.setDefaultItem(itemDetails);
            Utils.setMenuItemImage(itemDetails, "details");
            itemDetails.addListener(13, (Listener)new DMTask(dms){

                public void run(DownloadManager dm) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.openView(5, dm);
                    }
                }
            });
            itemDetails.setEnabled(hasSelection);
        }
        MenuItem itemBar = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemBar, "MyTorrentsView.menu.showdownloadbar");
        Utils.setMenuItemImage(itemBar, "downloadBar");
        itemBar.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                if (DownloadBar.getManager().isOpen(dm)) {
                    DownloadBar.close(dm);
                } else {
                    DownloadBar.open(dm, menu.getShell());
                }
            }
        });
        itemBar.setEnabled(hasSelection);
        itemBar.setSelection(barsOpened);
        new MenuItem(menu, 2);
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "MyTorrentsView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        itemOpen.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                TorrentUtil.runTorrents(dms);
            }
        });
        itemOpen.setEnabled(hasSelection);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, (Listener)new DMTask(dms, false){

            public void run(DownloadManager dm) {
                ManagerUtils.open(dm, use_open_containing_folder);
            }
        });
        itemExplore.setEnabled(hasSelection);
        MenuItem itemAdvanced = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemAdvanced, "MyTorrentsView.menu.advancedmenu");
        itemAdvanced.setEnabled(hasSelection);
        Menu menuAdvanced = new Menu((Decorations)menu.getShell(), 4);
        itemAdvanced.setMenu(menuAdvanced);
        long maxDownload = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024;
        long maxUpload = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * 1024;
        ViewUtils.addSpeedMenu(menu.getShell(), menuAdvanced, true, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDownload, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUpload, dms.length, new ViewUtils.SpeedAdapter(){

            public void setDownSpeed(final int speed) {
                DMTask task2 = new DMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getStats().setDownloadRateLimitBytesPerSecond(speed);
                    }
                };
                task2.go();
            }

            public void setUpSpeed(final int speed) {
                DMTask task2 = new DMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getStats().setUploadRateLimitBytesPerSecond(speed);
                    }
                };
                task2.go();
            }
        });
        Menu menuTracker = new Menu((Decorations)menu.getShell(), 4);
        MenuItem itemTracker = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemTracker, "MyTorrentsView.menu.tracker");
        itemTracker.setMenu(menuTracker);
        MenuItem itemChangeTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemChangeTracker, "MyTorrentsView.menu.changeTracker");
        Utils.setMenuItemImage(itemChangeTracker, "add_tracker");
        itemChangeTracker.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                if (dms.length > 0) {
                    new TrackerChangerWindow(composite.getDisplay(), dms);
                }
            }
        });
        itemChangeTracker.setEnabled(changeUrl);
        MenuItem itemEditTracker = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemEditTracker, "MyTorrentsView.menu.editTracker");
        Utils.setMenuItemImage(itemEditTracker, "edit_trackers");
        itemEditTracker.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                HashMap<String, ArrayList<DownloadManager>> same_map = new HashMap<String, ArrayList<DownloadManager>>();
                for (DownloadManager dm : dms) {
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null) continue;
                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                    String str = "";
                    for (List<String> l : group) {
                        str = str + "[[";
                        for (String s : l) {
                            str = str + s + ", ";
                        }
                    }
                    ArrayList<DownloadManager> dl = (ArrayList<DownloadManager>)same_map.get(str);
                    if (dl == null) {
                        dl = new ArrayList<DownloadManager>();
                        same_map.put(str, dl);
                    }
                    dl.add(dm);
                }
                for (final List set : same_map.values()) {
                    TOTorrent torrent = ((DownloadManager)set.get(0)).getTorrent();
                    List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                    new MultiTrackerEditor(null, group, new TrackerEditorListener(){

                        @Override
                        public void trackersChanged(String str, String str2, List<List<String>> group) {
                            for (DownloadManager dm : set) {
                                TOTorrent torrent = dm.getTorrent();
                                TorrentUtils.listToAnnounceGroups(group, torrent);
                                try {
                                    TorrentUtils.writeToFile(torrent);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                                if (dm.getTrackerClient() == null) continue;
                                dm.getTrackerClient().resetTrackerUrl(true);
                            }
                        }
                    }, true);
                }
            }
        });
        itemEditTracker.setEnabled(hasSelection);
        MenuItem itemManualUpdate = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualUpdate, "GeneralView.label.trackerurlupdate");
        itemManualUpdate.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                dm.requestTrackerAnnounce(false);
            }
        });
        itemManualUpdate.setEnabled(manualUpdate);
        boolean scrape_enabled = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Enable");
        boolean scrape_stopped = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
        boolean manualScrape = !scrape_enabled || !scrape_stopped && allStopped;
        MenuItem itemManualScrape = new MenuItem(menuTracker, 8);
        Messages.setLanguageText((Widget)itemManualScrape, "GeneralView.label.trackerscrapeupdate");
        itemManualScrape.addListener(13, (Listener)new DMTask(dms, true, true){

            public void run(DownloadManager dm) {
                dm.requestTrackerScrape(true);
            }
        });
        itemManualScrape.setEnabled(manualScrape);
        MenuItem itemFiles = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemFiles, "ConfigView.section.files");
        Menu menuFiles = new Menu((Decorations)composite.getShell(), 4);
        itemFiles.setMenu(menuFiles);
        MenuItem itemFileMoveData = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveData, "MyTorrentsView.menu.movedata");
        itemFileMoveData.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                if (dms != null && dms.length > 0) {
                    DirectoryDialog dd = new DirectoryDialog(composite.getShell());
                    dd.setFilterPath(TorrentOpener.getFilterPathData());
                    dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                    String path = dd.open();
                    if (path != null) {
                        TorrentOpener.setFilterPathData(path);
                        File target = new File(path);
                        for (int i = 0; i < dms.length; ++i) {
                            try {
                                dms[i].moveDataFiles(target);
                                continue;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert((Object)dms[i], true, "Download data move operation failed", e));
                            }
                        }
                    }
                }
            }
        });
        itemFileMoveData.setEnabled(fileMove);
        MenuItem itemFileMoveTorrent = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileMoveTorrent, "MyTorrentsView.menu.movetorrent");
        itemFileMoveTorrent.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                if (dms != null && dms.length > 0) {
                    DirectoryDialog dd = new DirectoryDialog(composite.getShell());
                    String filter_path = TorrentOpener.getFilterPathTorrent();
                    if (filter_path == null || filter_path.trim().length() == 0) {
                        filter_path = new File(dms[0].getTorrentFileName()).getParent();
                    }
                    dd.setFilterPath(filter_path);
                    dd.setText(MessageText.getString("MyTorrentsView.menu.movedata.dialog"));
                    String path = dd.open();
                    if (path != null) {
                        File target = new File(path);
                        TorrentOpener.setFilterPathTorrent(target.toString());
                        for (int i = 0; i < dms.length; ++i) {
                            try {
                                dms[i].moveTorrentFile(target);
                                continue;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert((Object)dms[i], true, "Download torrent move operation failed", e));
                            }
                        }
                    }
                }
            }
        });
        itemFileMoveTorrent.setEnabled(fileMove);
        MenuItem itemCheckFilesExist = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemCheckFilesExist, "MyTorrentsView.menu.checkfilesexist");
        itemCheckFilesExist.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                dm.filesExist(true);
            }
        });
        final MenuItem itemFileRescan = new MenuItem(menuFiles, 32);
        Messages.setLanguageText((Widget)itemFileRescan, "MyTorrentsView.menu.rescanfile");
        itemFileRescan.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                dm.getDownloadState().setFlag(2L, itemFileRescan.getSelection());
            }
        });
        itemFileRescan.setSelection(allScanSelected);
        itemFileRescan.setEnabled(fileRescan);
        MenuItem itemFileClearAlloc = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileClearAlloc, "MyTorrentsView.menu.clear_alloc_data");
        itemFileClearAlloc.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                dm.setDataAlreadyAllocated(false);
            }
        });
        itemFileClearAlloc.setEnabled(allStopped);
        MenuItem itemFileClearResume = new MenuItem(menuFiles, 8);
        Messages.setLanguageText((Widget)itemFileClearResume, "MyTorrentsView.menu.clear_resume_data");
        itemFileClearResume.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                dm.getDownloadState().clearResumeData();
            }
        });
        itemFileClearResume.setEnabled(allStopped);
        MenuItem itemRename = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemRename, "MyTorrentsView.menu.rename");
        itemRename.setEnabled(hasSelection);
        Menu menuRename = new Menu((Decorations)composite.getShell(), 4);
        itemRename.setMenu(menuRename);
        DownloadManager first_selected = dms.length == 0 ? null : dms[0];
        MenuItem itemRenameDisplayed = new MenuItem(menuRename, 64);
        Messages.setLanguageText((Widget)itemRenameDisplayed, "MyTorrentsView.menu.rename.displayed");
        itemRenameDisplayed.setEnabled(hasSelection);
        if (itemRenameDisplayed.isEnabled()) {
            itemRenameDisplayed.setData("suggested_text", (Object)first_selected.getDisplayName());
            itemRenameDisplayed.setData("display_name", (Object)Boolean.TRUE);
            itemRenameDisplayed.setData("save_name", (Object)Boolean.FALSE);
            itemRenameDisplayed.setData("rename_all", (Object)Boolean.FALSE);
            itemRenameDisplayed.setData("msg_key", (Object)"displayed");
        }
        MenuItem itemRenameSavePath = new MenuItem(menuRename, 64);
        Messages.setLanguageText((Widget)itemRenameSavePath, "MyTorrentsView.menu.rename.save_path");
        itemRenameSavePath.setEnabled(fileMove && dms.length == 1);
        if (itemRenameSavePath.isEnabled()) {
            itemRenameSavePath.setData("suggested_text", (Object)first_selected.getAbsoluteSaveLocation().getName());
            itemRenameSavePath.setData("display_name", (Object)Boolean.FALSE);
            itemRenameSavePath.setData("save_name", (Object)Boolean.TRUE);
            itemRenameSavePath.setData("rename_all", (Object)Boolean.FALSE);
            itemRenameSavePath.setData("msg_key", (Object)"save_path");
        }
        MenuItem itemRenameBoth = new MenuItem(menuRename, 64);
        Messages.setLanguageText((Widget)itemRenameBoth, "MyTorrentsView.menu.rename.displayed_and_save_path");
        itemRenameBoth.setEnabled(fileMove && dms.length == 1);
        if (itemRenameBoth.isEnabled()) {
            itemRenameBoth.setData("suggested_text", (Object)first_selected.getAbsoluteSaveLocation().getName());
            itemRenameBoth.setData("display_name", (Object)Boolean.TRUE);
            itemRenameBoth.setData("save_name", (Object)Boolean.TRUE);
            itemRenameBoth.setData("msg_key", (Object)"displayed_and_save_path");
            itemRenameBoth.setData("rename_all", (Object)Boolean.FALSE);
        }
        Listener rename_listener = new Listener(){

            public void handleEvent(Event event2) {
                MenuItem mi = (MenuItem)event2.widget;
                String suggested = (String)mi.getData("suggested_text");
                final boolean rename_all = (Boolean)mi.getData("rename_all");
                final boolean change_displayed_name = (Boolean)mi.getData("display_name");
                final boolean change_save_name = (Boolean)mi.getData("save_name");
                String msg_key_prefix = "MyTorrentsView.menu.rename." + (String)mi.getData("msg_key") + ".enter.";
                SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow();
                text_entry.setTitle(msg_key_prefix + "title");
                text_entry.setMessage(msg_key_prefix + "message");
                text_entry.setPreenteredText(suggested, false);
                text_entry.prompt();
                if (text_entry.hasSubmittedInput()) {
                    String value = text_entry.getSubmittedInput();
                    final String value_to_set = value.length() == 0 ? null : value;
                    DMTask task2 = new DMTask(dms){

                        public void run(DownloadManager dm) {
                            if (rename_all) {
                                try {
                                    dm.rename(value_to_set);
                                }
                                catch (Exception e) {
                                    Logger.log(new LogAlert((Object)dm, true, "Download data rename operation failed", (Throwable)e));
                                }
                            }
                            if (change_displayed_name) {
                                dm.getDownloadState().setDisplayName(value_to_set);
                            }
                            if (change_save_name) {
                                try {
                                    dm.renameDownload(value_to_set == null ? dm.getDisplayName() : value_to_set);
                                }
                                catch (Exception e) {
                                    Logger.log(new LogAlert((Object)dm, true, "Download data rename operation failed", (Throwable)e));
                                }
                            }
                        }
                    };
                    task2.go();
                }
            }
        };
        itemRenameDisplayed.addListener(13, rename_listener);
        itemRenameSavePath.addListener(13, rename_listener);
        itemRenameBoth.addListener(13, rename_listener);
        if (userMode > 0) {
            MenuItem itemExport = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemExport, "MyTorrentsView.menu.exportmenu");
            Utils.setMenuItemImage(itemExport, "export");
            itemExport.setEnabled(hasSelection);
            Menu menuExport = new Menu((Decorations)composite.getShell(), 4);
            itemExport.setMenu(menuExport);
            final MenuItem itemExportXML = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportXML, "MyTorrentsView.menu.export");
            itemExportXML.addListener(13, (Listener)new DMTask(dms){

                public void run(DownloadManager[] dms) {
                    DownloadManager dm = dms[0];
                    if (dm != null) {
                        new ExportTorrentWizard(itemExportXML.getDisplay(), dm);
                    }
                }
            });
            MenuItem itemExportTorrent = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemExportTorrent, "MyTorrentsView.menu.exporttorrent");
            itemExportTorrent.addListener(13, (Listener)new DMTask(dms){

                public void run(DownloadManager[] dms) {
                    int i;
                    String path;
                    File[] destinations = new File[dms.length];
                    if (dms.length == 1) {
                        FileDialog fd = new FileDialog(composite.getShell(), 8192);
                        fd.setFileName(dms[0].getTorrentFileName());
                        path = fd.open();
                        if (path == null) {
                            return;
                        }
                        destinations[0] = new File(path);
                    } else {
                        DirectoryDialog dd = new DirectoryDialog(composite.getShell(), 8192);
                        path = dd.open();
                        if (path == null) {
                            return;
                        }
                        for (int i2 = 0; i2 < dms.length; ++i2) {
                            destinations[i2] = new File(path, new File(dms[i2].getTorrentFileName()).getName());
                        }
                    }
                    try {
                        for (i = 0; i < dms.length; ++i) {
                            File target = destinations[i];
                            if (target.exists()) {
                                MessageBox mb = new MessageBox(composite.getShell(), 196);
                                mb.setText(MessageText.getString("exportTorrentWizard.process.outputfileexists.title"));
                                mb.setMessage(MessageText.getString("exportTorrentWizard.process.outputfileexists.message") + "\n" + destinations[i].getName());
                                int result = mb.open();
                                if (result == 128) {
                                    return;
                                }
                                if (!target.delete()) {
                                    throw new Exception("Failed to delete file");
                                }
                            }
                            TorrentUtils.copyToFile(dms[i].getDownloadState().getTorrent(), target);
                            TOTorrent dest = TOTorrentFactory.deserialiseFromBEncodedFile(target);
                            dest.removeAdditionalProperties();
                            dest.serialiseToBEncodedFile(target);
                        }
                    }
                    catch (Throwable e) {
                        Logger.log(new LogAlert((Object)dms[i], false, "Torrent export failed", e));
                    }
                }
            });
            MenuItem itemWebSeed = new MenuItem(menuExport, 8);
            Messages.setLanguageText((Widget)itemWebSeed, "MyTorrentsView.menu.exporthttpseeds");
            itemWebSeed.addListener(13, (Listener)new DMTask(dms){

                public void run(DownloadManager[] dms) {
                    String port;
                    String NL = "\r\n";
                    String data = "";
                    boolean http_enable = COConfigurationManager.getBooleanParameter("HTTP.Data.Listen.Port.Enable");
                    if (http_enable) {
                        int p = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port");
                        int o = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port.Override");
                        port = o == 0 ? String.valueOf(p) : String.valueOf(o);
                    } else {
                        data = "You need to enable the HTTP port or modify the URL(s) appropriately\r\n\r\n";
                        port = "<port>";
                    }
                    String ip = COConfigurationManager.getStringParameter("Tracker IP", "");
                    if (ip.length() == 0) {
                        data = data + "You might need to modify the host address in the URL(s)\r\n\r\n";
                        try {
                            InetAddress ia = AzureusCoreFactory.getSingleton().getInstanceManager().getMyInstance().getExternalAddress();
                            if (ia != null) {
                                ip = IPToHostNameResolver.syncResolve(ia.getHostAddress(), 10000);
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (ip.length() == 0) {
                            ip = "<host>";
                        }
                    }
                    String base = "http://" + UrlUtils.convertIPV6Host(ip) + ":" + port + "/";
                    for (int i = 0; i < dms.length; ++i) {
                        TOTorrent torrent;
                        DownloadManager dm = dms[i];
                        if (dm == null || (torrent = dm.getTorrent()) == null) continue;
                        data = data + base + "webseed" + "\r\n";
                        try {
                            data = data + base + "files/" + URLEncoder.encode(new String(torrent.getHash(), "ISO-8859-1"), "ISO-8859-1") + "/" + "\r\n" + "\r\n";
                            continue;
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    if (data.length() > 0) {
                        ClipboardCopy.copyToClipBoard(data);
                    }
                }
            });
        }
        if (userMode > 0) {
            MenuItem itemExportXML = new MenuItem(menuAdvanced, 8);
            Messages.setLanguageText((Widget)itemExportXML, "MainWindow.menu.view.configuration");
            itemExportXML.addListener(13, (Listener)new DMTask(dms){

                public void run(DownloadManager[] dms) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    uiFunctions.openView(6, dms);
                }
            });
        }
        if (userMode > 0) {
            MenuItem itemPeerSource = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemPeerSource, "MyTorrentsView.menu.peersource");
            Menu menuPeerSource = new Menu((Decorations)composite.getShell(), 4);
            itemPeerSource.setMenu(menuPeerSource);
            for (int i = 0; i < PEPeerSource.PS_SOURCES.length; ++i) {
                boolean bEnabled;
                final String p = PEPeerSource.PS_SOURCES[i];
                msg_text = "ConfigView.section.connection.peersource." + p;
                final MenuItem itemPS = new MenuItem(menuPeerSource, 32);
                itemPS.setData("peerSource", (Object)p);
                Messages.setLanguageText((Widget)itemPS, msg_text);
                itemPS.addListener(13, (Listener)new DMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getDownloadState().setPeerSourceEnabled(p, itemPS.getSelection());
                    }
                });
                itemPS.setSelection(true);
                bChecked = hasSelection;
                boolean bl = bEnabled = !hasSelection;
                if (bChecked) {
                    bEnabled = true;
                    for (int j = 0; j < dms.length; ++j) {
                        DownloadManager dm = dms[j];
                        if (!dm.getDownloadState().isPeerSourceEnabled(p)) {
                            bChecked = false;
                        }
                        if (dm.getDownloadState().isPeerSourcePermitted(p)) continue;
                        bEnabled = false;
                    }
                }
                itemPS.setSelection(bChecked);
                itemPS.setEnabled(bEnabled);
            }
        }
        if (userMode > 1) {
            MenuItem itemNetworks = new MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemNetworks, "MyTorrentsView.menu.networks");
            Menu menuNetworks = new Menu((Decorations)composite.getShell(), 4);
            itemNetworks.setMenu(menuNetworks);
            for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
                final String nn = AENetworkClassifier.AT_NETWORKS[i];
                msg_text = "ConfigView.section.connection.networks." + nn;
                final MenuItem itemNetwork = new MenuItem(menuNetworks, 32);
                itemNetwork.setData("network", (Object)nn);
                Messages.setLanguageText((Widget)itemNetwork, msg_text);
                itemNetwork.addListener(13, (Listener)new DMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getDownloadState().setNetworkEnabled(nn, itemNetwork.getSelection());
                    }
                });
                bChecked = hasSelection;
                if (bChecked) {
                    for (int j = 0; j < dms.length; ++j) {
                        DownloadManager dm = dms[j];
                        if (dm.getDownloadState().isNetworkEnabled(nn)) continue;
                        bChecked = false;
                        break;
                    }
                }
                itemNetwork.setSelection(bChecked);
            }
        }
        if (userMode > 1 && isSeedingView) {
            MenuItem itemSuperSeed = new MenuItem(menuAdvanced, 32);
            Messages.setLanguageText((Widget)itemSuperSeed, "ManagerItem.superseeding");
            boolean enabled = canSetSuperSeed && (superSeedAllNo || superSeedAllYes);
            itemSuperSeed.setEnabled(enabled);
            final boolean selected = superSeedAllNo;
            if (enabled) {
                itemSuperSeed.setSelection(selected);
                itemSuperSeed.addListener(13, (Listener)new DMTask(dms){

                    public void run(DownloadManager dm) {
                        PEPeerManager pm = dm.getPeerManager();
                        if (pm != null && pm.isSuperSeedMode() == selected && pm.canToggleSuperSeedMode()) {
                            pm.setSuperSeedMode(!selected);
                        }
                    }
                });
            }
        }
        MenuItem itemPositionManual = new MenuItem(menuAdvanced, 8);
        Messages.setLanguageText((Widget)itemPositionManual, "MyTorrentsView.menu.reposition.manual");
        itemPositionManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("MyTorrentsView.dialog.setPosition.title", "MyTorrentsView.dialog.setPosition.text");
                entryWindow.prompt();
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int newPosition = -1;
                try {
                    newPosition = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    // empty catch block
                }
                int size = azureus_core.getGlobalManager().downloadManagerCount(isSeedingView);
                if (newPosition > size) {
                    newPosition = size;
                }
                if (newPosition <= 0) {
                    MessageBox mb = new MessageBox(composite.getShell(), 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                TorrentUtil.moveSelectedTorrentsTo(tv, dms, newPosition);
            }
        });
        if (userMode > 0 && isTrackerOn) {
            MenuItem itemHost = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemHost, "MyTorrentsView.menu.host");
            Utils.setMenuItemImage(itemHost, "host");
            itemHost.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.hostTorrents(dms, azureus_core, composite);
                }
            });
            MenuItem itemPublish = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemPublish, "MyTorrentsView.menu.publish");
            Utils.setMenuItemImage(itemPublish, "publish");
            itemPublish.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    TorrentUtil.publishTorrents(dms, azureus_core, composite);
                }
            });
            itemHost.setEnabled(hasSelection);
            itemPublish.setEnabled(hasSelection);
        }
        Menu menuCategory = new Menu((Decorations)composite.getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(menuCategory);
        itemCategory.setEnabled(hasSelection);
        TorrentUtil.addCategorySubMenu(dms, menuCategory, composite);
        new MenuItem(menu, 2);
        MenuItem itemQueue = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
        Utils.setMenuItemImage(itemQueue, "start");
        itemQueue.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                TorrentUtil.queueTorrents(dms, menu.getShell());
            }
        });
        itemQueue.setEnabled(start);
        if (userMode > 0) {
            final MenuItem itemForceStart = new MenuItem(menu, 32);
            Messages.setLanguageText((Widget)itemForceStart, "MyTorrentsView.menu.forceStart");
            Utils.setMenuItemImage(itemForceStart, "forcestart");
            itemForceStart.addListener(13, (Listener)new DMTask(dms){

                public void run(DownloadManager dm) {
                    if (ManagerUtils.isForceStartable(dm)) {
                        dm.setForceStart(itemForceStart.getSelection());
                    }
                }
            });
            itemForceStart.setSelection(forceStart);
            itemForceStart.setEnabled(forceStartEnabled);
        }
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        itemStop.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                TorrentUtil.stopTorrents(dms, menu.getShell());
            }
        });
        itemStop.setEnabled(stop);
        MenuItem itemRecheck = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRecheck, "MyTorrentsView.menu.recheck");
        Utils.setMenuItemImage(itemRecheck, "recheck");
        itemRecheck.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                if (dm.canForceRecheck()) {
                    dm.forceRecheck();
                }
            }
        });
        itemRecheck.setEnabled(recheck);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MyTorrentsView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        itemRemove.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                TorrentUtil.removeTorrent(dm, false, false, menu.getShell());
            }
        });
        itemRemove.setEnabled(hasSelection);
        MenuItem itemRemoveAnd = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemRemoveAnd, "MyTorrentsView.menu.removeand");
        Utils.setMenuItemImage(itemRemoveAnd, "delete");
        itemRemoveAnd.setEnabled(hasSelection);
        Menu menuRemove = new Menu((Decorations)composite.getShell(), 4);
        itemRemoveAnd.setMenu(menuRemove);
        MenuItem itemDeleteTorrent = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteTorrent, "MyTorrentsView.menu.removeand.deletetorrent");
        itemDeleteTorrent.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                TorrentUtil.removeTorrent(dm, true, false, menu.getShell());
            }
        });
        MenuItem itemDeleteData = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteData, "MyTorrentsView.menu.removeand.deletedata");
        itemDeleteData.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                TorrentUtil.removeTorrent(dm, false, true, menu.getShell());
            }
        });
        MenuItem itemDeleteBoth = new MenuItem(menuRemove, 8);
        Messages.setLanguageText((Widget)itemDeleteBoth, "MyTorrentsView.menu.removeand.deleteboth");
        itemDeleteBoth.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager dm) {
                TorrentUtil.removeTorrent(dm, true, true, menu.getShell());
            }
        });
    }

    private static void addCategorySubMenu(DownloadManager[] dms, Menu menuCategory, final Composite composite) {
        boolean allow_category_selection;
        int i;
        MenuItem[] items = menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        boolean bl = allow_category_selection = categories.length > 0;
        if (allow_category_selection) {
            boolean user_category_found = false;
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                user_category_found = true;
                break;
            }
            allow_category_selection = user_category_found;
        }
        if (allow_category_selection) {
            final Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                MenuItem itemCategory = new MenuItem(menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.addListener(13, (Listener)new DMTask(dms){

                    public void run(DownloadManager dm) {
                        dm.getDownloadState().setCategory(catUncat);
                    }
                });
                new MenuItem(menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                Object category = categories[i];
                if (category.getType() != 0) continue;
                MenuItem itemCategory = new MenuItem(menuCategory, 8);
                itemCategory.setText(category.getName());
                itemCategory.addListener(13, (Listener)new DMTask(dms, (Category)category){
                    final /* synthetic */ Category val$category;
                    {
                        this.val$category = category;
                        super(x0);
                    }

                    public void run(DownloadManager dm) {
                        dm.getDownloadState().setCategory(this.val$category);
                    }
                });
            }
            new MenuItem(menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, (Listener)new DMTask(dms){

            public void run(DownloadManager[] dms) {
                CategoryAdderWindow adderWindow = new CategoryAdderWindow(composite.getDisplay());
                Category newCategory = adderWindow.getNewCategory();
                if (newCategory != null) {
                    TorrentUtil.assignToCategory(dms, newCategory);
                }
            }
        });
    }

    private static void moveSelectedTorrentsTo(TableView tv, DownloadManager[] dms, int iNewPos) {
        if (dms == null || dms.length == 0) {
            return;
        }
        TableColumnCore sortColumn = tv == null ? null : tv.getSortColumn();
        boolean isSortAscending = sortColumn == null ? true : sortColumn.isSortAscending();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            int iOldPos = dm.getPosition();
            dm.getGlobalManager().moveTo(dm, iNewPos);
            if (isSortAscending) {
                if (iOldPos <= iNewPos) continue;
                ++iNewPos;
                continue;
            }
            if (iOldPos >= iNewPos) continue;
            --iNewPos;
        }
        if (tv != null) {
            boolean bForceSort = sortColumn.getName().equals("#");
            tv.columnInvalidate("#");
            tv.refreshTable(bForceSort);
        }
    }

    private static void changeDirSelectedTorrents(DownloadManager[] dms, Shell shell) {
        File f;
        String sDefPath;
        if (dms.length <= 0) {
            return;
        }
        String string = sDefPath = COConfigurationManager.getBooleanParameter("Use default data dir") ? COConfigurationManager.getStringParameter("Default save path") : "";
        if (sDefPath.length() > 0 && !(f = new File(sDefPath)).exists()) {
            FileUtil.mkdirs(f);
        }
        DirectoryDialog dDialog = new DirectoryDialog(shell, 131072);
        dDialog.setFilterPath(sDefPath);
        dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath"));
        String sSavePath = dDialog.open();
        if (sSavePath != null) {
            File fSavePath = new File(sSavePath);
            for (int i = 0; i < dms.length; ++i) {
                DownloadManager dm = dms[i];
                if (dm.getState() != 100) continue;
                dm.setTorrentSaveDir(sSavePath);
                boolean found = dm.filesExist(true);
                if (!found && dm.getTorrent() != null && !dm.getTorrent().isSimpleTorrent() && (sSavePath = fSavePath.getParent()) != null) {
                    dm.setTorrentSaveDir(sSavePath);
                    found = dm.filesExist(true);
                }
                if (!found) continue;
                dm.stopIt(70, false, false);
                ManagerUtils.queue(dm, (Composite)shell);
            }
        }
    }

    public static void runTorrents(Object[] download_managers) {
        for (int i = download_managers.length - 1; i >= 0; --i) {
            DownloadManager dm = (DownloadManager)download_managers[i];
            if (dm == null) continue;
            ManagerUtils.run(dm);
        }
    }

    public static void hostTorrents(Object[] download_managers, final AzureusCore azureus_core, final Composite composite) {
        DMTask task2 = new DMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                ManagerUtils.host(azureus_core, dm, composite);
            }
        };
        task2.go();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.openView(9, null);
        }
    }

    public static void publishTorrents(Object[] download_managers, final AzureusCore azureus_core, final Composite composite) {
        DMTask task2 = new DMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                ManagerUtils.publish(azureus_core, dm, composite);
            }
        };
        task2.go();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.openView(9, null);
        }
    }

    public static void removeTorrent(DownloadManager dm, boolean bDeleteTorrent, boolean bDeleteData, Shell shell) {
        ManagerUtils.remove(dm, shell, bDeleteTorrent, bDeleteData);
    }

    public static void removeTorrents(Object[] download_managers, final Shell shell) {
        DMTask task2 = new DMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                TorrentUtil.removeTorrent(dm, false, false, shell);
            }
        };
        task2.go();
    }

    public static void stopTorrents(Object[] download_managers, final Shell shell) {
        DMTask task2 = new DMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                ManagerUtils.stop(dm, shell);
            }
        };
        task2.go();
    }

    public static void queueTorrents(Object[] download_managers, final Shell shell) {
        DMTask task2 = new DMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                ManagerUtils.queue(dm, (Composite)shell);
            }
        };
        task2.go();
    }

    public static void resumeTorrents(Object[] download_managers) {
        DMTask task2 = new DMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                ManagerUtils.start(dm);
            }
        };
        task2.go();
    }

    public static void assignToCategory(Object[] download_managers, final Category category) {
        DMTask task2 = new DMTask(TorrentUtil.toDMS(download_managers)){

            public void run(DownloadManager dm) {
                dm.getDownloadState().setCategory(category);
            }
        };
        task2.go();
    }

    public static void promptUserForComment(DownloadManager[] dms) {
        if (dms.length == 0) {
            return;
        }
        DownloadManager dm = dms[0];
        String suggested = dm.getDownloadState().getUserComment();
        String msg_key_prefix = "MyTorrentsView.menu.edit_comment.enter.";
        SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow();
        text_entry.setTitle(msg_key_prefix + "title");
        text_entry.setMessage(msg_key_prefix + "message");
        text_entry.setPreenteredText(suggested, false);
        text_entry.setMultiLine(true);
        text_entry.prompt();
        if (text_entry.hasSubmittedInput()) {
            String value = text_entry.getSubmittedInput();
            final String value_to_set = value.length() == 0 ? null : value;
            DMTask task2 = new DMTask(dms){

                public void run(DownloadManager dm) {
                    dm.getDownloadState().setUserComment(value_to_set);
                }
            };
            task2.go();
        }
    }

    private static DownloadManager[] toDMS(Object[] objects) {
        if (objects instanceof DownloadManager[]) {
            return (DownloadManager[])objects;
        }
        DownloadManager[] result = new DownloadManager[objects.length];
        System.arraycopy(objects, 0, result, 0, result.length);
        return result;
    }

    public static boolean isFileTorrent(File torrentFile, Shell parentShell, String torrentName) {
        String sFirstChunk = null;
        try {
            sFirstChunk = FileUtil.readFileAsString(torrentFile, 16384).toLowerCase();
        }
        catch (IOException e) {
            Debug.out("warning", e);
        }
        if (sFirstChunk == null) {
            sFirstChunk = "";
        }
        if (!sFirstChunk.startsWith("d")) {
            if (parentShell != null) {
                boolean isHTML = sFirstChunk.indexOf("<html") >= 0;
                MessageBoxShell boxShell = new MessageBoxShell(parentShell, MessageText.getString("OpenTorrentWindow.mb.notTorrent.title"), MessageText.getString("OpenTorrentWindow.mb.notTorrent.text", new String[]{torrentName, isHTML ? "" : MessageText.getString("OpenTorrentWindow.mb.notTorrent.cannot.display")}), new String[]{MessageText.getString("Button.ok")}, 0);
                if (isHTML) {
                    boxShell.setHtml(sFirstChunk);
                }
                boxShell.open();
            }
            return false;
        }
        return true;
    }

    private static abstract class DMTask
    implements Listener {
        private DownloadManager[] dms;
        private boolean ascending;
        private boolean async;

        public DMTask(DownloadManager[] dms) {
            this(dms, true);
        }

        public DMTask(DownloadManager[] dms, boolean ascending) {
            this.dms = dms;
            this.ascending = ascending;
        }

        public DMTask(DownloadManager[] dms, boolean ascending, boolean async) {
            this.dms = dms;
            this.ascending = ascending;
            this.async = async;
        }

        public void run(DownloadManager dm) {
        }

        public void run(DownloadManager[] dm) {
        }

        public void handleEvent(Event event2) {
            if (this.async) {
                new AEThread2("DMTask:async", true){

                    public void run() {
                        DMTask.this.go();
                    }
                }.start();
            } else {
                this.go();
            }
        }

        public void go() {
            try {
                DownloadManager dm = null;
                for (int i = 0; i < this.dms.length; ++i) {
                    dm = this.dms[this.ascending ? i : this.dms.length - 1 - i];
                    if (dm == null) continue;
                    this.run(dm);
                }
                this.run(this.dms);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

