/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableItemImpl;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;

public abstract class BufferedGraphicTableItem2
extends BufferedTableItemImpl
implements BufferedGraphicTableItem {
    private int marginHeight = 1;
    private int marginWidth = 1;
    private int orientation = 0x1000000;
    Canvas cBlockView = null;
    private Image image;
    private Color lastBackColor = null;

    public BufferedGraphicTableItem2(BufferedTableRow row, int position) {
        super(row, position);
    }

    private void createBlockView() {
        int iStyle = 786432;
        if (this.orientation == 4) {
            iStyle |= 0x100000;
        }
        this.cBlockView = new Canvas((Composite)this.getTable(), iStyle);
        this.cBlockView.setBackground(null);
        this.cBlockView.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event2) {
                if (event2.width == 0 || event2.height == 0) {
                    return;
                }
                BufferedGraphicTableItem2.this.doPaint(event2.gc.getClipping());
            }
        });
        this.cBlockView.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Table table = BufferedGraphicTableItem2.this.getTable();
                Rectangle r = BufferedGraphicTableItem2.this.cBlockView.getBounds();
                TableItem[] item = new TableItem[]{table.getItem(new Point(r.x, r.y))};
                if (item[0] != null) {
                    table.setSelection(item);
                }
                table.setFocus();
            }

            public void mouseUp(MouseEvent e) {
                BufferedGraphicTableItem2.this.getTable().setFocus();
            }
        });
    }

    public Image getGraphic() {
        return this.image;
    }

    public boolean setGraphic(Image img) {
        boolean bImageSet;
        boolean bl = bImageSet = this.image != img;
        if (bImageSet) {
            if (this.cBlockView == null) {
                this.createBlockView();
            }
            this.image = img;
        }
        if (img != null) {
            this.doPaint((Rectangle)null);
        }
        return bImageSet;
    }

    public boolean needsPainting() {
        return true;
    }

    public void locationChanged() {
        if (this.cBlockView == null || this.cBlockView.isDisposed()) {
            return;
        }
        Rectangle bounds = this.getBoundsForCanvas();
        if (bounds == null || this.image == null || this.image.isDisposed()) {
            return;
        }
        this.cBlockView.setLocation(bounds.x, bounds.y);
    }

    public void doPaint(GC gc) {
        if (this.cBlockView == null || this.cBlockView.isDisposed()) {
            return;
        }
        Rectangle bounds = this.getBoundsForCanvas();
        if (bounds == null || this.image == null || this.image.isDisposed()) {
            return;
        }
        Rectangle canvasBounds = this.cBlockView.getBounds();
        if (canvasBounds.x != bounds.x || canvasBounds.y != bounds.y) {
            this.cBlockView.setLocation(bounds.x, bounds.y);
            canvasBounds = this.cBlockView.getBounds();
        }
        Table table = this.getTable();
        Rectangle tableBounds = table.getClientArea();
        if (tableBounds.y < table.getHeaderHeight()) {
            tableBounds.y = table.getHeaderHeight();
        }
        Rectangle rNewCanvas = bounds.intersection(tableBounds);
        if (rNewCanvas.width <= 0 || rNewCanvas.height <= 0) {
            return;
        }
        if (!rNewCanvas.equals((Object)canvasBounds) || this.orientation != 4 && !this.getRowBackground(table).equals((Object)this.lastBackColor)) {
            rNewCanvas.x -= canvasBounds.x;
            rNewCanvas.y -= canvasBounds.y;
            this.doPaint(rNewCanvas);
        }
    }

    public void doPaint(Rectangle clipping) {
        if (this.cBlockView == null || this.cBlockView.isDisposed()) {
            return;
        }
        Table table = this.getTable();
        Rectangle bounds = this.getBoundsForCanvas();
        if (bounds == null || this.image == null || this.image.isDisposed()) {
            return;
        }
        Rectangle canvasBounds = this.cBlockView.getBounds();
        if (canvasBounds.x != bounds.x || canvasBounds.y != bounds.y) {
            this.cBlockView.setLocation(bounds.x, bounds.y);
            canvasBounds = this.cBlockView.getBounds();
        }
        if (bounds.width != canvasBounds.width || bounds.height != canvasBounds.height) {
            this.cBlockView.setSize(bounds.width, bounds.height);
            canvasBounds = this.cBlockView.getBounds();
        }
        if (this.orientation == 4) {
            Rectangle imageBounds = this.image.getBounds();
            if (imageBounds.width != bounds.width || imageBounds.height != bounds.height) {
                this.cBlockView.setSize(bounds.width, bounds.height);
                GC gc = new GC((Drawable)this.cBlockView);
                gc.drawImage(this.image, 0, 0, imageBounds.width, imageBounds.height, 0, 0, bounds.width, bounds.height);
                gc.dispose();
                this.invalidate();
                return;
            }
        }
        if (clipping == null) {
            clipping = new Rectangle(0, 0, bounds.width, bounds.height);
        }
        Rectangle tableBounds = table.getClientArea();
        if (tableBounds.y < table.getHeaderHeight()) {
            tableBounds.y = table.getHeaderHeight();
        }
        tableBounds.x -= canvasBounds.x;
        tableBounds.y -= canvasBounds.y;
        clipping = clipping.intersection(tableBounds);
        if (clipping.x + clipping.width <= 0 && clipping.y + clipping.height <= 0) {
            return;
        }
        GC gc = new GC((Drawable)this.cBlockView);
        if (this.orientation == 4) {
            gc.setClipping(clipping);
            gc.drawImage(this.image, 0, 0);
        } else {
            this.lastBackColor = this.getRowBackground(table);
            gc.setBackground(this.lastBackColor);
            gc.fillRectangle(clipping);
            int x = 0;
            gc.setClipping(clipping);
            gc.drawImage(this.image, x, 0);
        }
        gc.dispose();
    }

    public void dispose() {
        super.dispose();
        this.image = null;
        if (this.cBlockView != null) {
            if (!this.cBlockView.isDisposed()) {
                this.cBlockView.dispose();
            }
            this.cBlockView = null;
        }
    }

    public Rectangle getBoundsForCanvas() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        bounds.y += this.marginHeight;
        bounds.height -= this.marginHeight * 2;
        bounds.x += this.marginWidth;
        bounds.width -= this.marginWidth * 2;
        if (bounds.width <= 0 || bounds.height <= 0) {
            return null;
        }
        return bounds;
    }

    public Point getSize() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return new Point(0, 0);
        }
        return new Point(bounds.width - this.marginWidth * 2, bounds.height - this.marginHeight * 2);
    }

    private Color getRowBackground(Table table) {
        if (this.row.isSelected()) {
            // empty if block
        }
        return this.getBackground();
    }

    public void invalidate() {
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMargin(int width, int height) {
        if (width >= 0) {
            this.marginWidth = width;
        }
        if (height >= 0) {
            this.marginHeight = height;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }
}

