/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;

public abstract class BufferedTableItemImpl
implements BufferedTableItem {
    protected BufferedTableRow row;
    private int position;
    private Color ourFGColor = null;
    private String text = "";
    private Image icon = null;

    public BufferedTableItemImpl(BufferedTableRow row, int position) {
        this.row = row;
        this.position = position;
    }

    public String getText() {
        if (Utils.SWT32_TABLEPAINT) {
            return this.text;
        }
        if (this.position != -1) {
            return this.row.getText(this.position);
        }
        return "";
    }

    public boolean setText(String text) {
        if (Utils.SWT32_TABLEPAINT) {
            if (this.text.equals(text)) {
                return false;
            }
            this.text = text == null ? "" : text;
            Rectangle bounds = this.getBounds();
            if (bounds != null) {
                Table table = this.row.getTable();
                Rectangle dirty = table.getClientArea().intersection(bounds);
                table.redraw(dirty.x, dirty.y, dirty.width, dirty.height, false);
            }
            return true;
        }
        if (this.position != -1) {
            return this.row.setText(this.position, text);
        }
        return false;
    }

    public void setIcon(Image img) {
        if (this.position != -1) {
            this.row.setImage(this.position, img);
            this.icon = img;
        }
    }

    public Image getIcon() {
        if (this.position != -1) {
            Image image = this.row.getImage(this.position);
            return image != null ? image : this.icon;
        }
        return null;
    }

    public void setRowForeground(Color color) {
        this.row.setForeground(color);
    }

    public boolean setForeground(Color color) {
        if (this.position == -1) {
            return false;
        }
        boolean ok = this.row.setForeground(this.position, color);
        if (ok && this.ourFGColor != null) {
            if (!this.ourFGColor.isDisposed()) {
                this.ourFGColor.dispose();
            }
            this.ourFGColor = null;
        }
        return ok;
    }

    public Color getForeground() {
        if (this.position == -1) {
            return null;
        }
        return this.row.getForeground(this.position);
    }

    public boolean setForeground(int red, int green, int blue) {
        if (this.position == -1) {
            return false;
        }
        if (red == -1 && green == -1 && blue == -1) {
            return this.setForeground(null);
        }
        Color oldColor = this.row.getForeground(this.position);
        RGB newRGB = new RGB(red, green, blue);
        if (oldColor != null && oldColor.getRGB().equals((Object)newRGB)) {
            return false;
        }
        Color newColor = new Color((Device)this.row.getTable().getDisplay(), newRGB);
        boolean ok = this.row.setForeground(this.position, newColor);
        if (ok) {
            if (this.ourFGColor != null && !this.ourFGColor.isDisposed()) {
                this.ourFGColor.dispose();
            }
            this.ourFGColor = newColor;
        } else if (!newColor.isDisposed()) {
            newColor.dispose();
        }
        return ok;
    }

    public Color getBackground() {
        return this.row.getBackground();
    }

    public Rectangle getBounds() {
        if (this.position != -1) {
            return this.row.getBounds(this.position);
        }
        return null;
    }

    public Table getTable() {
        return this.row.getTable();
    }

    public void dispose() {
        if (this.ourFGColor != null && !this.ourFGColor.isDisposed()) {
            this.ourFGColor.dispose();
        }
    }

    public boolean isShown() {
        return true;
    }

    public boolean needsPainting() {
        return false;
    }

    public void doPaint(GC gc) {
    }

    public void locationChanged() {
    }

    public int getPosition() {
        return this.position;
    }

    public Image getBackgroundImage() {
        Table table = this.row.getTable();
        Rectangle bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)table.getDisplay(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        gc.setForeground(this.getBackground());
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.dispose();
        return image;
    }

    public void redraw() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Table table;
                Rectangle dirty;
                Rectangle bounds = BufferedTableItemImpl.this.getBounds();
                if (bounds != null && !(dirty = (table = BufferedTableItemImpl.this.row.getTable()).getClientArea().intersection(bounds)).isEmpty()) {
                    table.redraw(dirty.x, dirty.y, dirty.width, dirty.height, false);
                }
            }
        });
    }

    public int getMaxLines() {
        return 1;
    }

    public void setCursor(final int cursorID) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BufferedTableItemImpl.this.row == null) {
                    return;
                }
                Table table = BufferedTableItemImpl.this.row.getTable();
                if (table == null || table.isDisposed()) {
                    return;
                }
                table.setCursor(table.getDisplay().getSystemCursor(cursorID));
            }
        });
    }

    public boolean isMouseOver() {
        Table table = this.row.getTable();
        if (table == null || table.isDisposed()) {
            return false;
        }
        Point pt = table.getDisplay().getCursorLocation();
        pt = table.toControl(pt);
        Rectangle bounds = this.getBounds();
        return bounds == null ? false : bounds.contains(pt);
    }
}

