/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;

public class LinkLabel {
    public LinkLabel(Composite composite, String resource, String link) {
        this(composite, new GridData(), resource, link);
    }

    public LinkLabel(Composite composite, GridData gridData, String resource, String link) {
        Label linkLabel = new Label(composite, 0);
        Messages.setLanguageText((Widget)linkLabel, resource);
        linkLabel.setLayoutData((Object)gridData);
        LinkLabel.makeLinkedLabel(linkLabel, link);
    }

    public static void makeLinkedLabel(Label label, String hyperlink) {
        label.setData((Object)hyperlink);
        String tooltip = label.getToolTipText();
        if (tooltip == null && !hyperlink.equals(label.getText())) {
            label.setToolTipText(hyperlink);
        }
        label.setCursor(Cursors.handCursor);
        label.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            public void mouseUp(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
    }

    public static void updateLinkedLabel(Label label, String hyperlink) {
        label.setData((Object)hyperlink);
        label.setToolTipText(hyperlink);
    }
}

