/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.Scale;
import org.gudy.azureus2.ui.swt.components.graphics.ScaledGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class SpeedGraphic
extends ScaledGraphic
implements ParameterListener {
    private static final int DEFAULT_ENTRIES = 2000;
    public static final int COLOR_AVERAGE = 0;
    public static final int COLOR_MAINSPEED = 1;
    public static final int COLOR_OVERHEAD = 2;
    public static final int COLOR_LIMIT = 3;
    public static final int COLOR_OTHERS = 4;
    public static final int COLOR_TRIMMED = 5;
    private static final int ALPHA_FOCUS = 200;
    private static final int ALPHA_NOFOCUS = 150;
    public Color[] colors = new Color[]{Colors.red, Colors.blues[7], Colors.colorInverse, Colors.blue, Colors.grey, Colors.light_grey};
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    protected Image bufferImage;
    private int nbValues = 0;
    private int maxEntries = 2000;
    private int[][] all_values = new int[1][this.maxEntries];
    private int currentPosition = 0;
    private int alpha = 255;
    private boolean autoAlpha = false;

    private SpeedGraphic(Scale scale, ValueFormater formater) {
        super(scale, formater);
        COConfigurationManager.addParameterListener("Graphics Update", (ParameterListener)this);
        this.parameterChanged("Graphics Update");
    }

    public void initialize(Canvas canvas) {
        super.initialize(canvas);
        canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (SpeedGraphic.this.autoAlpha) {
                    SpeedGraphic.this.setAlpha(150);
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (SpeedGraphic.this.autoAlpha) {
                    SpeedGraphic.this.setAlpha(200);
                }
            }
        });
        this.drawCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (SpeedGraphic.this.bufferImage != null && !SpeedGraphic.this.bufferImage.isDisposed()) {
                    Rectangle bounds = SpeedGraphic.this.bufferImage.getBounds();
                    if (bounds.width >= e.width && bounds.height >= e.height) {
                        if (SpeedGraphic.this.alpha != 255) {
                            try {
                                e.gc.setAlpha(SpeedGraphic.this.alpha);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        e.gc.drawImage(SpeedGraphic.this.bufferImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                }
            }
        });
        this.drawCanvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                SpeedGraphic.this.drawChart(true);
            }
        });
    }

    public static SpeedGraphic getInstance() {
        return new SpeedGraphic(new Scale(), new ValueFormater(){

            public String format(int value) {
                return DisplayFormatters.formatByteCountToBase10KBEtcPerSec(value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntsValue(int[] new_values) {
        try {
            this.this_mon.enter();
            if (this.all_values.length < new_values.length) {
                int i;
                int[][] new_all_values = new int[new_values.length][];
                for (i = 0; i < this.all_values.length; ++i) {
                    new_all_values[i] = this.all_values[i];
                }
                for (i = this.all_values.length; i < new_all_values.length; ++i) {
                    new_all_values[i] = new int[this.maxEntries];
                }
                this.all_values = new_all_values;
            }
            for (int i = 0; i < new_values.length; ++i) {
                this.all_values[i][this.currentPosition] = new_values[i];
            }
            ++this.currentPosition;
            if (this.nbValues < this.maxEntries) {
                ++this.nbValues;
            }
            this.currentPosition %= this.maxEntries;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addIntValue(int value) {
        this.addIntsValue(new int[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 10000 || bounds.height > 10000) {
            return;
        }
        if (bounds.width > this.maxEntries) {
            try {
                this.this_mon.enter();
                while (this.maxEntries < bounds.width) {
                    this.maxEntries += 1000;
                }
                for (int i = 0; i < this.all_values.length; ++i) {
                    int[] newValues = new int[this.maxEntries];
                    System.arraycopy(this.all_values[i], 0, newValues, 0, this.all_values[i].length);
                    this.all_values[i] = newValues;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged) {
            this.drawChart(sizeChanged);
        }
        this.drawCanvas.redraw();
        this.drawCanvas.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawChart(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed() || !this.drawCanvas.isVisible()) {
            return;
        }
        GC gcImage = null;
        try {
            int max;
            this.this_mon.enter();
            this.drawScale(sizeChanged);
            if (this.bufferScale == null || this.bufferScale.isDisposed()) {
                return;
            }
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.isEmpty()) {
                return;
            }
            if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                this.bufferImage.dispose();
            }
            this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            gcImage = new GC((Drawable)this.bufferImage);
            gcImage.drawImage(this.bufferScale, 0, 0);
            int oldAverage = 0;
            int[] oldTargetValues = new int[this.all_values.length];
            int[] maxs = new int[this.all_values.length];
            for (int x = 0; x < bounds.width - 71; ++x) {
                int position = this.currentPosition - x - 1;
                if (position < 0 && (position += this.maxEntries) < 0) {
                    position = 0;
                }
                for (int chartIdx = 0; chartIdx < this.all_values.length; ++chartIdx) {
                    int value = this.all_values[chartIdx][position];
                    if (value <= maxs[chartIdx]) continue;
                    maxs[chartIdx] = value;
                }
            }
            int max_primary = max = maxs[0];
            for (int i = 1; i < maxs.length; ++i) {
                int m = maxs[i];
                if (i == 1) {
                    if (max >= m) continue;
                    max_primary = max = m;
                    continue;
                }
                if (max >= m) continue;
                if (m <= 2 * max_primary) {
                    max = m;
                    continue;
                }
                max = 2 * max_primary;
                break;
            }
            this.scale.setMax(max);
            int maxHeight = this.scale.getScaledValue(max);
            Color background = this.colors[1];
            Color foreground = this.colors[1];
            for (int x = 0; x < bounds.width - 71; ++x) {
                int position = this.currentPosition - x - 1;
                if (position < 0 && (position += this.maxEntries) < 0) {
                    position = 0;
                }
                int xDraw = bounds.width - 71 - x;
                int height = this.scale.getScaledValue(this.all_values[0][position]);
                gcImage.setForeground(background);
                gcImage.setBackground(foreground);
                gcImage.setClipping(xDraw, bounds.height - 1 - height, 1, height);
                gcImage.fillGradientRectangle(xDraw, bounds.height - 1 - maxHeight, 1, maxHeight, true);
                gcImage.setClipping(0, 0, bounds.width, bounds.height);
                if (this.all_values.length > 1) {
                    gcImage.setForeground(this.colors[2]);
                    height = this.scale.getScaledValue(this.all_values[1][position]);
                    Utils.drawStriped(gcImage, xDraw, bounds.height - 1 - height, 1, height, 1, this.currentPosition, false);
                }
                for (int chartIdx = 2; chartIdx < this.all_values.length; ++chartIdx) {
                    int targetValue = this.all_values[chartIdx][position];
                    int oldTargetValue = oldTargetValues[chartIdx];
                    if (x > 1 && (chartIdx == 2 && targetValue > 0 && oldTargetValue > 0 || chartIdx > 2 && (targetValue > 0 || oldTargetValue > 0))) {
                        int trimmed = 0;
                        if (targetValue > max) {
                            targetValue = max;
                            ++trimmed;
                        }
                        if (oldTargetValue > max) {
                            oldTargetValue = max;
                            ++trimmed;
                        }
                        if (trimmed < 2 || trimmed == 2 && position % 3 == 0) {
                            int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                            int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                            gcImage.setForeground(chartIdx == 2 ? this.colors[3] : (trimmed > 0 ? this.colors[5] : this.colors[4]));
                            gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                        }
                    }
                    oldTargetValues[chartIdx] = this.all_values[chartIdx][position];
                }
                int average = this.computeAverage(position);
                if (x > 6) {
                    int h1 = bounds.height - this.scale.getScaledValue(average) - 2;
                    int h2 = bounds.height - this.scale.getScaledValue(oldAverage) - 2;
                    gcImage.setForeground(this.colors[0]);
                    gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                }
                oldAverage = average;
            }
            if (this.nbValues > 0) {
                int height = bounds.height - this.scale.getScaledValue(this.computeAverage(this.currentPosition - 6)) - 2;
                gcImage.setForeground(this.colors[0]);
                gcImage.drawText(this.formater.format(this.computeAverage(this.currentPosition - 6)), bounds.width - 65, height - 12, true);
            }
        }
        catch (Exception e) {
            Debug.out("Warning", e);
        }
        finally {
            if (gcImage != null) {
                gcImage.dispose();
            }
            this.this_mon.exit();
        }
    }

    protected int computeAverage(int position) {
        long sum = 0L;
        for (int i = -5; i < 6; ++i) {
            int pos = position + i;
            if ((pos %= this.maxEntries) < 0) {
                pos += this.maxEntries;
            }
            sum += (long)this.all_values[0][pos];
        }
        return (int)(sum / 11L);
    }

    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    public void dispose() {
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }

    private int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.drawCanvas != null && !this.drawCanvas.isDisposed()) {
            this.drawCanvas.redraw();
        }
    }

    private boolean isAutoAlpha() {
        return this.autoAlpha;
    }

    private void setAutoAlpha(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
        if (autoAlpha) {
            this.setAlpha(this.drawCanvas.getDisplay().getCursorControl() == this.drawCanvas ? 200 : 150);
        }
    }

    public void setLineColors(Color average, Color speed, Color overhead, Color limit, Color others, Color trimmed) {
        if (average != null) {
            this.colors[0] = average;
        }
        if (speed != null) {
            this.colors[1] = speed;
        }
        if (overhead != null) {
            this.colors[2] = overhead;
        }
        if (limit != null) {
            this.colors[3] = limit;
        }
        if (others != null) {
            this.colors[4] = others;
        }
        if (trimmed != null) {
            this.colors[5] = trimmed;
        }
        if (this.drawCanvas != null && !this.drawCanvas.isDisposed()) {
            this.drawCanvas.redraw();
        }
    }

    public void setLineColors(Color[] newChangeableColorSet) {
        this.colors = newChangeableColorSet;
        if (this.drawCanvas != null && !this.drawCanvas.isDisposed()) {
            this.drawCanvas.redraw();
        }
    }
}

