/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.shell;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.StyledShell;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;

public class LightBoxShell {
    private Shell lbShell = null;
    private Shell parentShell = null;
    private int insetTop = 0;
    private int insetBottom = 0;
    private int insetLeft = 0;
    private int insetRight = 0;
    private boolean closeOnESC = false;
    private boolean isAlreadyOpened = false;
    private Display display;
    private UIFunctionsSWT uiFunctions;
    private boolean isBusy = false;
    private Image[] spinnerImages = null;
    private Rectangle spinnerBounds = null;
    private boolean busyAlready = false;
    private Canvas spinnerCanvas = null;
    private Rectangle shellBounds = null;
    private boolean parentActivatedOnce = false;
    public static final int RESIZE_VERTICAL = 2;
    public static final int RESIZE_HORIZONTAL = 4;
    private int styleMask = 6;
    private int alphaLevel = 178;

    public LightBoxShell() {
        this(false);
    }

    public LightBoxShell(boolean closeOnESC) {
        this.closeOnESC = closeOnESC;
        this.parentShell = this.getUIFunctions().getMainShell();
        if (null == this.parentShell) {
            return;
        }
        IMainWindow mainWindow = this.getUIFunctions().getMainWindow();
        Rectangle r = mainWindow.getMetrics(3);
        this.setInsets(0, r.height, 0, 0);
        this.createControls();
    }

    public LightBoxShell(Shell parentShell, boolean closeOnESC) {
        this.parentShell = parentShell;
        this.closeOnESC = closeOnESC;
        this.createControls();
    }

    public void setInsets(int top, int bottom, int left, int right) {
        this.insetTop = top;
        this.insetBottom = bottom;
        this.insetLeft = left;
        this.insetRight = right;
        if (null != this.lbShell && !this.lbShell.isDisposed() && this.isAlreadyOpened()) {
            this.lbShell.setBounds(this.getBounds(true));
        }
    }

    private void createControls() {
        if (null == this.parentShell) {
            return;
        }
        this.lbShell = new Shell(this.parentShell, 8);
        if (Constants.isOSX) {
            this.getUIFunctions().createMainMenu(this.lbShell);
        }
        this.display = this.parentShell.getDisplay();
        if (this.closeOnESC) {
            this.lbShell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.detail == 2) {
                        e.doit = false;
                        LightBoxShell.this.close();
                    }
                }
            });
        }
        if (Constants.isOSX) {
            this.lbShell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellActivated(ShellEvent e) {
                    if (null != LightBoxShell.this.parentShell && !LightBoxShell.this.parentShell.isDisposed()) {
                        if (!LightBoxShell.this.parentActivatedOnce) {
                            LightBoxShell.this.parentActivatedOnce = true;
                            LightBoxShell.this.parentShell.forceActive();
                        } else {
                            LightBoxShell.this.parentActivatedOnce = false;
                        }
                    }
                }
            });
        }
        this.lbShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (null != LightBoxShell.this.spinnerImages) {
                    LightBoxShell.access$202(LightBoxShell.this, null);
                }
            }
        });
        final ControlListener moveAndResizeListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                LightBoxShell.this.shellBounds = null;
                LightBoxShell.this.getBounds();
                LightBoxShell.this.lbShell.setLocation(((LightBoxShell)LightBoxShell.this).shellBounds.x, ((LightBoxShell)LightBoxShell.this).shellBounds.y);
            }

            public void controlResized(ControlEvent e) {
                if ((LightBoxShell.this.styleMask & 4) != 0 && (LightBoxShell.this.styleMask & 2) != 0) {
                    LightBoxShell.this.shellBounds = null;
                    LightBoxShell.this.getBounds();
                    LightBoxShell.this.lbShell.setSize(((LightBoxShell)LightBoxShell.this).shellBounds.width, ((LightBoxShell)LightBoxShell.this).shellBounds.height);
                } else if ((LightBoxShell.this.styleMask & 4) != 0) {
                    LightBoxShell.this.shellBounds = null;
                    LightBoxShell.this.getBounds();
                    LightBoxShell.this.lbShell.setSize(((LightBoxShell)LightBoxShell.this).shellBounds.width, ((LightBoxShell)LightBoxShell.this).lbShell.getSize().y);
                } else if ((LightBoxShell.this.styleMask & 2) != 0) {
                    LightBoxShell.this.shellBounds = null;
                    LightBoxShell.this.getBounds();
                    LightBoxShell.this.lbShell.setSize(((LightBoxShell)LightBoxShell.this).lbShell.getSize().x, ((LightBoxShell)LightBoxShell.this).shellBounds.height);
                }
            }
        };
        this.parentShell.addControlListener(moveAndResizeListener);
        this.lbShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LightBoxShell.this.parentShell.removeControlListener(moveAndResizeListener);
            }
        });
    }

    private UIFunctionsSWT getUIFunctions() {
        if (null == this.uiFunctions) {
            this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (null == this.uiFunctions) {
                throw new NullPointerException("An initialized instance of UIFunctionsSWT is required to create a LightBoxShell");
            }
        }
        return this.uiFunctions;
    }

    public void open(boolean dim) {
        if (null != this.lbShell && !this.lbShell.isDisposed()) {
            this.lbShell.setBounds(this.getBounds());
            this.isAlreadyOpened = true;
            this.lbShell.setBackground(Colors.black);
            try {
                this.lbShell.setAlpha(this.alphaLevel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (dim) {
                this.lbShell.open();
            }
        }
    }

    public void close() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (null != LightBoxShell.this.lbShell && !LightBoxShell.this.lbShell.isDisposed()) {
                    LightBoxShell.this.lbShell.dispose();
                }
            }
        });
    }

    public Rectangle getBounds() {
        return this.getBounds(false);
    }

    private Rectangle getBounds(boolean recalculate) {
        if (!recalculate && null != this.shellBounds) {
            return new Rectangle(this.shellBounds.x, this.shellBounds.y, this.shellBounds.width, this.shellBounds.height);
        }
        this.shellBounds = this.parentShell.getClientArea();
        Point parentLocation = this.parentShell.toDisplay(this.insetLeft, this.insetTop);
        this.shellBounds.x = parentLocation.x;
        this.shellBounds.y = parentLocation.y;
        this.shellBounds.width -= this.insetRight + this.insetLeft;
        this.shellBounds.height -= this.insetTop + this.insetBottom;
        return new Rectangle(this.shellBounds.x, this.shellBounds.y, this.shellBounds.width, this.shellBounds.height);
    }

    public StyledShell createPopUpShell(int borderWidth, boolean closeLightboxOnExit) {
        return this.createPopUpShell(borderWidth, closeLightboxOnExit, true);
    }

    public StyledShell createPopUpShell(int borderWidth, boolean closeLightboxOnExit, boolean useCustomTrim) {
        StyledShell newShell = new StyledShell(this.lbShell, borderWidth, useCustomTrim);
        if (closeLightboxOnExit) {
            newShell.addListener(12, new Listener(){

                public void handleEvent(Event event2) {
                    LightBoxShell.this.close();
                }
            });
        }
        return newShell;
    }

    public void open(StyledShell shellToOpen, boolean dim) {
        if (null != shellToOpen && null != this.lbShell) {
            if (!this.isAlreadyOpened) {
                this.open(dim);
            }
            if (!shellToOpen.isAlreadyOpened()) {
                shellToOpen.open();
            }
        }
    }

    public void setCursor(Cursor cursor) {
        if (null != this.lbShell && !this.lbShell.isDisposed()) {
            this.lbShell.setCursor(cursor);
        }
    }

    public void setData(String key, Object value) {
        if (null != this.lbShell && !this.lbShell.isDisposed()) {
            this.lbShell.setData(key, value);
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean isAlreadyOpened() {
        return this.isAlreadyOpened;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.lbShell.addDisposeListener(listener);
    }

    public void showBusy(boolean value, long delayInMilli) {
        if (value == this.isBusy) {
            return;
        }
        this.isBusy = value;
        if (this.isBusy && !this.busyAlready) {
            this.showSpinner(Math.max(0L, delayInMilli));
        }
    }

    private void showSpinner(long delayInMilli) {
        if (null == this.spinnerImages) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            this.spinnerImages = imageLoader.getImages("spinner_big");
            if (this.spinnerImages.length == 0) {
                return;
            }
            int w = 0;
            int h = 0;
            for (int i = 0; i < this.spinnerImages.length; ++i) {
                Image image = this.spinnerImages[i];
                Rectangle bounds = image.getBounds();
                w = Math.max(w, bounds.width);
                h = Math.max(w, bounds.height);
            }
            this.spinnerBounds = new Rectangle(0, 0, w, h);
            this.lbShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    imageLoader.releaseImage("spinner_big");
                }
            });
        }
        Utils.centerRelativeTo(this.spinnerBounds, this.getBounds());
        Point to_lbShell = this.lbShell.toControl(this.spinnerBounds.x, this.spinnerBounds.y);
        this.spinnerBounds.x = to_lbShell.x;
        this.spinnerBounds.y = to_lbShell.y;
        final int[] imageDataIndex = new int[1];
        if (null == this.spinnerCanvas) {
            this.spinnerCanvas = new Canvas((Composite)this.lbShell, 0);
            this.spinnerCanvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(LightBoxShell.this.spinnerImages[imageDataIndex[0]], 0, 0);
                }
            });
        }
        this.spinnerCanvas.setBackground(this.lbShell.getBackground());
        this.spinnerCanvas.setBounds(this.spinnerBounds);
        Utils.execSWTThreadLater(100, new AERunnable(){

            public void runSupport() {
                if (!LightBoxShell.this.isBusy || LightBoxShell.this.spinnerImages == null) {
                    LightBoxShell.this.busyAlready = false;
                    return;
                }
                LightBoxShell.this.busyAlready = true;
                if (null != LightBoxShell.this.spinnerCanvas && !LightBoxShell.this.spinnerCanvas.isDisposed()) {
                    LightBoxShell.this.spinnerCanvas.redraw();
                    LightBoxShell.this.spinnerCanvas.update();
                }
                imageDataIndex[0] = imageDataIndex[0] == LightBoxShell.this.spinnerImages.length - 1 ? 0 : imageDataIndex[0] + 1;
                Utils.execSWTThreadLater(100, this);
            }
        });
    }

    public int getStyleMask() {
        return this.styleMask;
    }

    public void setStyleMask(int styleMask) {
        this.styleMask = styleMask;
    }

    public int getAlphaLevel() {
        return this.alphaLevel;
    }

    public void setAlphaLevel(final int alphaLevel) {
        this.alphaLevel = alphaLevel;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (LightBoxShell.this.lbShell.isDisposed()) {
                    return;
                }
                try {
                    LightBoxShell.this.lbShell.setAlpha(alphaLevel);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public void moveAbove(Control control) {
        this.lbShell.moveAbove(control);
    }

    public Shell getShell() {
        return this.lbShell;
    }

    static /* synthetic */ Image[] access$202(LightBoxShell x0, Image[] x1) {
        x0.spinnerImages = x1;
        return x1;
    }
}

