/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.shell;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public final class ShellFactory {
    public static Shell createMainShell(int styles) {
        Shell parent = null;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            parent = uiFunctions.getMainShell();
        }
        if (parent == null) {
            return ShellFactory.createShell(SWTThread.getInstance().getDisplay());
        }
        return ShellFactory.createShell(parent, styles);
    }

    public static Shell createShell(Display disp, int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(disp, styles));
    }

    public static Shell createShell(Display disp) {
        return ShellFactory.getRegisteredShell(new AEShell(disp));
    }

    public static Shell createShell(Shell parent, int styles) {
        if (parent != null && parent.isDisposed()) {
            return null;
        }
        return ShellFactory.getRegisteredShell(new AEShell(parent, styles));
    }

    public static Shell createShell(Shell parent) {
        return ShellFactory.getRegisteredShell(new AEShell(parent));
    }

    public static Shell createShell(int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(styles));
    }

    private static Shell getRegisteredShell(Shell toRegister) {
        if (null == toRegister) {
            return null;
        }
        if (Constants.isOSX) {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions == null) {
                throw new IllegalStateException("Main window is not initialized yet");
            }
            uiFunctions.createMainMenu(toRegister);
        }
        ShellManager.sharedManager().addWindow(toRegister);
        return toRegister;
    }

    private static class AEShell
    extends Shell {
        private AEShell(int styles) {
            super(styles);
        }

        private AEShell(Display display) {
            super(display);
        }

        private AEShell(Display display, int styles) {
            super(display, AEShell.fixupStyle(styles));
        }

        private AEShell(Shell parent) {
            super(parent);
        }

        private AEShell(Shell parent, int styles) {
            super(parent, AEShell.fixupStyle(styles));
        }

        private static int fixupStyle(int style) {
            UIFunctionsSWT uiFunctions;
            if ((style & 0x38000) > 0 && Utils.anyShellHaveStyle(16416) && (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && uiFunctions.getMainShell() != null) {
                style |= 0x4000;
            }
            return style;
        }

        protected void checkSubclass() {
        }

        public void setImage(Image image) {
            if (!Constants.isOSX) {
                super.setImage(image);
            }
        }

        public void setImages(Image[] images) {
            if (!Constants.isOSX) {
                super.setImages(images);
            }
        }

        public void open() {
            Shell mainShell;
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null && (mainShell = uiFunctions.getMainShell()) != null && mainShell.getMinimized()) {
                uiFunctions.bringToFront();
            }
            super.open();
        }
    }
}

