/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.shell;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class StyledShell {
    public static final int HINT_ALIGN_CENTER = 2;
    public static final int HINT_ALIGN_FIT_IN_MONITOR = 4;
    public static final int HINT_ALIGN_NONE = 1;
    private Shell parentShell;
    private Shell styledShell;
    private Display display;
    private Composite borderedBackground;
    private Composite content;
    private int borderWidth;
    private boolean isAlreadyOpened = false;
    private int alpha = 255;
    private boolean isAnimating = false;
    private Monitor monitor = null;
    private boolean useCustomTrim = true;
    private Region region;
    private boolean isAlphaSupported = true;
    private UIFunctionsSWT uiFunctions;

    public StyledShell(Shell parentShell, int borderWidth) {
        this(parentShell, borderWidth, true);
    }

    public StyledShell(Shell parentShell, int borderWidth, boolean useCustomTrim) {
        this.parentShell = parentShell;
        this.borderWidth = borderWidth;
        this.useCustomTrim = useCustomTrim;
        if (null == parentShell) {
            throw new NullPointerException("parentShell can not be null");
        }
        try {
            parentShell.setAlpha(parentShell.getAlpha());
        }
        catch (Throwable t) {
            this.isAlphaSupported = false;
        }
        this.display = parentShell.getDisplay();
        if (useCustomTrim) {
            this.createCustomShell();
            if (null != this.styledShell) {
                this.styledShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (null != StyledShell.this.region && !StyledShell.this.region.isDisposed()) {
                            StyledShell.this.region.dispose();
                        }
                    }
                });
            }
        } else {
            this.createStandardShell();
        }
    }

    private void createCustomShell() {
        this.styledShell = ShellFactory.createShell(this.parentShell, this.getShellStyle(0));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = this.borderWidth;
        fillLayout.marginWidth = this.borderWidth;
        this.styledShell.setLayout((Layout)fillLayout);
        if (Constants.isOSX) {
            this.getUIFunctions().createMainMenu(this.styledShell);
        }
        this.borderedBackground = new Composite((Composite)this.styledShell, 0);
        fillLayout = new FillLayout();
        fillLayout.marginHeight = this.borderWidth;
        fillLayout.marginWidth = this.borderWidth;
        this.borderedBackground.setLayout((Layout)fillLayout);
        this.content = new Composite(this.borderedBackground, 0x20000000);
        this.content.setBackgroundMode(1);
        this.setBackground(ColorCache.getColor((Device)this.styledShell.getDisplay(), 38, 38, 38));
        this.content.setBackground(ColorCache.getColor((Device)this.styledShell.getDisplay(), 13, 13, 13));
        this.content.setForeground(ColorCache.getColor((Device)this.styledShell.getDisplay(), 206, 206, 206));
        this.borderedBackground.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = StyledShell.this.borderedBackground.getClientArea();
                int r = StyledShell.this.borderWidth;
                int d = r * 2;
                try {
                    e.gc.setAntialias(1);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                e.gc.setBackground(StyledShell.this.styledShell.getBackground());
                e.gc.fillRectangle(0, 0, r, r);
                e.gc.fillRectangle(bounds.width - r, 0, r, r);
                e.gc.fillRectangle(bounds.width - r, bounds.height - r, r, r);
                e.gc.fillRectangle(0, bounds.height - r, r, r);
                e.gc.setBackground(StyledShell.this.content.getBackground());
                e.gc.fillPolygon(StyledShell.this.circle(r, r, r));
                e.gc.fillPolygon(StyledShell.this.circle(r, r, bounds.height - r));
                e.gc.fillPolygon(StyledShell.this.circle(r, bounds.width - r, r));
                e.gc.fillPolygon(StyledShell.this.circle(r, bounds.width - r, bounds.height - r));
                e.gc.fillRectangle(new Rectangle(r, 0, bounds.width - d, r));
                e.gc.fillRectangle(new Rectangle(r, bounds.height - r, bounds.width - d, r));
                e.gc.fillRectangle(new Rectangle(0, r, bounds.width, bounds.height - d));
            }
        });
        Listener l = new Listener(){
            int startX;
            int startY;

            public void handleEvent(Event e) {
                if (e.type == 1 && e.character == '\u001b') {
                    StyledShell.this.styledShell.dispose();
                }
                if (e.type == 3 && e.button == 1) {
                    this.startX = e.x;
                    this.startY = e.y;
                }
                if (e.type == 5 && (e.stateMask & 0x80000) != 0) {
                    Point p = StyledShell.this.styledShell.toDisplay(e.x, e.y);
                    p.x -= this.startX;
                    p.y -= this.startY;
                    StyledShell.this.styledShell.setLocation(p);
                }
                if (e.type == 11) {
                    StyledShell.this.styledShell.setRegion(StyledShell.this.getRoundedRegion(StyledShell.this.styledShell.getBounds()));
                }
            }
        };
        this.styledShell.addListener(1, l);
        this.styledShell.addListener(3, l);
        this.styledShell.addListener(5, l);
        this.styledShell.addListener(11, l);
        this.styledShell.setCursor(this.display.getSystemCursor(5));
        this.content.setCursor(this.display.getSystemCursor(0));
    }

    private void createStandardShell() {
        this.styledShell = ShellFactory.createShell(this.parentShell, this.getShellStyle(65536));
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        this.styledShell.setLayout((Layout)fillLayout);
        if (Constants.isOSX) {
            this.getUIFunctions().createMainMenu(this.styledShell);
        }
        Utils.setShellIcon(this.styledShell);
        this.content = new Composite((Composite)this.styledShell, 0x20000000);
        this.content.setBackgroundMode(1);
        this.alpha = 255;
    }

    private int getShellStyle(int style) {
        if (this.useCustomTrim) {
            if (Constants.isOSX) {
                if (this.isAlphaSupported) {
                    style |= 8;
                }
            } else {
                style |= 8;
            }
            return style;
        }
        return style | 0x860 | 0x10;
    }

    private Region getRoundedRegion(Rectangle bounds) {
        int r = this.borderWidth;
        int d = r * 2;
        if (null != this.region && !this.region.isDisposed()) {
            this.region.dispose();
        }
        this.region = new Region();
        this.region.add(this.circle(r, r, r));
        this.region.add(this.circle(r, r, bounds.height - r));
        this.region.add(this.circle(r, bounds.width - r, r));
        this.region.add(this.circle(r, bounds.width - r, bounds.height - r));
        this.region.add(new Rectangle(r, 0, bounds.width - d, r));
        this.region.add(new Rectangle(r, bounds.height - r, bounds.width - d, r));
        this.region.add(new Rectangle(0, r, bounds.width, bounds.height - d));
        return this.region;
    }

    private int[] circle(int r, int offsetX, int offsetY) {
        int[] polygon = new int[8 * r + 4];
        for (int i = 0; i < 2 * r + 1; ++i) {
            int x = i - r;
            int y = (int)Math.sqrt(r * r - x * x);
            polygon[2 * i] = offsetX + x;
            polygon[2 * i + 1] = offsetY + y;
            polygon[8 * r - 2 * i - 2] = offsetX + x;
            polygon[8 * r - 2 * i - 1] = offsetY - y;
        }
        return polygon;
    }

    public void addListener(int eventType, Listener listener) {
        if (this.isAlive()) {
            this.styledShell.addListener(eventType, listener);
        }
    }

    public void open() {
        if (this.isAlive()) {
            Point cursorLocation = this.display.getCursorLocation();
            this.monitor = Utils.getMonitor(cursorLocation);
            this.styledShell.open();
            this.isAlreadyOpened = true;
        }
    }

    public void close() {
        if (this.isAlive()) {
            this.styledShell.close();
            this.isAlreadyOpened = false;
        }
    }

    public void forceActive() {
        if (this.isAlive()) {
            this.styledShell.setVisible(true);
            this.styledShell.forceActive();
        }
    }

    public void pack() {
        if (this.isAlive()) {
            this.styledShell.pack();
        }
    }

    public void pack(boolean changed) {
        if (this.isAlive()) {
            this.styledShell.pack(changed);
        }
    }

    public void setSize(int width, int height) {
        this.setSize(width, height, false == this.isAlreadyOpened ? 2 : 0);
    }

    public void setSize(int width, int height, int hint) {
        if (this.isAlive()) {
            Rectangle outerBounds = this.styledShell.getBounds();
            if (this.useCustomTrim) {
                width += this.borderWidth * 4;
                height += this.borderWidth * 4;
            } else {
                width += this.styledShell.getBounds().width - this.styledShell.getClientArea().width;
                height += this.styledShell.getBounds().height - this.styledShell.getClientArea().height;
            }
            if (outerBounds.width != width || outerBounds.height != height) {
                outerBounds.width = width;
                outerBounds.height = height;
                if ((hint & 2) != 0) {
                    Utils.centerRelativeTo(outerBounds, this.getUIFunctions().getMainShell().getBounds());
                }
                if ((hint & 4) != 0) {
                    if (null != this.monitor) {
                        Utils.makeVisibleOnMonitor(outerBounds, this.monitor);
                    } else {
                        Utils.makeVisibleOnCursor(outerBounds);
                    }
                }
                this.styledShell.setBounds(outerBounds);
                if (this.useCustomTrim) {
                    this.styledShell.setRegion(this.getRoundedRegion(outerBounds));
                }
                this.styledShell.forceActive();
            }
        }
    }

    public void centersShell() {
        if (this.isAlive()) {
            Rectangle bounds = this.styledShell.getBounds();
            Utils.centerRelativeTo(bounds, this.getUIFunctions().getMainShell().getBounds());
            this.styledShell.setBounds(bounds);
        }
    }

    public void makeShellVisible() {
        if (this.isAlive()) {
            Rectangle bounds = this.styledShell.getBounds();
            if (null != this.monitor) {
                Utils.makeVisibleOnMonitor(bounds, this.monitor);
            } else {
                Utils.makeVisibleOnCursor(bounds);
            }
            this.styledShell.setBounds(bounds);
        }
    }

    public void animateFade(final int milliSeconds) {
        if (!this.isAlive() || this.isAnimating || !this.isAlphaSupported) {
            return;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (!StyledShell.this.isAlive()) {
                    return;
                }
                StyledShell.this.isAnimating = true;
                try {
                    int seconds = milliSeconds;
                    int currentAlpha = 0;
                    int delay = 3;
                    int sleepIncrement = milliSeconds / (10 + delay);
                    if (StyledShell.this.isAlive()) {
                        StyledShell.this.setAlpha(StyledShell.this.styledShell, currentAlpha);
                        StyledShell.this.styledShell.setVisible(true);
                    }
                    while (seconds > 0) {
                        Thread.sleep(sleepIncrement);
                        seconds -= sleepIncrement;
                        if (StyledShell.this.isAlive()) {
                            if (delay <= 0) {
                                StyledShell.this.setAlpha(StyledShell.this.styledShell, Math.min(currentAlpha, StyledShell.this.alpha));
                                currentAlpha += 20;
                            }
                            --delay;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    if (StyledShell.this.isAlive()) {
                        StyledShell.this.setAlpha(StyledShell.this.styledShell, StyledShell.this.alpha);
                    }
                    StyledShell.this.isAnimating = false;
                    StyledShell.this.styledShell.forceActive();
                }
            }
        });
    }

    public void setVisible(boolean visible) {
        if (this.isAlive()) {
            this.styledShell.setVisible(visible);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (this.isAlive()) {
            this.styledShell.removeListener(eventType, listener);
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.isAlive()) {
            this.styledShell.setCursor(cursor);
        }
    }

    public void setData(String key, Object value) {
        if (this.isAlive()) {
            this.styledShell.setData(key, value);
        }
    }

    public boolean isAlive() {
        return null != this.styledShell && true != this.styledShell.isDisposed();
    }

    public Composite getContent() {
        return this.content;
    }

    public Shell getShell() {
        return this.styledShell;
    }

    public boolean isAlreadyOpened() {
        return this.isAlreadyOpened;
    }

    public void setBackground(Color color) {
        this.styledShell.setBackground(color);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void hideShell(boolean value) {
        if (value) {
            this.setAlpha(this.styledShell, 0);
        } else {
            this.setAlpha(this.styledShell, this.alpha);
        }
    }

    public String getText() {
        return true == this.isAlive() ? this.styledShell.getText() : null;
    }

    public void setText(String string) {
        if (this.isAlive()) {
            this.styledShell.setText(string);
        }
    }

    public boolean isUseCustomTrim() {
        return this.useCustomTrim;
    }

    private UIFunctionsSWT getUIFunctions() {
        if (null == this.uiFunctions) {
            this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (null == this.uiFunctions) {
                throw new NullPointerException("An initialized instance of UIFunctionsSWT is required to create a LightBoxShell");
            }
        }
        return this.uiFunctions;
    }

    private void setAlpha(Shell shell, int alpha) {
        if (this.isAlphaSupported && null != shell) {
            shell.setAlpha(alpha);
        }
    }

    public Rectangle getBounds() {
        return this.styledShell.getBounds();
    }
}

