/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.widgets;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.ui.swt.components.widgets.Inset;
import org.gudy.azureus2.ui.swt.components.widgets.SkinButton;

public class BubbleButton
extends SkinButton {
    private Image[] backgroundImages = new Image[3];
    private Image[] backgroundImages_hover = new Image[3];
    private Color[] foregroundColors = new Color[3];

    public BubbleButton(Composite parent) {
        super(parent);
        final ImageLoader imageLoader = ImageLoader.getInstance();
        this.backgroundImages[0] = imageLoader.getImage("button_dialog_left");
        this.backgroundImages[1] = imageLoader.getImage("button_dialog_center");
        this.backgroundImages[2] = imageLoader.getImage("button_dialog_right");
        this.backgroundImages_hover[0] = imageLoader.getImage("button_dialog_left-over");
        this.backgroundImages_hover[1] = imageLoader.getImage("button_dialog_center-over");
        this.backgroundImages_hover[2] = imageLoader.getImage("button_dialog_right-over");
        this.foregroundColors[0] = ColorCache.getColor((Device)parent.getDisplay(), 194, 194, 194);
        this.foregroundColors[1] = ColorCache.getColor((Device)parent.getDisplay(), 194, 194, 194);
        this.foregroundColors[2] = ColorCache.getColor((Device)parent.getDisplay(), 85, 85, 85);
        this.setInset(new Inset(20, 20, 0, 0));
        FontData[] fData = this.getFont().getFontData();
        for (int i = 0; i < fData.length; ++i) {
            fData[i].height += 1.0f;
        }
        final Font newFont = new Font((Device)this.getDisplay(), fData);
        this.setFont(newFont);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (null != newFont && !newFont.isDisposed()) {
                    newFont.dispose();
                }
                imageLoader.releaseImage("button_dialog_left");
                imageLoader.releaseImage("button_dialog_center");
                imageLoader.releaseImage("button_dialog_right");
                imageLoader.releaseImage("button_dialog_left-over");
                imageLoader.releaseImage("button_dialog_center-over");
                imageLoader.releaseImage("button_dialog_right-over");
            }
        });
    }

    public Image[] getBackgroundImages() {
        return this.backgroundImages;
    }

    public Image[] getBackgroundImages_disabled() {
        return null;
    }

    public Image[] getBackgroundImages_hover() {
        return this.backgroundImages_hover;
    }

    public Color[] getForegroundColors() {
        return this.foregroundColors;
    }
}

