/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.widgets;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.ui.swt.Utils;

public class PaginationWidget {
    private Composite parent = null;
    private Canvas canvas = null;
    private int hSpacing = 3;
    private int yOffset = 5;
    private Rectangle[] pages = new Rectangle[1];
    private int currentPage = 0;
    private int height = 5;
    private int width = 8;
    private FormData fd;
    private Color color_normal = null;
    private Color color_selected = null;
    private List listeners = new ArrayList();
    private int itemsPerPage = 1;
    private int itemsTotal = 0;

    public PaginationWidget(Composite parent) {
        if (null == parent || parent.isDisposed()) {
            throw new IllegalArgumentException("parent can not be null or disposed");
        }
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.canvas = new Canvas(this.parent, 0);
        this.parent.setLayout((Layout)new FormLayout());
        this.fd = new FormData();
        this.fd.top = new FormAttachment(0, 0);
        this.fd.bottom = new FormAttachment(100, 0);
        this.fd.left = new FormAttachment(0, 0);
        this.fd.right = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)this.fd);
        this.color_selected = ColorCache.getColor((Device)this.canvas.getDisplay(), 204, 204, 204);
        this.color_normal = ColorCache.getColor((Device)this.canvas.getDisplay(), 99, 99, 99);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PaginationWidget.this.pages.length > 1) {
                    for (int i = 0; i < PaginationWidget.this.pages.length; ++i) {
                        if (i == PaginationWidget.this.currentPage) {
                            e.gc.setBackground(PaginationWidget.this.color_selected);
                        } else {
                            e.gc.setBackground(PaginationWidget.this.color_normal);
                        }
                        e.gc.fillRectangle(PaginationWidget.this.pages[i]);
                    }
                }
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event2) {
                if (event2.type == 3) {
                    for (int i = 0; i < PaginationWidget.this.pages.length; ++i) {
                        if (!PaginationWidget.this.pages[i].contains(event2.x, event2.y)) continue;
                        PaginationWidget.this.currentPage = i;
                        PaginationWidget.this.canvas.redraw();
                        PaginationWidget.this.notifyListeners(i);
                        break;
                    }
                }
                if (event2.type == 5) {
                    boolean pageFound = false;
                    for (int i = 0; i < PaginationWidget.this.pages.length; ++i) {
                        if (!PaginationWidget.this.pages[i].contains(event2.x, event2.y)) continue;
                        String tooltipText = PaginationWidget.this.getTooltip(i);
                        if (!tooltipText.equals(PaginationWidget.this.canvas.getToolTipText())) {
                            PaginationWidget.this.canvas.setToolTipText(tooltipText);
                        }
                        PaginationWidget.this.canvas.setCursor(PaginationWidget.this.canvas.getDisplay().getSystemCursor(21));
                        pageFound = true;
                        break;
                    }
                    if (!pageFound) {
                        PaginationWidget.this.canvas.setCursor(null);
                        PaginationWidget.this.canvas.setToolTipText(null);
                    }
                }
            }
        };
        this.canvas.addListener(3, listener);
        this.canvas.addListener(5, listener);
    }

    private String getTooltip(int pageIndex) {
        int end = Math.min(++pageIndex * this.itemsPerPage, this.itemsTotal);
        int start = Math.max(pageIndex * this.itemsPerPage - (this.itemsPerPage - 1), 1);
        return start + "-" + end + " of " + this.itemsTotal;
    }

    public void setPageCount(int pageCount) {
        this.pages = new Rectangle[pageCount];
        this.pages[0] = new Rectangle(0, this.yOffset, this.width, this.height);
        int xOffset = this.width + this.hSpacing;
        for (int i = 1; i < this.pages.length; ++i) {
            this.pages[i] = new Rectangle(xOffset, this.yOffset, this.width, this.height);
            xOffset += this.width + this.hSpacing;
        }
        if (this.parent.getLayoutData() instanceof FormData) {
            FormData pfd = (FormData)this.parent.getLayoutData();
            pfd.width = pageCount * (this.hSpacing + this.width);
        }
        this.fd.width = pageCount * (this.hSpacing + this.width);
        this.canvas.setSize(pageCount * (this.hSpacing + this.width), 16);
        Utils.relayout((Control)this.parent);
    }

    public void addPageSelectionListener(PageSelectionListener listener) {
        if (!this.listeners.contains(listener) && null != listener) {
            this.listeners.add(listener);
        }
    }

    private void notifyListeners(int selectedPage) {
        for (PageSelectionListener listener : this.listeners) {
            listener.pageSelected(selectedPage);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (this.currentPage != currentPage) {
            this.currentPage = currentPage;
            this.canvas.redraw();
        }
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public int getItemsTotal() {
        return this.itemsTotal;
    }

    public void setItemsTotal(int itemsTotal) {
        this.itemsTotal = itemsTotal;
    }

    public static interface PageSelectionListener {
        public void pageSelected(int var1);
    }
}

