/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.widgets;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.widgets.Inset;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;

public abstract class SkinButton
extends Canvas {
    protected static String imagePath = "com/aelitis/azureus/ui/images/";
    public static final int WIDGET_STATE_NORMAL = 0;
    public static final int WIDGET_STATE_NOT_VISIBLE = 1;
    public static final int WIDGET_STATE_DISABLED = 2;
    public static final int WIDGET_STATE_HOVER = 3;
    private int currentState = 0;
    private Image buttonImage = null;
    private String buttonText = null;
    private int alpha = 255;
    private Inset inset = new Inset(0, 0, 0, 0);
    private Color foregroundHover = null;
    private Color foregroundDisabled = null;
    private boolean enabled = true;

    public SkinButton(Composite parent) {
        this(parent, null, null);
    }

    public SkinButton(Composite parent, String buttonText) {
        this(parent, buttonText, null);
    }

    public SkinButton(Composite parent, String buttonText, Image buttonImage) {
        super(parent, 0x20000001);
        this.buttonImage = buttonImage;
        this.buttonText = buttonText;
        this.init();
    }

    private void init() {
        this.setCursor(Cursors.handCursor);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    e.gc.setAntialias(1);
                    e.gc.setTextAntialias(1);
                    e.gc.setAlpha(SkinButton.this.alpha);
                    e.gc.setInterpolation(2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Image[] images = SkinButton.this.getCurrentBackgroundImages();
                if (null != images) {
                    if (images.length != 3) {
                        if (null != images[0] && !images[0].isDisposed()) {
                            ImageData iData = images[0].getImageData();
                            e.gc.drawImage(images[0], 0, 0, iData.width, iData.height, 0, 0, iData.width, iData.height);
                        }
                    } else {
                        ImageData iData;
                        int leftOffset = 0;
                        int rightOffset = 0;
                        if (null != images[0] && !images[0].isDisposed()) {
                            iData = images[0].getImageData();
                            e.gc.drawImage(images[0], 0, 0, iData.width, iData.height, 0, 0, iData.width, iData.height);
                            leftOffset = iData.width;
                        }
                        if (null != images[2] && !images[2].isDisposed()) {
                            iData = images[2].getImageData();
                            rightOffset = SkinButton.this.getSize().x - iData.width;
                            e.gc.drawImage(images[2], 0, 0, iData.width, iData.height, rightOffset, 0, iData.width, iData.height);
                        }
                        if (null != images[1] && !images[1].isDisposed()) {
                            iData = images[1].getImageData();
                            int iterations = (rightOffset - leftOffset) / iData.width;
                            int roundingOverflow = rightOffset - leftOffset - iterations * iData.width;
                            for (int i = 0; i < iterations; ++i) {
                                e.gc.drawImage(images[1], 0, 0, iData.width, iData.height, leftOffset + i * iData.width, 0, iData.width, iData.height);
                            }
                            if (roundingOverflow > 0) {
                                e.gc.drawImage(images[1], 0, 0, roundingOverflow, iData.height, leftOffset + iterations * iData.width, 0, roundingOverflow, iData.height);
                            }
                        }
                    }
                }
                int imageOffset = 0;
                if (null != SkinButton.this.getImage() && !SkinButton.this.getImage().isDisposed()) {
                    ImageData iData = SkinButton.this.getImage().getImageData();
                    e.gc.drawImage(SkinButton.this.getImage(), 0, 0, iData.width, iData.height, ((SkinButton)SkinButton.this).inset.left, ((SkinButton)SkinButton.this).inset.top, iData.width, iData.height);
                    imageOffset = ((SkinButton)SkinButton.this).inset.left + iData.width;
                }
                if (null != SkinButton.this.getText()) {
                    if (SkinButton.this.currentState == 2) {
                        if (null != SkinButton.this.getForegroundColors()[2]) {
                            e.gc.setForeground(SkinButton.this.getForegroundColors()[2]);
                        }
                    } else if (SkinButton.this.currentState == 3) {
                        if (null != SkinButton.this.getForegroundColors()[1]) {
                            e.gc.setForeground(SkinButton.this.getForegroundColors()[1]);
                        }
                    } else if (null != SkinButton.this.getForegroundColors()[0]) {
                        e.gc.setForeground(SkinButton.this.getForegroundColors()[0]);
                    } else {
                        e.gc.setForeground(SkinButton.this.getForeground());
                    }
                    if (imageOffset != 0) {
                        Point extent = e.gc.textExtent(SkinButton.this.getText());
                        e.gc.drawText(SkinButton.this.getText(), imageOffset += 6, SkinButton.this.getSize().y / 2 - extent.y / 2, 9);
                    } else {
                        Point extent = e.gc.textExtent(SkinButton.this.getText());
                        e.gc.drawText(SkinButton.this.getText(), SkinButton.this.getSize().x / 2 - extent.x / 2, SkinButton.this.getSize().y / 2 - extent.y / 2, 9);
                    }
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (SkinButton.this.currentState != 2 && SkinButton.this.currentState != 3) {
                    SkinButton.this.currentState = 3;
                    SkinButton.this.refreshVisuals();
                }
            }

            public void mouseExit(MouseEvent e) {
                if (SkinButton.this.currentState != 2 && SkinButton.this.currentState != 0) {
                    SkinButton.this.currentState = 0;
                    SkinButton.this.refreshVisuals();
                }
            }
        });
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Image[] bgImages;
        Point backgroundExtent = new Point(0, 0);
        Point imageExtent = new Point(0, 0);
        Point textExtent = new Point(0, 0);
        if (null != this.getImage()) {
            imageExtent.x = this.getImage().getImageData().width;
            imageExtent.y = this.getImage().getImageData().height;
        }
        if (null != this.getText()) {
            GC gc = new GC((Drawable)this.getDisplay());
            textExtent = gc.textExtent(this.getText());
            gc.dispose();
        }
        if (null != (bgImages = this.getBackgroundImages())) {
            if (null != bgImages[0]) {
                backgroundExtent.x = bgImages[0].getImageData().width;
                backgroundExtent.y = bgImages[0].getImageData().height;
            }
            if (null != bgImages[1]) {
                backgroundExtent.x += bgImages[1].getImageData().width;
                backgroundExtent.y = bgImages[1].getImageData().height;
            }
            if (null != bgImages[2]) {
                backgroundExtent.x += bgImages[2].getImageData().width;
                backgroundExtent.y = bgImages[2].getImageData().height;
            }
        }
        int maxHeight = Math.max(backgroundExtent.y, imageExtent.y + this.inset.top + this.inset.bottom);
        maxHeight = Math.max(maxHeight, textExtent.y + this.inset.top + this.inset.bottom);
        int maxWidth = Math.max(backgroundExtent.x, imageExtent.x + 6 + textExtent.x + this.inset.left + this.inset.right);
        maxWidth = Math.max(maxWidth, imageExtent.x + this.inset.left + this.inset.right);
        maxWidth = Math.max(maxWidth, textExtent.x + this.inset.left + this.inset.right);
        return new Point(maxWidth, maxHeight);
    }

    private Image[] getCurrentBackgroundImages() {
        Image[] images;
        if (this.currentState == 2 ? null != (images = this.getBackgroundImages_disabled()) && images.length > 0 : this.currentState == 3 && null != (images = this.getBackgroundImages_hover()) && images.length > 0) {
            return images;
        }
        images = this.getBackgroundImages();
        if (null != images && images.length > 0) {
            return images;
        }
        return null;
    }

    public Image getImage() {
        return this.buttonImage;
    }

    public void setImage(Image buttonImage) {
        if (this.buttonImage != buttonImage) {
            this.buttonImage = buttonImage;
            this.refreshVisuals();
        }
    }

    public String getText() {
        return this.buttonText;
    }

    public void setText(String buttonText) {
        if (this.buttonText != buttonText) {
            this.buttonText = buttonText;
            this.refreshVisuals();
        }
    }

    public abstract Image[] getBackgroundImages();

    public abstract Image[] getBackgroundImages_disabled();

    public abstract Image[] getBackgroundImages_hover();

    public abstract Color[] getForegroundColors();

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            super.setEnabled(enabled);
            if (!enabled) {
                this.currentState = 2;
                this.alpha = 128;
            } else {
                this.currentState = 0;
                this.alpha = 255;
            }
            this.refreshVisuals();
            this.update();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Inset getInset() {
        return this.inset;
    }

    public void setInset(Inset inset) {
        if (this.inset != inset) {
            this.inset = inset;
            this.refreshVisuals();
        }
    }

    public void refreshVisuals() {
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                if (!SkinButton.this.isDisposed()) {
                    SkinButton.this.redraw();
                }
            }
        }, false);
    }

    public Color getForegroundHover() {
        return this.foregroundHover;
    }

    public void setForegroundHover(Color foregroundHover) {
        this.foregroundHover = foregroundHover;
    }

    public Color getForegroundDisabled() {
        return this.foregroundDisabled;
    }

    public void setForegroundDisabled(Color foregroundDisabled) {
        this.foregroundDisabled = foregroundDisabled;
    }
}

