/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.wizard;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.config.wizard.TransferPanel;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class WelcomePanel
extends AbstractWizardPanel {
    public WelcomePanel(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("configureWizard.welcome.title"));
        String initsMode = "";
        final String[] text = new String[]{""};
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        final String[] messTexts = new String[]{"ConfigView.section.mode.beginner.wiki.definitions", "ConfigView.section.mode.intermediate.wiki.host", "ConfigView.section.mode.advanced.wiki.main", "ConfigView.section.mode.intermediate.wiki.publish"};
        final String[] links = new String[]{"http://www.azureuswiki.com/index.php/This_funny_word", "http://www.azureuswiki.com/index.php/HostingFiles", "http://www.azureuswiki.com/index.php/Main_Page", "http://www.azureuswiki.com/index.php/PublishingFiles"};
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Label label0 = new Label(panel, 64);
        gridData = new GridData(768);
        label0.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label0, "configureWizard.welcome.message");
        label0 = new Label(panel, 0);
        Label label1 = new Label(panel, 64);
        gridData = new GridData(768);
        label1.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label1, "configureWizard.welcome.usermodes");
        gridData = new GridData();
        final Group gRadio = new Group(panel, 64);
        Messages.setLanguageText((Widget)gRadio, "ConfigView.section.mode.title");
        gRadio.setLayoutData((Object)gridData);
        gRadio.setLayout((Layout)new RowLayout(256));
        Button button0 = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)button0, "ConfigView.section.mode.beginner");
        button0.setData("iMode", (Object)"0");
        button0.setData("sMode", (Object)"beginner.text");
        Button button1 = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)button1, "ConfigView.section.mode.intermediate");
        button1.setData("iMode", (Object)"1");
        button1.setData("sMode", (Object)"intermediate.text");
        Button button2 = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)button2, "ConfigView.section.mode.advanced");
        button2.setData("iMode", (Object)"2");
        button2.setData("sMode", (Object)"advanced.text");
        if (userMode == 0) {
            initsMode = "beginner.text";
            button0.setSelection(true);
        } else if (userMode == 1) {
            initsMode = "intermediate.text";
            button1.setSelection(true);
        } else {
            initsMode = "advanced.text";
            button2.setSelection(true);
        }
        final Label labl = new Label(panel, 64);
        gridData = new GridData(1808);
        gridData.widthHint = 380;
        gridData.heightHint = 50;
        labl.setLayoutData((Object)gridData);
        text[0] = MessageText.getString("ConfigView.section.mode." + initsMode);
        labl.setText(text[0]);
        labl.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.launch(event2.text);
            }
        });
        Group gWiki = new Group(panel, 64);
        gridData = new GridData();
        gridData.widthHint = 350;
        gWiki.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 1;
        gWiki.setLayout((Layout)layout);
        gWiki.setText(MessageText.getString("Utils.link.visit"));
        final Label linkLabel = new Label((Composite)gWiki, 0);
        linkLabel.setText(MessageText.getString(messTexts[userMode]));
        linkLabel.setData((Object)links[userMode]);
        linkLabel.setCursor(Cursors.handCursor);
        linkLabel.setForeground(Colors.blue);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        linkLabel.setLayoutData((Object)gridData);
        linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            public void mouseUp(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
        final Label linkLabel1 = new Label((Composite)gWiki, 0);
        linkLabel1.setText(userMode == 1 ? MessageText.getString(messTexts[3]) : "");
        linkLabel1.setData((Object)links[3]);
        linkLabel1.setCursor(Cursors.handCursor);
        linkLabel1.setForeground(Colors.blue);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        linkLabel1.setLayoutData((Object)gridData);
        linkLabel1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            public void mouseUp(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
        Listener radioGroup = new Listener(){

            public void handleEvent(Event event2) {
                Control[] children = gRadio.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    Button button;
                    Control child = children[j];
                    if (!(child instanceof Button) || ((button = (Button)child).getStyle() & 0x10) == 0) continue;
                    button.setSelection(false);
                }
                Button button = (Button)event2.widget;
                button.setSelection(true);
                int mode = Integer.parseInt((String)button.getData("iMode"));
                text[0] = MessageText.getString("ConfigView.section.mode." + (String)button.getData("sMode"));
                labl.setText(text[0]);
                linkLabel.setText(MessageText.getString(messTexts[mode]));
                linkLabel.setData((Object)links[mode]);
                if (mode == 1) {
                    linkLabel1.setText(MessageText.getString(messTexts[3]));
                    linkLabel1.setData((Object)links[3]);
                } else {
                    linkLabel1.setText("");
                    linkLabel1.setData((Object)"");
                }
                COConfigurationManager.setParameter("User Mode", Integer.parseInt((String)button.getData("iMode")));
            }
        };
        button0.addListener(13, radioGroup);
        button1.addListener(13, radioGroup);
        button2.addListener(13, radioGroup);
    }

    public boolean isNextEnabled() {
        return true;
    }

    public IWizardPanel getNextPanel() {
        return new TransferPanel((ConfigureWizard)this.wizard, (IWizardPanel)this);
    }
}

