/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.debug;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateShell;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class UIDebugGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate() {
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        while (display.readAndDispatch()) {
        }
        Shell[] shells = display.getShells();
        if (shells == null || shells.length == 0) {
            return;
        }
        final File path = new File(SystemProperties.getUserPath(), "debug");
        if (!path.isDirectory()) {
            path.mkdir();
        } else {
            try {
                File[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int i = 0; i < shells.length; ++i) {
            try {
                Shell shell = shells[i];
                Image image = null;
                if (shell.getData("class") instanceof ObfusticateShell) {
                    ObfusticateShell shellClass = (ObfusticateShell)shell.getData("class");
                    try {
                        image = shellClass.generateObfusticatedImage();
                    }
                    catch (Exception e) {
                        Debug.out("Obfusticating shell " + shell, e);
                    }
                } else {
                    Rectangle clientArea = shell.getClientArea();
                    image = new Image((Device)display, clientArea.width, clientArea.height);
                    GC gc = new GC((Drawable)shell);
                    try {
                        gc.copyArea(image, clientArea.x, clientArea.y);
                    }
                    finally {
                        gc.dispose();
                    }
                }
                if (image == null) continue;
                File file = new File(path, "image-" + i + ".jpg");
                String sFileName = file.getAbsolutePath();
                ImageLoader imageLoader = new ImageLoader();
                imageLoader.data = new ImageData[]{image.getImageData()};
                imageLoader.save(sFileName, 4);
                continue;
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LogIDs.GUI, "Creating Obfusticated Image", e));
            }
        }
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("UIDebugGenerator.messageask.title", "UIDebugGenerator.messageask.text", true);
        entryWindow.prompt();
        if (!entryWindow.hasSubmittedInput()) {
            return;
        }
        String message = entryWindow.getSubmittedInput();
        if (message == null || message.length() == 0) {
            Utils.openMessageBox(Utils.findAnyShell(), 32, "UIDebugGenerator.message.cancel", (String[])null);
            return;
        }
        try {
            File fUserMessage = new File(path, "usermessage.txt");
            FileWriter fw = new FileWriter(fUserMessage);
            fw.write(message);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.createOperation(3, new AzureusCoreOperationTask(){

                    public void run(AzureusCoreOperation operation) {
                        try {
                            File fEvidence = new File(path, "evidence.log");
                            FileWriter fw = new FileWriter(fEvidence);
                            PrintWriter pw = new PrintWriter(fw);
                            AEDiagnostics.generateEvidence(pw);
                            fw.close();
                        }
                        catch (IOException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            }
        });
        try {
            int result;
            File loggingFile;
            File outFile = new File(SystemProperties.getUserPath(), "debug.zip");
            if (outFile.exists()) {
                outFile.delete();
            }
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
            File logPath = new File(SystemProperties.getUserPath(), "logs");
            File[] files = logPath.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".log");
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            File userPath = new File(SystemProperties.getUserPath());
            files = userPath.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".log");
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            files = path.listFiles();
            UIDebugGenerator.addFilesToZip(out, files);
            final long ago = SystemTime.getCurrentTime() - 7776000000L;
            File azureusPath = new File(SystemProperties.getApplicationPath());
            files = azureusPath.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().startsWith("hs_err") && pathname.lastModified() > ago;
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            File javaLogPath = new File(System.getProperty("user.home"), "Library" + File.separator + "Logs" + File.separator + "Java");
            if (javaLogPath.isDirectory()) {
                files = javaLogPath.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith("log") && pathname.lastModified() > ago;
                    }
                });
                UIDebugGenerator.addFilesToZip(out, files);
            }
            boolean bLogToFile = COConfigurationManager.getBooleanParameter("Logging Enable");
            String sLogDir = COConfigurationManager.getStringParameter("Logging Dir", "");
            if (bLogToFile && sLogDir != null && (loggingFile = new File(sLogDir, "az.log")).isFile()) {
                UIDebugGenerator.addFilesToZip(out, new File[]{loggingFile});
            }
            out.close();
            if (outFile.exists() && (result = Utils.openMessageBox(Utils.findAnyShell(), 65826, "UIDebugGenerator.complete", new String[]{outFile.toString()})) == 32) {
                try {
                    PlatformManagerFactory.getPlatformManager().showFile(outFile.getAbsolutePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addFilesToZip(ZipOutputStream out, File[] files) {
        byte[] buf = new byte[1024];
        if (files == null) {
            return;
        }
        for (int j = 0; j < files.length; ++j) {
            FileInputStream in;
            File file = files[j];
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                continue;
            }
            try {
                int len;
                ZipEntry entry = new ZipEntry(file.getName());
                entry.setTime(file.lastModified());
                out.putNextEntry(entry);
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                in.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obfusticateArea(Display display, Image image, Rectangle bounds) {
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(display.getSystemColor(1));
            gc.setForeground(display.getSystemColor(3));
            gc.fillRectangle(bounds);
            gc.drawRectangle(bounds);
            int x2 = bounds.x + bounds.width;
            int y2 = bounds.y + bounds.height;
            gc.drawLine(bounds.x, bounds.y, x2, y2);
            gc.drawLine(x2, bounds.y, bounds.x, y2);
        }
        finally {
            gc.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void obfusticateArea(Display display, Image image, Rectangle bounds, String text) {
        if (bounds.isEmpty()) {
            return;
        }
        if (text == "") {
            UIDebugGenerator.obfusticateArea(display, image, bounds);
            return;
        }
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(display.getSystemColor(1));
            gc.setForeground(display.getSystemColor(3));
            gc.fillRectangle(bounds);
            gc.drawRectangle(bounds);
            gc.setClipping(bounds);
            gc.drawText(text, bounds.x + 2, bounds.y + 1);
        }
        finally {
            gc.dispose();
        }
    }

    public static void obfusticateArea(Image image, Control control, Point shellOffset, String text) {
        Rectangle bounds = control.getBounds();
        Point offset = control.getParent().toDisplay(bounds.x, bounds.y);
        bounds.x = offset.x - shellOffset.x;
        bounds.y = offset.y - shellOffset.y;
        UIDebugGenerator.obfusticateArea(control.getDisplay(), image, bounds, text);
    }
}

