/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.donations;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import java.util.Locale;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class DonationWindow {
    public static boolean DEBUG = System.getProperty("donations.debug", "0").equals("1");
    private static int reAskEveryHours = 96;
    private static int initialAskHours = 48;
    private static boolean pageLoadedOk = false;
    private static Shell shell = null;
    private static Browser browser;

    public static void checkForDonationPopup() {
        if (shell != null) {
            if (DEBUG) {
                Utils.openMessageBox(null, 32, "Donations Test", "Already Open");
            }
            return;
        }
        boolean alreadyDonated = COConfigurationManager.getBooleanParameter("donations.donated", false);
        if (alreadyDonated) {
            if (DEBUG) {
                Utils.openMessageBox(null, 32, "Donations Test", "Already Donated! I like you.");
            }
            return;
        }
        OverallStats stats = StatsFactory.getStats();
        if (stats == null) {
            return;
        }
        long upTime = stats.getTotalUpTime();
        int hours = (int)(upTime / 3600L);
        int nextAsk = COConfigurationManager.getIntParameter("donations.nextAskHours", 0);
        if (nextAsk == 0) {
            COConfigurationManager.setParameter("donations.nextAskHours", hours + initialAskHours);
            COConfigurationManager.save();
            if (DEBUG) {
                Utils.openMessageBox(null, 32, "Donations Test", "Newbie. You're active for " + hours + ".");
            }
            return;
        }
        if (hours < nextAsk) {
            if (DEBUG) {
                Utils.openMessageBox(null, 32, "Donations Test", "Wait " + (nextAsk - hours) + ".");
            }
            return;
        }
        long minDate = COConfigurationManager.getLongParameter("donations.minDate", 0L);
        if (minDate > 0L && minDate > SystemTime.getCurrentTime()) {
            if (DEBUG) {
                Utils.openMessageBox(null, 32, "Donation Test", "Wait " + (SystemTime.getCurrentTime() - minDate) / 1000L / 3600L / 24L + " days");
            }
            return;
        }
        COConfigurationManager.setParameter("donations.nextAskHours", hours + reAskEveryHours);
        COConfigurationManager.save();
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                DonationWindow.open(false, "check");
            }
        });
    }

    public static void open(final boolean showNoLoad, final String sourceRef) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                DonationWindow._open(showNoLoad, sourceRef);
            }
        });
    }

    public static void _open(final boolean showNoLoad, String sourceRef) {
        if (shell != null && !shell.isDisposed()) {
            return;
        }
        final Shell parentShell = Utils.findAnyShell();
        shell = ShellFactory.createShell(parentShell, 67616);
        shell.setLayout((Layout)new FillLayout());
        if (parentShell != null) {
            parentShell.setCursor(shell.getDisplay().getSystemCursor(1));
        }
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (parentShell != null) {
                    parentShell.setCursor(e.display.getSystemCursor(0));
                }
                shell = null;
            }
        });
        try {
            browser = new Browser((Composite)shell, Utils.getInitialBrowserStyle(0));
        }
        catch (Throwable t) {
            shell.dispose();
            return;
        }
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                shell.setText(event2.title);
            }
        });
        browser.addStatusTextListener(new StatusTextListener(){
            String last = null;

            public void changed(StatusTextEvent event2) {
                String[] strings;
                String text = event2.text.toLowerCase();
                if (this.last != null && this.last.equals(text)) {
                    return;
                }
                this.last = text;
                if (text.contains("page-loaded")) {
                    pageLoadedOk = true;
                    COConfigurationManager.setParameter("donations.count", COConfigurationManager.getLongParameter("donations.count", 1L) + 1L);
                    Utils.centreWindow(shell);
                    if (parentShell != null) {
                        parentShell.setCursor(shell.getDisplay().getSystemCursor(0));
                    }
                    shell.open();
                } else if (text.contains("reset-ask-time")) {
                    int time = reAskEveryHours;
                    String[] strings2 = text.split(" ");
                    if (strings2.length > 1) {
                        try {
                            time = Integer.parseInt(strings2[1]);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DonationWindow.resetAskTime(time);
                } else if (text.contains("never-ask-again")) {
                    DonationWindow.neverAskAgain();
                } else if (text.contains("close")) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            shell.dispose();
                        }
                    });
                } else if (text.startsWith("open-url")) {
                    String url = event2.text.substring(9);
                    Utils.launch(url);
                } else if (text.startsWith("set-size") && (strings = text.split(" ")).length > 2) {
                    try {
                        int w = Integer.parseInt(strings[1]);
                        int h = Integer.parseInt(strings[2]);
                        Rectangle computeTrim = shell.computeTrim(0, 0, w, h);
                        shell.setSize(computeTrim.width, computeTrim.height);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event2) {
            }

            public void changed(LocationEvent event2) {
            }
        });
        long upTime = StatsFactory.getStats().getTotalUpTime();
        int upHours = (int)(upTime / 3600L);
        String azid = Base32.encode(CryptoManagerFactory.getSingleton().getSecureID());
        final String url = "http://" + System.getProperty("platform_address", "www.vuze.com") + ":" + System.getProperty("platform_port", "80") + "/" + "donate.start?locale=" + Locale.getDefault().toString() + "&azv=" + "4.2.0.8" + "&count=" + COConfigurationManager.getLongParameter("donations.count", 1L) + "&uphours=" + upHours + "&azid=" + azid + "&sourceref=" + UrlUtils.encode(sourceRef);
        SimpleTimer.addEvent("donation.pageload", SystemTime.getOffsetTime(6000L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (!pageLoadedOk) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            Debug.out("Page Didn't Load:" + url);
                            shell.dispose();
                            if (showNoLoad) {
                                Utils.openMessageBox(shell, 32, MessageText.getString("DonationWindow.noload.title"), MessageText.getString("DonationWindow.noload.text", new String[]{url}));
                            }
                        }
                    });
                }
            }
        });
        browser.setUrl(url);
    }

    protected static void neverAskAgain() {
        COConfigurationManager.setParameter("donations.donated", true);
        COConfigurationManager.save();
    }

    public static void resetAskTime() {
        DonationWindow.resetAskTime(reAskEveryHours);
    }

    public static void resetAskTime(int askEveryHours) {
        long upTime = StatsFactory.getStats().getTotalUpTime();
        int hours = (int)(upTime / 3600L);
        int nextAsk = hours + askEveryHours;
        COConfigurationManager.setParameter("donations.nextAskHours", nextAsk);
        COConfigurationManager.setParameter("donations.lastVersion", "4.2.0.8");
        COConfigurationManager.save();
    }

    public static void updateMinDate() {
        COConfigurationManager.setParameter("donations.minDate", SystemTime.getOffsetTime(2592000000L));
        COConfigurationManager.save();
    }

    public static void setMinDate(long timestamp) {
        COConfigurationManager.setParameter("donations.minDate", timestamp);
        COConfigurationManager.save();
    }

    public static int getInitialAskHours() {
        return initialAskHours;
    }

    public static void setInitialAskHours(int i) {
        initialAskHours = i;
    }

    public static void main(String[] args) {
        try {
            AzureusCoreFactory.create().start();
            DonationWindow.open(true, "test");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Display d = Display.getDefault();
        while (true) {
            if (d.readAndDispatch()) {
                continue;
            }
            d.sleep();
        }
    }
}

