/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class ClipboardCopy {
    public static void copyToClipBoard(String data) {
        new Clipboard(SWTThread.getInstance().getDisplay()).setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
    }

    public static void addCopyToClipMenu(final Control control, final copyToClipProvider provider2) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (control.isDisposed()) {
                    return;
                }
                final String text = provider2.getText();
                if (control.getMenu() != null || text == null || text.length() == 0) {
                    return;
                }
                if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                    return;
                }
                final Menu menu = new Menu((Decorations)control.getShell(), 8);
                MenuItem item = new MenuItem(menu, 0);
                item.setText(MessageText.getString("ConfigView.copy.to.clipboard.tooltip"));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        new Clipboard(control.getDisplay()).setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
                    }
                });
                control.setMenu(menu);
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuHidden(MenuEvent arg0) {
                        if (control.getMenu() == menu) {
                            control.setMenu(null);
                        }
                    }
                });
                menu.setVisible(true);
            }
        });
    }

    public static interface copyToClipProvider {
        public String getText();
    }
}

