/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.swt.mainwindow.DebugMenuHelper;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;

public class MainMenu
implements IMainMenu {
    public static int MENU_BAR = 0;
    public static int MENU_TRANSFER = 1;
    public static int MENU_VIEW = 2;
    private MainWindow mainWindow = MainWindow.getWindow();
    private Menu menuBar;

    public MainMenu(Shell shell) {
        this.createMenus(shell);
    }

    public void setMainWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void linkMenuBar(Shell parent) {
        parent.setMenuBar(this.menuBar);
    }

    private void createMenus(Shell parent) {
        this.menuBar = new Menu((Decorations)parent, 2);
        parent.setMenuBar(this.menuBar);
        this.addFileMenu(parent);
        if (Constants.isOSX) {
            this.addViewMenu(parent);
            this.addTransferMenu(parent);
            this.addTorrentMenu(parent);
        } else {
            this.addTransferMenu(parent);
            this.addTorrentMenu(parent);
            this.addViewMenu(parent);
            this.addToolsMenu(parent);
        }
        this.addPluginsMenu(parent);
        if (Constants.isOSX) {
            this.addWindowMenu(parent);
        }
        if (Constants.isCVSVersion()) {
            DebugMenuHelper.createDebugMenuItem(this.menuBar);
        }
        this.addV2HelpMenu(parent);
        MenuFactory.updateEnabledStates(this.menuBar);
    }

    private void addWindowMenu(Shell parent) {
        MenuItem menu_window = MenuFactory.createWindowMenuItem(this.menuBar);
        Menu windowMenu = menu_window.getMenu();
        MenuFactory.addMinimizeWindowMenuItem(windowMenu);
        MenuFactory.addZoomWindowMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBlockedIPsMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBringAllToFrontMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.appendWindowMenuItems(windowMenu);
    }

    private void addFileMenu(Shell parent) {
        MenuItem fileItem = MenuFactory.createFileMenuItem(this.menuBar);
        Menu fileMenu = fileItem.getMenu();
        MenuFactory.addCreateMenuItem(fileMenu);
        MenuItem openMenuItem = MenuFactory.createOpenMenuItem(fileMenu);
        Menu openSubMenu = openMenuItem.getMenu();
        MenuFactory.addOpenTorrentMenuItem(openSubMenu);
        MenuFactory.addOpenTorrentForTrackingMenuItem(openSubMenu);
        MenuFactory.addOpenVuzeFileMenuItem(openSubMenu);
        MenuItem shareMenuItem = MenuFactory.createShareMenuItem(fileMenu);
        Menu shareSubMenu = shareMenuItem.getMenu();
        MenuFactory.addShareFileMenuItem(shareSubMenu);
        MenuFactory.addShareFolderMenuItem(shareSubMenu);
        MenuFactory.addShareFolderContentMenuItem(shareSubMenu);
        MenuFactory.addShareFolderContentRecursiveMenuItem(shareSubMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addImportMenuItem(fileMenu);
        MenuFactory.addExportMenuItem(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addCloseWindowMenuItem(fileMenu);
        MenuFactory.addCloseTabMenuItem(fileMenu, this.mainWindow);
        MenuFactory.addCloseDetailsMenuItem(fileMenu);
        MenuFactory.addCloseDownloadBarsToMenu(fileMenu);
        if (!Constants.isOSX) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addRestartMenuItem(fileMenu);
            MenuFactory.addExitMenuItem(fileMenu);
        }
    }

    private void addTransferMenu(Shell parent) {
        MenuFactory.createTransfersMenuItem(this.menuBar);
    }

    private void addViewMenu(Shell parent) {
        try {
            MenuItem viewItem = MenuFactory.createViewMenuItem(this.menuBar);
            Menu viewMenu = viewItem.getMenu();
            MenuFactory.addLabelMenuItem(viewMenu, "MainWindow.menu.view.show");
            MainMenu.indent(MenuFactory.addMyTorrentsMenuItem(viewMenu));
            MainMenu.indent(MenuFactory.addMyTrackerMenuItem(viewMenu));
            MainMenu.indent(MenuFactory.addMySharesMenuItem(viewMenu));
            MainMenu.indent(MenuFactory.addViewToolbarMenuItem(viewMenu));
            MainMenu.indent(MenuFactory.addTransferBarToMenu(viewMenu));
            MainMenu.indent(MenuFactory.addAllPeersMenuItem(viewMenu));
            if (Constants.isCVSVersion()) {
                MainMenu.indent(MenuFactory.addDetailedListMenuItem(viewMenu));
            }
            if (Constants.isOSX) {
                MainMenu.indent(MenuFactory.addConsoleMenuItem(viewMenu));
                MainMenu.indent(MenuFactory.addStatisticsMenuItem(viewMenu));
            }
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addTorrentMenu(Shell parent) {
        if (COConfigurationManager.getBooleanParameter("show_torrents_menu")) {
            MenuFactory.createTorrentMenuItem(this.menuBar);
        }
    }

    private void addToolsMenu(Shell parent) {
        MenuItem item = MenuFactory.createToolsMenuItem(this.menuBar);
        Menu toolsMenu = item.getMenu();
        MenuFactory.addBlockedIPsMenuItem(toolsMenu);
        MenuFactory.addConsoleMenuItem(toolsMenu);
        MenuFactory.addStatisticsMenuItem(toolsMenu);
        MenuFactory.addNatTestMenuItem(toolsMenu);
        MenuFactory.addSpeedTestMenuItem(toolsMenu);
        MenuFactory.addSeparatorMenuItem(toolsMenu);
        MenuFactory.addConfigWizardMenuItem(toolsMenu);
        MenuFactory.addOptionsMenuItem(toolsMenu);
    }

    private void addPluginsMenu(Shell parent) {
        MenuFactory.createPluginsMenuItem(this.menuBar, false);
    }

    private void addV2HelpMenu(Shell parent) {
        MenuItem helpItem = MenuFactory.createHelpMenuItem(this.menuBar);
        Menu helpMenu = helpItem.getMenu();
        if (!Constants.isOSX) {
            MenuFactory.addAboutMenuItem(helpMenu);
            MenuFactory.addSeparatorMenuItem(helpMenu);
        }
        MenuFactory.addHealthMenuItem(helpMenu);
        MenuFactory.addReleaseNotesMenuItem(helpMenu);
        MenuFactory.addWhatsNewMenuItem(helpMenu);
        MenuFactory.addWikiMenuItem(helpMenu);
        MenuFactory.addGetPluginsMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        if (!SystemProperties.isJavaWebStartInstance()) {
            MenuFactory.addCheckUpdateMenuItem(helpMenu);
        }
        MenuFactory.addDonationMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addDebugHelpMenuItem(helpMenu);
    }

    private static final void indent(MenuItem item) {
        item.setData("IndentItem", (Object)"YES");
        item.setText("  " + item.getText());
    }

    public Menu getMenu(int id) {
        if (id == MENU_BAR) {
            return this.getMenu("menu.bar");
        }
        if (id == MENU_TRANSFER) {
            return this.getMenu("MainWindow.menu.transfers");
        }
        if (id == MENU_VIEW) {
            return this.getMenu("MainWindow.menu.view");
        }
        return null;
    }

    public Menu getMenu(String id) {
        if ("menu.bar".equals(id)) {
            return this.menuBar;
        }
        return MenuFactory.findMenu(this.menuBar, id);
    }
}

