/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;

public class SplashWindow
implements InitializerListener {
    private static final String IMG_SPLASH = "azureus_splash";
    protected static final int OFFSET_LEFT = 10;
    protected static final int OFFSET_RIGHT = 139;
    protected static final int OFFSET_BOTTOM = 12;
    protected static final int PB_HEIGHT = 2;
    protected static final boolean PB_INVERTED = true;
    protected static final int PB_INVERTED_BG_HEIGHT = 2;
    protected static final int PB_INVERTED_X_OFFSET = 0;
    protected static final boolean DISPLAY_BORDER = true;
    Display display;
    IUIIntializer initializer;
    Shell splash;
    Canvas canvas;
    Image background;
    int width;
    int height;
    Image current;
    Color progressBarColor;
    Color textColor;
    Color fadedGreyColor;
    Font textFont;
    private String task;
    private int percent;
    private boolean updating;
    int pbX;
    int pbY;
    int pbWidth;

    public SplashWindow(Display display) {
        this(display, null);
    }

    public static void main(String[] args) {
        Display display = new Display();
        final SplashWindow splash = new SplashWindow(display);
        Thread t = new Thread(){

            public void run() {
                try {
                    int percent = 0;
                    while (percent <= 100) {
                        splash.reportPercent(percent++);
                        splash.reportCurrentTask(percent + "% Loading dbnvsudn vjksfdh fgshdu fbhsduh bvsfd fbsd fbvsdb fsuid opnum supnum boopergood haha text doot subliminal.".substring(0, (int)(1.0 + Math.random() * 110.0)));
                        Thread.sleep(100L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                splash.closeSplash();
            }
        };
        t.start();
        while (!splash.splash.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplashWindow(Display _display, IUIIntializer initializer) {
        this.display = _display;
        this.initializer = initializer;
        this.splash = new Shell(this.display, 8);
        this.splash.setText(Constants.APP_NAME);
        Utils.setShellIcon(this.splash);
        this.splash.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas((Composite)this.splash, 0x20000000);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.background = imageLoader.getImage(IMG_SPLASH);
        if (ImageLoader.isRealImage(this.background)) {
            this.width = this.background.getBounds().width;
            this.height = this.background.getBounds().height;
        } else {
            this.width = 400;
            this.height = 80;
            this.background = new Image((Device)this.display, this.width, this.height);
            GC gc = new GC((Drawable)this.background);
            try {
                gc.setBackground(ColorCache.getColor((Device)this.display, 255, 255, 255));
                gc.fillRectangle(0, 0, this.width, this.height);
                gc.drawRectangle(0, 0, this.width - 1, this.height - 1);
                gc.drawText(Constants.APP_NAME, 5, 5, true);
            }
            finally {
                gc.dispose();
            }
        }
        this.current = new Image((Device)this.display, this.background, 0);
        this.progressBarColor = new Color((Device)this.display, 21, 92, 198);
        this.textColor = new Color((Device)this.display, 90, 90, 90);
        this.fadedGreyColor = new Color((Device)this.display, 170, 170, 170);
        this.pbX = 10;
        this.pbY = this.height - 12;
        this.pbWidth = this.width - 10 - 139;
        this.canvas.setSize(this.width, this.height);
        Font font = this.canvas.getFont();
        FontData[] fdata = font.getFontData();
        fdata[0].setHeight(Constants.isOSX ? 9 : 7);
        this.textFont = new Font((Device)this.display, fdata);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event2) {
                if (SplashWindow.this.current == null) {
                    return;
                }
                event2.gc.drawImage(SplashWindow.this.current, 0, 0);
            }
        });
        this.splash.setSize(this.width, this.height);
        Utils.centreWindow(this.splash);
        this.splash.open();
        if (initializer != null) {
            initializer.addListener(this);
        }
    }

    public static void create(final Display display, final Initializer initializer) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (display == null || display.isDisposed()) {
                    return;
                }
                new SplashWindow(display, initializer);
            }
        });
    }

    public void closeSplash() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    if (SplashWindow.this.initializer != null) {
                        SplashWindow.this.initializer.removeListener(SplashWindow.this);
                    }
                    if (SplashWindow.this.splash != null && !SplashWindow.this.splash.isDisposed()) {
                        SplashWindow.this.splash.dispose();
                    }
                    if (SplashWindow.this.current != null && !SplashWindow.this.current.isDisposed()) {
                        SplashWindow.this.current.dispose();
                    }
                    if (SplashWindow.this.progressBarColor != null && !SplashWindow.this.progressBarColor.isDisposed()) {
                        SplashWindow.this.progressBarColor.dispose();
                    }
                    if (SplashWindow.this.fadedGreyColor != null && !SplashWindow.this.fadedGreyColor.isDisposed()) {
                        SplashWindow.this.fadedGreyColor.dispose();
                    }
                    if (SplashWindow.this.textColor != null && !SplashWindow.this.textColor.isDisposed()) {
                        SplashWindow.this.textColor.dispose();
                    }
                    if (SplashWindow.this.textFont != null && !SplashWindow.this.textFont.isDisposed()) {
                        SplashWindow.this.textFont.dispose();
                    }
                    ImageLoader imageLoader = ImageLoader.getInstance();
                    imageLoader.releaseImage(SplashWindow.IMG_SPLASH);
                    imageLoader.collectGarbage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void reportCurrentTask(String task2) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if (this.task == null || this.task.compareTo(task2) != 0) {
            this.task = task2;
            this.update();
        }
    }

    private void update() {
        if (this.updating && !Utils.isThisThreadSWT()) {
            return;
        }
        this.updating = true;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SplashWindow.this.updating = false;
                if (SplashWindow.this.splash == null || SplashWindow.this.splash.isDisposed()) {
                    return;
                }
                Image newCurrent = new Image((Device)SplashWindow.this.display, SplashWindow.this.background, 0);
                GC gc = new GC((Drawable)newCurrent);
                try {
                    gc.setAntialias(1);
                    gc.setTextAntialias(1);
                }
                catch (Exception e) {
                    // empty catch block
                }
                int y = SplashWindow.this.pbY;
                if (SplashWindow.this.task != null) {
                    gc.setFont(SplashWindow.this.textFont);
                    gc.setForeground(SplashWindow.this.textColor);
                    Point extent = gc.textExtent(SplashWindow.this.task);
                    y = SplashWindow.this.pbY - extent.y - 5;
                    gc.setClipping(10, y, SplashWindow.this.width - 20, extent.y);
                    gc.drawText(SplashWindow.this.task, 10, y, true);
                    gc.setClipping((Rectangle)null);
                }
                gc.setForeground(SplashWindow.this.fadedGreyColor);
                gc.setBackground(SplashWindow.this.fadedGreyColor);
                gc.fillRectangle(SplashWindow.this.pbX - 0, SplashWindow.this.pbY + Math.abs(0) / 2, SplashWindow.this.pbWidth + 0, 2);
                gc.setForeground(SplashWindow.this.progressBarColor);
                gc.setBackground(SplashWindow.this.progressBarColor);
                gc.fillRectangle(SplashWindow.this.pbX, SplashWindow.this.pbY, SplashWindow.this.percent * SplashWindow.this.pbWidth / 100, 2);
                Image old = SplashWindow.this.current;
                SplashWindow.this.current = newCurrent;
                if (old != null && !old.isDisposed()) {
                    old.dispose();
                }
                gc.dispose();
                SplashWindow.this.canvas.redraw(0, y, SplashWindow.this.width, SplashWindow.this.height - y, true);
                SplashWindow.this.canvas.update();
            }
        });
    }

    public int getPercent() {
        return this.percent;
    }

    public void reportPercent(int percent) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if (percent > 100) {
            this.closeSplash();
            return;
        }
        if (this.percent != percent) {
            this.percent = percent;
            this.update();
        }
    }
}

