/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.OpenTorrentWindow;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class TorrentOpener {
    public static void openTorrent(String torrentFile) {
        TorrentOpener.openTorrentWindow(null, new String[]{torrentFile}, false);
    }

    public static void openTorrents(String[] torrentFiles) {
        TorrentOpener.openTorrentWindow(null, torrentFiles, false);
    }

    public static void openTorrentWindow() {
        TorrentOpener.openTorrentWindow(null, null, false);
    }

    protected static void openTorrentsForTracking(final String path, final String[] fileNames) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Display display = SWTThread.getInstance().getDisplay();
                if (display == null || display.isDisposed() || core == null) {
                    return;
                }
                new AEThread("TorrentOpener"){

                    public void runSupport() {
                        for (int i = 0; i < fileNames.length; ++i) {
                            try {
                                TOTorrent t = TorrentUtils.readFromFile(new File(path, fileNames[i]), true);
                                core.getTrackerHost().hostTorrent(t, true, true);
                                continue;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert(false, "Torrent open fails for '" + path + File.separator + fileNames[i] + "'", e));
                            }
                        }
                    }
                }.start();
            }
        });
    }

    public static void openTorrentTrackingOnly() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Shell shell = Utils.findAnyShell();
                if (shell == null) {
                    return;
                }
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path == null) {
                    return;
                }
                TorrentOpener.openTorrentsForTracking(path, fDialog.getFileNames());
            }
        });
    }

    public static void openTorrentSimple() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Shell shell = Utils.findAnyShell();
                if (shell == null) {
                    return;
                }
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path == null) {
                    return;
                }
                TorrentOpener.openTorrentWindow(path, fDialog.getFileNames(), false);
            }
        });
    }

    public static void openDroppedTorrents(DropTargetEvent event2, final boolean bAllowShareAdd) {
        boolean bOverrideToStopped;
        if (event2.data == null) {
            return;
        }
        boolean bl = bOverrideToStopped = event2.detail == 1;
        if (event2.data instanceof String[] || event2.data instanceof String) {
            String[] stringArray;
            if (event2.data instanceof String[]) {
                stringArray = (String[])event2.data;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)event2.data;
            }
            String[] sourceNames = stringArray;
            if (sourceNames == null) {
                event2.detail = 0;
            }
            if (event2.detail == 0) {
                return;
            }
            for (int i = 0; i < sourceNames.length; ++i) {
                final File source = new File(sourceNames[i]);
                String sURL = UrlUtils.parseTextForURL(sourceNames[i], true);
                if (sURL != null && !source.exists()) {
                    TorrentOpener.openTorrentWindow(null, new String[]{sURL}, bOverrideToStopped);
                    continue;
                }
                if (source.isFile()) {
                    new AEThread2("asyncOpen", true){

                        public void run() {
                            String filename = source.getAbsolutePath();
                            VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                            if (vfh.loadAndHandleVuzeFile(filename, 0) != null) {
                                return;
                            }
                            try {
                                if (!TorrentUtils.isTorrentFile(filename) && bAllowShareAdd) {
                                    Logger.log(new LogEvent(LogIDs.GUI, "openDroppedTorrents: file not a torrent file, sharing"));
                                    ShareUtils.shareFile(filename);
                                } else {
                                    TorrentOpener.openTorrentWindow(null, new String[]{filename}, bOverrideToStopped);
                                }
                            }
                            catch (Exception e) {
                                Logger.log(new LogAlert(true, "Torrent open fails for '" + filename + "'", e));
                            }
                        }
                    }.start();
                    continue;
                }
                if (!source.isDirectory()) continue;
                String dir_name = source.getAbsolutePath();
                if (!bAllowShareAdd) {
                    TorrentOpener.openTorrentWindow(dir_name, null, bOverrideToStopped);
                    continue;
                }
                String drop_action = COConfigurationManager.getStringParameter("config.style.dropdiraction");
                if (drop_action.equals("1")) {
                    ShareUtils.shareDir(dir_name);
                    continue;
                }
                if (drop_action.equals("2")) {
                    ShareUtils.shareDirContents(dir_name, false);
                    continue;
                }
                if (drop_action.equals("3")) {
                    ShareUtils.shareDirContents(dir_name, true);
                    continue;
                }
                TorrentOpener.openTorrentWindow(dir_name, null, bOverrideToStopped);
            }
        } else if (event2.data instanceof URLTransfer.URLType) {
            TorrentOpener.openTorrentWindow(null, new String[]{((URLTransfer.URLType)event2.data).linkURL}, bOverrideToStopped);
        }
    }

    public static String getFilterPathData() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.data");
        if (before != null && before.length() > 0) {
            return before;
        }
        try {
            String def = COConfigurationManager.getDirectoryParameter("Default save path");
            return def;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getFilterPathTorrent() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent");
        if (before != null && before.length() > 0) {
            return before;
        }
        return COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
    }

    public static String setFilterPathData(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.data")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.data", now);
                COConfigurationManager.save();
            }
        }
        return path;
    }

    public static String setFilterPathTorrent(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.torrent", now);
                COConfigurationManager.save();
            }
            return now;
        }
        return path;
    }

    private static void openTorrentWindow(final String path, final String[] torrents, final boolean bOverrideStartModeToStopped) {
        new AEThread2("openTorrentWindow", true){

            public void run() {
                TorrentOpener._openTorrentWindow(path, torrents, bOverrideStartModeToStopped);
            }
        }.start();
    }

    private static void _openTorrentWindow(final String path, String[] torrents, final boolean bOverrideStartModeToStopped) {
        if (torrents != null && torrents.length > 0) {
            VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
            ArrayList<String> non_vuze_files = new ArrayList<String>();
            ArrayList<VuzeFile> vuze_files = new ArrayList<VuzeFile>();
            for (int i = 0; i < torrents.length; ++i) {
                String torrent = torrents[i];
                try {
                    VuzeFile vf = vfh.loadVuzeFile(torrent);
                    if (vf == null) {
                        non_vuze_files.add(torrent);
                        continue;
                    }
                    vuze_files.add(vf);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    non_vuze_files.add(torrent);
                }
            }
            if (vuze_files.size() > 0) {
                VuzeFile[] vfs = new VuzeFile[vuze_files.size()];
                vuze_files.toArray(vfs);
                vfh.handleFiles(vfs, 0);
            }
            if (non_vuze_files.size() == 0 && vuze_files.size() > 0) {
                return;
            }
            String[] t = new String[non_vuze_files.size()];
            non_vuze_files.toArray(t);
            torrents = t;
        }
        final String[] f_torrents = torrents;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Shell shell = Utils.findAnyShell();
                if (!AzureusCoreFactory.isCoreRunning()) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            if (UIFunctionsManager.getUIFunctions() == null) {
                                core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                                    public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                                        if (component instanceof UIFunctionsSWT) {
                                            TorrentOpener.openTorrentWindow(path, f_torrents, bOverrideStartModeToStopped);
                                        }
                                    }
                                });
                            } else {
                                TorrentOpener.openTorrentWindow(path, f_torrents, bOverrideStartModeToStopped);
                            }
                        }
                    });
                }
                if (shell == null) {
                    Debug.out("openTorrentWindow().. no shell");
                    return;
                }
                OpenTorrentWindow.invoke(shell, AzureusCoreFactory.getSingleton().getGlobalManager(), path, f_torrents, bOverrideStartModeToStopped, false, false);
            }
        });
    }
}

