/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.shells.SimpleBrowserWindow;
import org.gudy.azureus2.ui.swt.update.FullUpdateWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;

public class UIFunctionsImpl
implements UIFunctionsSWT {
    private final MainWindow mainwindow;

    public UIFunctionsImpl(MainWindow mainwindow) {
        this.mainwindow = mainwindow;
    }

    public void bringToFront() {
        this.bringToFront(true);
    }

    public void bringToFront(final boolean tryTricks) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.setVisible(true, tryTricks);
            }
        });
    }

    public void addPluginView(final PluginView view) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                PluginsMenuHelper.getInstance().addPluginView(view, view.getPluginViewName());
            }
        });
    }

    public void openPluginView(final PluginView view) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.openPluginView(view, view.getPluginViewName());
            }
        });
    }

    public void removePluginView(final PluginView view) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                PluginsMenuHelper.getInstance().removePluginView(view, view.getPluginViewName());
            }
        });
    }

    private void showStats() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showStats();
            }
        });
    }

    private void showStatsDHT() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showStatsDHT();
            }
        });
    }

    private void showStatsTransfers() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showStatsTransfers();
            }
        });
    }

    public Shell getMainShell() {
        return this.mainwindow.getShell();
    }

    public void addPluginView(final UISWTPluginView view) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                PluginsMenuHelper.getInstance().addPluginView(view, view.getPluginViewName());
            }
        });
    }

    public void openPluginView(final UISWTPluginView view) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.openPluginView(view, view.getPluginViewName());
            }
        });
    }

    public void removePluginView(final UISWTPluginView view) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                PluginsMenuHelper.getInstance().removePluginView(view, view.getPluginViewName());
            }
        });
    }

    public boolean showConfig(String string) {
        return this.mainwindow.showConfig(string);
    }

    public void addPluginView(final String viewID, final UISWTViewEventListener l) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                PluginsMenuHelper.getInstance().addPluginView(viewID, l);
            }
        });
    }

    public void refreshLanguage() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.setSelectedLanguageItem();
            }
        });
    }

    public void closeDownloadBars() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                MiniBarManager.getManager().closeAll();
            }
        });
    }

    public boolean isGlobalTransferBarShown() {
        return AllTransfersBar.getManager().isOpen(this.mainwindow.getGlobalManager());
    }

    public void showGlobalTransferBar() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                AllTransfersBar.open(UIFunctionsImpl.this.mainwindow.getGlobalManager(), UIFunctionsImpl.this.mainwindow.getShell());
            }
        });
    }

    public void closeGlobalTransferBar() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                AllTransfersBar.close(UIFunctionsImpl.this.mainwindow.getGlobalManager());
            }
        });
    }

    public UISWTInstanceImpl getSWTPluginInstanceImpl() {
        return this.mainwindow.getUISWTInstanceImpl();
    }

    public void openManagerView(final DownloadManager dm) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.openManagerView(dm);
            }
        });
    }

    public void refreshIconBar() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.refreshIconBar();
            }
        });
    }

    public void removeManagerView(final DownloadManager dm) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.removeManagerView(dm);
            }
        });
    }

    private void showMyTracker() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showMyTracker();
            }
        });
    }

    public void closePluginView(final IView view) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.closePluginView(view);
            }
        });
    }

    public UISWTView[] getPluginViews() {
        return this.mainwindow.getPluginViews();
    }

    public void openPluginView(final String sParentID, final String sViewID, final UISWTViewEventListener l, final Object dataSource, final boolean bSetFocus) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.openPluginView(sParentID, sViewID, l, dataSource, bSetFocus, false);
            }
        });
    }

    public void removePluginView(final String viewID) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                PluginsMenuHelper.getInstance().removePluginViews(viewID);
            }
        });
    }

    public void setStatusText(final String string) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.setStatusText(string);
            }
        });
    }

    public void setStatusText(final int statustype, final String string, final UIStatusTextClickListener l) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.setStatusText(statustype, string, l);
            }
        });
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        return this.mainwindow.dispose(for_restart, close_already_in_progress);
    }

    public Menu getMenu(int id) {
        if (this.mainwindow.getMenu() != null) {
            return this.mainwindow.getMenu().getMenu(id);
        }
        return null;
    }

    public void closePluginViews(final String sViewID) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.closePluginViews(sViewID);
            }
        });
    }

    public void openPluginView(final AbstractIView view, final String name) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.openPluginView(view, name);
            }
        });
    }

    private void showMyShares() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showMyShares();
            }
        });
    }

    private void showMyTorrents() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showMyTorrents();
            }
        });
    }

    private void showDetailedListView() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showDetailedListView();
            }
        });
    }

    private void showAllPeersView() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showAllPeersView();
            }
        });
    }

    private void showMultiOptionsView(final DownloadManager[] dms) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showMultiOptionsView(dms);
            }
        });
    }

    private void showConsole() {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                UIFunctionsImpl.this.mainwindow.showConsole();
            }
        });
    }

    public UISWTInstance getUISWTInstance() {
        return this.mainwindow.getUISWTInstanceImpl();
    }

    public void viewURL(String url, String target, String sourceRef) {
        this.viewURL(url, target, 0.9, 0.9, true, false);
    }

    public boolean viewURL(final String url, String target, final int w, final int h, final boolean allowResize, final boolean isModal) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SimpleBrowserWindow window = new SimpleBrowserWindow(UIFunctionsImpl.this.mainwindow.getShell(), url, w, h, allowResize, isModal);
                window.waitUntilClosed();
            }
        });
        return true;
    }

    public boolean viewURL(final String url, String target, final double w, final double h, final boolean allowResize, final boolean isModal) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SimpleBrowserWindow window = new SimpleBrowserWindow(UIFunctionsImpl.this.mainwindow.getShell(), url, w, h, allowResize, isModal);
                window.waitUntilClosed();
            }
        });
        return true;
    }

    public int promptUser(String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean rememberByDefault, int autoCloseInMS) {
        return MessageBoxShell.open(this.getMainShell(), title, text, buttons, defaultOption, rememberID, rememberText, rememberByDefault, autoCloseInMS);
    }

    public UIFunctionsUserPrompter getUserPrompter(String title, String text, String[] buttons, int defaultOption) {
        MessageBoxShell mb = new MessageBoxShell(this.getMainShell(), title, text, buttons, defaultOption);
        return mb;
    }

    public void refreshTorrentMenu() {
        this.mainwindow.refreshTorrentMenu();
    }

    public MainStatusBar getMainStatusBar() {
        return this.mainwindow.getMainStatusBar();
    }

    public IMainMenu createMainMenu(Shell shell) {
        return new MainMenu(shell);
    }

    public IMainWindow getMainWindow() {
        return this.mainwindow;
    }

    public UIUpdater getUIUpdater() {
        return UIUpdaterSWT.getInstance();
    }

    public void closeAllDetails() {
        this.mainwindow.closeAllDetails();
    }

    public boolean hasDetailViews() {
        return this.mainwindow.hasDetailViews();
    }

    public void openView(int viewID, Object datasource) {
        switch (viewID) {
            case 0: {
                this.showConsole();
                break;
            }
            case 10: {
                this.showAllPeersView();
                break;
            }
            case 4: {
                this.showConfig(datasource instanceof String ? (String)datasource : null);
                break;
            }
            case 5: {
                if (!(datasource instanceof DownloadManager)) break;
                this.openManagerView((DownloadManager)datasource);
                break;
            }
            case 6: {
                if (!(datasource instanceof DownloadManager[])) break;
                DownloadManager[] dms = (DownloadManager[])datasource;
                this.showMultiOptionsView(dms);
                break;
            }
            case 7: {
                this.showMyShares();
                break;
            }
            case 8: {
                this.showMyTorrents();
                break;
            }
            case 9: {
                this.showMyTracker();
                break;
            }
            case 1: {
                if ("dht".equals(datasource)) {
                    this.showStatsDHT();
                    break;
                }
                if ("transfers".equals(datasource)) {
                    this.showStatsTransfers();
                    break;
                }
                this.showStats();
                break;
            }
            case 11: {
                this.showDetailedListView();
                break;
            }
        }
    }

    public void performAction(int action_id, Object args, UIFunctions.actionListener listener) {
        if (action_id == 1) {
            FullUpdateWindow.handleUpdate((String)args, listener);
        } else {
            Debug.out("Unknown action " + action_id);
        }
    }

    public Shell showCoreWaitDlg() {
        Shell activeShell = Display.getDefault().getActiveShell();
        if (activeShell == null) {
            activeShell = Utils.findAnyShell();
        }
        Shell shell = new Shell(activeShell, 67616);
        shell.setText("Please Wait");
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        shell.setLayout((Layout)fillLayout);
        Label label = new Label((Composite)shell, 0);
        label.setText("Your operation will run momentarily");
        shell.pack();
        Utils.centreWindow(shell);
        shell.open();
        return shell;
    }

    public void doSearch(String searchText) {
    }
}

