/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.osx;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.IOException;
import java.lang.reflect.Method;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.AEDesc;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.macosx.access.jnilib.OSXAccess;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.help.AboutWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.nat.NatTestWindow;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestWizard;

public class CarbonUIEnhancer {
    private static final int kHICommandPreferences = 1886545254;
    private static final int kHICommandAbout = 1633841013;
    private static final int kHICommandServices = 1936028278;
    private static final int kHICommandWizard = 1635410798;
    private static final int kHICommandNatTest = 1635413620;
    private static final int kHICommandSpeedTest = 1635414900;
    private static final int kHICommandRestart = 1635414643;
    private static final int typeAEList = 1818850164;
    private static final int kCoreEventClass = 1634039412;
    private static final int kAEOpenDocuments = 1868853091;
    private static final int kAEReopenApplication = 1918988400;
    private static final int kAEOpenContents = 1868787566;
    private static final int kURLEventClass = 1196773964;
    private static final int typeText = 0x54455854;
    private static final String RESOURCE_BUNDLE = "org.eclipse.ui.carbon.Messages";
    private static String fgAboutActionName;
    private static String fgWizardActionName;
    private static String fgNatTestActionName;
    private static String fgRestartActionName;
    private static String fgSpeedTestActionName;
    private static int memmove_type;
    private boolean isAZ3 = "az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"));
    public static final int BOUNCE_SINGLE = 10;
    public static final int BOUNCE_CONTINUOUS = 0;
    static final Object target;

    public CarbonUIEnhancer() {
        if (fgAboutActionName == null) {
            fgAboutActionName = MessageText.getString("MainWindow.menu.help.about").replaceAll("&", "");
        }
        if (!this.isAZ3) {
            if (fgWizardActionName == null) {
                fgWizardActionName = MessageText.getString("MainWindow.menu.file.configure").replaceAll("&", "");
            }
            if (fgNatTestActionName == null) {
                fgNatTestActionName = MessageText.getString("MainWindow.menu.tools.nattest").replaceAll("&", "");
            }
            if (fgSpeedTestActionName == null) {
                fgSpeedTestActionName = MessageText.getString("MainWindow.menu.tools.speedtest").replaceAll("&", "");
            }
        }
        if (fgRestartActionName == null) {
            fgRestartActionName = MessageText.getString("MainWindow.menu.file.restart").replaceAll("&", "");
        }
        this.earlyStartup();
        this.registerTorrentFile();
    }

    public static void registerToolbarToggle(Shell shell) {
        final Callback toolbarToggleCB = new Callback(target, "toolbarToggle", 3);
        int toolbarToggle = toolbarToggleCB.getAddress();
        if (toolbarToggle == 0) {
            Debug.out("OSX: Could not find callback 'toolbarToggle'");
            toolbarToggleCB.dispose();
            return;
        }
        shell.getDisplay().disposeExec(new Runnable(){

            public void run() {
                toolbarToggleCB.dispose();
            }
        });
        int windowHandle = OS.GetControlOwner((int)shell.handle);
        OS.ChangeWindowAttributes((int)windowHandle, (int)64, (int)0);
        int[] mask = new int[]{2003398244, 150};
        OS.InstallEventHandler((int)OS.GetApplicationEventTarget(), (int)toolbarToggle, (int)(mask.length / 2), (int[])mask, (int)0, null);
    }

    private void registerTorrentFile() {
        int result;
        Callback clickDockIconCallback = new Callback(target, "clickDockIcon", 3);
        int clickDocIcon = clickDockIconCallback.getAddress();
        if (clickDocIcon == 0) {
            clickDockIconCallback.dispose();
        } else {
            result = OS.AEInstallEventHandler((int)1634039412, (int)1918988400, (int)clickDocIcon, (int)0, (boolean)false);
            if (result != 0) {
                Debug.out("OSX: Could Install ReopenApplication Event Handler. Error: " + result);
            }
        }
        Callback openContentsCallback = new Callback(target, "openContents", 3);
        int openContents = openContentsCallback.getAddress();
        if (openContents == 0) {
            openContentsCallback.dispose();
        } else {
            result = OS.AEInstallEventHandler((int)1634039412, (int)1868787566, (int)openContents, (int)0, (boolean)false);
            if (result != 0) {
                Debug.out("OSX: Could Install OpenContents Event Handler. Error: " + result);
            }
        }
        Callback openDocCallback = new Callback(target, "openDocProc", 3);
        int openDocProc = openDocCallback.getAddress();
        if (openDocProc == 0) {
            Debug.out("OSX: Could not find Callback 'openDocProc'");
            openDocCallback.dispose();
            return;
        }
        result = OS.AEInstallEventHandler((int)1634039412, (int)1868853091, (int)openDocProc, (int)0, (boolean)false);
        if (result != 0) {
            Debug.out("OSX: Could not Install OpenDocs Event Handler. Error: " + result);
            return;
        }
        result = OS.AEInstallEventHandler((int)1196773964, (int)1196773964, (int)openDocProc, (int)0, (boolean)false);
        if (result != 0) {
            Debug.out("OSX: Could not Install URLEventClass Event Handler. Error: " + result);
            return;
        }
        Callback quitAppCallback = new Callback(target, "quitAppProc", 3);
        int quitAppProc = quitAppCallback.getAddress();
        if (quitAppProc == 0) {
            Debug.out("OSX: Could not find Callback 'quitApp'");
            quitAppCallback.dispose();
        } else {
            result = OS.AEInstallEventHandler((int)1634039412, (int)1903520116, (int)quitAppProc, (int)0, (boolean)false);
            if (result != 0) {
                Debug.out("OSX: Could not install QuitApplication Event Handler. Error: " + result);
            }
        }
        int appTarget = OS.GetApplicationEventTarget();
        Callback appleEventCallback = new Callback((Object)this, "appleEventProc", 3);
        int appleEventProc = appleEventCallback.getAddress();
        int[] mask3 = new int[]{1701867619, 1, 1196773964, 1918988400, 1868787566};
        result = OS.InstallEventHandler((int)appTarget, (int)appleEventProc, (int)(mask3.length / 2), (int[])mask3, (int)0, null);
        if (result != 0) {
            Debug.out("OSX: Could Install Event Handler. Error: " + result);
            return;
        }
    }

    public void earlyStartup() {
        final Display display = Display.getDefault();
        display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                CarbonUIEnhancer.this.hookApplicationMenu(display);
            }
        });
    }

    public void hookApplicationMenu(final Display display) {
        Object target = new Object(){

            int commandProc(int nextHandler, int theEvent, int userData) {
                if (OS.GetEventKind((int)theEvent) == 1) {
                    HICommand command = new HICommand();
                    OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)1751346532, null, (int)14, null, (HICommand)command);
                    switch (command.commandID) {
                        case 1886545254: {
                            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                            if (uiFunctions != null) {
                                uiFunctions.openView(4, null);
                            }
                            return 0;
                        }
                        case 1633841013: {
                            AboutWindow.show(display);
                            return 0;
                        }
                        case 1635414643: {
                            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                            if (uiFunctions != null) {
                                uiFunctions.dispose(true, false);
                            }
                            return 0;
                        }
                        case 1635410798: {
                            new ConfigureWizard(false);
                            return 0;
                        }
                        case 1635413620: {
                            new NatTestWindow();
                            return 0;
                        }
                        case 1635414900: {
                            new SpeedTestWizard();
                            return 0;
                        }
                        case 1903520116: {
                            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                            if (uiFunctions != null) {
                                uiFunctions.dispose(false, false);
                                return 0;
                            }
                            UIExitUtilsSWT.setSkipCloseCheck(true);
                        }
                    }
                }
                return -9874;
            }
        };
        final Callback commandCallback = new Callback(target, "commandProc", 3);
        int commandProc = commandCallback.getAddress();
        if (commandProc == 0) {
            commandCallback.dispose();
            return;
        }
        int[] mask = new int[]{1668113523, 1};
        OS.InstallEventHandler((int)OS.GetApplicationEventTarget(), (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)0, null);
        int[] outMenu = new int[1];
        short[] outIndex = new short[1];
        if (OS.GetIndMenuItemWithCommandID((int)0, (int)1886545254, (int)1, (int[])outMenu, (short[])outIndex) == 0 && outMenu[0] != 0) {
            int menu = outMenu[0];
            int l = fgAboutActionName.length();
            char[] buffer = new char[l];
            fgAboutActionName.getChars(0, l, buffer, 0);
            int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)0, (int)0, (int)1633841013);
            OS.CFRelease((int)str);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)0, (short)1, (int)64, (int)0);
            OS.EnableMenuCommand((int)menu, (int)1886545254);
            OS.DisableMenuCommand((int)menu, (int)1936028278);
            if (!this.isAZ3) {
                l = fgWizardActionName.length();
                buffer = new char[l];
                fgWizardActionName.getChars(0, l, buffer, 0);
                str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
                OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)3, (int)0, (int)1635410798);
                OS.CFRelease((int)str);
                l = fgNatTestActionName.length();
                buffer = new char[l];
                fgNatTestActionName.getChars(0, l, buffer, 0);
                str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
                OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)4, (int)0, (int)1635413620);
                OS.CFRelease((int)str);
                l = fgSpeedTestActionName.length();
                buffer = new char[l];
                fgSpeedTestActionName.getChars(0, l, buffer, 0);
                str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
                OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)5, (int)0, (int)1635414900);
                OS.CFRelease((int)str);
            }
            OS.InsertMenuItemTextWithCFString((int)menu, (int)0, (short)6, (int)64, (int)0);
            l = fgRestartActionName.length();
            buffer = new char[l];
            fgRestartActionName.getChars(0, l, buffer, 0);
            str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)str, (short)7, (int)0, (int)1635414643);
            OS.CFRelease((int)str);
            OS.InsertMenuItemTextWithCFString((int)menu, (int)0, (short)8, (int)64, (int)0);
        }
        display.disposeExec((Runnable)new AERunnable(){

            public void runSupport() {
                commandCallback.dispose();
            }
        });
    }

    private static void stopSidekick() {
        try {
            Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell application \"Azureus\" to quit"});
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
    }

    int appleEventProc(int nextHandler, int theEvent, int userData) {
        int eventClass = OS.GetEventClass((int)theEvent);
        if (eventClass == 1701867619) {
            int[] aeEventID = new int[1];
            if (OS.GetEventParameter((int)theEvent, (int)1702261865, (int)1954115685, null, (int)4, null, (int[])aeEventID) != 0) {
                return -9874;
            }
            if (aeEventID[0] != 1868853091 && aeEventID[0] != 1196773964 && aeEventID[0] != 1918988400 && aeEventID[0] != 1868787566 && aeEventID[0] != 1903520116) {
                return -9874;
            }
            EventRecord eventRecord = new EventRecord();
            OS.ConvertEventRefToEventRecord((int)theEvent, (EventRecord)eventRecord);
            OS.AEProcessAppleEvent((EventRecord)eventRecord);
            return 0;
        }
        return -9874;
    }

    private static String OSXtoString(int i) {
        char[] c = new char[]{(char)(i >> 24 & 0xFF), (char)(i >> 16 & 0xFF), (char)(i >> 8 & 0xFF), (char)(i & 0xFF)};
        return new String(c);
    }

    private static void memmove(byte[] dest, int src, int size) {
        switch (memmove_type) {
            case 0: {
                try {
                    OSXAccess.memmove(dest, src, size);
                    memmove_type = 0;
                    return;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            case 1: {
                try {
                    Class<?> cMemMove = Class.forName("org.eclipse.swt.internal.carbon.OS");
                    Method method = cMemMove.getMethod("memmove", byte[].class, Integer.TYPE, Integer.TYPE);
                    method.invoke(null, dest, new Integer(src), new Integer(size));
                    memmove_type = 1;
                    return;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            case 2: {
                try {
                    Class<?> cMemMove = Class.forName("org.eclipse.swt.internal.carbon.OS");
                    Method method = cMemMove.getMethod("memcpy", byte[].class, Integer.TYPE, Integer.TYPE);
                    method.invoke(null, dest, new Integer(src), new Integer(size));
                    memmove_type = 2;
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        memmove_type = 3;
    }

    static {
        memmove_type = 0;
        target = new Object(){

            int quitAppProc(int theAppleEvent, int reply, int handlerRefcon) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.dispose(false, false);
                } else {
                    UIExitUtilsSWT.setSkipCloseCheck(true);
                    Display.getDefault().dispose();
                }
                return 0;
            }

            int openDocProc(int theAppleEvent, int reply, int handlerRefcon) {
                AEDesc aeDesc = new AEDesc();
                EventRecord eventRecord = new EventRecord();
                OS.ConvertEventRefToEventRecord((int)theAppleEvent, (EventRecord)eventRecord);
                try {
                    int result = OSXAccess.AEGetParamDesc(theAppleEvent, 0x2D2D2D2D, 1818850164, aeDesc);
                    if (result != 0) {
                        Debug.out("OSX: Could call AEGetParamDesc. Error: " + result);
                        return 0;
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    Debug.out("OSX: AEGetParamDesc not available.  Can't open sent file");
                    return 0;
                }
                int[] count = new int[1];
                OS.AECountItems((AEDesc)aeDesc, (int[])count);
                if (count[0] > 0) {
                    String[] fileNames = new String[count[0]];
                    int maximumSize = 80;
                    int dataPtr = OS.NewPtr((int)maximumSize);
                    int[] aeKeyword = new int[1];
                    int[] typeCode = new int[1];
                    int[] actualSize = new int[1];
                    for (int i = 0; i < count[0]; ++i) {
                        if (OS.AEGetNthPtr((AEDesc)aeDesc, (int)(i + 1), (int)1718841958, (int[])aeKeyword, (int[])typeCode, (int)dataPtr, (int)maximumSize, (int[])actualSize) == 0) {
                            byte[] fsRef = new byte[actualSize[0]];
                            CarbonUIEnhancer.memmove(fsRef, dataPtr, actualSize[0]);
                            int dirUrl = OS.CFURLCreateFromFSRef((int)0, (byte[])fsRef);
                            int dirString = OS.CFURLCopyFileSystemPath((int)dirUrl, (int)0);
                            OS.CFRelease((int)dirUrl);
                            int length = OS.CFStringGetLength((int)dirString);
                            char[] buffer = new char[length];
                            CFRange range = new CFRange();
                            range.length = length;
                            OS.CFStringGetCharacters((int)dirString, (CFRange)range, (char[])buffer);
                            OS.CFRelease((int)dirString);
                            fileNames[i] = new String(buffer);
                        }
                        if (OS.AEGetNthPtr((AEDesc)aeDesc, (int)(i + 1), (int)0x54455854, (int[])aeKeyword, (int[])typeCode, (int)dataPtr, (int)maximumSize, (int[])actualSize) != 0) continue;
                        byte[] urlRef = new byte[actualSize[0]];
                        CarbonUIEnhancer.memmove(urlRef, dataPtr, actualSize[0]);
                        fileNames[i] = new String(urlRef);
                    }
                    TorrentOpener.openTorrents(fileNames);
                }
                return 0;
            }

            int clickDockIcon(int nextHandler, int theEvent, int userData) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.bringToFront();
                    return 0;
                }
                return -9874;
            }

            int openContents(int nextHandler, int theEvent, int userData) {
                Debug.out("openDocContents");
                return 0;
            }

            int toolbarToggle(int nextHandler, int theEvent, int userData) {
                int eventKind = OS.GetEventKind((int)theEvent);
                if (eventKind != 150) {
                    return -9874;
                }
                int[] theWindow = new int[1];
                OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)2003398244, null, (int)4, null, (int[])theWindow);
                int[] theRoot = new int[1];
                OS.GetRootControl((int)theWindow[0], (int[])theRoot);
                final Widget widget = Display.getCurrent().findWidget(theRoot[0]);
                if (!(widget instanceof Shell)) {
                    return -9874;
                }
                final Shell shellAffected = (Shell)widget;
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        Long l = (Long)shellAffected.getData("OSX.ToolBarToggle");
                        int type = l == null || l == 0L ? 18 : 17;
                        Event event2 = new Event();
                        event2.type = type;
                        event2.display = widget.getDisplay();
                        event2.widget = widget;
                        shellAffected.notifyListeners(type, event2);
                        shellAffected.setData("OSX.ToolBarToggle", (Object)new Long(type == 18 ? 1L : 0L));
                    }
                });
                return 0;
            }
        };
    }
}

