/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.config.EnablerParameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ActionParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ColorParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.DirectoryParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.HyperlinkParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.InfoParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.LabelParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterGroupImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterImplListener;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PasswordParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringListParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.UIParameterImpl;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ButtonParameter;
import org.gudy.azureus2.ui.swt.config.ColorParameter;
import org.gudy.azureus2.ui.swt.config.DirectoryParameter;
import org.gudy.azureus2.ui.swt.config.DualChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.FileParameter;
import org.gudy.azureus2.ui.swt.config.InfoParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.LinkParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.PasswordParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.config.UISWTParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.plugins.UISWTParameterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPluginConfigImpl
implements UISWTConfigSection {
    protected WeakReference<BasicPluginConfigModel> model_ref;
    protected String parent_section;
    protected String section;

    public BasicPluginConfigImpl(WeakReference<BasicPluginConfigModel> _model_ref) {
        this.model_ref = _model_ref;
        BasicPluginConfigModel model = (BasicPluginConfigModel)this.model_ref.get();
        this.parent_section = model.getParentSection();
        this.section = model.getSection();
    }

    @Override
    public String configSectionGetParentSection() {
        if (this.parent_section == null || this.parent_section.length() == 0) {
            return "root";
        }
        return this.parent_section;
    }

    @Override
    public String configSectionGetName() {
        return this.section;
    }

    @Override
    public void configSectionSave() {
    }

    @Override
    public void configSectionDelete() {
    }

    @Override
    public int maxUserMode() {
        BasicPluginConfigModel model = (BasicPluginConfigModel)this.model_ref.get();
        org.gudy.azureus2.plugins.ui.config.Parameter[] parameters = model.getParameters();
        int max_mode = 0;
        for (int i = 0; i < parameters.length; ++i) {
            ParameterImpl param = (ParameterImpl)parameters[i];
            if (param.getMinimumRequiredUserMode() <= max_mode) continue;
            max_mode = param.getMinimumRequiredUserMode();
        }
        return max_mode;
    }

    @Override
    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite main_tab = new Composite(parent, 0);
        GridData main_gridData = new GridData(272);
        main_tab.setLayoutData((Object)main_gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        main_tab.setLayout((Layout)layout);
        final HashMap<ParameterImpl, Object[]> comp_map = new HashMap<ParameterImpl, Object[]>();
        ParameterGroupImpl current_group = null;
        Composite current_composite = main_tab;
        BasicPluginConfigModel model = (BasicPluginConfigModel)this.model_ref.get();
        org.gudy.azureus2.plugins.ui.config.Parameter[] parameters = model.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            GridData gridData;
            Composite area;
            GridData gridData2;
            Parameter swt_param;
            String label_text;
            final ParameterImpl param = (ParameterImpl)parameters[i];
            if (param.getMinimumRequiredUserMode() > userMode) continue;
            ParameterGroupImpl pg = param.getGroup();
            if (pg == null) {
                current_composite = main_tab;
            } else if (pg != current_group) {
                current_group = pg;
                current_composite = new Group(main_tab, 0);
                Messages.setLanguageText((Widget)current_composite, current_group.getResourceName());
                GridData gridData3 = new GridData(272);
                gridData3.horizontalSpan = 2;
                current_composite.setLayoutData((Object)gridData3);
                layout = new GridLayout();
                layout.numColumns = 2;
                current_composite.setLayout((Layout)layout);
            }
            Label label = null;
            String label_key = param.getLabelKey();
            String string = label_text = label_key == null ? param.getLabelText() : MessageText.getString(label_key);
            if (label_text.indexOf(10) != -1 || label_text.indexOf(9) != -1 || !(param instanceof BooleanParameterImpl)) {
                String hyperlink = null;
                if (param instanceof HyperlinkParameterImpl) {
                    hyperlink = ((HyperlinkParameterImpl)param).getHyperlink();
                }
                label = new Label(current_composite, param instanceof LabelParameterImpl ? 64 : 0);
                if (label_key == null) {
                    label.setText(param.getLabelText());
                } else {
                    Messages.setLanguageText((Widget)label, label_key);
                }
                if (hyperlink != null) {
                    LinkLabel.makeLinkedLabel(label, hyperlink);
                }
                if (param instanceof HyperlinkParameterImpl) {
                    final Label f_label = label;
                    param.addListener(new ParameterListener(){

                        public void parameterChanged(org.gudy.azureus2.plugins.ui.config.Parameter p) {
                            if (f_label.isDisposed()) {
                                param.removeListener(this);
                            } else {
                                String hyperlink = ((HyperlinkParameterImpl)param).getHyperlink();
                                if (hyperlink != null) {
                                    LinkLabel.updateLinkedLabel(f_label, hyperlink);
                                }
                            }
                        }
                    });
                }
            }
            String key = param.getKey();
            if (param instanceof BooleanParameterImpl) {
                swt_param = label == null ? new BooleanParameter(current_composite, key, ((BooleanParameterImpl)param).getDefaultValue(), param.getLabelKey()) : new BooleanParameter(current_composite, key, ((BooleanParameterImpl)param).getDefaultValue());
                GridData data = new GridData();
                data.horizontalSpan = label == null ? 2 : 1;
                swt_param.setLayoutData(data);
                param.addListener(new ParameterListener(){

                    public void parameterChanged(org.gudy.azureus2.plugins.ui.config.Parameter p) {
                        if (swt_param.getControls()[0].isDisposed()) {
                            param.removeListener(this);
                        } else {
                            ((BooleanParameter)swt_param).setSelected(((BooleanParameterImpl)param).getValue());
                        }
                    }
                });
            } else if (param instanceof IntParameterImpl) {
                IntParameterImpl int_param = (IntParameterImpl)param;
                swt_param = new IntParameter(current_composite, key, int_param.getDefaultValue());
                if (int_param.isLimited()) {
                    ((IntParameter)swt_param).setMinimumValue(int_param.getMinValue());
                    ((IntParameter)swt_param).setMaximumValue(int_param.getMaxValue());
                }
                param.addListener(new ParameterListener(){

                    public void parameterChanged(org.gudy.azureus2.plugins.ui.config.Parameter p) {
                        if (swt_param.getControls()[0].isDisposed()) {
                            param.removeListener(this);
                        } else {
                            ((IntParameter)swt_param).setValue(((IntParameterImpl)param).getValue());
                        }
                    }
                });
                gridData2 = new GridData();
                gridData2.widthHint = 100;
                swt_param.setLayoutData(gridData2);
            } else if (param instanceof ColorParameterImpl) {
                area = new Composite(current_composite, 0);
                gridData2 = new GridData();
                area.setLayoutData((Object)gridData2);
                layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                area.setLayout((Layout)layout);
                final ButtonParameter[] reset_button_holder = new ButtonParameter[1];
                final ColorParameterImpl color_param = (ColorParameterImpl)param;
                swt_param = new ColorParameter(area, key, color_param.getRedValue(), color_param.getGreenValue(), color_param.getBlueValue()){

                    public void newColorSet() {
                        color_param.reloadParamDataFromConfig(true);
                        if (reset_button_holder[0] == null) {
                            return;
                        }
                        reset_button_holder[0].getControl().setEnabled(true);
                    }
                };
                reset_button_holder[0] = new ButtonParameter(area, "ConfigView.section.style.colorOverrides.reset");
                reset_button_holder[0].getControl().setEnabled(color_param.isOverridden());
                reset_button_holder[0].getControl().addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        reset_button_holder[0].getControl().setEnabled(false);
                        color_param.resetToDefault();
                        color_param.reloadParamDataFromConfig(false);
                    }
                });
                gridData2 = new GridData();
                gridData2.widthHint = 50;
                swt_param.setLayoutData(gridData2);
            } else if (param instanceof StringParameterImpl) {
                gridData = new GridData(768);
                gridData.widthHint = 150;
                StringParameterImpl s_param = (StringParameterImpl)param;
                swt_param = new StringParameter(current_composite, key, s_param.getDefaultValue(), s_param.getGenerateIntermediateEvents());
                swt_param.setLayoutData(gridData);
            } else if (param instanceof InfoParameterImpl) {
                gridData = new GridData(768);
                gridData.widthHint = 150;
                swt_param = new InfoParameter(current_composite, key, "");
                swt_param.setLayoutData(gridData);
            } else if (param instanceof StringListParameterImpl) {
                StringListParameterImpl sl_param = (StringListParameterImpl)param;
                gridData2 = new GridData();
                gridData2.widthHint = 150;
                swt_param = new StringListParameter(current_composite, key, sl_param.getDefaultValue(), sl_param.getLabels(), sl_param.getValues());
                swt_param.setLayoutData(gridData2);
            } else if (param instanceof PasswordParameterImpl) {
                gridData = new GridData();
                gridData.widthHint = 150;
                swt_param = new PasswordParameter(current_composite, key, ((PasswordParameterImpl)param).getEncodingType());
                swt_param.setLayoutData(gridData);
            } else if (param instanceof DirectoryParameterImpl || param instanceof org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter) {
                area = new Composite(current_composite, 0);
                gridData2 = new GridData(768);
                area.setLayoutData((Object)gridData2);
                layout = new GridLayout();
                layout.numColumns = 2;
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                area.setLayout((Layout)layout);
                if (param instanceof DirectoryParameterImpl) {
                    swt_param = new DirectoryParameter(area, key, ((DirectoryParameterImpl)param).getDefaultValue());
                } else {
                    org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter fp = (org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter)param;
                    swt_param = new FileParameter(area, key, fp.getDefaultValue(), fp.getFileExtensions());
                }
            } else if (param instanceof ActionParameterImpl) {
                ActionParameterImpl _param = (ActionParameterImpl)param;
                swt_param = _param.getStyle() == 1 ? new ButtonParameter(current_composite, _param.getActionResource()) : new LinkParameter(current_composite, _param.getActionResource());
                swt_param.addChangeListener(new ParameterChangeAdapter(){

                    public void parameterChanged(Parameter p, boolean caused_internally) {
                        try {
                            param.parameterChanged("");
                        }
                        catch (Throwable t) {
                            Debug.out(t);
                        }
                    }
                });
            } else if (param instanceof UIParameterImpl) {
                if (((UIParameterImpl)param).getContext() instanceof UISWTParameterContext) {
                    UISWTParameterContext context2 = (UISWTParameterContext)((UIParameterImpl)param).getContext();
                    Composite internal_composite = new Composite(current_composite, 0);
                    GridData gridData4 = new GridData(768);
                    internal_composite.setLayoutData((Object)gridData4);
                    boolean initialised_component = true;
                    try {
                        context2.create(internal_composite);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                        initialised_component = false;
                    }
                    if (initialised_component) {
                        swt_param = new UISWTParameter((Control)internal_composite, param.getKey());
                    } else {
                        swt_param = null;
                        if (label != null) {
                            label.setText("Error while generating UI component.");
                        }
                    }
                } else {
                    swt_param = null;
                }
            } else {
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                gridData.widthHint = 300;
                label.setLayoutData((Object)gridData);
                swt_param = null;
            }
            if (swt_param == null) {
                if (label == null) {
                    comp_map.put(param, new Object[]{null});
                    continue;
                }
                comp_map.put(param, new Object[]{null, label});
                continue;
            }
            Control[] c = swt_param.getControls();
            Object[] moo = new Object[c.length + (label == null ? 1 : 2)];
            int pos = 1;
            moo[0] = swt_param;
            if (label != null) {
                moo[pos++] = label;
            }
            for (int j = 0; j < c.length; ++j) {
                moo[j + pos] = c[j];
            }
            comp_map.put(param, moo);
        }
        ParameterImplListener parameterImplListener = new ParameterImplListener(){

            public void enabledChanged(final ParameterImpl p) {
                final Object[] stuff = (Object[])comp_map.get(p);
                if (stuff != null) {
                    if (stuff[1] != null && ((Control)stuff[1]).isDisposed()) {
                        p.removeImplListener(this);
                    } else {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                for (int k = 1; k < stuff.length; ++k) {
                                    if (!(stuff[k] instanceof Control)) continue;
                                    ((Control)stuff[k]).setEnabled(p.isEnabled());
                                }
                            }
                        });
                    }
                }
            }

            public void labelChanged(ParameterImpl p, final String text, final boolean bIsKey) {
                Label lbl;
                Object[] stuff = (Object[])comp_map.get(p);
                if (stuff == null) {
                    return;
                }
                if (stuff[1] instanceof Label) {
                    lbl = (Label)stuff[1];
                } else if (stuff[0] instanceof Label) {
                    lbl = (Label)stuff[0];
                } else {
                    return;
                }
                if (lbl.isDisposed()) {
                    p.removeImplListener(this);
                } else {
                    final Label finalLabel = lbl;
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (bIsKey) {
                                Messages.setLanguageText((Widget)finalLabel, text);
                            } else {
                                finalLabel.setData((Object)"");
                                finalLabel.setText(text);
                            }
                            finalLabel.getParent().layout(true);
                        }
                    });
                }
            }
        };
        for (int i = 0; i < parameters.length; ++i) {
            Control[] cd;
            Object[] stuff;
            ParameterImpl param = (ParameterImpl)parameters[i];
            param.addImplListener(parameterImplListener);
            if (!param.isEnabled() && (stuff = (Object[])comp_map.get(param)) != null) {
                for (int k = 1; k < stuff.length; ++k) {
                    ((Control)stuff[k]).setEnabled(false);
                }
            }
            if (!param.isVisible() && (stuff = (Object[])comp_map.get(param)) != null) {
                for (int k = 1; k < stuff.length; ++k) {
                    Control con = (Control)stuff[k];
                    con.setVisible(false);
                    GridData gridData = new GridData();
                    gridData.heightHint = 0;
                    gridData.verticalSpan = 0;
                    gridData.grabExcessVerticalSpace = false;
                    con.setLayoutData((Object)gridData);
                }
            }
            if (!(param instanceof EnablerParameter)) continue;
            ArrayList<Object> controlsToEnable = new ArrayList<Object>();
            for (ParameterImpl enable_param : param.getEnabledOnSelectionParameters()) {
                Object[] stuff2 = (Object[])comp_map.get(enable_param);
                if (stuff2 == null) continue;
                for (int k = 1; k < stuff2.length; ++k) {
                    controlsToEnable.add(stuff2[k]);
                }
            }
            ArrayList<Object> controlsToDisable = new ArrayList<Object>();
            for (ParameterImpl disable_param : param.getDisabledOnSelectionParameters()) {
                Object[] stuff3 = (Object[])comp_map.get(disable_param);
                if (stuff3 == null) continue;
                for (int k = 1; k < stuff3.length; ++k) {
                    controlsToDisable.add(stuff3[k]);
                }
            }
            Control[] ce = new Control[controlsToEnable.size()];
            if (ce.length + (cd = new Control[controlsToDisable.size()]).length <= 0) continue;
            DualChangeSelectionActionPerformer ap = new DualChangeSelectionActionPerformer(controlsToEnable.toArray(ce), controlsToDisable.toArray(cd));
            BooleanParameter target = (BooleanParameter)((Object[])comp_map.get(param))[0];
            target.setAdditionalActionPerformer(ap);
        }
        return main_tab;
    }
}

