/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIException;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIInstanceFactory;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerEvent;
import org.gudy.azureus2.plugins.ui.UIManagerEventListener;
import org.gudy.azureus2.plugins.ui.UIMessage;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTAWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginConfigImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIMessageImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTStatusEntryImpl;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISWTInstanceImpl
implements UIInstanceFactory,
UISWTInstance,
UIManagerEventListener {
    private AzureusCore core;
    private Map<UISWTAWTPluginView, UISWTPluginView> awt_view_map = new WeakHashMap<UISWTAWTPluginView, UISWTPluginView>();
    private Map<BasicPluginConfigModel, BasicPluginConfigImpl> config_view_map = new WeakHashMap<BasicPluginConfigModel, BasicPluginConfigImpl>();
    private Map<String, Map<String, UISWTViewEventListener>> views = new HashMap<String, Map<String, UISWTViewEventListener>>();
    private Map<PluginInterface, UIInstance> plugin_map = new WeakHashMap<PluginInterface, UIInstance>();
    private boolean bUIAttaching;
    private final UIFunctionsSWT uiFunctions;

    public UISWTInstanceImpl(AzureusCore _core) {
        this.core = _core;
        this.uiFunctions = (UIFunctionsSWT)UIFunctionsManager.getUIFunctions();
    }

    public void init(IUIIntializer init) {
        UIManager ui_manager = PluginInitializer.getDefaultInterface().getUIManager();
        ui_manager.addUIEventListener(this);
        this.bUIAttaching = true;
        ((UIManagerImpl)ui_manager).attachUI(this, init);
        this.bUIAttaching = false;
    }

    @Override
    public UIInstance getInstance(PluginInterface plugin_interface) {
        UIInstance instance = this.plugin_map.get(plugin_interface);
        if (instance == null) {
            instance = new instanceWrapper(plugin_interface, this);
            this.plugin_map.put(plugin_interface, instance);
        }
        return instance;
    }

    @Override
    public boolean eventOccurred(UIManagerEvent event2) {
        boolean done = true;
        final Object data = event2.getData();
        switch (event2.getType()) {
            case 1: {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        String[] params = (String[])data;
                        new TextViewerWindow(params[0], params[1], params[2]);
                    }
                });
                break;
            }
            case 21: {
                final int[] result = new int[]{0};
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        Shell shell;
                        UIFunctionsManagerSWT.getUIFunctionsSWT().bringToFront();
                        Object[] params = (Object[])data;
                        long _styles = (Long)params[2];
                        int styles = 0;
                        if ((_styles & 4L) != 0L) {
                            styles |= 0x40;
                        }
                        if ((_styles & 8L) != 0L) {
                            styles |= 0x80;
                        }
                        if ((_styles & 1L) != 0L) {
                            styles |= 0x20;
                        }
                        if ((_styles & 2L) != 0L) {
                            styles |= 0x100;
                        }
                        if ((shell = UISWTInstanceImpl.this.uiFunctions.getMainShell()) != null) {
                            int _r = Utils.openMessageBox(shell, styles, MessageText.getString((String)params[0]), MessageText.getString((String)params[1]));
                            int r = 0;
                            if ((_r & 0x40) != 0) {
                                r |= 4;
                            }
                            if ((_r & 0x80) != 0) {
                                r |= 8;
                            }
                            if ((_r & 0x20) != 0) {
                                r |= 1;
                            }
                            if ((_r & 0x100) != 0) {
                                r |= 2;
                            }
                            result[0] = r;
                        }
                    }
                }, false);
                event2.setResult(new Long(result[0]));
                break;
            }
            case 2: {
                TorrentOpener.openTorrent(((File)data).toString());
                break;
            }
            case 22: {
                Torrent t = (Torrent)data;
                try {
                    File f = AETemporaryFileHandler.createTempFile();
                    t.writeToFile(f);
                    TorrentOpener.openTorrent(f.toString());
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                break;
            }
            case 3: {
                Display display = SWTThread.getInstance().getDisplay();
                display.syncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        Object[] params = (Object[])data;
                        URL target = (URL)params[0];
                        URL referrer = (URL)params[1];
                        boolean auto_download = (Boolean)params[2];
                        Map request_properties = (Map)params[3];
                        if (!COConfigurationManager.getBooleanParameter("add_torrents_silently")) {
                            UISWTInstanceImpl.this.uiFunctions.bringToFront();
                        }
                        if (auto_download) {
                            Shell shell = UISWTInstanceImpl.this.uiFunctions.getMainShell();
                            if (shell != null) {
                                new FileDownloadWindow(shell, target.toString(), referrer == null ? null : referrer.toString(), request_properties);
                            }
                        } else {
                            TorrentOpener.openTorrent(target.toString());
                        }
                    }
                });
                break;
            }
            case 4: {
                if (!(data instanceof BasicPluginViewModel)) break;
                BasicPluginViewModel model = (BasicPluginViewModel)data;
                String sViewID = model.getName().replaceAll(" ", ".");
                BasicPluginViewImpl view = new BasicPluginViewImpl(model);
                this.addView("Main", sViewID, view);
                break;
            }
            case 7: {
                if (!(data instanceof BasicPluginViewModel)) break;
                BasicPluginViewModel model = (BasicPluginViewModel)data;
                String sViewID = model.getName().replaceAll(" ", ".");
                this.removeViews("Main", sViewID);
                break;
            }
            case 5: {
                if (!(data instanceof BasicPluginConfigModel)) break;
                BasicPluginConfigModel model = (BasicPluginConfigModel)data;
                BasicPluginConfigImpl view = new BasicPluginConfigImpl(new WeakReference<BasicPluginConfigModel>(model));
                this.config_view_map.put(model, view);
                model.getPluginInterface().addConfigSection(view);
                break;
            }
            case 8: {
                BasicPluginConfigModel model;
                BasicPluginConfigImpl view;
                if (!(data instanceof BasicPluginConfigModel) || (view = this.config_view_map.get(model = (BasicPluginConfigModel)data)) == null) break;
                model.getPluginInterface().removeConfigSection(view);
                break;
            }
            case 6: {
                ClipboardCopy.copyToClipBoard((String)data);
                break;
            }
            case 9: {
                Utils.launch(((URL)data).toExternalForm());
                break;
            }
            case 10: {
                if (data instanceof TableColumn) {
                    event2.setResult((TableColumn)data);
                    break;
                }
                String[] args = (String[])data;
                event2.setResult(new TableColumnImpl(args[0], args[1]));
                break;
            }
            case 11: {
                TableColumn _col = (TableColumn)data;
                if (_col instanceof TableColumnImpl) {
                    TableColumnManager.getInstance().addColumns(new TableColumnCore[]{(TableColumnCore)_col});
                    TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(_col.getTableID());
                    tsed.tableStructureChanged(true, _col.getForDataSourceType());
                    break;
                }
                throw new UIRuntimeException("TableManager.addColumn(..) can only add columns created by createColumn(..)");
            }
            case 25: {
                String[] tables;
                Object[] params = (Object[])data;
                TableColumnManager tcManager = TableColumnManager.getInstance();
                Class dataSource = (Class)params[0];
                String columnName = (String)params[1];
                tcManager.registerColumn(dataSource, columnName, (TableColumnCreationListener)params[2]);
                for (String tid : tables = tcManager.getTableIDs()) {
                    TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(tid);
                    tsed.tableStructureChanged(true, dataSource);
                }
                break;
            }
            case 26: {
                String[] tables;
                Object[] params = (Object[])data;
                TableColumnManager tcManager = TableColumnManager.getInstance();
                Class dataSource = (Class)params[0];
                String columnName = (String)params[1];
                tcManager.unregisterColumn(dataSource, columnName, (TableColumnCreationListener)params[2]);
                for (String tid : tables = tcManager.getTableIDs()) {
                    TableColumnCore col = tcManager.getTableColumnCore(tid, columnName);
                    if (col == null) continue;
                    col.remove();
                }
                break;
            }
            case 12: {
                TableContextMenuItem item = (TableContextMenuItem)data;
                TableContextMenuManager.getInstance().addContextMenuItem(item);
                break;
            }
            case 15: {
                MenuItem item = (MenuItem)data;
                MenuItemManager.getInstance().addMenuItem(item);
                break;
            }
            case 17: {
                TableContextMenuItem item = (TableContextMenuItem)data;
                TableContextMenuManager.getInstance().removeContextMenuItem(item);
                break;
            }
            case 19: {
                MenuItem item = (MenuItem)data;
                MenuItemManager.getInstance().removeMenuItem(item);
                break;
            }
            case 13: {
                event2.setResult(new Boolean(false));
                if (!(data instanceof String)) break;
                event2.setResult(Boolean.TRUE);
                this.uiFunctions.openView(4, data);
                break;
            }
            case 24: {
                File file_to_use = (File)data;
                Utils.launch(file_to_use.getAbsolutePath());
                break;
            }
            case 23: {
                File file_to_use = (File)data;
                boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
                ManagerUtils.open(file_to_use, use_open_containing_folder);
                break;
            }
            default: {
                done = false;
            }
        }
        return done;
    }

    @Override
    public Display getDisplay() {
        return SWTThread.getInstance().getDisplay();
    }

    @Override
    public Image loadImage(String resource) {
        throw new RuntimeException("plugin specific instance required");
    }

    protected Image loadImage(PluginInterface pi, String res) {
        InputStream is = pi.getPluginClassLoader().getResourceAsStream(res);
        if (is != null) {
            ImageData imageData = new ImageData(is);
            return new Image((Device)this.getDisplay(), imageData);
        }
        return null;
    }

    @Override
    public UISWTGraphic createGraphic(Image img) {
        return new UISWTGraphicImpl(img);
    }

    @Override
    public void addView(UISWTPluginView view, boolean bAutoOpen) {
        try {
            this.uiFunctions.addPluginView(view);
            if (bAutoOpen) {
                this.uiFunctions.openPluginView(view);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void removeView(UISWTPluginView view) {
        try {
            this.uiFunctions.removePluginView(view);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void addView(UISWTAWTPluginView view, boolean auto_open) {
        final WeakReference<UISWTAWTPluginView> view_ref = new WeakReference<UISWTAWTPluginView>(view);
        UISWTPluginView v = new UISWTPluginView(){
            Composite composite;
            Component component;
            boolean first_paint = true;

            public String getPluginViewName() {
                return ((UISWTAWTPluginView)view_ref.get()).getPluginViewName();
            }

            public String getFullTitle() {
                return ((UISWTAWTPluginView)view_ref.get()).getPluginViewName();
            }

            public void initialize(Composite _composite) {
                this.first_paint = true;
                this.composite = _composite;
                Composite frame_composite = new Composite(this.composite, 0x1000000);
                GridData data = new GridData(1808);
                frame_composite.setLayoutData((Object)data);
                Frame f = SWT_AWT.new_Frame((Composite)frame_composite);
                BorderLayout layout = new BorderLayout(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void layoutContainer(Container parent) {
                        try {
                            super.layoutContainer(parent);
                        }
                        finally {
                            if (first_paint) {
                                first_paint = false;
                                ((UISWTAWTPluginView)view_ref.get()).open(component);
                            }
                        }
                    }
                };
                Panel pan = new Panel(layout);
                f.add(pan);
                this.component = ((UISWTAWTPluginView)view_ref.get()).create();
                pan.add(this.component, "Center");
            }

            public Composite getComposite() {
                return this.composite;
            }

            public void delete() {
                super.delete();
                ((UISWTAWTPluginView)view_ref.get()).delete(this.component);
            }
        };
        this.awt_view_map.put(view, v);
        this.addView(v, auto_open);
    }

    @Override
    public void removeView(UISWTAWTPluginView view) {
        UISWTPluginView v = this.awt_view_map.remove(view);
        if (v != null) {
            this.removeView(v);
        }
    }

    @Override
    public void detach() throws UIException {
        throw new UIException("not supported");
    }

    @Override
    public void addView(String sParentID, final String sViewID, final UISWTViewEventListener l) {
        Map<String, UISWTViewEventListener> subViews = this.views.get(sParentID);
        if (subViews == null) {
            subViews = new HashMap<String, UISWTViewEventListener>();
            this.views.put(sParentID, subViews);
        }
        subViews.put(sViewID, l);
        if (sParentID.equals("Main")) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    try {
                        UISWTInstanceImpl.this.uiFunctions.addPluginView(sViewID, l);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void removeViews(String sParentID, final String sViewID) {
        Map<String, UISWTViewEventListener> subViews = this.views.get(sParentID);
        if (subViews == null) {
            return;
        }
        if (sParentID.equals("Main")) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    try {
                        if (UISWTInstanceImpl.this.uiFunctions != null) {
                            UISWTInstanceImpl.this.uiFunctions.removePluginView(sViewID);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        subViews.remove(sViewID);
    }

    @Override
    public boolean openView(String sParentID, String sViewID, Object dataSource) {
        return this.openView(sParentID, sViewID, dataSource, true);
    }

    @Override
    public boolean openView(final String sParentID, final String sViewID, final Object dataSource, final boolean setfocus) {
        Map<String, UISWTViewEventListener> subViews = this.views.get(sParentID);
        if (subViews == null) {
            return false;
        }
        final UISWTViewEventListener l = subViews.get(sViewID);
        if (l == null) {
            return false;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (UISWTInstanceImpl.this.uiFunctions != null) {
                    UISWTInstanceImpl.this.uiFunctions.openPluginView(sParentID, sViewID, l, dataSource, setfocus && !UISWTInstanceImpl.this.bUIAttaching);
                }
            }
        });
        return true;
    }

    @Override
    public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource) {
        this.openMainView(sViewID, l, dataSource, true);
    }

    @Override
    public void openMainView(final String sViewID, final UISWTViewEventListener l, final Object dataSource, final boolean setfocus) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (UISWTInstanceImpl.this.uiFunctions != null) {
                    UISWTInstanceImpl.this.uiFunctions.openPluginView("Main", sViewID, l, dataSource, setfocus && !UISWTInstanceImpl.this.bUIAttaching);
                }
            }
        });
    }

    @Override
    public UISWTView[] getOpenViews(String sParentID) {
        if (sParentID.equals("Main")) {
            try {
                if (this.uiFunctions != null) {
                    return this.uiFunctions.getPluginViews();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new UISWTView[0];
    }

    @Override
    public int promptUser(String title, String text, String[] options, int defaultOption) {
        return MessageBoxShell.open(this.uiFunctions.getMainShell(), title, text, options, defaultOption);
    }

    @Override
    public void showDownloadBar(Download download, final boolean display) {
        if (!(download instanceof DownloadImpl)) {
            return;
        }
        final DownloadManager dm = ((DownloadImpl)download).getDownload();
        if (dm == null) {
            return;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                if (display) {
                    DownloadBar.open(dm, UISWTInstanceImpl.this.getDisplay().getActiveShell());
                } else {
                    DownloadBar.close(dm);
                }
            }
        }, false);
    }

    @Override
    public void showTransfersBar(final boolean display) {
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                if (display) {
                    AllTransfersBar.open(UISWTInstanceImpl.this.core.getGlobalManager(), UISWTInstanceImpl.this.getDisplay().getActiveShell());
                } else {
                    AllTransfersBar.close(UISWTInstanceImpl.this.core.getGlobalManager());
                }
            }
        }, false);
    }

    public Map<String, UISWTViewEventListener> getViewListeners(String sParentID) {
        return this.views.get(sParentID);
    }

    public Map<String, Map<String, UISWTViewEventListener>> getAllViews() {
        return this.views;
    }

    @Override
    public UIInputReceiver getInputReceiver() {
        return new SimpleTextEntryWindow();
    }

    @Override
    public UIMessage createMessage() {
        return new UIMessageImpl();
    }

    @Override
    public UISWTStatusEntry createStatusEntry() {
        final UISWTStatusEntryImpl entry = new UISWTStatusEntryImpl();
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT == null) {
            return null;
        }
        MainStatusBar mainStatusBar = functionsSWT.getMainStatusBar();
        if (mainStatusBar == null) {
            return null;
        }
        final CLabel label = mainStatusBar.createStatusEntry(entry);
        final Listener click_listener = new Listener(){

            public void handleEvent(Event e) {
                entry.onClick();
            }
        };
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                label.addListener(8, click_listener);
            }
        }, true);
        return entry;
    }

    @Override
    public boolean openView(BasicPluginViewModel model) {
        return this.openView("Main", model.getName().replaceAll(" ", "."), null);
    }

    @Override
    public void openConfig(final BasicPluginConfigModel model) {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                UISWTInstanceImpl.this.uiFunctions.openView(4, model.getSection());
            }
        });
    }

    protected static class instanceWrapper
    implements UISWTInstance {
        private WeakReference<PluginInterface> pi_ref;
        private UISWTInstanceImpl delegate;

        protected instanceWrapper(PluginInterface _pi, UISWTInstanceImpl _delegate) {
            this.pi_ref = new WeakReference<PluginInterface>(_pi);
            this.delegate = _delegate;
        }

        public void detach() throws UIException {
            this.delegate.detach();
        }

        public Display getDisplay() {
            return this.delegate.getDisplay();
        }

        public Image loadImage(String resource) {
            PluginInterface pi = (PluginInterface)this.pi_ref.get();
            if (pi == null) {
                return null;
            }
            return this.delegate.loadImage(pi, resource);
        }

        public UISWTGraphic createGraphic(Image img) {
            return this.delegate.createGraphic(img);
        }

        public void addView(String sParentID, String sViewID, UISWTViewEventListener l) {
            this.delegate.addView(sParentID, sViewID, l);
        }

        public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource) {
            this.delegate.openMainView(sViewID, l, dataSource);
        }

        public void openMainView(String sViewID, UISWTViewEventListener l, Object dataSource, boolean setfocus) {
            this.delegate.openMainView(sViewID, l, dataSource, setfocus);
        }

        public void removeViews(String sParentID, String sViewID) {
            this.delegate.removeViews(sParentID, sViewID);
        }

        public UISWTView[] getOpenViews(String sParentID) {
            return this.delegate.getOpenViews(sParentID);
        }

        public void addView(UISWTPluginView view, boolean autoOpen) {
            this.delegate.addView(view, autoOpen);
        }

        public void removeView(UISWTPluginView view) {
            this.delegate.removeView(view);
        }

        public void addView(UISWTAWTPluginView view, boolean auto_open) {
            this.delegate.addView(view, auto_open);
        }

        public void removeView(UISWTAWTPluginView view) {
            this.delegate.removeView(view);
        }

        public int promptUser(String title, String text, String[] options, int defaultOption) {
            return this.delegate.promptUser(title, text, options, defaultOption);
        }

        public boolean openView(String sParentID, String sViewID, Object dataSource) {
            return this.delegate.openView(sParentID, sViewID, dataSource);
        }

        public boolean openView(String sParentID, String sViewID, Object dataSource, boolean setfocus) {
            return this.delegate.openView(sParentID, sViewID, dataSource, setfocus);
        }

        public UIInputReceiver getInputReceiver() {
            return this.delegate.getInputReceiver();
        }

        public UIMessage createMessage() {
            return this.delegate.createMessage();
        }

        public void showDownloadBar(Download download, boolean display) {
            this.delegate.showDownloadBar(download, display);
        }

        public void showTransfersBar(boolean display) {
            this.delegate.showTransfersBar(display);
        }

        public UISWTStatusEntry createStatusEntry() {
            return this.delegate.createStatusEntry();
        }

        public boolean openView(BasicPluginViewModel model) {
            return this.delegate.openView(model);
        }

        public void openConfig(BasicPluginConfigModel model) {
            this.delegate.openConfig(model);
        }
    }
}

