/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWFilePanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWListPanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class IPWModePanel
extends AbstractWizardPanel {
    private static final int MODE_FROM_LIST = 0;
    private static final int MODE_FROM_FILE = 1;
    private int mode = 0;

    public IPWModePanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        this.wizard.setTitle(MessageText.getString("installPluginsWizard.mode.title"));
        this.wizard.setErrorMessage("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1812);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Button bListMode = new Button(panel, 16);
        Messages.setLanguageText((Widget)bListMode, "installPluginsWizard.mode.list");
        bListMode.setData("mode", (Object)new Integer(0));
        if (((InstallPluginWizard)this.wizard).mode == 0) {
            bListMode.setSelection(true);
        }
        Button bFileMode = new Button(panel, 16);
        Messages.setLanguageText((Widget)bFileMode, "installPluginsWizard.mode.file");
        bFileMode.setData("mode", (Object)new Integer(1));
        if (((InstallPluginWizard)this.wizard).mode == 1) {
            bFileMode.setSelection(true);
        }
        Listener modeListener = new Listener(){

            public void handleEvent(Event e) {
                IPWModePanel.this.mode = (Integer)e.widget.getData("mode");
                ((InstallPluginWizard)((IPWModePanel)IPWModePanel.this).wizard).mode = IPWModePanel.this.mode;
            }
        };
        bListMode.addListener(13, modeListener);
        bFileMode.addListener(13, modeListener);
        if (userMode < 2) {
            Group cWiki = new Group(panel, 64);
            cWiki.setText(MessageText.getString("installPluginsWizard.installMode.info.title"));
            gridData = new GridData(772);
            gridData.verticalIndent = 15;
            cWiki.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginHeight = 0;
            cWiki.setLayout((Layout)layout);
            gridData = new GridData(772);
            gridData.horizontalIndent = 10;
            gridData.horizontalSpan = 4;
            Label label = new Label((Composite)cWiki, 64);
            label.setLayoutData((Object)gridData);
            label.setText(MessageText.getString("installPluginsWizard.installMode.info.text"));
        }
    }

    public IWizardPanel getNextPanel() {
        switch (this.mode) {
            case 0: {
                return new IPWListPanel(this.wizard, this);
            }
            case 1: {
                return new IPWFilePanel(this.wizard, this);
            }
        }
        return null;
    }

    public boolean isNextEnabled() {
        return true;
    }
}

