/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsuninstaller;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.pluginsuninstaller.UIPWFinishPanel;
import org.gudy.azureus2.ui.swt.pluginsuninstaller.UnInstallPluginWizard;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class UIPWListPanel
extends AbstractWizardPanel {
    Table pluginList;

    public UIPWListPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                UIPWListPanel.this._show(core);
            }
        });
    }

    private void _show(AzureusCore core) {
        this.wizard.setTitle(MessageText.getString("uninstallPluginsWizard.list.title"));
        this.wizard.setErrorMessage("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Label lblStatus = new Label(panel, 0);
        Messages.setLanguageText((Widget)lblStatus, "uninstallPluginsWizard.list.loaded");
        this.pluginList = new Table(panel, 68132);
        this.pluginList.setHeaderVisible(true);
        GridData data = new GridData(768);
        data.heightHint = 200;
        this.pluginList.setLayoutData((Object)data);
        TableColumn tcName = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcName, "installPluginsWizard.list.name");
        tcName.setWidth(200);
        TableColumn tcVersion = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcVersion, "installPluginsWizard.list.version");
        tcVersion.setWidth(150);
        PluginInterface[] plugins = new PluginInterface[]{};
        try {
            plugins = core.getPluginManager().getPluginInterfaces();
            Arrays.sort(plugins, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((PluginInterface)o1).getPluginName().compareTo(((PluginInterface)o2).getPluginName());
                }
            });
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        HashMap<String, ArrayList<PluginInterface>> pid_map = new HashMap<String, ArrayList<PluginInterface>>();
        for (int i = 0; i < plugins.length; ++i) {
            PluginInterface plugin = plugins[i];
            String pid = plugin.getPluginID();
            ArrayList<PluginInterface> pis = (ArrayList<PluginInterface>)pid_map.get(pid);
            if (pis == null) {
                pis = new ArrayList<PluginInterface>();
                pid_map.put(pid, pis);
            }
            pis.add(plugin);
        }
        ArrayList[] pid_list = new ArrayList[pid_map.size()];
        pid_map.values().toArray(pid_list);
        Arrays.sort(pid_list, new Comparator(){

            public int compare(Object o1, Object o2) {
                ArrayList l1 = (ArrayList)o1;
                ArrayList l2 = (ArrayList)o2;
                return ((PluginInterface)l1.get(0)).getPluginName().compareToIgnoreCase(((PluginInterface)l2.get(0)).getPluginName());
            }
        });
        for (int i = 0; i < pid_list.length; ++i) {
            ArrayList pis = pid_list[i];
            boolean skip = false;
            String display_name = "";
            for (int j = 0; j < pis.size(); ++j) {
                PluginInterface pi = (PluginInterface)pis.get(j);
                if (pi.getPluginState().isMandatory() || pi.getPluginState().isBuiltIn()) {
                    skip = true;
                    break;
                }
                display_name = display_name + (j == 0 ? "" : ",") + pi.getPluginName();
            }
            if (skip) continue;
            PluginInterface plugin = (PluginInterface)pis.get(0);
            List selected_plugins = ((UnInstallPluginWizard)this.wizard).getPluginList();
            TableItem item = new TableItem(this.pluginList, 0);
            item.setData((Object)plugin);
            item.setText(0, display_name);
            item.setChecked(selected_plugins.contains(plugin));
            String version = plugin.getPluginVersion();
            if (version == null) {
                version = MessageText.getString("installPluginsWizard.list.nullversion");
            }
            item.setText(1, version);
        }
        this.pluginList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UIPWListPanel.this.updateList();
            }
        });
    }

    public boolean isFinishEnabled() {
        return ((UnInstallPluginWizard)this.wizard).getPluginList().size() > 0;
    }

    public IWizardPanel getFinishPanel() {
        return new UIPWFinishPanel(this.wizard, this);
    }

    public void updateList() {
        ArrayList<Object> list = new ArrayList<Object>();
        TableItem[] items = this.pluginList.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getChecked()) continue;
            list.add(items[i].getData());
        }
        ((UnInstallPluginWizard)this.wizard).setPluginList(list);
        ((UnInstallPluginWizard)this.wizard).setFinishEnabled(this.isFinishEnabled());
    }
}

