/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import com.aelitis.azureus.ui.swt.UISkinnableManagerSWT;
import com.aelitis.azureus.ui.swt.UISkinnableSWTListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class MessageBoxShell
implements UIFunctionsUserPrompter {
    public static final String STATUS_TEXT_CLOSE = "__VUZE__MessageBoxShell__CLOSE";
    private static final int MIN_SIZE_X_DEFAULT = 300;
    private static final int MIN_SIZE_Y_DEFAULT = 120;
    private static final int MAX_SIZE_X_DEFAULT = 500;
    private static final int MIN_BUTTON_SIZE = 70;
    private static int numOpen = 0;
    private Shell parent;
    private int min_size_x = 300;
    private int min_size_y = 120;
    private int max_size_x = 500;
    private final String title;
    private final String text;
    private final String[] buttons;
    private final int defaultOption;
    private String rememberID;
    private String rememberText;
    private boolean rememberByDefault;
    private int rememberOnlyIfButton = -1;
    private int autoCloseInMS;
    private String html;
    private String url;
    private boolean squish;
    private boolean autoClosed = false;
    private Object[] relatedObjects;
    private Image imgLeft;
    protected Color urlColor;
    private boolean handleHTML = true;
    private Image iconImage;
    private Browser shell_browser;
    private boolean browser_follow_links;
    protected boolean isRemembered;
    private String iconImageID;

    public static int open(Shell parent, String title, String text, String[] buttons, int defaultOption) {
        return MessageBoxShell.open(parent, title, text, buttons, defaultOption, null, false, -1);
    }

    public static int open(Shell parent, String title, String text, String[] buttons, int defaultOption, String rememberID, boolean bRememberByDefault, int autoCloseInMS) {
        return MessageBoxShell.open(parent, title, text, buttons, defaultOption, rememberID, MessageText.getString("MessageBoxWindow.rememberdecision"), bRememberByDefault, autoCloseInMS);
    }

    public static int open(Shell parent, String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean bRememberByDefault, int autoCloseInMS) {
        MessageBoxShell messageBoxShell = new MessageBoxShell(parent, title, text, buttons, defaultOption, rememberID, rememberText, bRememberByDefault, autoCloseInMS);
        return messageBoxShell.open();
    }

    public static boolean isOpen() {
        return numOpen > 0;
    }

    public MessageBoxShell(Shell parent, String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean bRememberByDefault, int autoCloseInMS) {
        this.parent = parent;
        this.title = title;
        this.text = text;
        this.buttons = buttons;
        this.defaultOption = defaultOption;
        this.rememberID = rememberID;
        this.rememberText = rememberText;
        this.rememberByDefault = bRememberByDefault;
        this.autoCloseInMS = autoCloseInMS;
    }

    public MessageBoxShell(Shell parent, String title, String text, String[] buttons, int defaultOption) {
        this(parent, title, text, buttons, defaultOption, null, null, false, -1);
    }

    public int open() {
        return this.open(false);
    }

    private int open(boolean useCustomShell) {
        int rememberedDecision;
        if (this.rememberID != null && (rememberedDecision = RememberedDecisionsManager.getRememberedDecision(this.rememberID)) >= 0) {
            return rememberedDecision;
        }
        ++numOpen;
        final int[] result = new int[]{-1};
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                result[0] = MessageBoxShell.this._open();
            }
        }, false);
        --numOpen;
        return result[0];
    }

    private int _open() {
        GridData gridData;
        final int[] result = new int[]{-1};
        if (this.parent == null || this.parent.isDisposed()) {
            this.parent = Utils.findAnyShell();
            if (this.parent == null || this.parent.isDisposed()) {
                return result[0];
            }
        }
        MouseTrackListener mouseAdapter = null;
        Display display = this.parent.getDisplay();
        final Shell shell = ShellFactory.createShell(this.parent, 67696);
        if (this.title != null) {
            shell.setText(this.title);
        }
        shell.setBackgroundMode(1);
        shell.addListener(21, new Listener(){

            public void handleEvent(Event arg0) {
                try {
                    if (MessageBoxShell.this.shell_browser != null) {
                        MessageBoxShell.this.shell_browser.setUrl("about:blank");
                        MessageBoxShell.this.shell_browser.setVisible(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                if (MessageBoxShell.this.iconImageID != null) {
                    ImageLoader.getInstance().releaseImage(MessageBoxShell.this.iconImageID);
                }
            }
        });
        GridLayout gridLayout = new GridLayout();
        if (this.squish) {
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginLeft = 0;
            gridLayout.marginRight = 0;
            gridLayout.marginTop = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        }
        shell.setLayout((Layout)gridLayout);
        Utils.setShellIcon(shell);
        UISkinnableSWTListener[] listeners = UISkinnableManagerSWT.getInstance().getSkinnableListeners(MessageBoxShell.class.toString());
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].skinBeforeComponents((Composite)shell, this, this.relatedObjects);
        }
        Shell textComposite = shell;
        if (this.imgLeft != null) {
            textComposite = new Composite((Composite)shell, 0);
            textComposite.setForeground(shell.getForeground());
            GridLayout gl = new GridLayout(2, false);
            gl.horizontalSpacing = 10;
            textComposite.setLayout((Layout)gl);
            textComposite.setLayoutData((Object)new GridData(1808));
            Label lblImage = new Label((Composite)textComposite, 0);
            lblImage.setImage(this.imgLeft);
            lblImage.setLayoutData((Object)new GridData(2));
        }
        Canvas linkControl = this.text != null && this.text.length() > 0 ? this.createLinkLabel((Composite)textComposite, this.text) : null;
        if (this.html != null && this.html.length() > 0 || this.url != null && this.url.length() > 0) {
            block33: {
                try {
                    final Browser browser = this.shell_browser = new Browser((Composite)shell, Utils.getInitialBrowserStyle(0));
                    if (this.url != null && this.url.length() > 0) {
                        browser.setUrl(this.url);
                    } else {
                        browser.setText(this.html);
                    }
                    GridData gd = new GridData(1808);
                    gd.heightHint = 200;
                    browser.setLayoutData((Object)gd);
                    browser.addProgressListener(new ProgressListener(){

                        public void completed(ProgressEvent event2) {
                            browser.addLocationListener(new LocationListener(){

                                public void changing(LocationEvent event2) {
                                    event2.doit = MessageBoxShell.this.browser_follow_links;
                                }

                                public void changed(LocationEvent event2) {
                                }
                            });
                            browser.addOpenWindowListener(new OpenWindowListener(){

                                public void open(WindowEvent event2) {
                                    event2.required = true;
                                }
                            });
                        }

                        public void changed(ProgressEvent event2) {
                        }
                    });
                    browser.addStatusTextListener(new StatusTextListener(){

                        public void changed(StatusTextEvent event2) {
                            if (MessageBoxShell.STATUS_TEXT_CLOSE.equals(event2.text)) {
                                Utils.execSWTThreadLater(0, new Runnable(){

                                    public void run() {
                                        if (!browser.isDisposed() && !shell.isDisposed()) {
                                            shell.close();
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Debug.out(e);
                    if (this.html == null) break block33;
                    Text text = new Text((Composite)shell, 2120);
                    text.setText(this.html);
                    GridData gd = new GridData(1808);
                    gd.heightHint = 200;
                    text.setLayoutData((Object)gd);
                }
            }
            if (linkControl != null) {
                gridData = new GridData(768);
                linkControl.setLayoutData((Object)gridData);
            }
        } else if (linkControl != null) {
            gridData = new GridData(1808);
            linkControl.setLayoutData((Object)gridData);
        }
        if (!(this.squish || this.autoCloseInMS <= 0 && this.rememberID == null)) {
            Label lblPadding = new Label((Composite)shell, 0);
            lblPadding.setLayoutData((Object)new GridData(768));
        }
        if (this.autoCloseInMS > 0) {
            final Label lblCloseIn = new Label((Composite)shell, 64);
            lblCloseIn.setForeground(shell.getForeground());
            lblCloseIn.setLayoutData((Object)new GridData(768));
            long endOn = SystemTime.getCurrentTime() + (long)this.autoCloseInMS;
            lblCloseIn.setData("CloseOn", (Object)new Long(endOn));
            SimpleTimer.addPeriodicEvent("autoclose", 500L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    if (shell.isDisposed()) {
                        event2.cancel();
                        return;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (!shell.isDisposed()) {
                                boolean bDelayPaused;
                                boolean bl = bDelayPaused = lblCloseIn.getData("DelayPaused") != null;
                                if (bDelayPaused) {
                                    return;
                                }
                                long endOn = (Long)lblCloseIn.getData("CloseOn");
                                if (SystemTime.getCurrentTime() > endOn) {
                                    result[0] = MessageBoxShell.this.defaultOption;
                                    MessageBoxShell.this.autoClosed = true;
                                    shell.dispose();
                                } else {
                                    String sText = "";
                                    if (lblCloseIn.isDisposed()) {
                                        return;
                                    }
                                    if (!bDelayPaused) {
                                        long delaySecs = (endOn - SystemTime.getCurrentTime()) / 1000L;
                                        sText = MessageText.getString("popup.closing.in", new String[]{String.valueOf(delaySecs)});
                                    }
                                    lblCloseIn.setText(sText);
                                }
                            }
                        }
                    });
                }
            });
            SimpleTimer.addPeriodicEvent("OverPopup", 100L, new TimerEventPerformer(){
                boolean wasOver = true;
                long lEnterOn = 0L;

                public void perform(final TimerEvent event2) {
                    if (shell.isDisposed()) {
                        event2.cancel();
                        return;
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (shell.isDisposed()) {
                                event2.cancel();
                                return;
                            }
                            boolean isOver = shell.getBounds().contains(shell.getDisplay().getCursorLocation());
                            if (isOver != wasOver) {
                                wasOver = isOver;
                                if (isOver) {
                                    lblCloseIn.setData("DelayPaused", (Object)"");
                                    lEnterOn = SystemTime.getCurrentTime();
                                    lblCloseIn.setText("");
                                } else {
                                    lblCloseIn.setData("DelayPaused", null);
                                    if (lEnterOn > 0L) {
                                        long diff = SystemTime.getCurrentTime() - lEnterOn;
                                        long endOn = (Long)lblCloseIn.getData("CloseOn") + diff;
                                        lblCloseIn.setData("CloseOn", (Object)new Long(endOn));
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }
        Button checkRemember = null;
        if (this.rememberID != null) {
            checkRemember = new Button((Composite)shell, 32);
            checkRemember.setText(this.rememberText);
            checkRemember.setSelection(this.rememberByDefault);
            checkRemember.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Button checkRemember = (Button)e.widget;
                    boolean bl = MessageBoxShell.this.isRemembered = checkRemember != null && checkRemember.getSelection();
                    if (MessageBoxShell.this.rememberID != null && MessageBoxShell.this.isRemembered && (MessageBoxShell.this.rememberOnlyIfButton == -1 || MessageBoxShell.this.rememberOnlyIfButton == result[0])) {
                        RememberedDecisionsManager.setRemembered(MessageBoxShell.this.rememberID, result[0]);
                    }
                }
            });
        }
        if (this.buttons.length > 0) {
            int i;
            Label labelSeparator = new Label((Composite)shell, 258);
            labelSeparator.setLayoutData((Object)new GridData(768));
            Composite cButtons = new Composite((Composite)shell, 0);
            FormLayout layout = new FormLayout();
            cButtons.setLayout((Layout)layout);
            gridData = new GridData(128);
            cButtons.setLayoutData((Object)gridData);
            Button lastButton = null;
            Listener buttonListener = new Listener(){

                public void handleEvent(Event event2) {
                    result[0] = (Integer)event2.widget.getData();
                    shell.dispose();
                }
            };
            int buttonWidth = 0;
            Button[] swtButtons = new Button[this.buttons.length];
            for (i = 0; i < this.buttons.length; ++i) {
                Button button;
                swtButtons[i] = button = new Button(cButtons, 8);
                button.setData((Object)new Integer(i));
                button.setText(this.buttons[i]);
                button.addListener(13, buttonListener);
                FormData formData = new FormData();
                if (lastButton != null) {
                    formData.left = new FormAttachment(lastButton, 5);
                }
                button.setLayoutData((Object)formData);
                Point size = button.computeSize(-1, -1);
                if (size.x > buttonWidth) {
                    buttonWidth = size.x;
                }
                if (i == this.defaultOption) {
                    button.setFocus();
                    shell.setDefaultButton(button);
                }
                lastButton = button;
            }
            if (buttonWidth > 0) {
                if (buttonWidth < 70) {
                    buttonWidth = 70;
                }
                for (i = 0; i < this.buttons.length; ++i) {
                    Point size = swtButtons[i].computeSize(buttonWidth, -1);
                    swtButtons[i].setSize(size);
                    FormData formData = (FormData)swtButtons[i].getLayoutData();
                    formData.width = buttonWidth;
                }
            }
        }
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event2) {
                if (event2.detail == 2) {
                    shell.dispose();
                }
            }
        });
        Listener filterListener = new Listener(){

            public void handleEvent(Event event2) {
                if (event2.detail == 64) {
                    event2.detail = 16;
                    event2.doit = true;
                } else if (event2.detail == 32) {
                    event2.detail = 8;
                    event2.doit = true;
                }
            }
        };
        display.addFilter(31, filterListener);
        if (mouseAdapter != null) {
            this.addMouseTrackListener((Composite)shell, mouseAdapter);
        }
        shell.pack();
        Point size = shell.getSize();
        if (size.x < this.min_size_x) {
            size.x = this.min_size_x;
            shell.setSize(size);
        } else if (size.x > this.max_size_x) {
            size = shell.computeSize(this.max_size_x, -1);
            shell.setSize(size);
        }
        if (size.y < this.min_size_y) {
            size.y = this.min_size_y;
            shell.setSize(size);
        }
        Utils.centerWindowRelativeTo(shell, (Control)this.parent);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].skinAfterComponents((Composite)shell, this, this.relatedObjects);
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (display != null && !display.isDisposed()) {
            display.removeFilter(31, filterListener);
        }
        return result[0];
    }

    private void addMouseTrackListener(Composite parent, MouseTrackListener listener) {
        if (parent == null || listener == null || parent.isDisposed()) {
            return;
        }
        parent.addMouseTrackListener(listener);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control instanceof Composite) {
                this.addMouseTrackListener((Composite)control, listener);
                continue;
            }
            control.addMouseTrackListener(listener);
        }
    }

    private Canvas createLinkLabel(final Composite shell, final String text) {
        final Canvas canvas = new Canvas(shell, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Rectangle area = new Rectangle(0, 0, wHint < 0 ? MessageBoxShell.this.max_size_x : wHint, 5000);
                GC gc = new GC((Drawable)this);
                GCStringPrinter sp = new GCStringPrinter(gc, text, area, true, false, 192);
                sp.calculateMetrics();
                gc.dispose();
                Point size = sp.getCalculatedSize();
                return size;
            }
        };
        Listener l = new Listener(){
            GCStringPrinter sp;

            public void handleEvent(Event e) {
                GCStringPrinter.URLInfo hitUrl;
                if (!MessageBoxShell.this.handleHTML) {
                    if (e.type == 9) {
                        Rectangle area = canvas.getClientArea();
                        e.gc.setForeground(shell.getForeground());
                        GCStringPrinter.printString(e.gc, text, area, true, false, 192);
                    }
                    return;
                }
                if (e.type == 9) {
                    Rectangle area = canvas.getClientArea();
                    this.sp = new GCStringPrinter(e.gc, text, area, true, false, 192);
                    this.sp.setUrlColor(ColorCache.getColor(e.gc.getDevice(), "#0000ff"));
                    if (MessageBoxShell.this.urlColor != null) {
                        this.sp.setUrlColor(MessageBoxShell.this.urlColor);
                    }
                    e.gc.setForeground(shell.getForeground());
                    this.sp.printString();
                } else if (e.type == 5) {
                    if (this.sp != null) {
                        GCStringPrinter.URLInfo hitUrl2 = this.sp.getHitUrl(e.x, e.y);
                        if (hitUrl2 != null) {
                            canvas.setCursor(canvas.getDisplay().getSystemCursor(21));
                            canvas.setToolTipText(hitUrl2.url);
                        } else {
                            canvas.setCursor(canvas.getDisplay().getSystemCursor(0));
                            canvas.setToolTipText(null);
                        }
                    }
                } else if (e.type == 4 && this.sp != null && (hitUrl = this.sp.getHitUrl(e.x, e.y)) != null && !hitUrl.url.startsWith(":")) {
                    Utils.launch(hitUrl.url);
                }
            }
        };
        canvas.addListener(9, l);
        if (this.handleHTML) {
            canvas.addListener(5, l);
            canvas.addListener(4, l);
        }
        ClipboardCopy.addCopyToClipMenu((Control)canvas, new ClipboardCopy.copyToClipProvider(){

            public String getText() {
                return text;
            }
        });
        return canvas;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSize(int width, int height) {
        this.min_size_x = width;
        this.max_size_x = width;
        this.min_size_y = height;
    }

    public String getRememberID() {
        return this.rememberID;
    }

    public void setRememberID(String rememberID, boolean rememberByDefault) {
        this.rememberID = rememberID;
        this.rememberByDefault = rememberByDefault;
    }

    public String getRememberText() {
        return this.rememberText;
    }

    public void setRememberText(String rememberText) {
        this.rememberText = rememberText;
    }

    public int getAutoCloseInMS() {
        return this.autoCloseInMS;
    }

    public void setAutoCloseInMS(int autoCloseInMS) {
        this.autoCloseInMS = autoCloseInMS;
    }

    public void setSquish(boolean b) {
        this.squish = b;
    }

    public boolean isAutoClosed() {
        return this.autoClosed;
    }

    public void setRelatedObject(Object relatedObject) {
        this.relatedObjects = new Object[]{relatedObject};
    }

    public void setRelatedObjects(Object[] relatedObjects) {
        this.relatedObjects = relatedObjects;
    }

    public Object[] getRelatedObjects() {
        return this.relatedObjects;
    }

    public Object getLeftImage() {
        return this.imgLeft == this.iconImage ? null : this.imgLeft;
    }

    public void setLeftImage(Image imgLeft) {
        this.imgLeft = imgLeft;
    }

    public void setLeftImage(final int icon) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MessageBoxShell.this.setLeftImage(Display.getDefault().getSystemImage(icon));
                MessageBoxShell.this.iconImage = Display.getDefault().getSystemImage(icon);
            }
        });
    }

    public void setIconResource(String resource) {
        this.iconImageID = null;
        if (resource.equals("info")) {
            this.iconImage = Display.getDefault().getSystemImage(2);
        } else if (resource.equals("warning")) {
            this.iconImage = Display.getDefault().getSystemImage(8);
        } else if (resource.equals("error")) {
            this.iconImage = Display.getDefault().getSystemImage(1);
        } else {
            this.iconImage = ImageLoader.getInstance().getImage(resource);
            this.iconImageID = resource;
        }
        this.setLeftImage(this.iconImage);
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1264);
        shell.open();
        MessageBoxShell messageBoxShell = new MessageBoxShell(shell, "Title", "Test\nTHis is a very long line that tests whether the box gets really wide which is something we don't want.\nA <A HREF=\"Link\">link</A> for <A HREF=\"http://moo.com\">you</a>", new String[]{"Okay", "Cancyyyyyy", "Maybe"}, 1, "test2", MessageText.getString("MessageBoxWindow.nomoreprompting"), false, 15000);
        messageBoxShell.setHtml("<b>Moo</b> goes the cow<p><hr>");
        System.out.println(messageBoxShell.open());
    }

    public int getRememberOnlyIfButton() {
        return this.rememberOnlyIfButton;
    }

    public void setRememberOnlyIfButton(int rememberOnlyIfButton) {
        this.rememberOnlyIfButton = rememberOnlyIfButton;
    }

    public Color getUrlColor() {
        return this.urlColor;
    }

    public void setBrowserFollowLinks(boolean follow) {
        this.browser_follow_links = follow;
    }

    public void setUrlColor(Color colorURL) {
        this.urlColor = colorURL;
    }

    public void setHandleHTML(boolean handleHTML) {
        this.handleHTML = handleHTML;
    }

    public boolean isRemembered() {
        return this.isRemembered;
    }
}

