/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.speedtest;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTest;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTestListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduler;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTester;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTestSchedulerImpl;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestData;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestSetLimitPanel;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.WizardListener;

public class SpeedTestPanel
extends AbstractWizardPanel
implements NetworkAdminSpeedTestScheduledTestListener,
NetworkAdminSpeedTesterListener {
    private NetworkAdminSpeedTestScheduler nasts;
    private NetworkAdminSpeedTestScheduledTest scheduled_test;
    private Combo testCombo;
    private Button encryptToggle;
    private Color originalColor;
    private Button test;
    private Button abort;
    private Label testCountDown1;
    private Label testCountDown2;
    private Text textMessages;
    private ProgressBar progress;
    private Display display;
    private boolean test_running;
    private boolean switched_to_close;
    int uploadTest;
    int downloadTest;
    long maxUploadTest;
    long maxDownloadTest;
    WizardListener clListener;
    private static final String START_VALUES = "   -         ";

    public SpeedTestPanel(SpeedTestWizard _wizard, IWizardPanel _previousPanel) {
        super(_wizard, _previousPanel);
        this.wizard = _wizard;
        this.nasts = NetworkAdminSpeedTestSchedulerImpl.getInstance();
    }

    public void show() {
        this.display = this.wizard.getDisplay();
        this.wizard.setTitle(MessageText.getString("speedtest.wizard.run"));
        this.wizard.setCurrentInfo(MessageText.getString("SpeedTestWizard.test.panel.currinfo"));
        this.wizard.setPreviousEnabled(false);
        this.wizard.setFinishEnabled(false);
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        Group azWiki = new Group(panel, 64);
        GridData azwGridData = new GridData();
        azwGridData.widthHint = 350;
        azwGridData.horizontalSpan = 4;
        azWiki.setLayoutData((Object)azwGridData);
        GridLayout azwLayout = new GridLayout();
        azwLayout.numColumns = 1;
        azWiki.setLayout((Layout)azwLayout);
        azWiki.setText(MessageText.getString("Utils.link.visit"));
        Label linkLabel = new Label((Composite)azWiki, 0);
        linkLabel.setText(Constants.APP_NAME + " Wiki Speed Test");
        linkLabel.setData((Object)"http://www.azureuswiki.com/index.php/Speed_Test_FAQ");
        linkLabel.setCursor(Cursors.handCursor);
        linkLabel.setForeground(Colors.blue);
        azwGridData = new GridData();
        azwGridData.horizontalIndent = 10;
        linkLabel.setLayoutData((Object)azwGridData);
        linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            public void mouseUp(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
        Label spacer = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        spacer.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        panel.setLayout((Layout)layout);
        Label explain = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        explain.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)explain, "SpeedTestWizard.test.panel.explain");
        spacer = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        spacer.setLayoutData((Object)gridData);
        Label ul = new Label(panel, 0);
        gridData = new GridData();
        ul.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)ul, "SpeedTestWizard.test.panel.label");
        this.testCombo = new Combo(panel, 8);
        gridData = new GridData(768);
        this.testCombo.setLayoutData((Object)gridData);
        int[] test_types = NetworkAdminSpeedTester.TEST_TYPES;
        int up_only_index = 0;
        for (int i = 0; i < test_types.length; ++i) {
            int test_type = test_types[i];
            String resource = null;
            if (test_type == 0) {
                resource = "up";
                up_only_index = i;
            } else if (test_type == 1) {
                resource = "down";
            } else {
                Debug.out("Unknown test type");
            }
            this.testCombo.add("BT " + MessageText.getString("speedtest.wizard.test.mode." + resource), i);
        }
        this.testCombo.select(up_only_index);
        this.test = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.test, "dht.execute");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.test.setLayoutData((Object)gridData);
        this.test.addListener(13, (Listener)new RunButtonListener());
        this.abort = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.abort, "SpeedTestWizard.test.panel.abort");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.abort.setLayoutData((Object)gridData);
        this.abort.setEnabled(false);
        this.abort.addListener(13, (Listener)new AbortButtonListener());
        Label enc = new Label(panel, 0);
        gridData = new GridData();
        enc.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)enc, "SpeedTestWizard.test.panel.enc.label");
        this.encryptToggle = new Button(panel, 2);
        String statusString = "SpeedTestWizard.test.panel.standard";
        if (this.encryptToggle.getSelection()) {
            statusString = "SpeedTestWizard.test.panel.encrypted";
        }
        Messages.setLanguageText((Widget)this.encryptToggle, statusString);
        gridData = new GridData();
        gridData.widthHint = 80;
        this.encryptToggle.setLayoutData((Object)gridData);
        this.encryptToggle.addListener(13, (Listener)new EncryptToggleButtonListener());
        Label spacer2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        spacer2.setLayoutData((Object)gridData);
        Label abortCountDown = new Label(panel, 0);
        gridData = new GridData();
        abortCountDown.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)abortCountDown, "SpeedTestWizard.test.panel.abort.countdown");
        this.testCountDown1 = new Label(panel, 0);
        gridData = new GridData();
        this.testCountDown1.setLayoutData((Object)gridData);
        this.testCountDown1.setText(START_VALUES);
        Label testFinishCountDown = new Label(panel, 0);
        gridData = new GridData();
        testFinishCountDown.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)testFinishCountDown, "SpeedTestWizard.test.panel.test.countdown");
        this.testCountDown2 = new Label(panel, 0);
        gridData = new GridData();
        this.testCountDown2.setLayoutData((Object)gridData);
        this.testCountDown2.setText(START_VALUES);
        this.progress = new ProgressBar(panel, 65536);
        this.progress.setMinimum(0);
        this.progress.setMaximum(100);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.progress.setLayoutData((Object)gridData);
        this.textMessages = new Text(panel, 2826);
        this.textMessages.setBackground(this.display.getSystemColor(1));
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.heightHint = 60;
        this.textMessages.setLayoutData((Object)gridData);
        String lastData = SpeedTestData.getInstance().getLastTestData();
        if (lastData != null) {
            this.textMessages.setText(lastData);
        }
    }

    public void finish() {
        this.test_running = true;
        this.clListener = new WizardListener(){

            public void closed() {
                SpeedTestPanel.this.cancel();
            }
        };
        this.wizard.addListener(this.clListener);
        this.wizard.setFinishEnabled(false);
        final int test_mode = NetworkAdminSpeedTester.TEST_TYPES[this.testCombo.getSelectionIndex()];
        final boolean encState = this.encryptToggle.getSelection();
        AEThread t = new AEThread("SpeedTest Performer"){

            public void runSupport() {
                SpeedTestPanel.this.runTest(test_mode, encState);
            }
        };
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public void cancel() {
        if (this.scheduled_test != null) {
            this.scheduled_test.abort();
            if (!this.test.isDisposed()) {
                this.test.setEnabled(true);
                this.abort.setEnabled(false);
                this.wizard.setNextEnabled(false);
                this.wizard.setFinishEnabled(false);
            }
        }
    }

    protected void runTest(int test_mode, boolean encrypt_mode) {
        block4: {
            this.test_running = true;
            if (this.nasts.getCurrentTest() != null) {
                this.reportStage(MessageText.getString("SpeedTestWizard.test.panel.already.running"));
            } else {
                try {
                    this.reportStage(MessageText.getString("SpeedTestWizard.stage.message.requesting"));
                    this.scheduled_test = this.nasts.scheduleTest(1);
                    this.scheduled_test.getTester().setMode(test_mode);
                    this.scheduled_test.getTester().setUseCrypto(encrypt_mode);
                    this.scheduled_test.addListener(this);
                    this.scheduled_test.getTester().addListener(this);
                    this.maxUploadTest = this.scheduled_test.getMaxUpBytePerSec();
                    this.maxDownloadTest = this.scheduled_test.getMaxDownBytePerSec();
                    this.scheduled_test.start();
                }
                catch (Throwable e) {
                    String requestNotAccepted = MessageText.getString("SpeedTestWizard.test.panel.not.accepted");
                    this.reportStage(requestNotAccepted + Debug.getNestedExceptionMessage(e));
                    if (this.test.isDisposed()) break block4;
                    this.display.asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            SpeedTestPanel.this.test.setEnabled(true);
                            SpeedTestPanel.this.abort.setEnabled(false);
                            SpeedTestPanel.this.encryptToggle.setEnabled(true);
                        }
                    });
                }
            }
        }
    }

    public void stage(NetworkAdminSpeedTestScheduledTest test, String step) {
        this.reportStage(step);
    }

    public void complete(NetworkAdminSpeedTestScheduledTest test) {
    }

    public void stage(NetworkAdminSpeedTester tester2, String step) {
        this.reportStage(step);
    }

    public void complete(NetworkAdminSpeedTester tester2, NetworkAdminSpeedTesterResult result) {
        SpeedTestData.getInstance().setResult(result);
        this.reportComplete(result);
    }

    protected void reportComplete(final NetworkAdminSpeedTesterResult result) {
        if (!this.textMessages.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (!SpeedTestPanel.this.textMessages.isDisposed()) {
                        if (result.hadError()) {
                            String testFailed = MessageText.getString("SpeedTestWizard.test.panel.testfailed");
                            SpeedTestPanel.this.textMessages.append(testFailed + ": " + result.getLastError());
                            SpeedTestPanel.this.test.setEnabled(true);
                            SpeedTestPanel.this.abort.setEnabled(false);
                            SpeedTestPanel.this.encryptToggle.setEnabled(true);
                            SpeedTestPanel.this.wizard.setErrorMessage(testFailed);
                        } else {
                            SpeedTestPanel.this.uploadTest = result.getUploadSpeed();
                            SpeedTestPanel.this.downloadTest = result.getDownloadSpeed();
                            String uploadSpeedStr = MessageText.getString("GeneralView.label.uploadspeed");
                            String downlaodSpeedStr = MessageText.getString("GeneralView.label.downloadspeed");
                            SpeedTestPanel.this.textMessages.append(uploadSpeedStr + " " + DisplayFormatters.formatByteCountToKiBEtcPerSec(result.getUploadSpeed()) + Text.DELIMITER);
                            SpeedTestPanel.this.textMessages.append(downlaodSpeedStr + " " + DisplayFormatters.formatByteCountToKiBEtcPerSec(result.getDownloadSpeed()) + Text.DELIMITER);
                            SpeedTestPanel.this.wizard.setNextEnabled(true);
                            SpeedTestPanel.this.abort.setEnabled(false);
                            SpeedTestPanel.this.test.setEnabled(true);
                            SpeedTestPanel.this.encryptToggle.setEnabled(true);
                        }
                        if (!result.hadError()) {
                            SpeedTestPanel.this.switchToClose();
                        }
                    }
                }
            });
        }
        this.wizard.removeListener(this.clListener);
        this.clListener = null;
    }

    protected void reportStage(final String step) {
        if (!this.textMessages.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (!SpeedTestPanel.this.textMessages.isDisposed()) {
                        if (step == null) {
                            return;
                        }
                        if (step.startsWith("progress:")) {
                            int progressAmount = SpeedTestPanel.getProgressBarValueFromString(step);
                            SpeedTestPanel.this.progress.setSelection(progressAmount);
                            int[] timeLeft = SpeedTestPanel.getTimeLeftFromString(step);
                            if (timeLeft != null) {
                                SpeedTestPanel.this.testCountDown1.setText("" + timeLeft[0] + " sec ");
                                SpeedTestPanel.this.testCountDown2.setText("" + timeLeft[1] + " sec ");
                            } else {
                                SpeedTestPanel.this.testCountDown1.setText(SpeedTestPanel.START_VALUES);
                                SpeedTestPanel.this.testCountDown2.setText(SpeedTestPanel.START_VALUES);
                            }
                            String modified = SpeedTestPanel.modifyProgressStatusString(step);
                            SpeedTestPanel.this.textMessages.append(modified);
                        } else {
                            SpeedTestPanel.this.textMessages.append(step + Text.DELIMITER);
                        }
                    }
                }
            });
        }
    }

    private static String modifyProgressStatusString(String step) {
        if (step == null) {
            return " ";
        }
        if (!step.startsWith("progress:")) {
            return " ";
        }
        String[] values = step.split(":");
        if (values.length < 4) {
            return " ";
        }
        int downAve = SpeedTestPanel.getValueFromAveString(values[2]);
        int upAve = SpeedTestPanel.getValueFromAveString(values[3]);
        StringBuffer sb = new StringBuffer();
        sb.append(MessageText.getString("GeneralView.label.uploadspeed"));
        sb.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(upAve)).append(" , ");
        sb.append(MessageText.getString("GeneralView.label.downloadspeed"));
        sb.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(downAve));
        sb.append("\n");
        return sb.toString();
    }

    private static int getValueFromAveString(String aveStr) {
        try {
            int number = -2;
            aveStr = aveStr.trim();
            String[] parts = aveStr.split(" ");
            if (parts != null) {
                number = Integer.parseInt(parts[parts.length - 1].trim());
            }
            return number;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private static int[] getTimeLeftFromString(String step) {
        if (step == null) {
            return null;
        }
        if (!step.startsWith("progress:")) {
            return null;
        }
        String[] values = step.split(":");
        if (values.length < 5) {
            return null;
        }
        int[] times = new int[2];
        try {
            times[0] = Integer.parseInt(values[4].trim());
            times[1] = Integer.parseInt(values[5].trim());
            if (times[0] < 0) {
                times[0] = 0;
            }
            if (times[1] < 0) {
                times[1] = 0;
            }
        }
        catch (Exception e) {
            return null;
        }
        return times;
    }

    private static int getProgressBarValueFromString(String step) {
        int progress;
        if (step == null) {
            return 0;
        }
        if (!step.startsWith("progress:")) {
            return 0;
        }
        String[] value = step.split(":");
        if (value.length < 2) {
            return 0;
        }
        try {
            progress = Integer.parseInt(value[1].trim());
        }
        catch (Exception e) {
            return 0;
        }
        if (progress < 0 || progress > 100) {
            return 0;
        }
        return progress;
    }

    protected void switchToClose() {
        this.switched_to_close = true;
        this.wizard.switchToClose();
    }

    public boolean isFinishEnabled() {
        return !this.switched_to_close && !this.test_running;
    }

    public boolean isFinishSelectionOK() {
        return !this.switched_to_close && !this.test_running;
    }

    public IWizardPanel getFinishPanel() {
        return this;
    }

    public boolean isNextEnabled() {
        return (this.uploadTest > 0 || this.downloadTest > 0) && !this.test_running;
    }

    public IWizardPanel getNextPanel() {
        SpeedTestData persist = SpeedTestData.getInstance();
        persist.setLastTestData(this.textMessages.getText());
        return new SpeedTestSetLimitPanel(this.wizard, this, this.uploadTest, this.maxUploadTest, this.downloadTest, this.maxDownloadTest);
    }

    class AbortButtonListener
    implements Listener {
        AbortButtonListener() {
        }

        public void handleEvent(Event event2) {
            SpeedTestPanel.this.cancel();
            SpeedTestPanel.this.test.setEnabled(true);
            SpeedTestPanel.this.abort.setEnabled(false);
            SpeedTestPanel.this.encryptToggle.setEnabled(true);
            SpeedTestPanel.this.wizard.setNextEnabled(false);
            SpeedTestPanel.this.uploadTest = 0;
            SpeedTestPanel.this.downloadTest = 0;
            String testAbortedManually = MessageText.getString("SpeedTestWizard.test.panel.aborted");
            SpeedTestPanel.this.wizard.setErrorMessage(testAbortedManually);
            SpeedTestPanel.this.reportStage("\n" + testAbortedManually);
        }
    }

    class EncryptToggleButtonListener
    implements Listener {
        EncryptToggleButtonListener() {
        }

        public void handleEvent(Event event2) {
            if (SpeedTestPanel.this.encryptToggle.getSelection()) {
                Messages.setLanguageText((Widget)SpeedTestPanel.this.encryptToggle, "SpeedTestWizard.test.panel.encrypted");
                SpeedTestPanel.this.originalColor = SpeedTestPanel.this.encryptToggle.getForeground();
                Color highlightColor = SpeedTestPanel.this.display.getSystemColor(8);
                SpeedTestPanel.this.encryptToggle.setBackground(highlightColor);
            } else {
                Messages.setLanguageText((Widget)SpeedTestPanel.this.encryptToggle, "SpeedTestWizard.test.panel.standard");
                if (SpeedTestPanel.this.originalColor != null) {
                    SpeedTestPanel.this.encryptToggle.setBackground(SpeedTestPanel.this.originalColor);
                }
            }
        }
    }

    class RunButtonListener
    implements Listener {
        RunButtonListener() {
        }

        public void handleEvent(Event event2) {
            SpeedTestPanel.this.abort.setEnabled(true);
            SpeedTestPanel.this.test.setEnabled(false);
            SpeedTestPanel.this.encryptToggle.setEnabled(false);
            SpeedTestPanel.this.wizard.setErrorMessage("");
            SpeedTestPanel.this.wizard.setNextEnabled(false);
            SpeedTestPanel.this.textMessages.setText("");
            SpeedTestPanel.this.finish();
        }
    }
}

