/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.test;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Main {
    private Color blue;
    private Table table;
    private boolean mousePressed;
    private TableItem selectedItem;
    Rectangle oldBounds;
    Image oldImage;

    public Main() {
        int i;
        final Display display = new Display();
        this.blue = new Color((Device)display, 0, 0, 128);
        final Shell shell = new Shell(display);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        shell.setLayout((Layout)layout);
        this.table = new Table((Composite)shell, 67588);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        Font f = this.table.getFont();
        FontData fd = f.getFontData()[0];
        fd.setHeight(9);
        Font font = new Font((Device)display, fd);
        this.table.setFont(font);
        Button bOk = new Button((Composite)shell, 8);
        bOk.setText("Ok");
        gridData = new GridData(896);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 70;
        bOk.setLayoutData((Object)gridData);
        Button bCancel = new Button((Composite)shell, 8);
        bCancel.setText("Cancel");
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        bCancel.setLayoutData((Object)gridData);
        Button bApply = new Button((Composite)shell, 8);
        bApply.setText("Apply");
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        bApply.setLayoutData((Object)gridData);
        for (i = 0; i < 2; ++i) {
            new TableColumn(this.table, 0);
        }
        for (i = 0; i < 12; ++i) {
            this.createTableRow(-1, "Toto" + i, false);
        }
        TableItem item = new TableItem(this.table, 0);
        item.setText(1, "---");
        this.table.getColumn(0).setWidth(20);
        this.table.getColumn(1).setWidth(200);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent arg0) {
                Main.this.mousePressed = true;
                Main.this.selectedItem = Main.this.table.getItem(new Point(arg0.x, arg0.y));
                if (Main.this.selectedItem.getText(1).equals("---")) {
                    Main.this.selectedItem = null;
                }
            }

            public void mouseUp(MouseEvent e) {
                Main.this.mousePressed = false;
                if (Main.this.oldBounds != null && Main.this.oldImage != null) {
                    GC gc = new GC((Drawable)Main.this.table);
                    gc.drawImage(Main.this.oldImage, Main.this.oldBounds.x, Main.this.oldBounds.y);
                    Main.this.oldImage.dispose();
                    Main.this.oldImage = null;
                    Main.this.oldBounds = null;
                }
                Point p = new Point(e.x, e.y);
                TableItem item = Main.this.table.getItem(p);
                if (item != null && Main.this.selectedItem != null) {
                    int oldIndex;
                    int index = Main.this.table.indexOf(item);
                    if (index == (oldIndex = Main.this.table.indexOf(Main.this.selectedItem))) {
                        return;
                    }
                    String name = (String)Main.this.selectedItem.getData("name");
                    Button oldBtn = (Button)Main.this.selectedItem.getData("button");
                    boolean selected = oldBtn.getSelection();
                    oldBtn.dispose();
                    Main.this.createTableRow(index, name, selected);
                    Main.this.selectedItem.dispose();
                    Point size = shell.getSize();
                    shell.setSize(size.x + 1, size.y + 1);
                    shell.setSize(size);
                }
            }
        });
        this.table.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (Main.this.mousePressed && Main.this.selectedItem != null) {
                    Point p = new Point(e.x, e.y);
                    TableItem item = Main.this.table.getItem(p);
                    if (item != null) {
                        GC gc = new GC((Drawable)Main.this.table);
                        Rectangle bounds = item.getBounds(1);
                        if (Main.this.oldBounds != null && Main.this.oldImage != null) {
                            gc.drawImage(Main.this.oldImage, Main.this.oldBounds.x, Main.this.oldBounds.y);
                            Main.this.oldImage.dispose();
                            Main.this.oldImage = null;
                            Main.this.oldBounds = null;
                        }
                        Main.this.oldImage = new Image((Device)display, bounds.width, 2);
                        gc.copyArea(Main.this.oldImage, bounds.x, bounds.y);
                        Main.this.oldBounds = bounds;
                        gc.setBackground(Main.this.blue);
                        gc.fillRectangle(bounds.x, bounds.y, bounds.width, 2);
                    }
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        if (font != null && !font.isDisposed()) {
            font.dispose();
        }
    }

    private void createTableRow(int index, String name, boolean selected) {
        TableItem item = index == -1 ? new TableItem(this.table, 0) : new TableItem(this.table, 0, index);
        item.setText(1, name);
        item.setData("name", (Object)name);
        TableEditor editor = new TableEditor(this.table);
        Button button = new Button((Composite)this.table, 32);
        button.setSelection(selected);
        button.pack();
        editor.minimumWidth = button.getSize().x;
        editor.horizontalAlignment = 0x1000000;
        editor.setEditor((Control)button, item, 0);
        item.setData("button", (Object)button);
    }

    public static void main(String[] args) {
        new Main();
    }
}

