/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.test;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableTest {
    static Table tableNormal;
    private static Table tableVirtual;
    static Display display;

    public static void main(String[] args) {
        display = Display.getDefault();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new FillLayout());
        tableNormal = new Table((Composite)shell, 2048);
        tableVirtual = new Table((Composite)shell, 0x10000800);
        Button btnStart = new Button((Composite)shell, 8);
        btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableTest.runtest();
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected static void runtest() {
        tableNormal.clearAll();
        TableTest.waitForComplete();
        TableTest.runtest1();
        tableNormal.clearAll();
        TableTest.waitForComplete();
        TableTest.runtest2();
        tableNormal.clearAll();
        TableTest.waitForComplete();
        TableTest.runtest3();
        tableNormal.clearAll();
        TableTest.waitForComplete();
        TableTest.runtest4();
        tableNormal.clearAll();
        TableTest.waitForComplete();
        TableTest.runtest5();
        tableNormal.clearAll();
        TableTest.waitForComplete();
        TableTest.runtest6();
        tableNormal.clearAll();
        TableTest.waitForComplete();
        TableTest.runtest7();
    }

    static void runtest1() {
        long lStartTime = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            new TableItem(tableNormal, 0);
        }
        TableTest.waitForComplete();
        long lEndTime = System.currentTimeMillis();
        System.out.println("NVI: " + (lEndTime - lStartTime));
    }

    static void runtest2() {
        long lStartTime = System.currentTimeMillis();
        tableNormal.setItemCount(500);
        TableTest.waitForComplete();
        long lEndTime = System.currentTimeMillis();
        System.out.println("NVS: " + (lEndTime - lStartTime));
    }

    static void runtest3() {
        long lStartTime = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            new TableItem(tableVirtual, 0);
        }
        TableTest.waitForComplete();
        long lEndTime = System.currentTimeMillis();
        System.out.println("VI:" + (lEndTime - lStartTime));
    }

    static void runtest4() {
        long lStartTime = System.currentTimeMillis();
        tableVirtual.setItemCount(500);
        TableTest.waitForComplete();
        long lEndTime = System.currentTimeMillis();
        System.out.println("Vs:" + (lEndTime - lStartTime));
    }

    static void waitForComplete() {
        while (display.readAndDispatch()) {
        }
    }

    static void runtest5() {
        tableNormal.setItemCount(1000);
        TableTest.waitForComplete();
        long lStartTime = System.currentTimeMillis();
        tableNormal.setItemCount(500);
        long lEndTime = System.currentTimeMillis();
        System.out.println("NVD1: " + (lEndTime - lStartTime));
    }

    static void runtest6() {
        tableNormal.setItemCount(1000);
        TableTest.waitForComplete();
        long lStartTime = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            tableNormal.getItem(2).dispose();
        }
        long lEndTime = System.currentTimeMillis();
        System.out.println("NVD2: " + (lEndTime - lStartTime));
    }

    static void runtest7() {
        tableNormal.setItemCount(1000);
        TableTest.waitForComplete();
        int[] indexes = new int[500];
        for (int i = 0; i < 200; ++i) {
            indexes[i] = i * 2;
        }
        int x = 400;
        for (int i = 200; i < 500; ++i) {
            indexes[i] = x++;
        }
        long lStartTime = System.currentTimeMillis();
        tableNormal.remove(indexes);
        long lEndTime = System.currentTimeMillis();
        System.out.println("NVD3: " + (lEndTime - lStartTime));
    }
}

