/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import com.aelitis.azureus.ui.UIFunctions;
import java.util.Locale;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class FullUpdateWindow {
    private static Shell current_shell = null;
    private static Browser browser;

    public static void handleUpdate(final String url, final UIFunctions.actionListener listener) {
        try {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    FullUpdateWindow.open(url, listener);
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
            listener.actionComplete(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open(String url, final UIFunctions.actionListener listener) {
        boolean ok = false;
        final boolean[] listener_informed = new boolean[]{false};
        try {
            if (current_shell != null && !current_shell.isDisposed()) {
                return;
            }
            final Shell parentShell = Utils.findAnyShell();
            final Shell shell = current_shell = ShellFactory.createShell(parentShell, 67680);
            shell.setLayout((Layout)new FillLayout());
            if (parentShell != null) {
                parentShell.setCursor(shell.getDisplay().getSystemCursor(1));
            }
            shell.addDisposeListener(new DisposeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void widgetDisposed(DisposeEvent e) {
                    try {
                        if (parentShell != null) {
                            parentShell.setCursor(e.display.getSystemCursor(0));
                        }
                        current_shell = null;
                    }
                    finally {
                        if (!listener_informed[0]) {
                            try {
                                listener.actionComplete(false);
                            }
                            catch (Throwable f) {
                                Debug.out(f);
                            }
                        }
                    }
                }
            });
            try {
                browser = new Browser((Composite)shell, Utils.getInitialBrowserStyle(0));
            }
            catch (Throwable t) {
                shell.dispose();
                if (!ok) {
                    try {
                        listener.actionComplete(false);
                    }
                    catch (Throwable f) {
                        Debug.out(f);
                    }
                }
                return;
            }
            browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event2) {
                    shell.setText(event2.title);
                }
            });
            browser.addStatusTextListener(new StatusTextListener(){
                String last = null;

                public void changed(StatusTextEvent event2) {
                    String text = event2.text.toLowerCase();
                    if (this.last != null && this.last.equals(text)) {
                        return;
                    }
                    this.last = text;
                    if (text.contains("page-loaded")) {
                        Utils.centreWindow(shell);
                        if (parentShell != null) {
                            parentShell.setCursor(shell.getDisplay().getSystemCursor(0));
                        }
                        shell.open();
                    } else if (text.startsWith("set-size")) {
                        String[] strings = text.split(" ");
                        if (strings.length > 2) {
                            try {
                                int w = Integer.parseInt(strings[1]);
                                int h = Integer.parseInt(strings[2]);
                                Rectangle computeTrim = shell.computeTrim(0, 0, w, h);
                                shell.setSize(computeTrim.width, computeTrim.height);
                            }
                            catch (Exception e) {}
                        }
                    } else if (text.contains("decline") || text.contains("close")) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            public void runSupport() {
                                shell.dispose();
                            }
                        });
                    } else if (text.contains("accept")) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            public void runSupport() {
                                listener_informed[0] = true;
                                try {
                                    listener.actionComplete(true);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                shell.dispose();
                            }
                        });
                    }
                }
            });
            browser.addLocationListener(new LocationListener(){

                public void changing(LocationEvent event2) {
                }

                public void changed(LocationEvent event2) {
                }
            });
            String final_url = url + (url.indexOf(63) == -1 ? "?" : "&") + "locale=" + Locale.getDefault().toString() + "&azv=" + "4.2.0.8";
            SimpleTimer.addEvent("fullupdate.pageload", SystemTime.getOffsetTime(5000L), new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (!shell.isDisposed()) {
                                shell.open();
                            }
                        }
                    });
                }
            });
            browser.setUrl(final_url);
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    listener.actionComplete(false);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            FullUpdateWindow.open("http://192.168.0.88:8080/client/Update.html", new UIFunctions.actionListener(){

                public void actionComplete(Object result) {
                    System.out.println("result=" + result);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Display d = Display.getDefault();
        while (true) {
            if (d.readAndDispatch()) {
                continue;
            }
            d.sleep();
        }
    }
}

