/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.updater2;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.swt.SWT;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.updater2.SWTVersionGetter;

public class SWTUpdateChecker
implements UpdatableComponent {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final String OSX_APP = "/" + SystemProperties.getApplicationName() + ".app";

    public static void initialize() {
        PluginInitializer.getDefaultInterface().getUpdateManager().registerUpdatableComponent(new SWTUpdateChecker(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdate(final UpdateChecker checker) {
        block21: {
            try {
                boolean update_required;
                SWTVersionGetter versionGetter = new SWTVersionGetter(checker);
                boolean bl = update_required = System.getProperty("azureus.skipSWTcheck") == null && versionGetter.needsUpdate();
                if (!update_required) break block21;
                int update_prevented_version = COConfigurationManager.getIntParameter("swt.update.prevented.version", -1);
                try {
                    String url_str;
                    URL swt_url = SWT.class.getClassLoader().getResource("org/eclipse/swt/SWT.class");
                    if (swt_url != null && (url_str = swt_url.toExternalForm()).startsWith("jar:file:")) {
                        File jar_file = FileUtil.getJarFileFromURL(url_str);
                        String expected_location = Constants.isOSX ? checker.getCheckInstance().getManager().getInstallDir() + OSX_APP + "/Contents/Resources/Java" : checker.getCheckInstance().getManager().getInstallDir();
                        File expected_dir = new File(expected_location);
                        File jar_file_dir = jar_file.getParentFile();
                        if (expected_dir.exists() && jar_file_dir.exists()) {
                            if ((expected_dir = expected_dir.getCanonicalFile()).equals(jar_file_dir = jar_file_dir.getCanonicalFile())) {
                                if (update_prevented_version != -1) {
                                    update_prevented_version = -1;
                                    COConfigurationManager.setParameter("swt.update.prevented.version", update_prevented_version);
                                }
                            } else {
                                boolean force;
                                String alert = MessageText.getString("swt.alert.cant.update", new String[]{String.valueOf(versionGetter.getCurrentVersion()), String.valueOf(versionGetter.getLatestVersion()), jar_file_dir.toString(), expected_dir.toString()});
                                checker.reportProgress(alert);
                                long last_prompt = COConfigurationManager.getLongParameter("swt.update.prevented.version.time", 0L);
                                long now = SystemTime.getCurrentTime();
                                boolean bl2 = force = now < last_prompt || now - last_prompt > 604800000L;
                                if (!checker.getCheckInstance().isAutomatic()) {
                                    force = true;
                                }
                                if (force || update_prevented_version != versionGetter.getCurrentVersion()) {
                                    Logger.log(new LogAlert(true, 3, alert));
                                    update_prevented_version = versionGetter.getCurrentVersion();
                                    COConfigurationManager.setParameter("swt.update.prevented.version", update_prevented_version);
                                    COConfigurationManager.setParameter("swt.update.prevented.version.time", now);
                                }
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                if (update_prevented_version == versionGetter.getCurrentVersion()) {
                    Logger.log(new LogEvent(LOGID, 3, "SWT update aborted due to previously reported issues regarding its install location"));
                    checker.failed();
                    checker.getCheckInstance().cancel();
                    return;
                }
                String[] mirrors = versionGetter.getMirrors();
                ResourceDownloader swtDownloader = null;
                ResourceDownloaderFactory factory = ResourceDownloaderFactoryImpl.getSingleton();
                ArrayList<ResourceDownloader> downloaders = new ArrayList<ResourceDownloader>();
                for (int i = 0; i < mirrors.length; ++i) {
                    try {
                        downloaders.add(factory.getSuffixBasedDownloader(factory.create(new URL(mirrors[i]))));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        if (!Logger.isEnabled()) continue;
                        Logger.log(new LogEvent(LOGID, 1, "Cannot use URL " + mirrors[i] + " (not valid)"));
                    }
                }
                ResourceDownloader[] resourceDownloaders = downloaders.toArray(new ResourceDownloader[downloaders.size()]);
                swtDownloader = factory.getRandomDownloader(resourceDownloaders);
                try {
                    swtDownloader.getSize();
                }
                catch (ResourceDownloaderException e) {
                    Debug.printStackTrace(e);
                }
                final Update update = checker.addUpdate("SWT Library for " + versionGetter.getPlatform(), new String[]{"SWT is the graphical library used by " + Constants.APP_NAME}, "" + versionGetter.getLatestVersion(), swtDownloader, 2);
                update.setDescriptionURL(versionGetter.getInfoURL());
                swtDownloader.addListener(new ResourceDownloaderAdapter(){

                    public boolean completed(ResourceDownloader downloader, InputStream data) {
                        return SWTUpdateChecker.this.processData(checker, update, downloader, data);
                    }
                });
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(false, "SWT Version check failed", e));
                checker.failed();
            }
            finally {
                checker.completed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processData(UpdateChecker checker, Update update, ResourceDownloader rd, InputStream data) {
        ZipInputStream zip = null;
        try {
            data = update.verifyData(data, true);
            rd.reportActivity("Data verified successfully");
            UpdateInstaller installer = checker.createInstaller();
            zip = new ZipInputStream(data);
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName();
                if (name.endsWith(".jar")) {
                    installer.addResource(name, zip, false);
                    if (Constants.isOSX) {
                        installer.addMoveAction(name, installer.getInstallDir() + OSX_APP + "/Contents/Resources/Java/" + name);
                        continue;
                    }
                    installer.addMoveAction(name, installer.getInstallDir() + File.separator + name);
                    continue;
                }
                if (name.endsWith(".jnilib") && Constants.isOSX) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, installer.getInstallDir() + OSX_APP + "/Contents/Resources/Java/dll/" + name);
                    continue;
                }
                if (name.equals("java_swt")) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, installer.getInstallDir() + OSX_APP + "/Contents/MacOS/" + name);
                    installer.addChangeRightsAction("755", installer.getInstallDir() + OSX_APP + "/Contents/MacOS/" + name);
                    continue;
                }
                if (name.endsWith(".dll") || name.endsWith(".so") || name.indexOf(".so.") != -1) {
                    installer.addResource(name, zip, false);
                    installer.addMoveAction(name, installer.getInstallDir() + File.separator + name);
                    continue;
                }
                if (name.equals("javaw.exe.manifest") || name.equals("azureus.sig")) continue;
                Debug.outNoStack("SWTUpdate: ignoring zip entry '" + name + "'");
            }
        }
        catch (Exception e) {
            Logger.log(new LogAlert(false, "SWT Update failed", e));
            boolean bl = false;
            return bl;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Throwable e) {}
            }
        }
        return true;
    }

    public String getName() {
        return "SWT library";
    }

    public int getMaximumCheckTime() {
        return 30;
    }
}

