/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.views.IView;

public abstract class AbstractIView
implements IView {
    protected AEMonitor this_mon = new AEMonitor("AbstractIView");
    private String lastFullTitleKey = null;
    private String lastFullTitle = "";

    public void initialize(Composite composite) {
    }

    public Composite getComposite() {
        return null;
    }

    public void refresh() {
    }

    public void delete() {
        Composite comp2 = this.getComposite();
        if (comp2 != null && !comp2.isDisposed()) {
            comp2.dispose();
        }
    }

    public String getData() {
        return null;
    }

    public String getFullTitle() {
        String key = this.getData();
        if (key == null) {
            return "";
        }
        if (this.lastFullTitle.length() > 0 && key.equals(this.lastFullTitleKey)) {
            return this.lastFullTitle;
        }
        this.lastFullTitleKey = key;
        this.lastFullTitle = MessageText.keyExists(key) ? MessageText.getString(key) : key.replace('.', ' ');
        return this.lastFullTitle;
    }

    public final String getShortTitle() {
        String shortTitle = this.getFullTitle();
        if (shortTitle != null && shortTitle.length() > 30) {
            shortTitle = shortTitle.substring(0, 30) + "...";
        }
        return shortTitle;
    }

    public void updateLanguage() {
        this.lastFullTitle = "";
        Messages.updateLanguageForControl((Widget)this.getComposite());
    }

    public boolean isEnabled(String itemKey) {
        return false;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
    }

    public void generateDiagnostics(IndentWriter writer) {
        writer.println("Diagnostics for " + this + " (" + this.getFullTitle() + ")");
    }

    public void dataSourceChanged(Object newDataSource) {
    }
}

