/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class DetailedListView
extends AbstractIView
implements ObfusticateImage,
IViewExtension {
    private static int SASH_WIDTH = 8;
    static final TableColumnCore[] tableIncompleteItems = TableColumnCreator.createIncompleteDM("MyTorrents");
    private AzureusCore azureus_core;
    private MyTorrentsView torrentview;
    private UISWTViewImpl managerview;
    private Composite managerview_parent;
    private Composite form;
    private MyTorrentsView lastSelectedView;

    public DetailedListView(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.addColumns(tableIncompleteItems);
    }

    public Composite getComposite() {
        return this.form;
    }

    public void delete() {
        if (this.torrentview != null) {
            this.torrentview.delete();
        }
        super.delete();
    }

    public void initialize(Composite parent) {
        Composite child2;
        if (this.form != null) {
            return;
        }
        this.form = new Composite(parent, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        this.form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        this.form.setLayoutData((Object)gridData);
        final Composite child1 = new Composite(this.form, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        child1.setLayout((Layout)layout);
        this.torrentview = new MyTorrentsView(this.azureus_core, "DetailedTorrentList", false, tableIncompleteItems);
        this.torrentview.initialize(child1);
        this.torrentview.getTableView().addSelectionListener(new TableSelectionAdapter(){

            public void selected(TableRowCore[] rows) {
                try {
                    DownloadManager[] dms = new DownloadManager[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        dms[i] = (DownloadManager)rows[i].getDataSource(true);
                    }
                    DetailedListView.this.refreshDownloadView(dms);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, true);
        final Sash sash = new Sash(this.form, 256);
        this.managerview_parent = child2 = new Composite(this.form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        child2.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        child1.setLayoutData((Object)formData);
        final FormData child1Data = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)child1);
        formData.height = SASH_WIDTH;
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)sash);
        int weight = (int)COConfigurationManager.getFloatParameter("DetailedList.SplitAt");
        if (weight > 10000) {
            weight = 10000;
        } else if (weight < 100) {
            weight *= 100;
        }
        if (weight < 500) {
            weight = 500;
        } else if (weight > 9000) {
            weight = 9000;
        }
        sash.setData("PCT", (Object)new Double((float)weight / 10000.0f));
        child2.setLayoutData((Object)formData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                child1Data.height = e.y + e.height - SASH_WIDTH;
                DetailedListView.this.form.layout();
                Double l = new Double((double)child1.getBounds().height / (double)((DetailedListView)DetailedListView.this).form.getBounds().height);
                sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    COConfigurationManager.setParameter("DetailedList.SplitAt", (int)(l * 10000.0));
                }
            }
        });
        this.form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Double l = (Double)sash.getData("PCT");
                if (l != null) {
                    child1Data.height = (int)((double)((DetailedListView)DetailedListView.this).form.getBounds().height * l);
                    DetailedListView.this.form.layout();
                }
            }
        });
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.torrentview.refresh();
    }

    public void updateLanguage() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.torrentview.updateLanguage();
    }

    public String getFullTitle() {
        return MessageText.getString("DetailedListView.title");
    }

    private MyTorrentsView getCurrentView() {
        try {
            if (this.torrentview.isTableFocus()) {
                this.lastSelectedView = this.torrentview;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastSelectedView;
    }

    public boolean isEnabled(String itemKey) {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    public String getIconBarPluginIdentity() {
        return "torrents";
    }

    public Object[] getIconBarPluginContextData() {
        DownloadManager[] dms = this.getSelectedDownloads();
        if (dms == null) {
            return null;
        }
        Object[] res = new Download[dms.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = PluginCoreUtils.wrap(dms[i]);
        }
        return res;
    }

    public DownloadManager[] getSelectedDownloads() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return null;
        }
        return currentView.getSelectedDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiagnostics(IndentWriter writer) {
        super.generateDiagnostics(writer);
        try {
            writer.indent();
            writer.println("Downloading");
            writer.indent();
            this.torrentview.generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
        try {
            writer.indent();
            writer.println("Seeding");
            writer.indent();
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        if (this.torrentview != null) {
            this.torrentview.obfusticatedImage(image, shellOffset);
        }
        return image;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)((Object)currentView)).viewActivated();
        }
        if (currentView instanceof MyTorrentsView) {
            currentView.updateSelectedContent();
        }
    }

    public void viewDeactivated() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return;
        }
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)((Object)currentView)).viewDeactivated();
        }
        String ID = currentView.getShortTitle();
        if (currentView instanceof MyTorrentsView) {
            ID = currentView.getTableView().getTableID();
        }
        SelectedContentManager.changeCurrentlySelectedContent(ID, null, this.torrentview == null ? null : this.torrentview.getTableView());
    }

    public void refreshDownloadView(DownloadManager[] dms) {
        boolean change;
        System.out.println("refreshDownloadView change");
        if (dms.length != 1) {
            return;
        }
        boolean bl = change = this.managerview == null || !dms[0].equals(this.managerview.getDataSource());
        if (!change) {
            return;
        }
        if (this.managerview != null) {
            this.managerview.delete();
        }
        try {
            this.managerview = new UISWTViewImpl(null, "DMView", new ManagerView(), dms[0]);
            this.managerview.setUseCoreDataSource(true);
            this.managerview.initialize(this.managerview_parent);
            this.managerview_parent.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

