/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectedRowsListener;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.MessageBoxWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.file.FileInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.files.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileExtensionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FirstPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ModeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PieceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ProgressGraphItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.RemainingPiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.StorageTypeItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class FilesView
extends TableViewTab
implements TableDataSourceChangedListener,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
DownloadManagerStateAttributeListener,
TableLifeCycleListener {
    boolean refreshing = false;
    private DragSource dragSource = null;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PathItem(), new SizeItem(), new DoneItem(), new PercentItem(), new FirstPieceItem(), new PieceCountItem(), new RemainingPiecesItem(), new ProgressGraphItem(), new ModeItem(), new PriorityItem(), new StorageTypeItem(), new FileExtensionItem()};
    private DownloadManager manager = null;
    public static boolean show_full_path;
    private MenuItem path_item;
    private TableViewSWT<DiskManagerFileInfo> tv = new TableViewSWTImpl<DiskManagerFileInfo>(org.gudy.azureus2.plugins.disk.DiskManagerFileInfo.class, "Files", "FilesView", basicItems, "firstpiece", 0x10010002);
    private boolean force_refresh = false;
    private boolean is_changing_links = false;

    public FilesView() {
        this.setTableView(this.tv);
        this.tv.setRowDefaultIconSize(new Point(16, 16));
        this.tv.setEnableTabViews(true);
        this.tv.setCoreTabViews(new IView[]{new FileInfoView()});
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addRefreshListener(this, true);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addLifeCycleListener(this);
    }

    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager old_manager = this.manager;
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        if (old_manager != null) {
            old_manager.getDownloadState().removeListener(this, "filelinks", 1);
        }
        if (this.manager != null) {
            this.manager.getDownloadState().addListener(this, "filelinks", 1);
        }
        this.tv.removeAllTableRows();
    }

    public void deselected(TableRowCore[] rows) {
    }

    public void focusChanged(TableRowCore focus) {
    }

    public void selected(TableRowCore[] rows) {
    }

    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)this.tv.getFirstSelectedDataSource();
        if (fileInfo2 != null && fileInfo2.getAccessMode() == 1) {
            Utils.launch(fileInfo2.getFile(true).toString());
        }
    }

    public void fillMenu(String sColumnName, Menu menu) {
        Shell shell = menu.getShell();
        Object[] data_sources = this.tv.getSelectedDataSources().toArray();
        boolean hasSelection = data_sources.length > 0;
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "FilesView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        menu.setDefaultItem(itemOpen);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Object[] dataSources = FilesView.this.tv.getSelectedDataSources().toArray();
                for (int i = dataSources.length - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)dataSources[i];
                    if (info == null) continue;
                    File this_file = info.getFile(true);
                    File parent_file = use_open_containing_folder ? this_file.getParentFile() : null;
                    ManagerUtils.open(parent_file == null ? this_file : parent_file);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        MenuItem itemRenameOrRetarget = null;
        MenuItem itemRename = null;
        MenuItem itemRetarget = null;
        itemRenameOrRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRenameOrRetarget, "FilesView.menu.rename");
        itemRenameOrRetarget.setData("rename", (Object)true);
        itemRenameOrRetarget.setData("retarget", (Object)true);
        itemRename = new MenuItem(menu, 8);
        itemRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRename, "FilesView.menu.rename_only");
        Messages.setLanguageText((Widget)itemRetarget, "FilesView.menu.retarget");
        itemRename.setData("rename", (Object)true);
        itemRename.setData("retarget", (Object)false);
        itemRetarget.setData("rename", (Object)false);
        itemRetarget.setData("retarget", (Object)true);
        MenuItem itemPriority = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemPriority, "FilesView.menu.setpriority");
        Menu menuPriority = new Menu((Decorations)shell, 4);
        itemPriority.setMenu(menuPriority);
        MenuItem itemHigh = new MenuItem(menuPriority, 64);
        itemHigh.setData("Priority", (Object)new Integer(0));
        Messages.setLanguageText((Widget)itemHigh, "FilesView.menu.setpriority.high");
        MenuItem itemLow = new MenuItem(menuPriority, 64);
        itemLow.setData("Priority", (Object)new Integer(1));
        Messages.setLanguageText((Widget)itemLow, "FilesView.menu.setpriority.normal");
        MenuItem itemSkipped = new MenuItem(menuPriority, 64);
        itemSkipped.setData("Priority", (Object)new Integer(2));
        Messages.setLanguageText((Widget)itemSkipped, "FilesView.menu.setpriority.skipped");
        MenuItem itemDelete = new MenuItem(menuPriority, 64);
        itemDelete.setData("Priority", (Object)new Integer(3));
        Messages.setLanguageText((Widget)itemDelete, "wizard.multitracker.delete");
        new MenuItem(menu, 2);
        if (!hasSelection) {
            itemOpen.setEnabled(false);
            itemPriority.setEnabled(false);
            itemRenameOrRetarget.setEnabled(false);
            itemRename.setEnabled(false);
            itemRetarget.setEnabled(false);
            return;
        }
        boolean open = true;
        boolean all_compact = true;
        boolean all_skipped = true;
        boolean all_priority = true;
        boolean all_not_priority = true;
        DiskManagerFileInfo[] dmi_array = new DiskManagerFileInfo[data_sources.length];
        System.arraycopy(data_sources, 0, dmi_array, 0, data_sources.length);
        int[] storage_types = this.manager.getStorageType(dmi_array);
        for (int i = 0; i < dmi_array.length; ++i) {
            DiskManagerFileInfo file_info = dmi_array[i];
            if (open && file_info.getAccessMode() != 1) {
                open = false;
            }
            if (all_compact && storage_types[i] != 2) {
                all_compact = false;
            }
            if (!all_skipped && !all_priority && !all_not_priority) continue;
            if (file_info.isSkipped()) {
                all_priority = false;
                all_not_priority = false;
                continue;
            }
            all_skipped = false;
            if (!all_not_priority && !all_priority) continue;
            if (file_info.isPriority()) {
                all_not_priority = false;
                continue;
            }
            all_priority = false;
        }
        itemOpen.setEnabled(open);
        itemRenameOrRetarget.setEnabled(this.manager.isPersistent());
        itemRename.setEnabled(this.manager.isPersistent());
        itemRetarget.setEnabled(this.manager.isPersistent());
        itemSkipped.setEnabled(!all_skipped);
        itemHigh.setEnabled(!all_priority);
        itemLow.setEnabled(!all_not_priority);
        itemDelete.setEnabled(!all_compact);
        itemOpen.addListener(13, (Listener)new TableSelectedRowsListener(this.tv){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                if (fileInfo2.getAccessMode() == 1) {
                    Utils.launch(fileInfo2.getFile(true).toString());
                }
            }
        });
        Listener rename_listener = new Listener(){

            public void handleEvent(Event event2) {
                boolean rename_it = (Boolean)event2.widget.getData("rename");
                boolean retarget_it = (Boolean)event2.widget.getData("retarget");
                FilesView.this.rename(FilesView.this.tv.getSelectedRows(), rename_it, retarget_it);
            }
        };
        itemRenameOrRetarget.addListener(13, rename_listener);
        itemRename.addListener(13, rename_listener);
        itemRetarget.addListener(13, rename_listener);
        Listener priorityListener = new Listener(){

            public void handleEvent(Event event2) {
                FilesView.this.changePriority((Integer)event2.widget.getData("Priority"), FilesView.this.tv.getSelectedRows());
            }
        };
        itemHigh.addListener(13, priorityListener);
        itemLow.addListener(13, priorityListener);
        itemSkipped.addListener(13, priorityListener);
        itemDelete.addListener(13, priorityListener);
    }

    private String askForRenameFilename(DiskManagerFileInfo fileInfo2) {
        SimpleTextEntryWindow dialog = new SimpleTextEntryWindow("FilesView.rename.filename.title", "FilesView.rename.filename.text");
        dialog.setPreenteredText(fileInfo2.getFile(true).getName(), false);
        dialog.allowEmptyInput(false);
        dialog.prompt();
        if (!dialog.hasSubmittedInput()) {
            return null;
        }
        return dialog.getSubmittedInput();
    }

    private String askForRetargetedFilename(DiskManagerFileInfo fileInfo2) {
        FileDialog fDialog = new FileDialog(Utils.findAnyShell(), 139264);
        File existing_file = fileInfo2.getFile(true);
        fDialog.setFilterPath(existing_file.getParent());
        fDialog.setFileName(existing_file.getName());
        fDialog.setText(MessageText.getString("FilesView.rename.choose.path"));
        return fDialog.open();
    }

    private String askForSaveDirectory(DiskManagerFileInfo fileInfo2) {
        DirectoryDialog dDialog = new DirectoryDialog(Utils.findAnyShell(), 139264);
        File current_dir = fileInfo2.getFile(true).getParentFile();
        dDialog.setFilterPath(current_dir.getPath());
        dDialog.setText(MessageText.getString("FilesView.rename.choose.path.dir"));
        return dDialog.open();
    }

    private boolean askCanOverwrite(File file) {
        return MessageBoxWindow.open("FilesView.messagebox.rename.id", 288, 32, true, Display.getDefault(), "warning", MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{file.toString()})) == 32;
    }

    private void moveFile(final DiskManagerFileInfo fileInfo2, final File target) {
        final boolean[] result = new boolean[]{false};
        this.is_changing_links = true;
        FileUtil.runAsTask(new AzureusCoreOperationTask(){

            public void run(AzureusCoreOperation operation) {
                result[0] = fileInfo2.setLink(target);
            }
        });
        this.is_changing_links = false;
        if (!result[0]) {
            MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
            mb.setText(MessageText.getString("FilesView.rename.failed.title"));
            mb.setMessage(MessageText.getString("FilesView.rename.failed.text"));
            mb.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rename(TableRowCore[] rows, boolean rename_it, boolean retarget_it) {
        if (this.manager == null) {
            return;
        }
        if (rows.length == 0) {
            return;
        }
        String save_dir = null;
        if (!rename_it && retarget_it && (save_dir = this.askForSaveDirectory((DiskManagerFileInfo)rows[0].getDataSource(true))) == null) {
            return;
        }
        boolean paused = false;
        try {
            for (int i = 0; i < rows.length; ++i) {
                String s_target;
                TableRowCore row = rows[i];
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)rows[i].getDataSource(true);
                File existing_file = fileInfo2.getFile(true);
                File f_target = null;
                if (rename_it && retarget_it) {
                    s_target = this.askForRetargetedFilename(fileInfo2);
                    if (s_target != null) {
                        f_target = new File(s_target);
                    }
                } else if (rename_it) {
                    s_target = this.askForRenameFilename(fileInfo2);
                    if (s_target != null) {
                        f_target = new File(existing_file.getParentFile(), s_target);
                    }
                } else {
                    f_target = new File(save_dir, existing_file.getName());
                }
                if (f_target == null) {
                    return;
                }
                if (!paused) {
                    paused = this.manager.pause();
                }
                if (f_target.exists() && (f_target.equals(existing_file) || existing_file.exists() && !this.askCanOverwrite(existing_file))) continue;
                this.moveFile(fileInfo2, f_target);
                row.invalidate();
            }
        }
        finally {
            if (paused) {
                this.manager.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePriority(int type, TableRowCore[] rows) {
        if (this.manager == null) {
            return;
        }
        boolean paused = false;
        try {
            DiskManagerFileInfo[] file_infos = new DiskManagerFileInfo[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                file_infos[i] = (DiskManagerFileInfo)rows[i].getDataSource(true);
                if (type != 0 && type != 1) continue;
                file_infos[i].setPriority(type == 0);
            }
            boolean skipped = type == 2 || type == 3;
            boolean delete_action = type == 3;
            paused = this.setSkipped(file_infos, skipped, delete_action);
        }
        finally {
            if (paused) {
                this.manager.resume();
            }
        }
    }

    private boolean setSkipped(DiskManagerFileInfo[] infos, boolean skipped, boolean delete_action) {
        File save_location;
        if (!this.manager.isPersistent()) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
            return false;
        }
        int[] existing_storage_types = this.manager.getStorageType(infos);
        int nbFiles = this.manager.getDiskManagerFileInfoSet().nbFiles();
        boolean[] setLinear = new boolean[nbFiles];
        boolean[] setCompact = new boolean[nbFiles];
        int compactCount = 0;
        int linearCount = 0;
        if (infos.length > 1) {
            // empty if block
        }
        boolean root_exists = (save_location = this.manager.getAbsoluteSaveLocation()).isDirectory() || infos.length <= 1 && save_location.exists();
        boolean type_has_been_changed = false;
        boolean requires_pausing = false;
        for (int i = 0; i < infos.length; ++i) {
            int existing_storage_type = existing_storage_types[i];
            int new_storage_type = 1;
            if (skipped) {
                File existing_file = infos[i].getFile(true);
                boolean perform_check = root_exists ? true : !FileUtil.isAncestorOf(save_location, existing_file);
                if (perform_check && existing_file.exists()) {
                    if (delete_action) {
                        boolean wants_to_delete;
                        boolean bl = wants_to_delete = MessageBoxWindow.open("FilesView.messagebox.delete.id", 288, 32, true, Display.getDefault(), "warning", MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{existing_file.toString()})) == 32;
                        if (wants_to_delete) {
                            new_storage_type = 2;
                        }
                    }
                } else {
                    new_storage_type = 2;
                }
            }
            boolean has_changed = existing_storage_type != new_storage_type;
            type_has_been_changed |= has_changed;
            requires_pausing |= has_changed && new_storage_type == 2;
            boolean bl = type_has_been_changed = existing_storage_type != new_storage_type;
            if (new_storage_type == 2) {
                setCompact[infos[i].getIndex()] = true;
                ++compactCount;
                continue;
            }
            setLinear[infos[i].getIndex()] = true;
            ++linearCount;
        }
        boolean ok = true;
        boolean paused = false;
        if (type_has_been_changed) {
            if (requires_pausing) {
                paused = this.manager.pause();
            }
            if (linearCount > 0) {
                ok &= Arrays.equals(setLinear, this.manager.getDiskManagerFileInfoSet().setStorageTypes(setLinear, 1));
            }
            if (compactCount > 0) {
                ok &= Arrays.equals(setCompact, this.manager.getDiskManagerFileInfoSet().setStorageTypes(setCompact, 2));
            }
        }
        if (ok) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
        }
        return paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableRefresh() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            if (this.tv.isDisposed()) {
                return;
            }
            DiskManagerFileInfo[] files = this.getFileInfo();
            if (files != null && (this.force_refresh || !this.doAllExist(files))) {
                this.force_refresh = false;
                List datasources = this.tv.getDataSources();
                if (datasources.size() == files.length) {
                    ArrayList<DiskManagerFileInfo> toAdd = new ArrayList<DiskManagerFileInfo>(Arrays.asList(files));
                    ArrayList<DiskManagerFileInfo> toRemove = new ArrayList<DiskManagerFileInfo>();
                    for (int i = 0; i < datasources.size(); ++i) {
                        DiskManagerFileInfo info = (DiskManagerFileInfo)datasources.get(i);
                        if (files[info.getIndex()] == info) {
                            toAdd.set(info.getIndex(), null);
                            continue;
                        }
                        toRemove.add(info);
                    }
                    this.tv.removeDataSources((DiskManagerFileInfo[])toRemove.toArray(new DiskManagerFileInfo[toRemove.size()]));
                    this.tv.addDataSources((DiskManagerFileInfo[])toAdd.toArray(new DiskManagerFileInfo[toAdd.size()]));
                    ((TableViewSWTImpl)this.tv).tableInvalidate();
                } else {
                    this.tv.removeAllTableRows();
                    DiskManagerFileInfo[] filesCopy = new DiskManagerFileInfo[files.length];
                    System.arraycopy(files, 0, filesCopy, 0, files.length);
                    this.tv.addDataSources((DiskManagerFileInfo[])filesCopy);
                }
                this.tv.processDataSourceQueue();
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    private boolean doAllExist(DiskManagerFileInfo[] files) {
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo fileinfo = files[i];
            TableRowCore row = this.tv.getRow(fileinfo);
            if (row == null) {
                return false;
            }
            if (row.getDataSource(true) == fileinfo) continue;
            return false;
        }
        return true;
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("path")) {
            this.path_item = new MenuItem(menuThisColumn, 32);
            menuThisColumn.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    FilesView.this.path_item.setSelection(show_full_path);
                }
            });
            Messages.setLanguageText((Widget)this.path_item, "FilesView.fullpath");
            this.path_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    show_full_path = FilesView.this.path_item.getSelection();
                    FilesView.this.tv.columnInvalidate("path");
                    FilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("FilesView.show.full.path", show_full_path);
                }
            });
        }
    }

    private DiskManagerFileInfo[] getFileInfo() {
        if (this.manager == null) {
            return null;
        }
        return this.manager.getDiskManagerFileInfo();
    }

    public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
        if (this.is_changing_links) {
            return;
        }
        this.force_refresh = true;
    }

    public void tableViewInitialized() {
        this.createDragDrop();
    }

    public void tableViewDestroyed() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    Utils.disposeSWTObjects(new Object[]{FilesView.this.dragSource});
                    FilesView.this.dragSource = null;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
        if (this.manager != null) {
            this.manager.getDownloadState().removeListener(this, "filelinks", 1);
        }
    }

    public void mouseEnter(TableRowCore row) {
    }

    public void mouseExit(TableRowCore row) {
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            this.dragSource = this.tv.createDragSource(3);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = FilesView.this.tv.getSelectedRows();
                        if (rows.length == 0 || FilesView.this.manager == null || FilesView.this.manager.getTorrent() == null) {
                            event2.doit = false;
                            return;
                        }
                        event2.doit = true;
                        Object[] selectedDownloads = FilesView.this.tv.getSelectedDataSources().toArray();
                        this.eventData = "DiskManagerFileInfo\n";
                        TOTorrent torrent = FilesView.this.manager.getTorrent();
                        for (int i = 0; i < selectedDownloads.length; ++i) {
                            DiskManagerFileInfo fi = (DiskManagerFileInfo)selectedDownloads[i];
                            try {
                                this.eventData = this.eventData + torrent.getHashWrapper().toBase32String() + ";" + fi.getIndex() + "\n";
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = this.eventData;
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LogIDs.GUI, "failed to init drag-n-drop", t));
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("FilesView.show.full.path", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path");
            }
        });
    }
}

