/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.io.PrintStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.logging.impl.FileLogging;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class LoggerView
extends AbstractIView
implements ILogEventListener,
ParameterListener {
    private static final int COLOR_INFO = 0;
    private static final int COLOR_WARN = 1;
    private static final int COLOR_ERR = 2;
    private static Color[] colors = null;
    private static final int PREFERRED_LINES = 256;
    private static final int MAX_LINES = 1280;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("[HH:mm:ss.SSS] ");
    private static final FieldPosition formatPos = new FieldPosition(0);
    private Display display;
    private Composite panel;
    private StyledText consoleText = null;
    private Button buttonAutoScroll = null;
    private Object[] filter = null;
    private LinkedList buffer = new LinkedList();
    private boolean bPaused = false;
    private boolean bRealtime = false;
    private boolean bEnabled = false;
    private boolean bAutoScroll = true;
    private Pattern inclusionFilter;
    private Pattern exclusionFilter;
    private ArrayList[] ignoredComponents = new ArrayList[3];
    private boolean stopOnNull = false;

    public LoggerView() {
        this(false);
        this.setEnabled(true);
    }

    public LoggerView(boolean stopOnNull) {
        for (int i = 0; i < this.ignoredComponents.length; ++i) {
            this.ignoredComponents[i] = new ArrayList();
        }
        this.stopOnNull = stopOnNull;
    }

    public LoggerView(List initialList) {
        this();
        if (initialList != null) {
            this.buffer.addAll(initialList);
        }
        this.setEnabled(true);
    }

    public void initialize(Composite composite) {
        this.display = composite.getDisplay();
        Colors.getInstance().addColorsChangedListener(this);
        this.parameterChanged("Color");
        this.panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        layout.numColumns = 2;
        this.panel.setLayout((Layout)layout);
        this.consoleText = new StyledText(this.panel, 776);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.consoleText.setLayoutData((Object)gd);
        this.consoleText.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                GC gc = new GC((Drawable)LoggerView.this.consoleText);
                int charWidth = gc.getFontMetrics().getAverageCharWidth();
                gc.dispose();
                int areaWidth = ((LoggerView)LoggerView.this).consoleText.getBounds().width;
                LoggerView.this.consoleText.setTabs(areaWidth / 6 / charWidth);
            }
        });
        ScrollBar sb = this.consoleText.getVerticalBar();
        sb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerView.this.bAutoScroll = false;
                if (LoggerView.this.buttonAutoScroll != null && !LoggerView.this.buttonAutoScroll.isDisposed()) {
                    LoggerView.this.buttonAutoScroll.setSelection(false);
                }
            }
        });
        Composite cLeft = new Composite(this.panel, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        cLeft.setLayout((Layout)layout);
        gd = new GridData(128, 16384, false, false);
        cLeft.setLayoutData((Object)gd);
        Button buttonPause = new Button(cLeft, 32);
        Messages.setLanguageText((Widget)buttonPause, "LoggerView.pause");
        gd = new GridData();
        buttonPause.setLayoutData((Object)gd);
        buttonPause.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == null || !(e.widget instanceof Button)) {
                    return;
                }
                Button btn = (Button)e.widget;
                LoggerView.this.bPaused = btn.getSelection();
                if (!LoggerView.this.bPaused && LoggerView.this.buffer != null) {
                    LoggerView.this.refresh();
                }
            }
        });
        Button buttonRealtime = new Button(cLeft, 32);
        Messages.setLanguageText((Widget)buttonRealtime, "LoggerView.realtime");
        gd = new GridData();
        buttonRealtime.setLayoutData((Object)gd);
        buttonRealtime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == null || !(e.widget instanceof Button)) {
                    return;
                }
                Button btn = (Button)e.widget;
                LoggerView.this.bRealtime = btn.getSelection();
            }
        });
        this.buttonAutoScroll = new Button(cLeft, 32);
        Messages.setLanguageText((Widget)this.buttonAutoScroll, "LoggerView.autoscroll");
        gd = new GridData();
        this.buttonAutoScroll.setLayoutData((Object)gd);
        this.buttonAutoScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == null || !(e.widget instanceof Button)) {
                    return;
                }
                Button btn = (Button)e.widget;
                LoggerView.this.bAutoScroll = btn.getSelection();
            }
        });
        this.buttonAutoScroll.setSelection(true);
        Button buttonClear = new Button(cLeft, 8);
        Messages.setLanguageText((Widget)buttonClear, "LoggerView.clear");
        gd = new GridData();
        buttonClear.setLayoutData((Object)gd);
        buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerView.this.consoleText.setText("");
            }
        });
        String sFilterPrefix = "ConfigView.section.logging.filter";
        Group gLogIDs = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gLogIDs, "LoggerView.filter");
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        gLogIDs.setLayout((Layout)layout);
        gd = new GridData();
        gLogIDs.setLayoutData((Object)gd);
        Label label = new Label((Composite)gLogIDs, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.logging.level");
        label.setLayoutData((Object)new GridData());
        final Label labelCatFilter = new Label((Composite)gLogIDs, 0);
        labelCatFilter.setLayoutData((Object)new GridData(256));
        final org.eclipse.swt.widgets.List listLogTypes = new org.eclipse.swt.widgets.List((Composite)gLogIDs, 2564);
        gd = new GridData(0, 1, false, false);
        listLogTypes.setLayoutData((Object)gd);
        final int[] logTypes = new int[]{0, 1, 3};
        for (int i = 0; i < logTypes.length; ++i) {
            listLogTypes.add(MessageText.getString("ConfigView.section.logging.log" + i + "type"));
        }
        listLogTypes.select(0);
        LogIDs[] logIDs = FileLogging.configurableLOGIDs;
        Composite cChecksAndButtons = new Composite((Composite)gLogIDs, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cChecksAndButtons.setLayout((Layout)layout);
        cChecksAndButtons.setLayoutData((Object)new GridData());
        final Composite cChecks = new Composite(cChecksAndButtons, 0);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.wrap = true;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        cChecks.setLayout((Layout)rowLayout);
        SelectionAdapter buttonClickListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                Button item = (Button)e.widget;
                if (item.getSelection()) {
                    LoggerView.this.ignoredComponents[index].remove(item.getData("LOGID"));
                } else {
                    LoggerView.this.ignoredComponents[index].add(item.getData("LOGID"));
                }
            }
        };
        for (int i = 0; i < logIDs.length; ++i) {
            Button btn = new Button(cChecks, 32);
            btn.setText(MessageText.getString("ConfigView.section.logging.filter." + logIDs[i], logIDs[i].toString()));
            btn.setData("LOGID", (Object)logIDs[i]);
            btn.addSelectionListener((SelectionListener)buttonClickListener);
            if (i != 0) continue;
            gd = new GridData(4, 4, false, false, 1, 2);
            gd.heightHint = (btn.computeSize((int)-1, (int)-1).y + 2) * 3;
            cChecks.setLayoutData((Object)gd);
        }
        listLogTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                labelCatFilter.setText(MessageText.getString("ConfigView.section.logging.showLogsFor", listLogTypes.getSelection()));
                Control[] items = cChecks.getChildren();
                for (int i = 0; i < items.length; ++i) {
                    LogIDs ID;
                    if (!(items[i] instanceof Button) || (ID = (LogIDs)items[i].getData("LOGID")) == null) continue;
                    boolean checked = !LoggerView.this.ignoredComponents[index].contains(ID);
                    ((Button)items[i]).setSelection(checked);
                }
            }
        });
        listLogTypes.notifyListeners(13, null);
        Button btn = new Button(cChecksAndButtons, 8);
        gd = new GridData();
        btn.setLayoutData((Object)gd);
        Messages.setLanguageText((Widget)btn, "LoggerView.filter.checkAll");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                Control[] items = cChecks.getChildren();
                for (int i = 0; i < items.length; ++i) {
                    LogIDs ID;
                    if (!(items[i] instanceof Button) || (ID = (LogIDs)items[i].getData("LOGID")) == null || !LoggerView.this.ignoredComponents[index].contains(ID)) continue;
                    ((Button)items[i]).setSelection(true);
                    LoggerView.this.ignoredComponents[index].remove(ID);
                }
            }
        });
        btn = new Button(cChecksAndButtons, 8);
        gd = new GridData();
        btn.setLayoutData((Object)gd);
        Messages.setLanguageText((Widget)btn, "LoggerView.filter.uncheckAll");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                Control[] items = cChecks.getChildren();
                for (int i = 0; i < items.length; ++i) {
                    LogIDs ID;
                    if (!(items[i] instanceof Button) || (ID = (LogIDs)items[i].getData("LOGID")) == null || LoggerView.this.ignoredComponents[index].contains(ID)) continue;
                    ((Button)items[i]).setSelection(false);
                    LoggerView.this.ignoredComponents[index].add(ID);
                }
            }
        });
        Composite cBottom = new Composite(this.panel, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        cBottom.setLayoutData((Object)gd);
        cBottom.setLayout((Layout)new GridLayout(2, false));
        label = new Label(cBottom, 0);
        label.setLayoutData((Object)new GridData());
        Messages.setLanguageText((Widget)label, "LoggerView.includeOnly");
        final Text inclText = new Text(cBottom, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        inclText.setLayoutData((Object)gd);
        inclText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newExpression = inclText.getText();
                if (newExpression.length() == 0) {
                    LoggerView.this.inclusionFilter = null;
                } else {
                    try {
                        LoggerView.this.inclusionFilter = Pattern.compile(newExpression, 2);
                        inclText.setBackground(null);
                    }
                    catch (PatternSyntaxException e1) {
                        inclText.setBackground(Colors.colorErrorBG);
                    }
                }
            }
        });
        label = new Label(cBottom, 0);
        label.setLayoutData((Object)new GridData());
        Messages.setLanguageText((Widget)label, "LoggerView.excludeAll");
        final Text exclText = new Text(cBottom, 2048);
        gd = new GridData();
        gd.widthHint = 200;
        exclText.setLayoutData((Object)gd);
        exclText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newExpression = exclText.getText();
                if (newExpression.length() == 0) {
                    LoggerView.this.exclusionFilter = null;
                } else {
                    try {
                        LoggerView.this.exclusionFilter = Pattern.compile(newExpression, 2);
                        exclText.setBackground(null);
                    }
                    catch (PatternSyntaxException e1) {
                        exclText.setBackground(Colors.colorErrorBG);
                    }
                }
            }
        });
        if (!Logger.isEnabled()) {
            this.consoleText.setText(MessageText.getString("LoggerView.loggingDisabled") + "\n");
        }
    }

    public Composite getComposite() {
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.bPaused) {
            return;
        }
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            if (this.consoleText == null || this.consoleText.isDisposed()) {
                return;
            }
            for (int i = 0; i < this.buffer.size(); ++i) {
                try {
                    LogEvent event2 = (LogEvent)this.buffer.get(i);
                    int nbLinesBefore = this.consoleText.getLineCount();
                    if (nbLinesBefore > 1280) {
                        this.consoleText.replaceTextRange(0, this.consoleText.getOffsetAtLine(256), "");
                        nbLinesBefore = this.consoleText.getLineCount();
                    }
                    StringBuffer buf = new StringBuffer();
                    buf.append('\n');
                    dateFormatter.format(event2.timeStamp, buf, formatPos);
                    buf.append("{").append(event2.logID).append("} ");
                    buf.append(event2.text);
                    if (event2.relatedTo != null) {
                        buf.append("; \t| ");
                        for (int j = 0; j < event2.relatedTo.length; ++j) {
                            Object obj = event2.relatedTo[j];
                            if (j > 0) {
                                buf.append("; ");
                            }
                            if (obj instanceof LogRelation) {
                                buf.append(((LogRelation)obj).getRelationText());
                                continue;
                            }
                            if (obj == null) continue;
                            buf.append(obj.getClass().getName()).append(": '").append(obj.toString()).append("'");
                        }
                    }
                    String toAppend = buf.toString();
                    if (this.inclusionFilter != null && !this.inclusionFilter.matcher(toAppend).find() || this.exclusionFilter != null && this.exclusionFilter.matcher(toAppend).find()) continue;
                    this.consoleText.append(toAppend);
                    int nbLinesNow = this.consoleText.getLineCount();
                    int colorIdx = -1;
                    if (event2.entryType == 0) {
                        colorIdx = 0;
                    } else if (event2.entryType == 1) {
                        colorIdx = 1;
                    } else if (event2.entryType == 3) {
                        colorIdx = 2;
                    }
                    if (colors == null || colorIdx < 0) continue;
                    this.consoleText.setLineBackground(nbLinesBefore, nbLinesNow - nbLinesBefore, colors[colorIdx]);
                    continue;
                }
                catch (Exception e) {
                    PrintStream ps = Logger.getOldStdErr();
                    if (ps == null) continue;
                    ps.println("Error writing event to console:");
                    e.printStackTrace(ps);
                }
            }
            this.buffer.clear();
            if (this.bAutoScroll) {
                this.consoleText.setTopIndex(this.consoleText.getLineCount());
            }
        }
    }

    public void delete() {
        Logger.removeListener(this);
        if (this.panel != null && !this.panel.isDisposed()) {
            this.panel.dispose();
        }
        Colors.getInstance().removeColorsChangedListener(this);
    }

    public String getFullTitle() {
        return MessageText.getString("ConsoleView.title.full");
    }

    public String getData() {
        return "ConsoleView.title.short";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void log(LogEvent event2) {
        boolean bMatch;
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if (this.ignoredComponents[this.logTypeToIndex(event2.entryType)].contains(event2.logID)) {
            return;
        }
        boolean bl = bMatch = event2.logID == LogIDs.STDERR || this.filter == null;
        if (!bMatch && event2.relatedTo != null) {
            for (int i = 0; !bMatch && i < event2.relatedTo.length; ++i) {
                Object obj = event2.relatedTo[i];
                if (obj == null) continue;
                for (int j = 0; !bMatch && j < this.filter.length; ++j) {
                    Object newObj;
                    if (obj instanceof LogRelation && (newObj = ((LogRelation)obj).queryForClass(this.filter[j].getClass())) != null) {
                        obj = newObj;
                    }
                    if (obj != this.filter[j]) continue;
                    bMatch = true;
                }
            }
        }
        if (bMatch) {
            LinkedList linkedList = this.buffer;
            synchronized (linkedList) {
                if (this.buffer.size() >= 200) {
                    this.buffer.removeFirst();
                }
                this.buffer.add(event2);
            }
            if (this.bRealtime && !this.bPaused) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        LoggerView.this.refresh();
                    }
                });
            }
        }
    }

    public void setFilter(Object[] _filter) {
        this.filter = _filter;
        this.clearConsole();
    }

    private void clearConsole() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                LoggerView.this.consoleText.setText("");
            }
        });
    }

    public void setEnabled(boolean on) {
        if (this.bEnabled == on) {
            return;
        }
        this.bEnabled = on;
        if (on) {
            Logger.addListener(this);
        } else {
            Logger.removeListener(this);
        }
    }

    public String getPluginViewName() {
        return "Console";
    }

    public void dataSourceChanged(Object newDataSource) {
        if (newDataSource == null) {
            if (this.stopOnNull) {
                this.setEnabled(false);
                return;
            }
            this.setFilter(null);
        } else if (newDataSource instanceof Object[]) {
            this.setFilter((Object[])newDataSource);
        } else {
            this.setFilter(new Object[]{newDataSource});
        }
        this.setEnabled(true);
    }

    private int logTypeToIndex(int entryType) {
        switch (entryType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private int indexToLogType(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.startsWith("Color")) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (LoggerView.this.display == null || LoggerView.this.display.isDisposed()) {
                        return;
                    }
                    if (colors == null) {
                        LoggerView.access$1002(new Color[3]);
                    }
                    Color[] newColors = new Color[]{Colors.blues[2], Colors.colorWarning, Colors.red_ConsoleView};
                    boolean bColorChanged = false;
                    for (int i = 0; i < newColors.length; ++i) {
                        if (colors[i] != null && !colors[i].isDisposed()) continue;
                        colors[i] = newColors[i];
                        bColorChanged = true;
                    }
                    if (bColorChanged && LoggerView.this.consoleText != null) {
                        String text = LoggerView.this.consoleText.getText();
                        LoggerView.this.consoleText.setText(text);
                    }
                }
            });
        }
    }

    static /* synthetic */ Color[] access$1002(Color[] x0) {
        colors = x0;
        return x0;
    }
}

