/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.GeneralView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.PeersGraphicView;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.PiecesView;
import org.gudy.azureus2.ui.swt.views.TorrentInfoView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ManagerView
implements DownloadManagerListener,
ObfusticateTab,
ObfusticateImage,
ViewTitleInfo,
UISWTViewCoreEventListener,
IconBarEnabler,
UIUpdatable {
    private DownloadManager manager;
    private CTabFolder folder;
    private ArrayList tabViews = new ArrayList();
    int lastCompleted = -1;
    private UISWTView swtView;
    private GlobalManagerAdapter gmListener;
    private Composite parent;
    protected IView activeView;

    public ManagerView() {
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        this.gmListener = new GlobalManagerAdapter(){

            public void downloadManagerRemoved(DownloadManager dm) {
                if (dm.equals(ManagerView.this.manager)) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            ManagerView.this.delete();
                        }
                    });
                }
            }
        };
        gm.addListener(this.gmListener, false);
        UIFunctionsManagerSWT.getUIFunctionsSWT().getUIUpdater().addUpdater(this);
    }

    private void dataSourceChanged(Object newDataSource) {
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        DownloadImpl dataSourcePlugin = null;
        if (newDataSource instanceof DownloadImpl) {
            dataSourcePlugin = (DownloadImpl)newDataSource;
            this.manager = dataSourcePlugin.getDownload();
        } else if (newDataSource instanceof DownloadManager) {
            this.manager = (DownloadManager)newDataSource;
            try {
                dataSourcePlugin = DownloadManagerImpl.getDownloadStatic(this.manager);
            }
            catch (DownloadException e) {}
        } else {
            this.manager = null;
        }
        if (this.manager != null) {
            this.manager.addListener(this);
        }
        for (int i = 0; i < this.tabViews.size(); ++i) {
            IView view = (IView)this.tabViews.get(i);
            if (view == null) continue;
            if (view instanceof UISWTViewImpl) {
                ((UISWTViewImpl)view).dataSourceChanged(dataSourcePlugin);
                continue;
            }
            view.dataSourceChanged(newDataSource);
        }
        this.refreshTitle();
        ViewTitleInfoManager.refreshTitleInfo(this);
    }

    private void delete() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.removeManagerView(this.manager);
            uiFunctions.getUIUpdater().removeUpdater(this);
        }
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        try {
            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            gm.removeListener(this.gmListener);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        if (this.folder != null && !this.folder.isDisposed()) {
            this.folder.setSelection(0);
        }
        if (Constants.isOSX && this.folder != null && !this.folder.isDisposed()) {
            CTabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isDisposed()) continue;
                items[i].dispose();
            }
        }
        for (int i = 0; i < this.tabViews.size(); ++i) {
            IView view = (IView)this.tabViews.get(i);
            try {
                if (view == null) continue;
                view.delete();
                continue;
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
        this.tabViews.clear();
        Utils.disposeSWTObjects(new Object[]{this.folder, this.parent});
    }

    private void initialize(Composite composite) {
        this.parent = composite;
        if (this.folder == null) {
            this.folder = new CTabFolder(composite, 16384);
            this.folder.setBorderVisible(true);
        } else {
            System.out.println("ManagerView::initialize : folder isn't null !!!");
        }
        if (composite.getLayout() instanceof FormLayout) {
            this.folder.setLayoutData((Object)Utils.getFilledFormData());
        } else if (composite.getLayout() instanceof GridLayout) {
            this.folder.setLayoutData((Object)new GridData(1808));
        }
        Label lblClose = new Label((Composite)this.folder, 64);
        lblClose.setText("x");
        lblClose.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                ManagerView.this.delete();
            }
        });
        this.folder.setTopRight((Control)lblClose);
        this.folder.setTabHeight(20);
        ArrayList<AbstractIView> iviews_to_use = new ArrayList<AbstractIView>();
        iviews_to_use.add(new GeneralView());
        iviews_to_use.add(new PeersView());
        iviews_to_use.add(new PeersGraphicView());
        iviews_to_use.add(new PiecesView());
        iviews_to_use.add(new FilesView());
        iviews_to_use.add(new TorrentInfoView());
        iviews_to_use.add(new TorrentOptionsView());
        if (Logger.isEnabled()) {
            iviews_to_use.add(new LoggerView(true));
        }
        IView[] views = iviews_to_use.toArray(new IView[iviews_to_use.size()]);
        for (int i = 0; i < views.length; ++i) {
            this.addSection(views[i], this.manager);
        }
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            Map<String, UISWTViewEventListener> pluginViews;
            UISWTInstanceImpl pluginUI = uiFunctions.getSWTPluginInstanceImpl();
            Map<String, UISWTViewEventListener> map = pluginViews = pluginUI == null ? null : pluginUI.getViewListeners("MyTorrents");
            if (pluginViews != null) {
                String[] sNames = pluginViews.keySet().toArray(new String[0]);
                for (int i = 0; i < sNames.length; ++i) {
                    UISWTViewEventListener l = pluginViews.get(sNames[i]);
                    if (l == null) continue;
                    try {
                        UISWTViewImpl view = new UISWTViewImpl("MyTorrents", sNames[i], l);
                        this.addSection(view);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerView.this.refresh();
                CTabItem item = (CTabItem)e.item;
                if (item != null) {
                    IView view;
                    ManagerView.this.activeView = view = (IView)item.getData("IView");
                    if (item.getControl() == null) {
                        view.initialize((Composite)ManagerView.this.folder);
                        item.setControl((Control)view.getComposite());
                    }
                    item.getControl().setFocus();
                }
                ManagerView.this.refresh();
                ViewTitleInfoManager.refreshTitleInfo(ManagerView.this);
            }
        });
        views[0].initialize((Composite)this.folder);
        this.folder.getItem(0).setControl((Control)views[0].getComposite());
        views[0].refresh();
        views[0].getComposite().layout(true);
        views[0].getComposite().setFocus();
        this.activeView = views[0];
        ViewTitleInfoManager.refreshTitleInfo(this);
    }

    private IView getActiveView() {
        return this.activeView;
    }

    private void refresh() {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        try {
            IView view = this.getActiveView();
            if (view != null) {
                view.refresh();
            }
            CTabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                CTabItem item = items[i];
                view = (IView)item.getData("IView");
                try {
                    if (item.isDisposed()) continue;
                    String lastTitle = item.getText();
                    String newTitle = view.getShortTitle();
                    if (lastTitle == null || !lastTitle.equals(newTitle)) {
                        item.setText(ManagerView.escapeAccelerators(newTitle));
                    }
                    String lastToolTip = item.getToolTipText();
                    String newToolTip = view.getFullTitle();
                    if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                    item.setToolTipText(newToolTip);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null) {
                uiFunctions.refreshIconBar();
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void refreshTitle() {
        if (this.swtView != null) {
            int completed;
            int n = completed = this.manager == null ? -1 : this.manager.getStats().getCompleted();
            if (this.lastCompleted != completed) {
                this.swtView.setTitle(DisplayFormatters.formatPercentFromThousands(completed) + " : " + this.manager.getDisplayName());
                ViewTitleInfoManager.refreshTitleInfo(this);
            }
        }
    }

    protected static String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    public boolean isEnabled(String itemKey) {
        IView active_view;
        if (itemKey.equals("run")) {
            return true;
        }
        if (itemKey.equals("start")) {
            return ManagerUtils.isStartable(this.manager);
        }
        if (itemKey.equals("stop")) {
            return ManagerUtils.isStopable(this.manager);
        }
        if (itemKey.equals("remove")) {
            return true;
        }
        if (itemKey.equals("editcolumns") && (active_view = this.getActiveView()) != null) {
            return active_view.isEnabled(itemKey);
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        IView active_view;
        if (itemKey.equals("run")) {
            ManagerUtils.run(this.manager);
            return;
        }
        if (itemKey.equals("start")) {
            ManagerUtils.queue(this.manager, (Composite)this.folder.getShell());
            return;
        }
        if (itemKey.equals("stop")) {
            ManagerUtils.stop(this.manager, this.folder.getShell());
            return;
        }
        if (itemKey.equals("remove")) {
            ManagerUtils.remove(this.manager, null, false, false);
            return;
        }
        if (itemKey.equals("editcolumns") && (active_view = this.getActiveView()) != null) {
            active_view.itemActivated(itemKey);
            return;
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    public void stateChanged(DownloadManager manager, int state) {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        Display display = this.folder.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        });
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void addSection(UISWTViewImpl view) {
        DownloadImpl pluginDataSource = null;
        try {
            pluginDataSource = DownloadManagerImpl.getDownloadStatic(this.manager);
        }
        catch (DownloadException downloadException) {
            // empty catch block
        }
        this.addSection(view, pluginDataSource);
    }

    private void addSection(IView view, Object dataSource) {
        if (view == null) {
            return;
        }
        view.dataSourceChanged(dataSource);
        CTabItem item = new CTabItem(this.folder, 0);
        Messages.setLanguageText((Widget)item, view.getData());
        item.setData("IView", (Object)view);
        this.tabViews.add(view);
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        IView view = this.getActiveView();
        if (view instanceof ObfusticateImage) {
            try {
                ((ObfusticateImage)((Object)view)).obfusticatedImage(image, shellOffset);
            }
            catch (Exception e) {
                Debug.out("Obfusticating " + view, e);
            }
        }
        return image;
    }

    public String getObfusticatedHeader() {
        int completed = this.manager.getStats().getCompleted();
        return DisplayFormatters.formatPercentFromThousands(completed) + " : " + this.manager;
    }

    public DownloadManager getDownload() {
        return this.manager;
    }

    public Object getTitleInfoProperty(int propertyID) {
        if (propertyID == 5) {
            return this.manager == null ? "" : this.manager.getDisplayName();
        }
        if (this.manager == null) {
            return null;
        }
        if (propertyID == 0) {
            int completed = this.manager.getStats().getCompleted();
            if (completed != 1000) {
                return completed / 10 + "%";
            }
        } else {
            if (propertyID == 1) {
                String eta;
                String s = "";
                int completed = this.manager.getStats().getCompleted();
                if (completed != 1000) {
                    s = completed / 10 + "% Complete\n";
                }
                if ((eta = DisplayFormatters.formatETA(this.manager.getStats().getETA())).length() > 0) {
                    s = s + MessageText.getString("TableColumn.header.eta") + ": " + eta + "\n";
                }
                return s;
            }
            if (propertyID == 7) {
                String id;
                if (this.activeView instanceof UISWTViewImpl) {
                    id = "" + ((UISWTViewImpl)this.activeView).getViewID();
                    id = id.substring(id.lastIndexOf(".") + 1);
                } else if (this.activeView != null) {
                    String simpleName = this.activeView.getClass().getName();
                    id = simpleName.substring(simpleName.lastIndexOf(".") + 1);
                } else {
                    id = "??";
                }
                return "DMDetails-" + id;
            }
        }
        return null;
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.folder);
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public String getUpdateUIName() {
        return "DMDetails";
    }

    public void updateUI() {
        this.refreshTitle();
    }
}

