/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class MyTorrentsSuperView
extends AbstractIView
implements ObfusticateImage,
IViewExtension {
    private static int SASH_WIDTH = 5;
    private MyTorrentsView torrentview;
    private MyTorrentsView seedingview;
    private Composite form;
    private MyTorrentsView lastSelectedView;
    private Composite child1;
    private Composite child2;

    public MyTorrentsSuperView() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TableColumnManager tcManager = TableColumnManager.getInstance();
                        tcManager.addColumns(MyTorrentsSuperView.this.getCompleteColumns());
                        tcManager.addColumns(MyTorrentsSuperView.this.getIncompleteColumns());
                    }
                });
            }
        });
    }

    public Composite getComposite() {
        return this.form;
    }

    public void delete() {
        if (this.torrentview != null) {
            this.torrentview.delete();
        }
        if (this.seedingview != null) {
            this.seedingview.delete();
        }
        super.delete();
    }

    public void initialize(final Composite parent) {
        if (this.form != null) {
            return;
        }
        this.form = new Composite(parent, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        this.form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        this.form.setLayoutData((Object)gridData);
        this.child1 = new Composite(this.form, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child1.setLayout((Layout)layout);
        final Sash sash = new Sash(this.form, 256);
        this.child2 = new Composite(this.form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child2.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        this.child1.setLayoutData((Object)formData);
        final FormData child1Data = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.child1);
        formData.height = SASH_WIDTH;
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)sash);
        int weight = (int)COConfigurationManager.getFloatParameter("MyTorrents.SplitAt");
        if (weight > 10000) {
            weight = 10000;
        } else if (weight < 100) {
            weight *= 100;
        }
        if (weight < 500) {
            weight = 500;
        } else if (weight > 9000) {
            weight = 9000;
        }
        sash.setData("PCT", (Object)new Double((float)weight / 10000.0f));
        this.child2.setLayoutData((Object)formData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                child1Data.height = e.y + e.height - SASH_WIDTH;
                MyTorrentsSuperView.this.form.layout();
                Double l = new Double((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).child1.getBounds().height / (double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height);
                sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    int i = (int)(l * 10000.0);
                    COConfigurationManager.setParameter("MyTorrents.SplitAt", i);
                }
            }
        });
        this.form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Double l = (Double)sash.getData("PCT");
                if (l != null) {
                    child1Data.height = (int)((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height * l);
                    MyTorrentsSuperView.this.form.layout();
                }
            }
        });
        try {
            Double l = (Double)sash.getData("PCT");
            if (l != null) {
                child1Data.height = (int)((double)this.form.getBounds().height * l);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        MyTorrentsSuperView.this.initializeWithCore(core, parent);
                    }
                });
            }
        });
    }

    private void initializeWithCore(AzureusCore core, Composite parent) {
        this.torrentview = this.createTorrentView(core, "MyTorrents", false, this.getIncompleteColumns(), this.child1);
        this.seedingview = this.createTorrentView(core, "MySeeders", true, this.getCompleteColumns(), this.child2);
        this.initializeDone();
    }

    public void initializeDone() {
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        if (this.seedingview != null) {
            this.seedingview.refresh();
        }
        if (this.torrentview != null) {
            this.torrentview.refresh();
        }
    }

    public void updateLanguage() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        if (this.seedingview != null) {
            this.seedingview.updateLanguage();
        }
        if (this.torrentview != null) {
            this.torrentview.updateLanguage();
        }
    }

    public String getFullTitle() {
        return MessageText.getString("MyTorrentsView.mytorrents");
    }

    private MyTorrentsView getCurrentView() {
        try {
            if (this.torrentview != null && this.torrentview.isTableFocus()) {
                this.lastSelectedView = this.torrentview;
            } else if (this.seedingview != null && this.seedingview.isTableFocus()) {
                this.lastSelectedView = this.seedingview;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastSelectedView;
    }

    public boolean isEnabled(String itemKey) {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    public DownloadManager[] getSelectedDownloads() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return null;
        }
        return currentView.getSelectedDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiagnostics(IndentWriter writer) {
        super.generateDiagnostics(writer);
        try {
            writer.indent();
            writer.println("Downloading");
            writer.indent();
            this.torrentview.generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
        try {
            writer.indent();
            writer.println("Seeding");
            writer.indent();
            this.seedingview.generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
            writer.exdent();
        }
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        if (this.torrentview != null) {
            this.torrentview.obfusticatedImage(image, shellOffset);
        }
        if (this.seedingview != null) {
            this.seedingview.obfusticatedImage(image, shellOffset);
        }
        return image;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        SelectedContentManager.clearCurrentlySelectedContent();
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)((Object)currentView)).viewActivated();
        }
        if (currentView instanceof MyTorrentsView) {
            currentView.updateSelectedContent();
        }
    }

    public void viewDeactivated() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return;
        }
        if (currentView instanceof IViewExtension) {
            ((IViewExtension)((Object)currentView)).viewDeactivated();
        }
    }

    protected TableColumnCore[] getIncompleteColumns() {
        return TableColumnCreator.createIncompleteDM("MyTorrents");
    }

    protected TableColumnCore[] getCompleteColumns() {
        return TableColumnCreator.createCompleteDM("MySeeders");
    }

    protected MyTorrentsView createTorrentView(AzureusCore _azureus_core, String tableID, boolean isSeedingView, TableColumnCore[] columns, Composite c) {
        MyTorrentsView view = new MyTorrentsView(_azureus_core, tableID, isSeedingView, columns);
        view.initialize(c);
        c.addListener(26, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsSuperView.this.viewActivated();
            }
        });
        c.addListener(27, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsSuperView.this.viewDeactivated();
            }
        });
        return view;
    }

    public MyTorrentsView getTorrentview() {
        return this.torrentview;
    }

    public MyTorrentsView getSeedingview() {
        return this.seedingview;
    }
}

