/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class MyTorrentsView
extends TableViewTab
implements GlobalManagerListener,
ParameterListener,
DownloadManagerListener,
CategoryManagerListener,
CategoryListener,
KeyListener,
TableLifeCycleListener,
TableViewSWTPanelCreator,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableCountChangeListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final int ASYOUTYPE_MODE_FIND = 0;
    private static final int ASYOUTYPE_MODE_FILTER = 1;
    private static final int ASYOUTYPE_MODE = 1;
    private static final int ASYOUTYPE_UPDATEDELAY = 300;
    private static final boolean EXPERIMENT = false;
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    protected boolean isSeedingView;
    private Composite cTablePanel;
    private Font fontButton = null;
    private Composite cCategories;
    private ControlAdapter catResizeAdapter;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    private Composite cHeader = null;
    private Label lblHeader = null;
    private Text txtFilter = null;
    private Label lblX = null;
    private Category currentCategory;
    private int drag_drop_line_start = -1;
    private TableRowCore[] drag_drop_rows = null;
    private TimerEvent searchUpdateEvent;
    private String sLastSearch = "";
    private long lLastSearchTime;
    private boolean bRegexSearch = false;
    private boolean bDNDalwaysIncomplete;
    private TableViewSWT tv;
    private Composite cTableParentPanel;
    protected boolean viewActive;
    private boolean forceHeaderVisible = false;
    private TableSelectionListener defaultSelectedListener;
    private Composite cFilterArea;
    protected boolean resizeHeaderEventQueued;
    private Button btnFilter;
    private boolean top;
    private boolean bottom;
    private boolean up;
    private boolean down;
    private boolean run;
    private boolean start;
    private boolean stop;
    private boolean remove;
    private boolean refreshingTableLabel = false;

    public MyTorrentsView() {
    }

    public MyTorrentsView(AzureusCore _azureus_core, String tableID, boolean isSeedingView, TableColumnCore[] basicItems) {
        this.init(_azureus_core, tableID, isSeedingView, basicItems);
    }

    public void init(AzureusCore _azureus_core, String tableID, boolean isSeedingView, TableColumnCore[] basicItems) {
        this.isSeedingView = isSeedingView;
        this.tv = this.createTableView(isSeedingView ? DownloadTypeComplete.class : DownloadTypeIncomplete.class, tableID, basicItems);
        this.setTableView(this.tv);
        this.tv.setRowDefaultIconSize(new Point(16, 16));
        if (this.getRowDefaultHeight() > 0) {
            this.tv.setRowDefaultHeight(this.getRowDefaultHeight());
        }
        this.azureus_core = _azureus_core;
        this.globalManager = this.azureus_core.getGlobalManager();
        this.currentCategory = CategoryManager.getCategory(1);
        this.tv.addLifeCycleListener(this);
        this.tv.setMainPanelCreator(this);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
        this.tv.addCountChangeListener(this);
        this.forceHeaderVisible = COConfigurationManager.getBooleanParameter("MyTorrentsView.alwaysShowHeader");
    }

    public void tableViewInitialized() {
        this.tv.addKeyListener(this);
        this.createTabs();
        this.createDragDrop();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"DND Always In Incomplete", "Confirm Data Delete", "MyTorrentsView.alwaysShowHeader"}, this);
        if (this.currentCategory != null) {
            this.currentCategory.addCategoryListener(this);
        }
        CategoryManager.addCategoryManagerListener(this);
        this.globalManager.addListener(this, false);
        Object[] dms = this.globalManager.getDownloadManagers().toArray();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = (DownloadManager)dms[i];
            dm.addListener(this);
            if (this.isOurDownloadManager(dm)) continue;
            dms[i] = null;
        }
        this.tv.addDataSources(dms);
        this.tv.processDataSourceQueue();
        this.cTablePanel.layout();
    }

    public void tableViewDestroyed() {
        this.tv.removeKeyListener(this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    Utils.disposeSWTObjects(new Object[]{MyTorrentsView.this.dragSource, MyTorrentsView.this.dropTarget, MyTorrentsView.this.fontButton});
                    MyTorrentsView.this.dragSource = null;
                    MyTorrentsView.this.dropTarget = null;
                    MyTorrentsView.this.fontButton = null;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
        Object[] dms = this.globalManager.getDownloadManagers().toArray();
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = (DownloadManager)dms[i];
            dm.removeListener(this);
        }
        if (this.currentCategory != null) {
            this.currentCategory.removeCategoryListener(this);
        }
        CategoryManager.removeCategoryManagerListener(this);
        this.globalManager.removeListener(this);
        COConfigurationManager.removeParameterListener("DND Always In Incomplete", this);
        COConfigurationManager.removeParameterListener("Confirm Data Delete", this);
        COConfigurationManager.removeParameterListener("User Mode", this);
    }

    public Composite createTableViewPanel(Composite composite) {
        composite.addListener(26, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.viewActive = true;
                MyTorrentsView.this.updateSelectedContent();
                MyTorrentsView.this.refreshIconBar();
            }
        });
        composite.addListener(27, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.viewActive = false;
            }
        });
        this.cTableParentPanel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.cTableParentPanel.setLayout((Layout)layout);
        if (composite.getLayout() instanceof GridLayout) {
            this.cTableParentPanel.setLayoutData((Object)new GridData(1808));
        }
        this.cTablePanel = new Composite(this.cTableParentPanel, 0);
        this.cTablePanel.setBackground(composite.getDisplay().getSystemColor(25));
        this.cTablePanel.setForeground(composite.getDisplay().getSystemColor(24));
        GridData gridData = new GridData(1808);
        this.cTablePanel.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.cTablePanel.setLayout((Layout)layout);
        this.cTablePanel.layout();
        return this.cTablePanel;
    }

    public void setForceHeaderVisible(boolean forceHeaderVisible) {
        this.forceHeaderVisible = forceHeaderVisible;
        if (this.cTablePanel != null && !this.cTablePanel.isDisposed()) {
            this.createTabs();
        }
    }

    private void createTabs() {
        int i;
        Control[] controls;
        boolean show;
        boolean showCat;
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        boolean bl = showCat = this.sLastSearch.length() > 0;
        if (!showCat) {
            for (int i2 = 0; i2 < categories.length; ++i2) {
                if (categories[i2].getType() != 0) continue;
                showCat = true;
                break;
            }
        }
        boolean bl2 = show = showCat || this.forceHeaderVisible;
        if (!showCat && this.cCategories != null && !this.cCategories.isDisposed()) {
            controls = this.cCategories.getChildren();
            for (i = 0; i < controls.length; ++i) {
                controls[i].dispose();
            }
        }
        if (show) {
            if (this.cCategories == null || this.cCategories.isDisposed()) {
                Composite parent = this.cTableParentPanel;
                this.cHeader = new Composite(parent, 0);
                GridData gridData = new GridData(768);
                gridData.horizontalIndent = 5;
                this.cHeader.setLayoutData((Object)gridData);
                this.cHeader.setLayout((Layout)new FormLayout());
                this.lblHeader = new Label(this.cHeader, 64);
                this.updateTableLabel();
                Label lblSep = new Label(this.cHeader, 514);
                gridData = new GridData(1040);
                gridData.heightHint = 5;
                lblSep.setLayoutData((Object)gridData);
                this.btnFilter = new Button(this.cHeader, 2);
                Messages.setLanguageText((Widget)this.btnFilter, "MyTorrentsView.filter");
                this.btnFilter.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean enable = MyTorrentsView.this.btnFilter.getSelection();
                        MyTorrentsView.this.cFilterArea.setVisible(enable);
                        if (enable) {
                            MyTorrentsView.this.sLastSearch = MyTorrentsView.this.txtFilter.getText();
                            MyTorrentsView.this.txtFilter.setFocus();
                        } else {
                            MyTorrentsView.this.sLastSearch = "";
                            MyTorrentsView.this.tv.setFocus();
                        }
                        MyTorrentsView.this.updateLastSearch();
                        MyTorrentsView.this.resizeHeader();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.btnFilter.setSelection(this.sLastSearch.length() != 0);
                this.cFilterArea = new Composite(this.cHeader, 0);
                this.cFilterArea.setVisible(this.sLastSearch.length() != 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 5;
                this.cFilterArea.setLayout((Layout)layout);
                this.cCategories = new Composite(this.cHeader, 0);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                rowLayout.marginLeft = 3;
                rowLayout.marginRight = 0;
                rowLayout.spacing = 0;
                rowLayout.wrap = true;
                this.cCategories.setLayout((Layout)rowLayout);
                FormData fd = new FormData();
                fd.top = new FormAttachment((Control)this.cFilterArea, 0, 0x1000000);
                this.lblHeader.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment((Control)lblSep, 10);
                fd.top = new FormAttachment((Control)this.cFilterArea, 0, 0x1000000);
                this.btnFilter.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment((Control)this.lblHeader, 10);
                fd.top = new FormAttachment((Control)this.cFilterArea, 3, 128);
                fd.bottom = new FormAttachment((Control)this.cFilterArea, -3, 1024);
                lblSep.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment((Control)this.btnFilter, 0);
                fd.right = new FormAttachment((Control)this.cCategories, -10);
                this.cFilterArea.setLayoutData((Object)fd);
                fd = new FormData();
                fd.right = new FormAttachment(100, -2);
                fd.top = new FormAttachment((Control)this.cFilterArea, 0, 0x1000000);
                fd.bottom = new FormAttachment((Control)this.cFilterArea, 0, 1024);
                this.cCategories.setLayoutData((Object)fd);
                this.cHeader.addListener(11, new Listener(){

                    public void handleEvent(Event event2) {
                        if (!MyTorrentsView.this.resizeHeaderEventQueued) {
                            MyTorrentsView.this.resizeHeaderEventQueued = true;
                            Utils.execSWTThreadLater(0, new AERunnable(){

                                public void runSupport() {
                                    MyTorrentsView.this.resizeHeader();
                                    MyTorrentsView.this.resizeHeaderEventQueued = false;
                                }
                            });
                        }
                    }
                });
                this.txtFilter = new Text(this.cFilterArea, 2048);
                Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                this.txtFilter.addKeyListener((KeyListener)this);
                gridData = new GridData(768);
                this.txtFilter.setLayoutData((Object)gridData);
                this.txtFilter.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        MyTorrentsView.this.sLastSearch = ((Text)e.widget).getText();
                        MyTorrentsView.this.showFilterArea();
                        MyTorrentsView.this.updateLastSearch();
                    }
                });
                this.txtFilter.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 0x1000002) {
                            MyTorrentsView.this.tv.setFocus();
                            e.doit = false;
                        } else if (e.character == '\r') {
                            if (MyTorrentsView.this.searchUpdateEvent != null) {
                                MyTorrentsView.this.searchUpdateEvent.cancel();
                            }
                            MyTorrentsView.this.searchUpdateEvent = null;
                            MyTorrentsView.this.activateCategory(MyTorrentsView.this.currentCategory);
                        }
                    }
                });
                this.lblX = new Label(this.cFilterArea, 64);
                Messages.setLanguageTooltip((Widget)this.lblX, "MyTorrentsView.clearFilter.tooltip");
                gridData = new GridData(128);
                this.lblX.setLayoutData((Object)gridData);
                ImageLoader.getInstance().setLabelImage(this.lblX, "smallx-gray");
                this.lblX.setData("ImageID", (Object)"smallx-gray");
                this.lblX.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        if (e.y <= 10) {
                            MyTorrentsView.this.sLastSearch = "";
                            MyTorrentsView.this.txtFilter.setText("");
                            MyTorrentsView.this.updateLastSearch();
                        }
                    }
                });
                lblSep = new Label(this.cFilterArea, 514);
                gridData = new GridData(1040);
                gridData.heightHint = 5;
                lblSep.setLayoutData((Object)gridData);
                this.cHeader.moveAbove(null);
                parent.layout(true);
            } else {
                controls = this.cCategories.getChildren();
                for (i = 0; i < controls.length; ++i) {
                    controls[i].dispose();
                }
            }
            if (showCat) {
                this.buildCat((Category[])categories);
            }
        } else {
            if (this.cHeader != null && !this.cHeader.isDisposed()) {
                this.cHeader.dispose();
            }
            if (this.cTableParentPanel != null && !this.cTableParentPanel.isDisposed()) {
                this.cTableParentPanel.layout();
            }
        }
    }

    protected void showFilterArea() {
        if (this.cFilterArea != null && !this.cFilterArea.isDisposed()) {
            this.cFilterArea.setVisible(true);
        }
        if (this.btnFilter != null && !this.btnFilter.isDisposed()) {
            this.btnFilter.setSelection(true);
        }
    }

    protected void resizeHeader() {
        boolean onNewLine;
        if (this.cCategories == null || this.cCategories.isDisposed()) {
            return;
        }
        Point curCatPos = this.cCategories.getLocation();
        int posEndFilter = this.cFilterArea.getLocation().x + (this.cFilterArea.isVisible() ? 170 : 0);
        boolean bl = onNewLine = ((FormData)this.cCategories.getLayoutData()).left != null;
        if (onNewLine) {
            Point prefSizeCat = this.cCategories.computeSize(-1, -1);
            if (prefSizeCat.x + posEndFilter < this.cHeader.getClientArea().width) {
                FormData fd = new FormData();
                fd.right = new FormAttachment(100, -2);
                fd.top = new FormAttachment((Control)this.cFilterArea, 0, 0x1000000);
                fd.bottom = new FormAttachment((Control)this.cFilterArea, 0, 1024);
                this.cCategories.setLayoutData((Object)fd);
                fd = new FormData();
                fd.left = new FormAttachment((Control)this.btnFilter, 0);
                fd.right = new FormAttachment((Control)this.cCategories, -10);
                this.cFilterArea.setLayoutData((Object)fd);
                this.cHeader.getShell().layout(new Control[]{this.cFilterArea, this.cCategories});
            }
        } else if (curCatPos.x < posEndFilter) {
            FormData fd = new FormData();
            fd.top = new FormAttachment((Control)this.cFilterArea, 2);
            fd.bottom = new FormAttachment(100, -3);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            this.cCategories.setLayoutData((Object)fd);
            fd = new FormData();
            fd.left = new FormAttachment((Control)this.btnFilter, 0);
            fd.right = new FormAttachment(100, -10);
            this.cFilterArea.setLayoutData((Object)fd);
            this.cHeader.getShell().layout(new Control[]{this.cFilterArea, this.cCategories});
        }
    }

    private void buildCat(Category[] categories) {
        int iFontPixelsHeight = 11;
        int iFontPointHeight = iFontPixelsHeight * 72 / this.cCategories.getDisplay().getDPI().y;
        for (int i = 0; i < categories.length; ++i) {
            final Category category = categories[i];
            final Button catButton = new Button(this.cCategories, 2);
            catButton.addKeyListener((KeyListener)this);
            if (i == 0 && this.fontButton == null) {
                Font f = catButton.getFont();
                FontData fd = f.getFontData()[0];
                fd.setHeight(iFontPointHeight);
                this.fontButton = new Font((Device)this.cCategories.getDisplay(), fd);
            }
            catButton.setText("|");
            catButton.setFont(this.fontButton);
            catButton.pack(true);
            if (catButton.computeSize((int)100, (int)-1).y > 0) {
                RowData rd = new RowData();
                rd.height = catButton.computeSize((int)100, (int)-1).y - 2 + catButton.getBorderWidth() * 2;
                catButton.setLayoutData((Object)rd);
            }
            String name = category.getName();
            if (category.getType() == 0) {
                catButton.setText(name);
            } else {
                Messages.setLanguageText((Widget)catButton, name);
            }
            catButton.setData("Category", (Object)category);
            if (category == this.currentCategory) {
                catButton.setSelection(true);
            }
            catButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i;
                    Button curButton = (Button)e.widget;
                    boolean isEnabled = curButton.getSelection();
                    Control[] controls = MyTorrentsView.this.cCategories.getChildren();
                    if (!isEnabled) {
                        for (i = 0; i < controls.length; ++i) {
                            if (!(controls[i] instanceof Button)) continue;
                            curButton = (Button)controls[i];
                            break;
                        }
                    }
                    for (i = 0; i < controls.length; ++i) {
                        if (!(controls[i] instanceof Button)) continue;
                        Button b = (Button)controls[i];
                        if (b != curButton && b.getSelection()) {
                            b.setSelection(false);
                            continue;
                        }
                        if (b != curButton || b.getSelection()) continue;
                        b.setSelection(true);
                    }
                    MyTorrentsView.this.activateCategory((Category)curButton.getData("Category"));
                }
            });
            catButton.addListener(32, new Listener(){

                public void handleEvent(Event event2) {
                    Button curButton = (Button)event2.widget;
                    Category curCategory = (Category)curButton.getData("Category");
                    List dms = curCategory.getDownloadManagers(MyTorrentsView.this.globalManager.getDownloadManagers());
                    long ttlActive = 0L;
                    long ttlSize = 0L;
                    long ttlRSpeed = 0L;
                    long ttlSSpeed = 0L;
                    int count = 0;
                    for (DownloadManager dm : dms) {
                        if (!MyTorrentsView.this.isInCategory(dm, MyTorrentsView.this.currentCategory)) continue;
                        ++count;
                        if (dm.getState() == 50 || dm.getState() == 60) {
                            ++ttlActive;
                        }
                        ttlSize += dm.getSize();
                        ttlRSpeed += dm.getStats().getDataReceiveRate();
                        ttlSSpeed += dm.getStats().getDataSendRate();
                    }
                    String up_details = "";
                    String down_details = "";
                    if (category.getType() != 1) {
                        String up_str = MessageText.getString("GeneralView.label.maxuploadspeed");
                        String down_str = MessageText.getString("GeneralView.label.maxdownloadspeed");
                        String unlimited_str = MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited");
                        int up_speed = category.getUploadSpeed();
                        int down_speed = category.getDownloadSpeed();
                        up_details = up_str + ": " + (up_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(up_speed));
                        down_details = down_str + ": " + (down_speed == 0 ? unlimited_str : DisplayFormatters.formatByteCountToKiBEtc(down_speed));
                    }
                    if (count == 0) {
                        curButton.setToolTipText(down_details + "\n" + up_details + "\nTotal: 0");
                        return;
                    }
                    curButton.setToolTipText((up_details.length() == 0 ? "" : down_details + "\n" + up_details + "\n") + "Total: " + count + "\n" + "Downloading/Seeding: " + ttlActive + "\n" + "\n" + "Speed: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlRSpeed / (long)count) + "/" + DisplayFormatters.formatByteCountToKiBEtcPerSec(ttlSSpeed / (long)count) + "\n" + "Size: " + DisplayFormatters.formatByteCountToKiBEtc(ttlSize));
                }
            });
            final DropTarget tabDropTarget = new DropTarget((Control)catButton, 23);
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            tabDropTarget.setTransfer(types);
            tabDropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void dragOver(DropTargetEvent e) {
                    e.detail = MyTorrentsView.this.drag_drop_line_start >= 0 ? 2 : 0;
                }

                public void drop(DropTargetEvent e) {
                    e.detail = 0;
                    if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                        MyTorrentsView.this.drag_drop_line_start = -1;
                        MyTorrentsView.access$1702(MyTorrentsView.this, null);
                        TorrentUtil.assignToCategory(MyTorrentsView.this.tv.getSelectedDataSources().toArray(), (Category)catButton.getData("Category"));
                    }
                }
            });
            catButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (tabDropTarget != null && !tabDropTarget.isDisposed()) {
                        tabDropTarget.dispose();
                    }
                }
            });
            final Menu menu = new Menu((Decorations)this.getComposite().getShell(), 8);
            catButton.setMenu(menu);
            menu.addMenuListener(new MenuListener(){
                boolean bShown = false;

                public void menuHidden(MenuEvent e) {
                    this.bShown = false;
                    if (Constants.isOSX) {
                        return;
                    }
                    e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            if (bShown || menu.isDisposed()) {
                                return;
                            }
                            MenuItem[] items = menu.getItems();
                            for (int i = 0; i < items.length; ++i) {
                                items[i].dispose();
                            }
                        }
                    });
                }

                public void menuShown(MenuEvent e) {
                    BuddyPlugin buddy_plugin;
                    MenuItem[] items = menu.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        items[i].dispose();
                    }
                    this.bShown = true;
                    if (category.getType() == 0) {
                        MenuItem itemDelete = new MenuItem(menu, 8);
                        Messages.setLanguageText((Widget)itemDelete, "MyTorrentsView.menu.category.delete");
                        menu.setDefaultItem(itemDelete);
                        itemDelete.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                Category catToDelete = (Category)catButton.getData("Category");
                                if (catToDelete != null) {
                                    List managers = catToDelete.getDownloadManagers(MyTorrentsView.this.globalManager.getDownloadManagers());
                                    DownloadManager[] dms = managers.toArray(new DownloadManager[managers.size()]);
                                    for (int i = 0; i < dms.length; ++i) {
                                        dms[i].getDownloadState().setCategory(null);
                                    }
                                    if (MyTorrentsView.this.currentCategory == catToDelete) {
                                        MyTorrentsView.this.activateCategory(CategoryManager.getCategory(1));
                                    } else {
                                        MyTorrentsView.this.activateCategory(MyTorrentsView.this.currentCategory);
                                    }
                                    CategoryManager.removeCategory(catToDelete);
                                }
                            }
                        });
                    }
                    if (category.getType() != 1) {
                        long maxDownload = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0) * 1024;
                        long maxUpload = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0) * 1024;
                        int down_speed = category.getDownloadSpeed();
                        int up_speed = category.getUploadSpeed();
                        ViewUtils.addSpeedMenu(menu.getShell(), menu, true, true, false, down_speed == 0, down_speed, down_speed, maxDownload, false, up_speed == 0, up_speed, up_speed, maxUpload, 1, new ViewUtils.SpeedAdapter(){

                            public void setDownSpeed(int val) {
                                category.setDownloadSpeed(val);
                            }

                            public void setUpSpeed(int val) {
                                category.setUploadSpeed(val);
                            }
                        });
                    }
                    List managers = category.getDownloadManagers(MyTorrentsView.this.globalManager.getDownloadManagers());
                    final DownloadManager[] dms = managers.toArray(new DownloadManager[managers.size()]);
                    boolean start = false;
                    boolean stop = false;
                    for (int i = 0; i < dms.length; ++i) {
                        DownloadManager dm = dms[i];
                        stop = stop || ManagerUtils.isStopable(dm);
                        start = start || ManagerUtils.isStartable(dm);
                    }
                    MenuItem itemQueue = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemQueue, "MyTorrentsView.menu.queue");
                    Utils.setMenuItemImage(itemQueue, "start");
                    itemQueue.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            TorrentUtil.queueTorrents(dms, menu.getShell());
                        }
                    });
                    itemQueue.setEnabled(start);
                    MenuItem itemStop = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
                    Utils.setMenuItemImage(itemStop, "stop");
                    itemStop.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            TorrentUtil.stopTorrents(dms, menu.getShell());
                        }
                    });
                    itemStop.setEnabled(stop);
                    PluginInterface bpi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByClass(BuddyPlugin.class);
                    int cat_type = category.getType();
                    if (bpi != null && cat_type != 2 && (buddy_plugin = (BuddyPlugin)bpi.getPlugin()).isEnabled()) {
                        Menu share_menu = new Menu((Decorations)menu.getShell(), 4);
                        MenuItem share_item = new MenuItem(menu, 64);
                        Messages.setLanguageText((Widget)share_item, "azbuddy.ui.menu.cat.share");
                        share_item.setMenu(share_menu);
                        List<BuddyPluginBuddy> buddies = buddy_plugin.getBuddies();
                        if (buddies.size() == 0) {
                            MenuItem item = new MenuItem(share_menu, 32);
                            item.setText(MessageText.getString("general.add.friends"));
                            item.setEnabled(false);
                        } else {
                            final String cname = cat_type == 1 ? "All" : category.getName();
                            final boolean is_public = buddy_plugin.isPublicCategory(cname);
                            MenuItem itemPubCat = new MenuItem(share_menu, 32);
                            Messages.setLanguageText((Widget)itemPubCat, "general.all.friends");
                            itemPubCat.setSelection(is_public);
                            itemPubCat.addListener(13, new Listener(){

                                public void handleEvent(Event event2) {
                                    if (is_public) {
                                        buddy_plugin.removePublicCategory(cname);
                                    } else {
                                        buddy_plugin.addPublicCategory(cname);
                                    }
                                }
                            });
                            new MenuItem(share_menu, 2);
                            for (final BuddyPluginBuddy buddy : buddies) {
                                if (buddy.getNickName() == null) continue;
                                final boolean auth = buddy.isLocalRSSCategoryAuthorised(cname);
                                MenuItem itemShare = new MenuItem(share_menu, 32);
                                itemShare.setText(buddy.getName());
                                itemShare.setSelection(auth || is_public);
                                if (is_public) {
                                    itemShare.setEnabled(false);
                                }
                                itemShare.addListener(13, new Listener(){

                                    public void handleEvent(Event event2) {
                                        if (auth) {
                                            buddy.removeLocalAuthorisedRSSCategory(cname);
                                        } else {
                                            buddy.addLocalAuthorisedRSSCategory(cname);
                                        }
                                    }
                                });
                            }
                        }
                    }
                    MenuItem itemOptions = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)itemOptions, "MainWindow.menu.view.configuration");
                    itemOptions.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                            uiFunctions.openView(6, dms);
                        }
                    });
                    if (dms.length == 0) {
                        itemOptions.setEnabled(false);
                    }
                }
            });
        }
        this.cHeader.layout(true, true);
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.resizeHeader();
            }
        });
    }

    public boolean isOurDownloadManager(DownloadManager dm) {
        boolean bOurs;
        if (!this.isInCategory(dm, this.currentCategory)) {
            return false;
        }
        boolean bCompleted = dm.isDownloadComplete(this.bDNDalwaysIncomplete);
        boolean bl = bOurs = bCompleted && this.isSeedingView || !bCompleted && !this.isSeedingView;
        if (bOurs) {
            bOurs = this.filterCheck(dm);
        }
        return bOurs;
    }

    public boolean filterCheck(DownloadManager dm) {
        boolean bOurs = true;
        if (this.sLastSearch.length() > 0) {
            try {
                String[][] names = new String[][]{{"", dm.getDisplayName()}, {"t:", dm.getTorrent().getAnnounceURL().getHost()}, {"st:", "" + dm.getState()}};
                String name = names[0][1];
                String tmpSearch = this.sLastSearch;
                for (int i = 0; i < names.length; ++i) {
                    if (!tmpSearch.startsWith(names[i][0])) continue;
                    tmpSearch = tmpSearch.substring(names[i][0].length());
                    name = names[i][1];
                }
                String s = this.bRegexSearch ? tmpSearch : "\\Q" + tmpSearch.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
                Pattern pattern = Pattern.compile(s, 2);
                if (!pattern.matcher(name).find()) {
                    bOurs = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bOurs;
    }

    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
        this.refreshIconBar();
    }

    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
        this.refreshTorrentMenu();
        this.refreshIconBar();
    }

    public void focusChanged(TableRowCore focus) {
        this.refreshIconBar();
        this.refreshTorrentMenu();
    }

    public void mouseEnter(TableRowCore row) {
    }

    public void mouseExit(TableRowCore row) {
    }

    public void updateSelectedContent() {
        if (this.cTablePanel == null || this.cTablePanel.isDisposed() || !this.cTablePanel.isVisible()) {
            return;
        }
        DownloadManager[] dms = this.getSelectedDownloads();
        ISelectedContent[] sc = new ISelectedContent[dms.length];
        int pos = 0;
        for (int i = 0; i < dms.length; ++i) {
            DownloadManager dm = dms[i];
            if (dm == null) continue;
            try {
                sc[pos] = new SelectedContent(dm);
                ++pos;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (pos != dms.length) {
            ISelectedContent[] sc_temp = new ISelectedContent[pos];
            System.arraycopy(sc, 0, sc_temp, 0, pos);
            sc = sc_temp;
        }
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
    }

    private void refreshIconBar() {
        this.computePossibleActions();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    private void refreshTorrentMenu() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null && uiFunctions instanceof UIFunctionsSWT) {
            ((UIFunctionsSWT)uiFunctions).refreshTorrentMenu();
        }
    }

    public DownloadManager[] getSelectedDownloads() {
        Object[] data_sources = this.tv.getSelectedDataSources().toArray();
        DownloadManager[] result = new DownloadManager[data_sources.length];
        System.arraycopy(data_sources, 0, result, 0, result.length);
        return result;
    }

    public void defaultSelected(TableRowCore[] rows, int keyMask) {
        if (this.defaultSelectedListener != null) {
            this.defaultSelectedListener.defaultSelected(rows, keyMask);
            return;
        }
        this.showSelectedDetails();
    }

    private void showSelectedDetails() {
        Object[] dm_sources = this.tv.getSelectedDataSources().toArray();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        for (int i = 0; i < dm_sources.length; ++i) {
            if (dm_sources[i] == null || uiFunctions == null) continue;
            uiFunctions.openView(5, (DownloadManager)dm_sources[i]);
        }
    }

    public void overrideDefaultSelected(TableSelectionListener defaultSelectedListener) {
        this.defaultSelectedListener = defaultSelectedListener;
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("health")) {
            MenuItem item = new MenuItem(menuThisColumn, 8);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.health");
            Utils.setMenuItemImage(item, "st_explain");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    HealthHelpWindow.show(Display.getDefault());
                }
            });
        }
    }

    public void fillMenu(String sColumnName, Menu menu) {
        boolean hasSelection;
        Object[] dm_items = this.tv.getSelectedDataSources().toArray();
        boolean bl = hasSelection = dm_items.length > 0;
        if (hasSelection) {
            DownloadManager[] dms = new DownloadManager[dm_items.length];
            for (int i = 0; i < dm_items.length; ++i) {
                dms[i] = (DownloadManager)dm_items[i];
            }
            TorrentUtil.fillTorrentMenu(menu, dms, this.azureus_core, this.cTablePanel, true, this.isSeedingView ? 2 : 1, this.tv);
            new MenuItem(menu, 2);
        }
        MenuItem itemFilter = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemFilter, "MyTorrentsView.menu.filter");
        itemFilter.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsView.this.openFilterDialog();
            }
        });
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
                this.dropTarget.dispose();
            }
            this.dragSource = this.tv.createDragSource(3);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = MyTorrentsView.this.tv.getSelectedRows();
                        if (rows.length != 0) {
                            event2.doit = true;
                            MyTorrentsView.this.drag_drop_line_start = rows[0].getIndex();
                            MyTorrentsView.access$1702(MyTorrentsView.this, rows);
                        } else {
                            event2.doit = false;
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.access$1702(MyTorrentsView.this, null);
                        }
                        DownloadManager[] selectedDownloads = MyTorrentsView.this.getSelectedDownloads();
                        this.eventData = "DownloadManager\n";
                        for (int i = 0; i < selectedDownloads.length; ++i) {
                            DownloadManager dm = selectedDownloads[i];
                            TOTorrent torrent = dm.getTorrent();
                            try {
                                this.eventData = this.eventData + torrent.getHashWrapper().toBase32String() + "\n";
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = this.eventData;
                    }
                });
            }
            this.dropTarget = this.tv.createDropTarget(31);
            if (this.dropTarget != null) {
                if (SWT.getVersion() >= 3107) {
                    this.dropTarget.setTransfer(new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    this.dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                }
                this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dropAccept(DropTargetEvent event2) {
                        event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                    }

                    public void dragEnter(DropTargetEvent event2) {
                        if (MyTorrentsView.this.drag_drop_line_start < 0) {
                            if (event2.detail != 1) {
                                if ((event2.operations & 4) > 0) {
                                    event2.detail = 4;
                                } else if ((event2.operations & 1) > 0) {
                                    event2.detail = 1;
                                }
                            }
                        } else if (TextTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 10;
                        }
                    }

                    public void dragOver(DropTargetEvent event2) {
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 10;
                        }
                    }

                    public void drop(DropTargetEvent event2) {
                        if (!(event2.data instanceof String) || !((String)event2.data).startsWith("DownloadManager\n")) {
                            TorrentOpener.openDroppedTorrents(event2, true);
                            return;
                        }
                        event2.detail = 0;
                        if (MyTorrentsView.this.drag_drop_line_start >= 0) {
                            event2.detail = 0;
                            TableRowCore row = MyTorrentsView.this.tv.getRow(event2);
                            if (row == null) {
                                return;
                            }
                            int drag_drop_line_end = row.getIndex();
                            if (drag_drop_line_end != MyTorrentsView.this.drag_drop_line_start) {
                                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                                MyTorrentsView.this.moveRowsTo(MyTorrentsView.this.drag_drop_rows, dm.getPosition());
                                event2.detail = 2;
                            }
                            MyTorrentsView.this.drag_drop_line_start = -1;
                            MyTorrentsView.access$1702(MyTorrentsView.this, null);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LOGID, "failed to init drag-n-drop", t));
        }
    }

    private void moveRowsTo(TableRowCore[] rows, int iNewPos) {
        if (rows == null || rows.length == 0) {
            return;
        }
        TableColumnCore sortColumn = this.tv.getSortColumn();
        boolean isSortAscending = sortColumn == null ? true : sortColumn.isSortAscending();
        for (int i = 0; i < rows.length; ++i) {
            TableRowCore row = rows[i];
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            int iOldPos = dm.getPosition();
            this.globalManager.moveTo(dm, iNewPos);
            if (isSortAscending) {
                if (iOldPos <= iNewPos) continue;
                ++iNewPos;
                continue;
            }
            if (iOldPos >= iNewPos) continue;
            --iNewPos;
        }
        boolean bForceSort = sortColumn.getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    public void tableRefresh() {
        if (this.tv.isDisposed()) {
            return;
        }
        this.refreshTorrentMenu();
    }

    public void keyPressed(KeyEvent e) {
        int key = e.character;
        if (key <= 26 && key > 0) {
            key += 96;
        }
        if (e.stateMask == 393216) {
            if (key == 115) {
                ManagerUtils.asyncStopAll();
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000002) {
                this.moveSelectedTorrents(10);
                e.doit = false;
                return;
            }
            if (e.keyCode == 0x1000001) {
                this.moveSelectedTorrents(-10);
                e.doit = false;
                return;
            }
        }
        if (e.stateMask == SWT.MOD1) {
            switch (key) {
                case 97: {
                    if (e.widget == this.txtFilter) break;
                    this.tv.selectAll();
                    e.doit = false;
                    break;
                }
                case 99: {
                    if (e.widget == this.txtFilter) break;
                    this.tv.clipboardSelected();
                    e.doit = false;
                    break;
                }
                case 102: {
                    this.openFilterDialog();
                    e.doit = false;
                    break;
                }
                case 105: {
                    this.showSelectedDetails();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.stateMask == 262144) {
            switch (e.keyCode) {
                case 0x1000001: {
                    this.moveSelectedTorrentsUp();
                    e.doit = false;
                    break;
                }
                case 0x1000002: {
                    this.moveSelectedTorrentsDown();
                    e.doit = false;
                    break;
                }
                case 0x1000007: {
                    this.moveSelectedTorrentsTop();
                    e.doit = false;
                    break;
                }
                case 0x1000008: {
                    this.moveSelectedTorrentsEnd();
                    e.doit = false;
                }
            }
            if (!e.doit) {
                return;
            }
            switch (key) {
                case 114: {
                    TorrentUtil.resumeTorrents(this.tv.getSelectedDataSources().toArray());
                    e.doit = false;
                    break;
                }
                case 115: {
                    TorrentUtil.stopTorrents(this.tv.getSelectedDataSources().toArray(), this.cTablePanel.getShell());
                    e.doit = false;
                    break;
                }
                case 120: {
                    this.bRegexSearch = !this.bRegexSearch;
                    e.doit = false;
                    this.updateLastSearch();
                }
            }
            if (!e.doit) {
                return;
            }
        }
        if (e.stateMask == 0 && e.keyCode == 127 && e.widget != this.txtFilter) {
            TorrentUtil.removeTorrents(this.tv.getSelectedDataSources().toArray(), this.cTablePanel.getShell());
            e.doit = false;
            return;
        }
        if (e.keyCode != 8 && ((e.stateMask & 0xFFFDFFFF) != 0 || e.character < ' ')) {
            return;
        }
        if (e.widget == this.txtFilter) {
            return;
        }
        if (e.keyCode == 8) {
            if (e.stateMask == 262144) {
                this.sLastSearch = "";
            } else if (this.sLastSearch.length() > 0) {
                this.sLastSearch = this.sLastSearch.substring(0, this.sLastSearch.length() - 1);
            }
        } else {
            this.sLastSearch = this.sLastSearch + String.valueOf(e.character);
        }
        this.showFilterArea();
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            this.txtFilter.setFocus();
        }
        this.updateLastSearch();
        e.doit = false;
    }

    private void openFilterDialog() {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setFilter.title", new String[]{MessageText.getString(this.tv.getTableID() + "View" + ".header")}, "MyTorrentsView.dialog.setFilter.text", null);
        entryWindow.setPreenteredText(this.sLastSearch, false);
        entryWindow.prompt();
        if (!entryWindow.hasSubmittedInput()) {
            return;
        }
        String message = entryWindow.getSubmittedInput();
        if (message == null) {
            message = "";
        }
        this.sLastSearch = message;
        this.updateLastSearch();
    }

    private void updateLastSearch() {
        if (this.lblHeader == null || this.lblHeader.isDisposed()) {
            this.createTabs();
        }
        if (this.txtFilter != null && !this.txtFilter.isDisposed() && this.txtFilter.isVisible()) {
            if (!this.sLastSearch.equals(this.txtFilter.getText())) {
                this.txtFilter.setText(this.sLastSearch);
                this.txtFilter.setSelection(this.sLastSearch.length());
            }
            if (this.bRegexSearch) {
                try {
                    Pattern.compile(this.sLastSearch, 2);
                    this.txtFilter.setBackground(Colors.colorAltRow);
                    Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                }
                catch (Exception e) {
                    this.txtFilter.setBackground(Colors.colorErrorBG);
                    this.txtFilter.setToolTipText(e.getMessage());
                }
            } else {
                this.txtFilter.setBackground(null);
                Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
            }
        }
        if (this.lblX != null && !this.lblX.isDisposed()) {
            String id;
            String oldID = (String)this.lblX.getData("ImageID");
            String string = id = this.sLastSearch.length() > 0 ? "smallx" : "smallx-gray";
            if (oldID == null || !oldID.equals(id)) {
                ImageLoader.getInstance().setLabelImage(this.lblX, id);
                this.lblX.setData("ImageID", (Object)id);
            }
        }
        if (this.searchUpdateEvent != null) {
            this.searchUpdateEvent.cancel();
        }
        this.searchUpdateEvent = SimpleTimer.addEvent("SearchUpdate", SystemTime.getOffsetTime(300L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (MyTorrentsView.this.searchUpdateEvent.isCancelled()) {
                    MyTorrentsView.this.searchUpdateEvent = null;
                    return;
                }
                MyTorrentsView.this.searchUpdateEvent = null;
                MyTorrentsView.this.activateCategory(MyTorrentsView.this.currentCategory);
            }
        });
    }

    public void keyReleased(KeyEvent e) {
    }

    private void moveSelectedTorrentsDown() {
        Object[] dataSources = this.tv.getSelectedDataSources().toArray();
        Arrays.sort(dataSources, new Comparator(){

            public int compare(Object a, Object b) {
                return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
            }
        });
        for (int i = dataSources.length - 1; i >= 0; --i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (!dm.getGlobalManager().isMoveableDown(dm)) continue;
            dm.getGlobalManager().moveDown(dm);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrentsUp() {
        Object[] dataSources = this.tv.getSelectedDataSources().toArray();
        Arrays.sort(dataSources, new Comparator(){

            public int compare(Object a, Object b) {
                return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
            }
        });
        for (int i = 0; i < dataSources.length; ++i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (!dm.getGlobalManager().isMoveableUp(dm)) continue;
            dm.getGlobalManager().moveUp(dm);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrents(int by) {
        DownloadManager dm;
        int i;
        Object[] dataSources = this.tv.getSelectedDataSources().toArray();
        if (dataSources.length <= 0) {
            return;
        }
        int[] newPositions = new int[dataSources.length];
        if (by < 0) {
            Arrays.sort(dataSources, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                }
            });
        } else {
            Arrays.sort(dataSources, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((DownloadManager)b).getPosition() - ((DownloadManager)a).getPosition();
                }
            });
        }
        int count = this.globalManager.downloadManagerCount(this.isSeedingView);
        for (i = 0; i < dataSources.length; ++i) {
            dm = (DownloadManager)dataSources[i];
            int pos = dm.getPosition() + by;
            if (pos < i + 1) {
                pos = i + 1;
            } else if (pos > count - i) {
                pos = count - i;
            }
            newPositions[i] = pos;
        }
        for (i = 0; i < dataSources.length; ++i) {
            dm = (DownloadManager)dataSources[i];
            this.globalManager.moveTo(dm, newPositions[i]);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        this.tv.columnInvalidate("#");
        this.tv.refreshTable(bForceSort);
    }

    private void moveSelectedTorrentsTop() {
        this.moveSelectedTorrentsTopOrEnd(true);
    }

    private void moveSelectedTorrentsEnd() {
        this.moveSelectedTorrentsTopOrEnd(false);
    }

    private void moveSelectedTorrentsTopOrEnd(boolean moveToTop) {
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length == 0) {
            return;
        }
        DownloadManager[] downloadManagers = new DownloadManager[datasources.length];
        System.arraycopy(datasources, 0, downloadManagers, 0, datasources.length);
        if (moveToTop) {
            this.globalManager.moveTop(downloadManagers);
        } else {
            this.globalManager.moveEnd(downloadManagers);
        }
        boolean bForceSort = this.tv.getSortColumn().getName().equals("#");
        if (bForceSort) {
            this.tv.columnInvalidate("#");
            this.tv.refreshTable(bForceSort);
        }
    }

    public void parameterChanged(String parameterName) {
        if (parameterName == null || parameterName.equals("DND Always In Incomplete")) {
            this.bDNDalwaysIncomplete = COConfigurationManager.getBooleanParameter("DND Always In Incomplete");
        }
        if (parameterName == null || parameterName.equals("MyTorrentsView.alwaysShowHeader")) {
            this.setForceHeaderVisible(COConfigurationManager.getBooleanParameter("MyTorrentsView.alwaysShowHeader"));
        }
    }

    private void computePossibleActions() {
        Object[] dataSources = this.tv.getSelectedDataSources().toArray();
        this.remove = dataSources.length > 0;
        this.run = this.remove;
        this.down = this.remove;
        this.up = this.remove;
        this.stop = false;
        this.start = false;
        this.bottom = false;
        this.top = false;
        for (int i = 0; i < dataSources.length; ++i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (!this.start && ManagerUtils.isStartable(dm)) {
                this.start = true;
            }
            if (!this.stop && ManagerUtils.isStopable(dm)) {
                this.stop = true;
            }
            if (!this.top && dm.getGlobalManager().isMoveableUp(dm)) {
                this.top = true;
            }
            if (this.bottom || !dm.getGlobalManager().isMoveableDown(dm)) continue;
            this.bottom = true;
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("run")) {
            return this.run;
        }
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        if (itemKey.equals("top")) {
            return this.top;
        }
        if (itemKey.equals("bottom")) {
            return this.bottom;
        }
        if (itemKey.equals("up")) {
            return this.up;
        }
        if (itemKey.equals("down")) {
            return this.down;
        }
        if (itemKey.equals("share")) {
            return this.remove;
        }
        if (itemKey.equals("transcode")) {
            return this.remove;
        }
        return super.isEnabled(itemKey);
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("top")) {
            this.moveSelectedTorrentsTop();
            return;
        }
        if (itemKey.equals("bottom")) {
            this.moveSelectedTorrentsEnd();
            return;
        }
        if (itemKey.equals("up")) {
            this.moveSelectedTorrentsUp();
            return;
        }
        if (itemKey.equals("down")) {
            this.moveSelectedTorrentsDown();
            return;
        }
        if (itemKey.equals("run")) {
            TorrentUtil.runTorrents(this.tv.getSelectedDataSources().toArray());
            return;
        }
        if (itemKey.equals("start")) {
            TorrentUtil.queueTorrents(this.tv.getSelectedDataSources().toArray(), this.cTablePanel.getShell());
            return;
        }
        if (itemKey.equals("stop")) {
            TorrentUtil.stopTorrents(this.tv.getSelectedDataSources().toArray(), this.cTablePanel.getShell());
            return;
        }
        if (itemKey.equals("remove")) {
            TorrentUtil.removeTorrents(this.tv.getSelectedDataSources().toArray(), this.cTablePanel.getShell());
            return;
        }
        super.itemActivated(itemKey);
    }

    public void downloadManagerAdded(Category category, DownloadManager manager) {
        if (this.isOurDownloadManager(manager)) {
            this.tv.addDataSource(manager);
        }
    }

    public void downloadManagerRemoved(Category category, DownloadManager removed) {
        this.tv.removeDataSource(removed);
    }

    public void stateChanged(DownloadManager manager, int state) {
        final TableRowCore row = this.tv.getRow(manager);
        if (row != null) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    row.refresh(true);
                    if (row.isSelected()) {
                        MyTorrentsView.this.refreshIconBar();
                    }
                }
            });
        }
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        if (this.isOurDownloadManager(download)) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    MyTorrentsView.this.refreshIconBar();
                }
            });
        }
    }

    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
        if (this.isOurDownloadManager(manager)) {
            if (this.currentCategory == null || this.currentCategory.getType() == 1) {
                this.tv.addDataSource(manager);
            } else {
                int catType = this.currentCategory.getType();
                Category manager_category = manager.getDownloadState().getCategory();
                if (manager_category == null) {
                    if (catType == 2) {
                        this.tv.addDataSource(manager);
                    }
                } else if (this.currentCategory.getName().equals(manager_category.getName())) {
                    this.tv.addDataSource(manager);
                }
            }
        } else if (this.isSeedingView && !bCompleted || !this.isSeedingView && bCompleted) {
            this.tv.removeDataSource(manager);
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    private void activateCategory(Category category) {
        if (category != this.currentCategory) {
            if (this.currentCategory != null) {
                this.currentCategory.removeCategoryListener(this);
            }
            if (category != null) {
                category.addCategoryListener(this);
            }
            this.currentCategory = category;
        }
        Object[] managers = this.globalManager.getDownloadManagers().toArray();
        List list = this.tv.getDataSources();
        ArrayList<DownloadManager> listRemoves = new ArrayList<DownloadManager>();
        ArrayList<DownloadManager> listAdds = new ArrayList<DownloadManager>();
        for (int i = 0; i < managers.length; ++i) {
            DownloadManager dm = (DownloadManager)managers[i];
            boolean bHave = list.contains(dm);
            if (!this.isOurDownloadManager(dm)) {
                if (!bHave) continue;
                listRemoves.add(dm);
                continue;
            }
            if (bHave) continue;
            listAdds.add(dm);
        }
        this.tv.removeDataSources(listRemoves.toArray());
        this.tv.addDataSources(listAdds.toArray());
        this.tv.processDataSourceQueue();
    }

    public boolean isInCurrentCategory(DownloadManager manager) {
        return this.isInCategory(manager, this.currentCategory);
    }

    private boolean isInCategory(DownloadManager manager, Category category) {
        if (category == null) {
            return true;
        }
        int type = category.getType();
        if (type == 1) {
            return true;
        }
        Category dmCategory = manager.getDownloadState().getCategory();
        if (dmCategory == null) {
            return type == 2;
        }
        return category.equals(dmCategory);
    }

    public void categoryAdded(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.createTabs();
            }
        });
    }

    public void categoryRemoved(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTorrentsView.this.createTabs();
            }
        });
    }

    public void downloadManagerAdded(DownloadManager dm) {
        dm.addListener(this);
        this.downloadManagerAdded(null, dm);
    }

    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removeListener(this);
        DownloadBar.close(dm);
        this.downloadManagerRemoved(null, dm);
    }

    public void destroyInitiated() {
    }

    public void destroyed() {
    }

    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    public void rowAdded(TableRowCore row) {
        this.updateTableLabel();
    }

    public void rowRemoved(TableRowCore row) {
        this.updateTableLabel();
    }

    public void updateLanguage() {
        super.updateLanguage();
        this.updateTableLabel();
        this.getComposite().layout(true, true);
    }

    private void updateTableLabel() {
        if (this.refreshingTableLabel || this.lblHeader == null || this.lblHeader.isDisposed()) {
            return;
        }
        this.refreshingTableLabel = true;
        this.lblHeader.getDisplay().asyncExec((Runnable)new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    if (MyTorrentsView.this.lblHeader != null && !MyTorrentsView.this.lblHeader.isDisposed()) {
                        String sText = MessageText.getString(MyTorrentsView.this.tv.getTableID() + "View" + ".header") + " (" + MyTorrentsView.this.tv.size(true) + ")";
                        MyTorrentsView.this.lblHeader.setText(sText);
                        MyTorrentsView.this.lblHeader.getParent().layout();
                    }
                }
                finally {
                    MyTorrentsView.this.refreshingTableLabel = false;
                }
            }
        });
    }

    public boolean isTableFocus() {
        return this.viewActive;
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        return this.tv.obfusticatedImage(image, shellOffset);
    }

    protected TableViewSWT createTableView(Class forDataSourceType, String tableID, TableColumnCore[] basicItems) {
        int tableExtraStyle = COConfigurationManager.getIntParameter("MyTorrentsView.table.style");
        return new TableViewSWTImpl(forDataSourceType, tableID, "MyTorrentsView", basicItems, "#", tableExtraStyle | 2 | 0x10000 | 0x10000000){

            protected void setSelectedRowIndexes(int[] newSelectedRowIndices) {
                super.setSelectedRowIndexes(newSelectedRowIndices);
                MyTorrentsView.this.updateSelectedContent();
            }
        };
    }

    protected int getRowDefaultHeight() {
        return -1;
    }

    static /* synthetic */ TableRowCore[] access$1702(MyTorrentsView x0, TableRowCore[] x1) {
        x0.drag_drop_rows = x1;
        return x1;
    }
}

