/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.ui.swt.components.graphics.PieUtils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class PeersGraphicView
extends AbstractIView
implements DownloadManagerPeerListener {
    private DownloadManager manager = null;
    private static final int NB_ANGLES = 1000;
    private double[] angles;
    private double[] deltaPerimeters;
    private double perimeter;
    private double[] rs;
    private double[] deltaXXs;
    private double[] deltaXYs;
    private double[] deltaYXs;
    private double[] deltaYYs;
    private Point oldSize;
    private List peers;
    private AEMonitor peers_mon = new AEMonitor("PeersGraphicView:peers");
    private PeerComparator peerComparator;
    private Display display;
    private Composite panel;
    private static final int PEER_SIZE = 15;
    private static final int PACKET_SIZE = 10;
    private static final int OWN_SIZE = 75;
    private boolean antiAliasingAvailable = true;

    public PeersGraphicView() {
        this.angles = new double[1000];
        this.deltaPerimeters = new double[1000];
        this.rs = new double[1000];
        this.deltaXXs = new double[1000];
        this.deltaXYs = new double[1000];
        this.deltaYXs = new double[1000];
        this.deltaYYs = new double[1000];
        for (int i = 0; i < 1000; ++i) {
            this.angles[i] = (double)(2 * i) * Math.PI / 1000.0 - Math.PI;
            this.deltaXXs[i] = Math.cos(this.angles[i]);
            this.deltaXYs[i] = Math.sin(this.angles[i]);
            this.deltaYXs[i] = Math.cos(this.angles[i] + 1.5707963267948966);
            this.deltaYYs[i] = Math.sin(this.angles[i] + 1.5707963267948966);
        }
        this.peers = new ArrayList();
        this.peerComparator = new PeerComparator();
    }

    public void dataSourceChanged(Object newDataSource) {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        if (this.manager != null) {
            this.manager.addPeerListener(this);
        }
    }

    public void delete() {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        super.delete();
    }

    public Composite getComposite() {
        return this.panel;
    }

    public String getData() {
        return "PeersGraphicView.title";
    }

    public void initialize(Composite composite) {
        this.display = composite.getDisplay();
        this.panel = new Canvas(composite, 0);
    }

    public void refresh() {
        this.doRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        PEPeer[] sortedPeers;
        try {
            this.peers_mon.enter();
            ArrayList<PEPeerTransport> connectedPeers = new ArrayList<PEPeerTransport>();
            for (PEPeerTransport peer : this.peers) {
                if (peer.getConnectionState() != 4) continue;
                connectedPeers.add(peer);
            }
            sortedPeers = connectedPeers.toArray(new PEPeer[connectedPeers.size()]);
        }
        finally {
            this.peers_mon.exit();
        }
        if (sortedPeers == null) {
            return;
        }
        Arrays.sort(sortedPeers, this.peerComparator);
        this.render(sortedPeers);
    }

    private void render(PEPeer[] sortedPeers) {
        if (this.panel == null || this.panel.isDisposed() || this.manager == null) {
            return;
        }
        Point panelSize = this.panel.getSize();
        int x0 = panelSize.x / 2;
        int y0 = panelSize.y / 2;
        int a = x0 - 20;
        int b = y0 - 20;
        if (a < 10 || b < 10) {
            return;
        }
        if (this.oldSize == null || !this.oldSize.equals((Object)panelSize)) {
            this.oldSize = panelSize;
            this.perimeter = 0.0;
            for (int i = 0; i < 1000; ++i) {
                this.rs[i] = Math.sqrt(1.0 / (this.deltaYXs[i] * this.deltaYXs[i] / (double)(a * a) + this.deltaYYs[i] * this.deltaYYs[i] / (double)(b * b)));
                this.perimeter += this.rs[i];
            }
        }
        Image buffer = new Image((Device)this.display, panelSize.x, panelSize.y);
        GC gcBuffer = new GC((Drawable)buffer);
        gcBuffer.setBackground(Colors.white);
        gcBuffer.setForeground(Colors.blue);
        gcBuffer.fillRectangle(0, 0, panelSize.x, panelSize.y);
        if (SWT.getVersion() < 3138 || this.antiAliasingAvailable) {
            // empty if block
        }
        gcBuffer.setBackground(Colors.blues[2]);
        int nbPeers = sortedPeers.length;
        int iAngle = 0;
        double currentPerimeter = 0.0;
        for (int i = 0; i < nbPeers; ++i) {
            int percentSent;
            double r;
            double angle;
            PEPeer peer = sortedPeers[i];
            do {
                angle = this.angles[iAngle];
                r = this.rs[iAngle];
                currentPerimeter += r;
                if (iAngle + 1 >= 1000) continue;
                ++iAngle;
            } while (currentPerimeter < (double)i * this.perimeter / (double)nbPeers);
            angle = (double)(4 * i - nbPeers) * Math.PI / (double)(2 * nbPeers) - 1.5707963267948966;
            int[] rectangle = new int[8];
            if (!peer.isChokedByMe() || !peer.isChokingMe()) {
                gcBuffer.setForeground(Colors.blues[2]);
                int x1 = x0 + (int)(r * this.deltaYXs[iAngle]);
                int y1 = y0 + (int)(r * this.deltaYYs[iAngle]);
                gcBuffer.drawLine(x0, y0, x1, y1);
            }
            if ((percentSent = peer.getPercentDoneOfCurrentIncomingRequest()) >= 0) {
                gcBuffer.setBackground(Colors.blues[7]);
                double r1 = r - r * (double)percentSent / 100.0;
                rectangle[0] = (int)((double)x0 + r1 * this.deltaYXs[iAngle] + 0.5);
                rectangle[1] = (int)((double)y0 + r1 * this.deltaYYs[iAngle] + 0.5);
                rectangle[2] = (int)((double)x0 + this.deltaXXs[iAngle] * 4.0 + r1 * this.deltaYXs[iAngle] + 0.5);
                rectangle[3] = (int)((double)y0 + this.deltaXYs[iAngle] * 4.0 + r1 * this.deltaYYs[iAngle] + 0.5);
                rectangle[4] = (int)((double)x0 + this.deltaXXs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                rectangle[5] = (int)((double)y0 + this.deltaXYs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                rectangle[6] = (int)((double)x0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                rectangle[7] = (int)((double)y0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                gcBuffer.fillPolygon(rectangle);
            }
            if ((percentSent = peer.getPercentDoneOfCurrentOutgoingRequest()) >= 0) {
                gcBuffer.setBackground(Colors.blues[2]);
                double r1 = r * (double)percentSent / 100.0;
                rectangle[0] = (int)((double)x0 + r1 * this.deltaYXs[iAngle] + 0.5);
                rectangle[1] = (int)((double)y0 + r1 * this.deltaYYs[iAngle] + 0.5);
                rectangle[2] = (int)((double)x0 - this.deltaXXs[iAngle] * 4.0 + r1 * this.deltaYXs[iAngle] + 0.5);
                rectangle[3] = (int)((double)y0 - this.deltaXYs[iAngle] * 4.0 + r1 * this.deltaYYs[iAngle] + 0.5);
                rectangle[4] = (int)((double)x0 - this.deltaXXs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                rectangle[5] = (int)((double)y0 - this.deltaXYs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                rectangle[6] = (int)((double)x0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                rectangle[7] = (int)((double)y0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                gcBuffer.fillPolygon(rectangle);
            }
            int x1 = x0 + (int)(r * this.deltaYXs[iAngle]);
            int y1 = y0 + (int)(r * this.deltaYYs[iAngle]);
            gcBuffer.setBackground(Colors.blues[7]);
            if (peer.isSnubbed()) {
                gcBuffer.setBackground(Colors.grey);
            }
            PieUtils.drawPie(gcBuffer, x1 - 7, y1 - 7, 15, 15, peer.getPercentDoneInThousandNotation() / 10);
        }
        gcBuffer.setBackground(Colors.blues[7]);
        PieUtils.drawPie(gcBuffer, x0 - 37, y0 - 37, 75, 75, this.manager.getStats().getCompleted() / 10);
        gcBuffer.dispose();
        GC gcPanel = new GC((Drawable)this.panel);
        gcPanel.drawImage(buffer, 0, 0);
        gcPanel.dispose();
        buffer.dispose();
    }

    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    public void peerManagerAdded(PEPeerManager manager) {
    }

    public void peerManagerRemoved(PEPeerManager manager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerAdded(PEPeer peer) {
        try {
            this.peers_mon.enter();
            this.peers.add(peer);
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerRemoved(PEPeer peer) {
        try {
            this.peers_mon.enter();
            this.peers.remove(peer);
        }
        finally {
            this.peers_mon.exit();
        }
    }

    class PeerComparator
    implements Comparator {
        PeerComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            PEPeer peer0 = (PEPeer)arg0;
            PEPeer peer1 = (PEPeer)arg1;
            int percent0 = peer0.getPercentDoneInThousandNotation();
            int percent1 = peer1.getPercentDoneInThousandNotation();
            return percent0 - percent1;
        }
    }
}

