/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.table.impl.FakeTableCell;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class TorrentInfoView
extends AbstractIView {
    private static final String TEXT_PREFIX = "TorrentInfoView.";
    private DownloadManager download_manager;
    private Composite outer_panel;
    private Font headerFont;
    private FakeTableCell[] cells;
    private ScrolledComposite sc;
    private Composite parent;

    protected TorrentInfoView() {
    }

    public void initialize(Composite composite) {
        this.parent = composite;
        if (this.download_manager == null) {
            return;
        }
        if (this.sc != null && !this.sc.isDisposed()) {
            this.sc.dispose();
        }
        this.sc = new ScrolledComposite(composite, 768);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.sc.setLayoutData((Object)gridData);
        this.outer_panel = this.sc;
        Composite panel = new Composite((Composite)this.sc, 0);
        this.sc.setContent((Control)panel);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Composite cHeader = new Composite(panel, 2048);
        GridLayout configLayout = new GridLayout();
        configLayout.marginHeight = 3;
        configLayout.marginWidth = 0;
        cHeader.setLayout((Layout)configLayout);
        gridData = new GridData(772);
        cHeader.setLayoutData((Object)gridData);
        Display d = panel.getDisplay();
        cHeader.setBackground(d.getSystemColor(26));
        cHeader.setForeground(d.getSystemColor(27));
        Label lHeader = new Label(cHeader, 0);
        lHeader.setBackground(d.getSystemColor(26));
        lHeader.setForeground(d.getSystemColor(27));
        FontData[] fontData = lHeader.getFont().getFontData();
        fontData[0].setStyle(1);
        int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
        fontData[0].setHeight(fontHeight);
        this.headerFont = new Font((Device)d, fontData);
        lHeader.setFont(this.headerFont);
        lHeader.setText(" " + MessageText.getString("authenticator.torrent") + " : " + this.download_manager.getDisplayName().replaceAll("&", "&&"));
        gridData = new GridData(772);
        lHeader.setLayoutData((Object)gridData);
        Composite gTorrentInfo = new Composite(panel, 0);
        gridData = new GridData(272);
        gTorrentInfo.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentInfo.setLayout((Layout)layout);
        Label label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("TorrentInfoView.torrent.encoding") + ": ");
        TOTorrent torrent = this.download_manager.getTorrent();
        BufferedLabel blabel = new BufferedLabel(gTorrentInfo, 0);
        gridData = new GridData();
        blabel.setLayoutData(gridData);
        blabel.setText(torrent == null ? "" : LocaleTorrentUtil.getCurrentTorrentEncoding(torrent));
        label = new Label(gTorrentInfo, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("MyTrackerView.tracker") + ": ");
        String trackers = "";
        if (torrent != null) {
            TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
            TOTorrentAnnounceURLSet[] sets = group.getAnnounceURLSets();
            ArrayList<String> tracker_list = new ArrayList<String>();
            URL url = torrent.getAnnounceURL();
            tracker_list.add(url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort()));
            for (int i = 0; i < sets.length; ++i) {
                TOTorrentAnnounceURLSet set = sets[i];
                URL[] urls = set.getAnnounceURLs();
                for (int j = 0; j < urls.length; ++j) {
                    url = urls[j];
                    String str = url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort());
                    if (tracker_list.contains(str)) continue;
                    tracker_list.add(str);
                }
            }
            TRTrackerAnnouncer announcer = this.download_manager.getTrackerClient();
            URL active_url = null;
            if (announcer != null) {
                active_url = announcer.getTrackerUrl();
            } else {
                TRTrackerScraperResponse scrape = this.download_manager.getTrackerScrapeResponse();
                if (scrape != null) {
                    active_url = scrape.getURL();
                }
            }
            if (active_url == null) {
                active_url = torrent.getAnnounceURL();
            }
            trackers = active_url.getHost() + (active_url.getPort() == -1 ? "" : ":" + active_url.getPort());
            tracker_list.remove(trackers);
            if (tracker_list.size() > 0) {
                trackers = trackers + " (";
                for (int i = 0; i < tracker_list.size(); ++i) {
                    trackers = trackers + (i == 0 ? "" : ", ") + tracker_list.get(i);
                }
                trackers = trackers + ")";
            }
        }
        blabel = new BufferedLabel(gTorrentInfo, 0);
        gridData = new GridData();
        blabel.setLayoutData(gridData);
        blabel.setText(trackers);
        Group gColumns = new Group(panel, 0);
        Messages.setLanguageText((Widget)gColumns, "TorrentInfoView.columns");
        gridData = new GridData(272);
        gColumns.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 4;
        gColumns.setLayout((Layout)layout);
        HashMap<String, FakeTableCell> usable_cols = new HashMap<String, FakeTableCell>();
        TableColumnManager col_man = TableColumnManager.getInstance();
        TableColumnCore[][] cols_sets = new TableColumnCore[][]{col_man.getAllTableColumnCoreAsArray(DownloadTypeIncomplete.class, "MyTorrents"), col_man.getAllTableColumnCoreAsArray(DownloadTypeComplete.class, "MySeeders")};
        for (int i = 0; i < cols_sets.length; ++i) {
            TableColumnCore[] cols = cols_sets[i];
            for (int j = 0; j < cols.length; ++j) {
                TableColumnCore col = cols[j];
                String id = col.getName();
                if (usable_cols.containsKey(id)) continue;
                FakeTableCell fakeTableCell = null;
                try {
                    fakeTableCell = new FakeTableCell(col);
                    fakeTableCell.setOrentation(16384);
                    fakeTableCell.setDataSource(this.download_manager);
                    col.invokeCellAddedListeners(fakeTableCell);
                    fakeTableCell.refresh();
                    usable_cols.put(id, fakeTableCell);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        if (fakeTableCell == null) continue;
                        fakeTableCell.dispose();
                        continue;
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                }
            }
        }
        Collection values = usable_cols.values();
        this.cells = new FakeTableCell[values.size()];
        values.toArray(this.cells);
        Arrays.sort(this.cells, new Comparator(){

            public int compare(Object o1, Object o2) {
                TableColumnCore c1 = (TableColumnCore)((TableCellCore)o1).getTableColumn();
                TableColumnCore c2 = (TableColumnCore)((TableCellCore)o2).getTableColumn();
                String key1 = MessageText.getString(c1.getTitleLanguageKey());
                String key2 = MessageText.getString(c2.getTitleLanguageKey());
                return key1.compareToIgnoreCase(key2);
            }
        });
        for (int i = 0; i < this.cells.length; ++i) {
            final FakeTableCell cell = this.cells[i];
            label = new Label((Composite)gColumns, 0);
            gridData = new GridData();
            if (i % 2 == 1) {
                gridData.horizontalIndent = 16;
            }
            label.setLayoutData((Object)gridData);
            String key = ((TableColumnCore)cell.getTableColumn()).getTitleLanguageKey();
            label.setText(MessageText.getString(key) + ": ");
            label.setToolTipText(MessageText.getString(key + ".info", ""));
            final Composite c = new Composite((Composite)gColumns, 0);
            gridData = new GridData(768);
            gridData.heightHint = 16;
            c.setLayoutData((Object)gridData);
            cell.setControl(c);
            cell.invalidate();
            cell.refresh();
            c.addListener(32, new Listener(){

                public void handleEvent(Event event2) {
                    Object toolTip = cell.getToolTip();
                    if (toolTip instanceof String) {
                        String s = (String)toolTip;
                        c.setToolTipText(s);
                    }
                }
            });
        }
        this.refresh();
        this.sc.setMinSize(panel.computeSize(-1, -1));
    }

    public void refresh() {
        if (this.cells != null) {
            for (int i = 0; i < this.cells.length; ++i) {
                FakeTableCell cell = this.cells[i];
                try {
                    cell.refresh();
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e, "Error refreshing cell: " + this.cells[i].getTableColumn().getName());
                }
            }
        }
    }

    public Composite getComposite() {
        return this.outer_panel;
    }

    public String getFullTitle() {
        return MessageText.getString("GeneralView.section.info");
    }

    public String getData() {
        return "GeneralView.section.info";
    }

    public void delete() {
        super.delete();
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        if (this.cells != null) {
            for (int i = 0; i < this.cells.length; ++i) {
                FakeTableCell cell = this.cells[i];
                cell.dispose();
            }
        }
    }

    public void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof DownloadManager) {
            this.download_manager = (DownloadManager)newDataSource;
        }
        if (this.parent != null) {
            this.initialize(this.parent);
        }
    }
}

