/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.generic.GenericBooleanParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericIntParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class TorrentOptionsView
extends AbstractIView
implements DownloadManagerStateAttributeListener {
    private static final String TEXT_PREFIX = "TorrentOptionsView.param.";
    private static final String MAX_UPLOAD = "max.upload";
    private static final String MAX_DOWNLOAD = "max.download";
    private boolean multi_view;
    private DownloadManager[] managers;
    private GenericParameterAdapter ds_param_adapter = new downloadStateParameterAdapter();
    private GenericParameterAdapter adhoc_param_adapter = new adhocParameterAdapter();
    private Map adhoc_parameters = new HashMap();
    private Map ds_parameters = new HashMap();
    private Composite panel;
    private Font headerFont;
    private Composite parent;

    public TorrentOptionsView() {
    }

    public TorrentOptionsView(DownloadManager[] managers2) {
        this.dataSourceChanged(managers2);
    }

    public void initialize(Composite composite) {
        this.parent = composite;
        if (this.managers == null) {
            return;
        }
        if (this.panel != null && !this.panel.isDisposed()) {
            this.panel.dispose();
        }
        this.panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        this.panel.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cHeader = new Composite(this.panel, 2048);
        GridLayout configLayout = new GridLayout();
        configLayout.marginHeight = 3;
        configLayout.marginWidth = 0;
        cHeader.setLayout((Layout)configLayout);
        GridData gridData = new GridData(772);
        cHeader.setLayoutData((Object)gridData);
        Display d = this.panel.getDisplay();
        cHeader.setBackground(d.getSystemColor(26));
        cHeader.setForeground(d.getSystemColor(27));
        Label lHeader = new Label(cHeader, 0);
        lHeader.setBackground(d.getSystemColor(26));
        lHeader.setForeground(d.getSystemColor(27));
        FontData[] fontData = lHeader.getFont().getFontData();
        fontData[0].setStyle(1);
        int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
        fontData[0].setHeight(fontHeight);
        this.headerFont = new Font((Device)d, fontData);
        lHeader.setFont(this.headerFont);
        if (this.managers.length == 1) {
            lHeader.setText(" " + MessageText.getString("authenticator.torrent") + " : " + this.managers[0].getDisplayName().replaceAll("&", "&&"));
        } else {
            String str = "";
            for (int i = 0; i < Math.min(3, this.managers.length); ++i) {
                str = str + (i == 0 ? "" : ", ") + this.managers[i].getDisplayName().replaceAll("&", "&&");
            }
            if (this.managers.length > 3) {
                str = str + "...";
            }
            lHeader.setText(" " + this.managers.length + " " + MessageText.getString("ConfigView.section.torrents") + " : " + str);
        }
        gridData = new GridData(772);
        lHeader.setLayoutData((Object)gridData);
        Group gTorrentOptions = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gTorrentOptions, "ConfigView.section.transfer");
        gridData = new GridData(272);
        gTorrentOptions.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gTorrentOptions.setLayout((Layout)layout);
        String k_unit = DisplayFormatters.getRateUnitBase10(1).trim();
        Label label = new Label((Composite)gTorrentOptions, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxuploadspeed.tooltip"));
        GenericIntParameter max_upload = new GenericIntParameter(this.adhoc_param_adapter, (Composite)gTorrentOptions, MAX_UPLOAD);
        this.adhoc_parameters.put(MAX_UPLOAD, max_upload);
        gridData = new GridData();
        gridData.widthHint = 40;
        max_upload.setLayoutData(gridData);
        if (userMode > 0) {
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.uploads.when.busy");
            GenericIntParameter max_upload_when_busy = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.upload.when.busy");
            this.ds_parameters.put("max.upload.when.busy", max_upload_when_busy);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_upload_when_busy.setLayoutData(gridData);
        }
        label = new Label((Composite)gTorrentOptions, 0);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxdownloadspeed.tooltip"));
        GenericIntParameter max_download = new GenericIntParameter(this.adhoc_param_adapter, (Composite)gTorrentOptions, MAX_DOWNLOAD);
        this.adhoc_parameters.put(MAX_DOWNLOAD, max_download);
        gridData = new GridData();
        gridData.widthHint = 40;
        max_download.setLayoutData(gridData);
        if (userMode > 0) {
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.uploads");
            GenericIntParameter max_uploads = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.uploads");
            this.ds_parameters.put("max.uploads", max_uploads);
            max_uploads.setMinimumValue(2);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_uploads.setLayoutData(gridData);
            Composite cMaxUploadsOptionsArea = new Composite((Composite)gTorrentOptions, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxUploadsOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxUploadsOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxUploadsOptionsArea, 0);
            ImageLoader.getInstance().setLabelImage(label, "subitem");
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            gridData = new GridData();
            GenericBooleanParameter max_uploads_when_seeding_enabled = new GenericBooleanParameter(this.ds_param_adapter, cMaxUploadsOptionsArea, "max.uploads.when.seeding.enabled", false, "TorrentOptionsView.param.alternative.value.enable");
            this.ds_parameters.put("max.uploads.when.seeding.enabled", max_uploads_when_seeding_enabled);
            max_uploads_when_seeding_enabled.setLayoutData(gridData);
            GenericIntParameter max_uploads_when_seeding = new GenericIntParameter(this.ds_param_adapter, cMaxUploadsOptionsArea, "max.uploads.when.seeding");
            this.ds_parameters.put("max.uploads.when.seeding", max_uploads_when_seeding);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_uploads_when_seeding.setMinimumValue(2);
            max_uploads_when_seeding.setLayoutData(gridData);
            max_uploads_when_seeding_enabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(max_uploads_when_seeding.getControl()));
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.peers");
            GenericIntParameter max_peers = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.peers");
            this.ds_parameters.put("max.peers", max_peers);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_peers.setLayoutData(gridData);
            Composite cMaxPeersOptionsArea = new Composite((Composite)gTorrentOptions, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxPeersOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxPeersOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxPeersOptionsArea, 0);
            ImageLoader.getInstance().setLabelImage(label, "subitem");
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            gridData = new GridData();
            GenericBooleanParameter max_peers_when_seeding_enabled = new GenericBooleanParameter(this.ds_param_adapter, cMaxPeersOptionsArea, "max.peers.when.seeding.enabled", false, "TorrentOptionsView.param.alternative.value.enable");
            this.ds_parameters.put("max.peers.when.seeding.enabled", max_peers_when_seeding_enabled);
            max_peers_when_seeding_enabled.setLayoutData(gridData);
            GenericIntParameter max_peers_when_seeding = new GenericIntParameter(this.ds_param_adapter, cMaxPeersOptionsArea, "max.peers.when.seeding");
            this.ds_parameters.put("max.peers.when.seeding", max_peers_when_seeding);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_peers_when_seeding.setLayoutData(gridData);
            max_peers_when_seeding_enabled.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(max_peers_when_seeding.getControl()));
            label = new Label((Composite)gTorrentOptions, 0);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "TorrentOptionsView.param.max.seeds");
            GenericIntParameter max_seeds = new GenericIntParameter(this.ds_param_adapter, (Composite)gTorrentOptions, "max.seeds");
            this.ds_parameters.put("max.seeds", max_seeds);
            gridData = new GridData();
            gridData.widthHint = 40;
            max_seeds.setLayoutData(gridData);
        }
        Label reset_label = new Label((Composite)gTorrentOptions, 0);
        Messages.setLanguageText((Widget)reset_label, "TorrentOptionsView.param.reset.to.default");
        Button reset_button = new Button((Composite)gTorrentOptions, 8);
        Messages.setLanguageText((Widget)reset_button, "TorrentOptionsView.param.reset.button");
        reset_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentOptionsView.this.setDefaults();
            }
        });
        for (int i = 0; i < this.managers.length; ++i) {
            this.managers[i].getDownloadState().addListener(this, "parameters", 1);
        }
    }

    protected void setDefaults() {
        for (String key : this.ds_parameters.keySet()) {
            for (int i = 0; i < this.managers.length; ++i) {
                this.managers[i].getDownloadState().setParameterDefault(key);
            }
        }
        for (Object param : this.adhoc_parameters.values()) {
            if (param instanceof GenericIntParameter) {
                GenericIntParameter int_param = (GenericIntParameter)param;
                int_param.setValue(0, true);
                continue;
            }
            Debug.out("Unknown parameter type: " + param.getClass());
        }
    }

    public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
        final DownloadManagerState state = dm.getDownloadState();
        Utils.execSWTThread(new Runnable(){

            public void run() {
                for (Map.Entry entry : TorrentOptionsView.this.ds_parameters.entrySet()) {
                    boolean bl;
                    String key = (String)entry.getKey();
                    Object param = entry.getValue();
                    if (param instanceof GenericIntParameter) {
                        GenericIntParameter int_param = (GenericIntParameter)param;
                        bl = state.getIntParameter(key);
                        int_param.setValue(bl ? 1 : 0);
                        continue;
                    }
                    if (param instanceof GenericBooleanParameter) {
                        GenericBooleanParameter bool_param = (GenericBooleanParameter)param;
                        bl = state.getBooleanParameter(key);
                        bool_param.setSelected(bl);
                        continue;
                    }
                    Debug.out("Unknown parameter type: " + param.getClass());
                }
            }
        }, true);
    }

    public Composite getComposite() {
        return this.panel;
    }

    public String getFullTitle() {
        return MessageText.getString(this.multi_view ? "TorrentOptionsView.multi.title.full" : "TorrentOptionsView.title.full");
    }

    public String getData() {
        return MessageText.getString(this.multi_view ? "TorrentOptionsView.multi.title.short" : "TorrentOptionsView.title.short");
    }

    public void delete() {
        super.delete();
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        if (this.managers != null) {
            for (int i = 0; i < this.managers.length; ++i) {
                this.managers[i].getDownloadState().removeListener(this, "parameters", 1);
            }
        }
    }

    public void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof DownloadManager) {
            this.multi_view = false;
            this.managers = new DownloadManager[]{(DownloadManager)newDataSource};
        } else if (newDataSource instanceof DownloadManager[]) {
            this.multi_view = true;
            this.managers = (DownloadManager[])newDataSource;
        }
        if (this.parent != null) {
            this.initialize(this.parent);
        }
    }

    protected class adhocParameterAdapter
    extends GenericParameterAdapter {
        protected adhocParameterAdapter() {
        }

        public int getIntValue(String key) {
            return this.getIntValue(key, 0);
        }

        public int getIntValue(String key, int def) {
            if (key == TorrentOptionsView.MAX_UPLOAD) {
                int result = def;
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    int val = TorrentOptionsView.this.managers[i].getStats().getUploadRateLimitBytesPerSecond() / 1024;
                    if (i == 0) {
                        result = val;
                        continue;
                    }
                    if (result == val) continue;
                    return def;
                }
                return result;
            }
            if (key == TorrentOptionsView.MAX_DOWNLOAD) {
                int result = def;
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    int val = TorrentOptionsView.this.managers[i].getStats().getDownloadRateLimitBytesPerSecond() / 1024;
                    if (i == 0) {
                        result = val;
                        continue;
                    }
                    if (result == val) continue;
                    return def;
                }
                return result;
            }
            Debug.out("Unknown key '" + key + "'");
            return 0;
        }

        public void setIntValue(String key, int value) {
            if (key == TorrentOptionsView.MAX_UPLOAD) {
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    DownloadManager manager = TorrentOptionsView.this.managers[i];
                    if (value == manager.getStats().getUploadRateLimitBytesPerSecond() / 1024) continue;
                    manager.getStats().setUploadRateLimitBytesPerSecond(value * 1024);
                }
            } else if (key == TorrentOptionsView.MAX_DOWNLOAD) {
                for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                    DownloadManager manager = TorrentOptionsView.this.managers[i];
                    if (value == manager.getStats().getDownloadRateLimitBytesPerSecond() / 1024) continue;
                    manager.getStats().setDownloadRateLimitBytesPerSecond(value * 1024);
                }
            } else {
                Debug.out("Unknown key '" + key + "'");
            }
        }
    }

    protected class downloadStateParameterAdapter
    extends GenericParameterAdapter {
        protected downloadStateParameterAdapter() {
        }

        public int getIntValue(String key) {
            return this.getIntValue(key, 0);
        }

        public int getIntValue(String key, int def) {
            int result = def;
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                int val = TorrentOptionsView.this.managers[i].getDownloadState().getIntParameter(key);
                if (i == 0) {
                    result = val;
                    continue;
                }
                if (result == val) continue;
                return def;
            }
            return result;
        }

        public void setIntValue(String key, int value) {
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                DownloadManager manager = TorrentOptionsView.this.managers[i];
                if (value == manager.getDownloadState().getIntParameter(key)) continue;
                manager.getDownloadState().setIntParameter(key, value);
            }
        }

        public boolean getBooleanValue(String key) {
            return this.getBooleanValue(key, false);
        }

        public boolean getBooleanValue(String key, boolean def) {
            boolean result = def;
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                boolean val = TorrentOptionsView.this.managers[i].getDownloadState().getBooleanParameter(key);
                if (i == 0) {
                    result = val;
                    continue;
                }
                if (result == val) continue;
                return def;
            }
            return result;
        }

        public void setBooleanValue(String key, boolean value) {
            for (int i = 0; i < TorrentOptionsView.this.managers.length; ++i) {
                DownloadManager manager = TorrentOptionsView.this.managers[i];
                if (value == manager.getDownloadState().getBooleanParameter(key)) continue;
                manager.getDownloadState().setBooleanParameter(key, value);
            }
        }
    }
}

