/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;

public class ViewUtils {
    public static void addSpeedMenu(final Shell shell, Menu menuAdvanced, boolean isTorrentContext, boolean hasSelection, boolean downSpeedDisabled, boolean downSpeedUnlimited, long totalDownSpeed, long downSpeedSetMax, long maxDownload, boolean upSpeedDisabled, boolean upSpeedUnlimited, long totalUpSpeed, long upSpeedSetMax, long maxUpload, final int num_entries, final SpeedAdapter adapter) {
        MenuItem itemDownSpeed = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemDownSpeed, "MyTorrentsView.menu.setDownSpeed");
        Utils.setMenuItemImage(itemDownSpeed, "speed");
        Menu menuDownSpeed = new Menu((Decorations)shell, 4);
        itemDownSpeed.setMenu(menuDownSpeed);
        MenuItem itemCurrentDownSpeed = new MenuItem(menuDownSpeed, 8);
        itemCurrentDownSpeed.setEnabled(false);
        StringBuffer speedText = new StringBuffer();
        String separator = "";
        if (downSpeedDisabled) {
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.disabled"));
            separator = " / ";
        }
        if (downSpeedUnlimited) {
            speedText.append(separator);
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
            separator = " / ";
        }
        if (totalDownSpeed > 0L) {
            speedText.append(separator);
            speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalDownSpeed));
        }
        itemCurrentDownSpeed.setText(speedText.toString());
        new MenuItem(menuDownSpeed, 2);
        MenuItem[] itemsDownSpeed = new MenuItem[12];
        Listener itemsDownSpeedListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget != null && e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    int speed = item.getData("maxdl") == null ? 0 : (Integer)item.getData("maxdl");
                    adapter.setDownSpeed(speed);
                }
            }
        };
        itemsDownSpeed[1] = new MenuItem(menuDownSpeed, 8);
        Messages.setLanguageText((Widget)itemsDownSpeed[1], "MyTorrentsView.menu.setSpeed.unlimit");
        itemsDownSpeed[1].setData("maxdl", (Object)new Integer(0));
        itemsDownSpeed[1].addListener(13, itemsDownSpeedListener);
        if (hasSelection) {
            if (maxDownload == 0L) {
                maxDownload = downSpeedSetMax == 0L ? 204800L : 4L * (downSpeedSetMax / 1024L) * 1024L;
            }
            for (int i = 2; i < 12; ++i) {
                itemsDownSpeed[i] = new MenuItem(menuDownSpeed, 8);
                itemsDownSpeed[i].addListener(13, itemsDownSpeedListener);
                int limit = (int)(maxDownload / (long)(10 * num_entries) * (long)(12 - i));
                StringBuffer speed = new StringBuffer();
                speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries));
                if (num_entries > 1) {
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.in"));
                    speed.append(" ");
                    speed.append(num_entries);
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.slots"));
                    speed.append(" ");
                    speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit));
                }
                itemsDownSpeed[i].setText(speed.toString());
                itemsDownSpeed[i].setData("maxdl", (Object)new Integer(limit));
            }
        }
        new MenuItem(menuDownSpeed, 2);
        String menu_key = "MyTorrentsView.menu.manual";
        if (num_entries > 1) {
            menu_key = menu_key + (isTorrentContext ? ".per_torrent" : ".per_peer");
        }
        MenuItem itemDownSpeedManualSingle = new MenuItem(menuDownSpeed, 8);
        Messages.setLanguageText((Widget)itemDownSpeedManualSingle, menu_key);
        itemDownSpeedManualSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int speed_value = ViewUtils.getManualSpeedValue(shell, true);
                if (speed_value > 0) {
                    adapter.setDownSpeed(speed_value);
                }
            }
        });
        if (num_entries > 1) {
            MenuItem itemDownSpeedManualShared = new MenuItem(menuDownSpeed, 8);
            Messages.setLanguageText((Widget)itemDownSpeedManualShared, isTorrentContext ? "MyTorrentsView.menu.manual.shared_torrents" : "MyTorrentsView.menu.manual.shared_peers");
            itemDownSpeedManualShared.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int speed_value = ViewUtils.getManualSharedSpeedValue(shell, true, num_entries);
                    if (speed_value > 0) {
                        adapter.setDownSpeed(speed_value);
                    }
                }
            });
        }
        MenuItem itemUpSpeed = new MenuItem(menuAdvanced, 64);
        Messages.setLanguageText((Widget)itemUpSpeed, "MyTorrentsView.menu.setUpSpeed");
        Utils.setMenuItemImage(itemUpSpeed, "speed");
        Menu menuUpSpeed = new Menu((Decorations)shell, 4);
        itemUpSpeed.setMenu(menuUpSpeed);
        MenuItem itemCurrentUpSpeed = new MenuItem(menuUpSpeed, 8);
        itemCurrentUpSpeed.setEnabled(false);
        separator = "";
        speedText = new StringBuffer();
        if (upSpeedDisabled) {
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.disabled"));
            separator = " / ";
        }
        if (upSpeedUnlimited) {
            speedText.append(separator);
            speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
            separator = " / ";
        }
        if (totalUpSpeed > 0L) {
            speedText.append(separator);
            speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalUpSpeed));
        }
        itemCurrentUpSpeed.setText(speedText.toString());
        new MenuItem(menuUpSpeed, 2);
        MenuItem[] itemsUpSpeed = new MenuItem[12];
        Listener itemsUpSpeedListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget != null && e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    int speed = item.getData("maxul") == null ? 0 : (Integer)item.getData("maxul");
                    adapter.setUpSpeed(speed);
                }
            }
        };
        itemsUpSpeed[1] = new MenuItem(menuUpSpeed, 8);
        Messages.setLanguageText((Widget)itemsUpSpeed[1], "MyTorrentsView.menu.setSpeed.unlimit");
        itemsUpSpeed[1].setData("maxul", (Object)new Integer(0));
        itemsUpSpeed[1].addListener(13, itemsUpSpeedListener);
        if (hasSelection) {
            maxUpload = maxUpload == 0L ? 76800L : (upSpeedSetMax == 0L ? 204800L : 4L * (upSpeedSetMax / 1024L) * 1024L);
            for (int i = 2; i < 12; ++i) {
                itemsUpSpeed[i] = new MenuItem(menuUpSpeed, 8);
                itemsUpSpeed[i].addListener(13, itemsUpSpeedListener);
                int limit = (int)(maxUpload / (long)(10 * num_entries) * (long)(12 - i));
                StringBuffer speed = new StringBuffer();
                speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries));
                if (num_entries > 1) {
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.in"));
                    speed.append(" ");
                    speed.append(num_entries);
                    speed.append(" ");
                    speed.append(MessageText.getString("MyTorrentsView.menu.setSpeed.slots"));
                    speed.append(" ");
                    speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit));
                }
                itemsUpSpeed[i].setText(speed.toString());
                itemsUpSpeed[i].setData("maxul", (Object)new Integer(limit));
            }
        }
        new MenuItem(menuUpSpeed, 2);
        MenuItem itemUpSpeedManualSingle = new MenuItem(menuUpSpeed, 8);
        Messages.setLanguageText((Widget)itemUpSpeedManualSingle, menu_key);
        itemUpSpeedManualSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int speed_value = ViewUtils.getManualSpeedValue(shell, false);
                if (speed_value > 0) {
                    adapter.setUpSpeed(speed_value);
                }
            }
        });
        if (num_entries > 1) {
            MenuItem itemUpSpeedManualShared = new MenuItem(menuUpSpeed, 8);
            Messages.setLanguageText((Widget)itemUpSpeedManualShared, isTorrentContext ? "MyTorrentsView.menu.manual.shared_torrents" : "MyTorrentsView.menu.manual.shared_peers");
            itemUpSpeedManualShared.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int speed_value = ViewUtils.getManualSharedSpeedValue(shell, false, num_entries);
                    if (speed_value > 0) {
                        adapter.setUpSpeed(speed_value);
                    }
                }
            });
        }
    }

    public static int getManualSpeedValue(Shell shell, boolean for_download) {
        String kbps_str = MessageText.getString("MyTorrentsView.dialog.setNumber.inKbps", new String[]{DisplayFormatters.getRateUnit(1)});
        String set_num_str = MessageText.getString("MyTorrentsView.dialog.setNumber." + (for_download ? "download" : "upload"));
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setSpeed.title", new String[]{set_num_str}, "MyTorrentsView.dialog.setNumber.text", new String[]{kbps_str, set_num_str});
        entryWindow.prompt();
        if (!entryWindow.hasSubmittedInput()) {
            return -1;
        }
        String sReturn = entryWindow.getSubmittedInput();
        if (sReturn == null) {
            return -1;
        }
        try {
            int result = (int)(Double.valueOf(sReturn) * 1024.0);
            if (DisplayFormatters.isRateUsingBits()) {
                result /= 8;
            }
            if (result <= 0) {
                throw new NumberFormatException("non-positive number entered");
            }
            return result;
        }
        catch (NumberFormatException er) {
            MessageBox mb = new MessageBox(shell, 33);
            mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
            mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
            mb.open();
            return -1;
        }
    }

    public static int getManualSharedSpeedValue(Shell shell, boolean for_download, int num_entries) {
        int result = ViewUtils.getManualSpeedValue(shell, for_download);
        if (result == -1) {
            return -1;
        }
        if ((result /= num_entries) == 0) {
            result = 1;
        }
        return result;
    }

    public static interface SpeedAdapter {
        public void setUpSpeed(int var1);

        public void setDownSpeed(int var1);
    }
}

