/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.columnsetup;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.columnsetup.TableColumnSetupWindow;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;

public class ColumnTC_NameInfo
extends CoreTableColumn
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableCellMouseMoveListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "TableColumnNameInfo";
    public static Font fontHeader = null;
    private static String[] profText = new String[]{"beginner", "intermediate", "advanced"};

    public ColumnTC_NameInfo(String tableID) {
        super(COLUMN_ID, tableID);
        this.initialize(5, -1, 415, -3);
        this.setType(2);
    }

    public void refresh(TableCell cell) {
        TableColumnCore column = (TableColumnCore)cell.getDataSource();
        String key = column.getTitleLanguageKey();
        cell.setSortValue((Comparable)((Object)MessageText.getString(key, column.getName())));
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle hitArea;
        TableColumnSetupWindow.TableViewColumnSetup tv;
        TableColumnCore column = (TableColumnCore)cell.getDataSource();
        String key = column.getTitleLanguageKey();
        Rectangle bounds = cell.getBounds();
        if (bounds == null || bounds.isEmpty()) {
            return;
        }
        Font fontDefault = gc.getFont();
        if (fontHeader == null) {
            FontData[] fontData = gc.getFont().getFontData();
            fontData[0].setStyle(1);
            fontData[0].setHeight(fontData[0].getHeight() + 1);
            fontHeader = new Font(gc.getDevice(), fontData);
        }
        gc.setFont(fontHeader);
        bounds.y += 3;
        bounds.x += 7;
        bounds.width -= 14;
        String name = MessageText.getString(key, column.getName());
        GCStringPrinter sp = new GCStringPrinter(gc, name, bounds, 1, 128);
        sp.printString();
        Point titleSize = sp.getCalculatedSize();
        gc.setFont(fontDefault);
        String info = MessageText.getString(key + ".info", "");
        Rectangle infoBounds = new Rectangle(bounds.x + 10, bounds.y + titleSize.y + 5, bounds.width - 15, bounds.height - 20);
        GCStringPrinter.printString(gc, info, infoBounds, true, false);
        TableColumnInfo columnInfo = (TableColumnInfo)cell.getTableRowCore().getData("columninfo");
        if (columnInfo == null) {
            TableColumnManager tcm = TableColumnManager.getInstance();
            columnInfo = tcm.getColumnInfo(column.getForDataSourceType(), column.getTableID(), column.getName());
            cell.getTableRowCore().setData("columninfo", columnInfo);
        }
        Rectangle profBounds = new Rectangle(bounds.width - 100, bounds.y - 2, 100, 20);
        byte proficiency = columnInfo.getProficiency();
        if (proficiency > 0 && proficiency < profText.length) {
            Color oldColor = gc.getForeground();
            gc.setForeground(Colors.grey);
            GCStringPrinter.printString(gc, MessageText.getString("ConfigView.section.mode." + profText[proficiency]), profBounds, true, false, 131200);
            gc.setForeground(oldColor);
        }
        if ((tv = (TableColumnSetupWindow.TableViewColumnSetup)cell.getTableRowCore().getView()).isColumnAdded(column)) {
            hitArea = Utils.EMPTY_RECT;
        } else {
            int x = bounds.x + titleSize.x + 15;
            int y = bounds.y - 1;
            int h = 15;
            String textAdd = MessageText.getString("Button.add");
            GCStringPrinter sp2 = new GCStringPrinter(gc, textAdd, new Rectangle(x, y, 500, h), true, false, 0x1000000);
            sp2.calculateMetrics();
            int w = sp2.getCalculatedSize().x + 12;
            gc.setAdvanced(true);
            gc.setAntialias(1);
            gc.setBackground(ColorCache.getColor(gc.getDevice(), 255, 255, 255));
            gc.fillRoundRectangle(x, y, w, h, 15, h);
            gc.setBackground(ColorCache.getColor(gc.getDevice(), 215, 215, 215));
            gc.fillRoundRectangle(x + 2, y + 2, w, h, 15, h);
            gc.setForeground(ColorCache.getColor(gc.getDevice(), 145, 145, 145));
            gc.drawRoundRectangle(x, y, w, h, 15, h);
            gc.setForeground(ColorCache.getColor(gc.getDevice(), 50, 50, 50));
            hitArea = new Rectangle(x, y, w + 2, h);
            sp2.printString(gc, hitArea, 0x1000000);
            bounds = cell.getBounds();
            hitArea.x -= bounds.x;
            hitArea.y -= bounds.y;
        }
        cell.getTableRowCore().setData("AddHitArea", hitArea);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.button == 1 && event2.eventType == 1 && event2.cell instanceof TableCellCore) {
            Rectangle hitArea;
            Object data = ((TableCellCore)event2.cell).getTableRowCore().getData("AddHitArea");
            if (data instanceof Rectangle && (hitArea = (Rectangle)data).contains(event2.x, event2.y)) {
                TableColumnSetupWindow.TableViewColumnSetup tv = (TableColumnSetupWindow.TableViewColumnSetup)((TableCellCore)event2.cell).getTableRowCore().getView();
                Object dataSource = event2.cell.getDataSource();
                if (dataSource instanceof TableColumnCore) {
                    TableColumnCore column = (TableColumnCore)dataSource;
                    tv.chooseColumn(column);
                }
            }
        } else if (event2.eventType == 3) {
            Rectangle hitArea;
            Object data = ((TableCellCore)event2.cell).getTableRowCore().getData("AddHitArea");
            if (data instanceof Rectangle && (hitArea = (Rectangle)data).contains(event2.x, event2.y)) {
                ((TableCellSWT)event2.cell).setCursorID(21);
                return;
            }
            ((TableCellSWT)event2.cell).setCursorID(0);
        }
    }

    public void cellHover(TableCell cell) {
    }

    public void cellHoverComplete(TableCell cell) {
    }
}

